--**************************************************************
--  Copyright (c) 2008 Xilinx, Inc.  All rights reserved.
--  File Name    : unisim_VCOMP.vhd
--  Library      : unisim
--  Release      : 11.1
--  Entity Count : 1118
--  Time         : Fri Apr  9 22:51:09 2010
--  Generated by : gencomp.pl
--**************************************************************

library IEEE;
use IEEE.STD_LOGIC_1164.all;
package VCOMPONENTS is
attribute BOX_TYPE : string;


-- synopsys translate_off

-----------------------------------------
-----------   FPGA Globals --------------
-----------------------------------------
signal GSR : std_logic := '0';
signal GTS : std_logic := '0';
signal GWE : std_logic := '0';
signal PLL_LOCKG : std_logic := 'H';

-----------------------------------------
-----------   CPLD Globals --------------
-----------------------------------------
signal PRLD : std_logic := '0';

-----------------------------------------
-----------   JTAG Globals --------------
-----------------------------------------
signal JTAG_TDO_GLBL  : std_logic;
signal JTAG_TDI_GLBL  : std_logic := '0';
signal JTAG_TMS_GLBL  : std_logic := '0';
signal JTAG_TCK_GLBL  : std_logic := '0';
signal JTAG_TRST_GLBL : std_logic := '0';

signal JTAG_CAPTURE_GLBL : std_logic := '0';
signal JTAG_RESET_GLBL : std_logic   := '1';
signal JTAG_SHIFT_GLBL : std_logic   := '1';
signal JTAG_UPDATE_GLBL : std_logic  := '0';
signal JTAG_RUNTEST_GLBL : std_logic  := '0';

signal JTAG_SEL1_GLBL : std_logic := '0';
signal JTAG_SEL2_GLBL : std_logic := '0';
signal JTAG_SEL3_GLBL : std_logic := '0';
signal JTAG_SEL4_GLBL : std_logic := '0';

signal JTAG_USER_TDO1_GLBL : std_logic := 'Z';
signal JTAG_USER_TDO2_GLBL : std_logic := 'Z';
signal JTAG_USER_TDO3_GLBL : std_logic := 'Z';
signal JTAG_USER_TDO4_GLBL : std_logic := 'Z';

-- synopsys translate_on

-- START COMPONENT
----- component AND2 -----
component AND2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND2 : component is "PRIMITIVE";

----- component AND2B1 -----
component AND2B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND2B1 : component is "PRIMITIVE";

----- component AND2B1L -----
component AND2B1L
  port (
     O : out std_ulogic;
     DI : in std_ulogic;
     SRI : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND2B1L : component is "PRIMITIVE";

----- component AND2B2 -----
component AND2B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND2B2 : component is "PRIMITIVE";

----- component AND3 -----
component AND3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND3 : component is "PRIMITIVE";

----- component AND3B1 -----
component AND3B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND3B1 : component is "PRIMITIVE";

----- component AND3B2 -----
component AND3B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND3B2 : component is "PRIMITIVE";

----- component AND3B3 -----
component AND3B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND3B3 : component is "PRIMITIVE";

----- component AND4 -----
component AND4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND4 : component is "PRIMITIVE";

----- component AND4B1 -----
component AND4B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND4B1 : component is "PRIMITIVE";

----- component AND4B2 -----
component AND4B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND4B2 : component is "PRIMITIVE";

----- component AND4B3 -----
component AND4B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND4B3 : component is "PRIMITIVE";

----- component AND4B4 -----
component AND4B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND4B4 : component is "PRIMITIVE";

----- component AND5 -----
component AND5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND5 : component is "PRIMITIVE";

----- component AND5B1 -----
component AND5B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND5B1 : component is "PRIMITIVE";

----- component AND5B2 -----
component AND5B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND5B2 : component is "PRIMITIVE";

----- component AND5B3 -----
component AND5B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND5B3 : component is "PRIMITIVE";

----- component AND5B4 -----
component AND5B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND5B4 : component is "PRIMITIVE";

----- component AND5B5 -----
component AND5B5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND5B5 : component is "PRIMITIVE";

----- component AND6 -----
component AND6
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND6 : component is "PRIMITIVE";

----- component AND7 -----
component AND7
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND7 : component is "PRIMITIVE";

----- component AND8 -----
component AND8
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AND8 : component is "PRIMITIVE";

----- component AUTOBUF -----
component AUTOBUF
  generic (
     BUFFER_TYPE : string := "AUTO"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  AUTOBUF : component is "PRIMITIVE";

----- component BSCAN_FPGACORE -----
component BSCAN_FPGACORE
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK1 : out std_ulogic := 'H';
     DRCK2 : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     SEL1 : out std_ulogic := 'L';
     SEL2 : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO1 : in std_ulogic := 'X';
     TDO2 : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  BSCAN_FPGACORE : component is "PRIMITIVE";

----- component BSCAN_SPARTAN3 -----
component BSCAN_SPARTAN3
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK1 : out std_ulogic := 'L';
     DRCK2 : out std_ulogic := 'L';
     RESET : out std_ulogic := 'L';
     SEL1 : out std_ulogic := 'L';
     SEL2 : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO1 : in std_ulogic := 'X';
     TDO2 : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  BSCAN_SPARTAN3 : component is "PRIMITIVE";

----- component BSCAN_SPARTAN3A -----
component BSCAN_SPARTAN3A
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK1 : out std_ulogic := 'L';
     DRCK2 : out std_ulogic := 'L';
     RESET : out std_ulogic := 'L';
     SEL1 : out std_ulogic := 'L';
     SEL2 : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TCK : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     TMS : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO1 : in std_ulogic := 'X';
     TDO2 : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  BSCAN_SPARTAN3A : component is "PRIMITIVE";

----- component BSCAN_SPARTAN6 -----
component BSCAN_SPARTAN6
  generic (
     JTAG_CHAIN : integer := 1
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     RUNTEST : out std_ulogic := 'L';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TCK : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     TMS : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  BSCAN_SPARTAN6 : component is "PRIMITIVE";

----- component BSCAN_VIRTEX4 -----
component BSCAN_VIRTEX4
  generic (
     JTAG_CHAIN : integer := 1
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  BSCAN_VIRTEX4 : component is "PRIMITIVE";

----- component BSCAN_VIRTEX5 -----
component BSCAN_VIRTEX5
  generic (
     JTAG_CHAIN : integer := 1
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  BSCAN_VIRTEX5 : component is "PRIMITIVE";

----- component BSCAN_VIRTEX6 -----
component BSCAN_VIRTEX6
  generic (
     DISABLE_JTAG : boolean := FALSE;
     JTAG_CHAIN : integer := 1
  );
  port (
     CAPTURE : out std_ulogic := 'H';
     DRCK : out std_ulogic := 'H';
     RESET : out std_ulogic := 'H';
     RUNTEST : out std_ulogic := 'L';
     SEL : out std_ulogic := 'L';
     SHIFT : out std_ulogic := 'L';
     TCK : out std_ulogic := 'L';
     TDI : out std_ulogic := 'L';
     TMS : out std_ulogic := 'L';
     UPDATE : out std_ulogic := 'L';
     TDO : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  BSCAN_VIRTEX6 : component is "PRIMITIVE";

----- component BUF -----
component BUF
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUF : component is "PRIMITIVE";

----- component BUFCF -----
component BUFCF
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFCF : component is "PRIMITIVE";

----- component BUFE -----
component BUFE
  port (
     O : out std_ulogic;
     E : in std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFE : component is "PRIMITIVE";

----- component BUFFOE -----
component BUFFOE
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFFOE : component is "PRIMITIVE";

----- component BUFG -----
component BUFG
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFG : component is "PRIMITIVE";

----- component BUFGCE -----
component BUFGCE
  port (
     O : out STD_ULOGIC;
     CE: in STD_ULOGIC;
     I : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  BUFGCE : component is "PRIMITIVE";

----- component BUFGCE_1 -----
component BUFGCE_1
  port (
     O : out STD_ULOGIC;
     CE: in STD_ULOGIC;
     I : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  BUFGCE_1 : component is "PRIMITIVE";

----- component BUFGCTRL -----
component BUFGCTRL
  generic (
     INIT_OUT : integer := 0;
     PRESELECT_I0 : boolean := false;
     PRESELECT_I1 : boolean := false
  );
  port (
     O : out std_ulogic;
     CE0 : in std_ulogic;
     CE1 : in std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     IGNORE0 : in std_ulogic;
     IGNORE1 : in std_ulogic;
     S0 : in std_ulogic;
     S1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFGCTRL : component is "PRIMITIVE";

----- component BUFGDLL -----
component BUFGDLL
  generic (
     DUTY_CYCLE_CORRECTION : boolean := true
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFGDLL : component is "PRIMITIVE";

----- component BUFGMUX -----
component BUFGMUX
  generic (
     CLK_SEL_TYPE : string := "SYNC"
  );
  port (
     O : out std_ulogic := '0';
     I0 : in std_ulogic := '0';
     I1 : in std_ulogic := '0';
     S : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  BUFGMUX : component is "PRIMITIVE";

----- component BUFGMUX_1 -----
component BUFGMUX_1
  generic (
     CLK_SEL_TYPE : string := "SYNC"
  );
  port (
     O : out std_ulogic := '1';
     I0 : in std_ulogic := '0';
     I1 : in std_ulogic := '0';
     S : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  BUFGMUX_1 : component is "PRIMITIVE";

----- component BUFGMUX_CTRL -----
component BUFGMUX_CTRL
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFGMUX_CTRL : component is "PRIMITIVE";

----- component BUFGMUX_VIRTEX4 -----
component BUFGMUX_VIRTEX4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFGMUX_VIRTEX4 : component is "PRIMITIVE";

----- component BUFGP -----
component BUFGP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFGP : component is "PRIMITIVE";

----- component BUFGSR -----
component BUFGSR
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFGSR : component is "PRIMITIVE";

----- component BUFGTS -----
component BUFGTS
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFGTS : component is "PRIMITIVE";

----- component BUFH -----
component BUFH
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFH : component is "PRIMITIVE";

----- component BUFHCE -----
component BUFHCE
  generic (
     INIT_OUT : integer := 0
  );
  port (
     O : out std_ulogic;
     CE : in std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFHCE : component is "PRIMITIVE";

----- component BUFIO -----
component BUFIO
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFIO : component is "PRIMITIVE";

----- component BUFIO2 -----
component BUFIO2
  generic (
     DIVIDE : integer := 1;
     DIVIDE_BYPASS : boolean := TRUE;
     I_INVERT : boolean := FALSE;
     USE_DOUBLER : boolean := FALSE
  );
  port (
     DIVCLK : out std_ulogic;
     IOCLK : out std_ulogic;
     SERDESSTROBE : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFIO2 : component is "PRIMITIVE";

----- component BUFIO2FB -----
component BUFIO2FB
  generic (
     DIVIDE_BYPASS : boolean := TRUE
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFIO2FB : component is "PRIMITIVE";

----- component BUFIO2_2CLK -----
component BUFIO2_2CLK
  generic (
     DIVIDE : integer := 2
  );
  port (
     DIVCLK : out std_ulogic;
     IOCLK : out std_ulogic;
     SERDESSTROBE : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFIO2_2CLK : component is "PRIMITIVE";

----- component BUFIODQS -----
component BUFIODQS
  generic (
     DQSMASK_ENABLE : boolean := FALSE
  );
  port (
     O : out std_ulogic;
     DQSMASK : in std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFIODQS : component is "PRIMITIVE";

----- component BUFPLL -----
component BUFPLL
  generic (
     DIVIDE : integer := 1;
     ENABLE_SYNC : boolean := TRUE
  );
  port (
     IOCLK : out std_ulogic;
     LOCK : out std_ulogic;
     SERDESSTROBE : out std_ulogic;
     GCLK : in std_ulogic;
     LOCKED : in std_ulogic;
     PLLIN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFPLL : component is "PRIMITIVE";

----- component BUFPLL_MCB -----
component BUFPLL_MCB
  generic (
     DIVIDE : integer := 2;
     LOCK_SRC : string := "LOCK_TO_0"
  );
  port (
     IOCLK0 : out std_ulogic;
     IOCLK1 : out std_ulogic;
     SERDESSTROBE0 : out std_ulogic;
     SERDESSTROBE1 : out std_ulogic;
     PLLIN0 : in std_ulogic;
     PLLIN1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFPLL_MCB : component is "PRIMITIVE";

----- component BUFR -----
component BUFR
  generic (
     BUFR_DIVIDE : string := "BYPASS";
     SIM_DEVICE : string := "VIRTEX4"
  );
  port (
     O : out std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFR : component is "PRIMITIVE";

----- component BUFT -----
component BUFT
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  BUFT : component is "PRIMITIVE";

----- component CAPTURE_FPGACORE -----
component CAPTURE_FPGACORE
  generic (
     ONESHOT : boolean := false
  );
  port (
     CAP : in std_ulogic;
     CLK : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CAPTURE_FPGACORE : component is "PRIMITIVE";

----- component CAPTURE_SPARTAN3 -----
component CAPTURE_SPARTAN3
  generic (
     ONESHOT : boolean := false
  );
  port (
     CAP : in std_ulogic;
     CLK : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CAPTURE_SPARTAN3 : component is "PRIMITIVE";

----- component CAPTURE_SPARTAN3A -----
component CAPTURE_SPARTAN3A
  generic (
     ONESHOT : boolean := true
  );
  port (
     CAP : in std_ulogic;
     CLK : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CAPTURE_SPARTAN3A : component is "PRIMITIVE";

----- component CAPTURE_VIRTEX4 -----
component CAPTURE_VIRTEX4
  generic (
     ONESHOT : boolean := true
  );
  port (
     CAP : in std_ulogic;
     CLK : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CAPTURE_VIRTEX4 : component is "PRIMITIVE";

----- component CAPTURE_VIRTEX5 -----
component CAPTURE_VIRTEX5
  generic (
     ONESHOT : boolean := true
  );
  port (
     CAP : in std_ulogic;
     CLK : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CAPTURE_VIRTEX5 : component is "PRIMITIVE";

----- component CAPTURE_VIRTEX6 -----
component CAPTURE_VIRTEX6
  generic (
     ONESHOT : boolean := TRUE
  );
  port (
     CAP : in std_ulogic;
     CLK : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CAPTURE_VIRTEX6 : component is "PRIMITIVE";

----- component CARRY4 -----
component CARRY4
  port (
     CO : out std_logic_vector(3 downto 0);
     O : out std_logic_vector(3 downto 0);
     CI : in std_ulogic;
     CYINIT : in std_ulogic;
     DI : in std_logic_vector(3 downto 0);
     S : in std_logic_vector(3 downto 0)
  );
end component;
attribute BOX_TYPE of
  CARRY4 : component is "PRIMITIVE";

----- component CFGLUT5 -----
component CFGLUT5
  generic (
     INIT : bit_vector := X"00000000"
  );
  port (
     CDO : out STD_ULOGIC;
     O5 : out STD_ULOGIC;
     O6 : out STD_ULOGIC;
     CDI : in STD_ULOGIC;
     CE : in STD_ULOGIC;
     CLK : in STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC;
     I3 : in STD_ULOGIC;
     I4 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  CFGLUT5 : component is "PRIMITIVE";

----- component CLKDLL -----
component CLKDLL
  generic (
     CLKDV_DIVIDE : real := 2.0;
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     STARTUP_WAIT : boolean := false
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLKDLL : component is "PRIMITIVE";

----- component CLKDLLE -----
component CLKDLLE
  generic (
     CLKDV_DIVIDE : real := 2.0;
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     STARTUP_WAIT : boolean := false
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLKDLLE : component is "PRIMITIVE";

----- component CLKDLLHF -----
component CLKDLLHF
  generic (
     CLKDV_DIVIDE : real := 2.0;
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"FFF0";
     STARTUP_WAIT : boolean := false
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLKDLLHF : component is "PRIMITIVE";

----- component CLK_DIV10 -----
component CLK_DIV10
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV10 : component is "PRIMITIVE";

----- component CLK_DIV10R -----
component CLK_DIV10R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV10R : component is "PRIMITIVE";

----- component CLK_DIV10RSD -----
component CLK_DIV10RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV10RSD : component is "PRIMITIVE";

----- component CLK_DIV10SD -----
component CLK_DIV10SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV10SD : component is "PRIMITIVE";

----- component CLK_DIV12 -----
component CLK_DIV12
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV12 : component is "PRIMITIVE";

----- component CLK_DIV12R -----
component CLK_DIV12R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV12R : component is "PRIMITIVE";

----- component CLK_DIV12RSD -----
component CLK_DIV12RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV12RSD : component is "PRIMITIVE";

----- component CLK_DIV12SD -----
component CLK_DIV12SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV12SD : component is "PRIMITIVE";

----- component CLK_DIV14 -----
component CLK_DIV14
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV14 : component is "PRIMITIVE";

----- component CLK_DIV14R -----
component CLK_DIV14R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV14R : component is "PRIMITIVE";

----- component CLK_DIV14RSD -----
component CLK_DIV14RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV14RSD : component is "PRIMITIVE";

----- component CLK_DIV14SD -----
component CLK_DIV14SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV14SD : component is "PRIMITIVE";

----- component CLK_DIV16 -----
component CLK_DIV16
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV16 : component is "PRIMITIVE";

----- component CLK_DIV16R -----
component CLK_DIV16R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV16R : component is "PRIMITIVE";

----- component CLK_DIV16RSD -----
component CLK_DIV16RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV16RSD : component is "PRIMITIVE";

----- component CLK_DIV16SD -----
component CLK_DIV16SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV16SD : component is "PRIMITIVE";

----- component CLK_DIV2 -----
component CLK_DIV2
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV2 : component is "PRIMITIVE";

----- component CLK_DIV2R -----
component CLK_DIV2R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV2R : component is "PRIMITIVE";

----- component CLK_DIV2RSD -----
component CLK_DIV2RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV2RSD : component is "PRIMITIVE";

----- component CLK_DIV2SD -----
component CLK_DIV2SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV2SD : component is "PRIMITIVE";

----- component CLK_DIV4 -----
component CLK_DIV4
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV4 : component is "PRIMITIVE";

----- component CLK_DIV4R -----
component CLK_DIV4R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV4R : component is "PRIMITIVE";

----- component CLK_DIV4RSD -----
component CLK_DIV4RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV4RSD : component is "PRIMITIVE";

----- component CLK_DIV4SD -----
component CLK_DIV4SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV4SD : component is "PRIMITIVE";

----- component CLK_DIV6 -----
component CLK_DIV6
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV6 : component is "PRIMITIVE";

----- component CLK_DIV6R -----
component CLK_DIV6R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV6R : component is "PRIMITIVE";

----- component CLK_DIV6RSD -----
component CLK_DIV6RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV6RSD : component is "PRIMITIVE";

----- component CLK_DIV6SD -----
component CLK_DIV6SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV6SD : component is "PRIMITIVE";

----- component CLK_DIV8 -----
component CLK_DIV8
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV8 : component is "PRIMITIVE";

----- component CLK_DIV8R -----
component CLK_DIV8R
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV8R : component is "PRIMITIVE";

----- component CLK_DIV8RSD -----
component CLK_DIV8RSD
  port (
     CLKDV : out std_ulogic := '0';
     CDRST : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV8RSD : component is "PRIMITIVE";

----- component CLK_DIV8SD -----
component CLK_DIV8SD
  port (
     CLKDV : out std_ulogic := '0';
     CLKIN : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  CLK_DIV8SD : component is "PRIMITIVE";

----- component CONFIG -----
component CONFIG
end component;
attribute BOX_TYPE of
  CONFIG : component is "PRIMITIVE";

----- component CRC32 -----
component CRC32
  generic (
     CRC_INIT : bit_vector := X"FFFFFFFF"
  );
  port (
     CRCOUT : out std_logic_vector(31 downto 0);
     CRCCLK : in std_ulogic;
     CRCDATAVALID : in std_ulogic;
     CRCDATAWIDTH : in std_logic_vector(2 downto 0);
     CRCIN : in std_logic_vector(31 downto 0);
     CRCRESET : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CRC32 : component is "PRIMITIVE";

----- component CRC64 -----
component CRC64
  generic (
     CRC_INIT : bit_vector := X"FFFFFFFF"
  );
  port (
     CRCOUT : out std_logic_vector(31 downto 0);
     CRCCLK : in std_ulogic;
     CRCDATAVALID : in std_ulogic;
     CRCDATAWIDTH : in std_logic_vector(2 downto 0);
     CRCIN : in std_logic_vector(63 downto 0);
     CRCRESET : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  CRC64 : component is "PRIMITIVE";

----- component DCIRESET -----
component DCIRESET
  port (
     LOCKED : out std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DCIRESET : component is "PRIMITIVE";

----- component DCM -----
component DCM
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := false;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DSS_MODE : string := "NONE";
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     PHASE_SHIFT : integer := 0;
     SIM_MODE : string := "SAFE";
     STARTUP_WAIT : boolean := false
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     STATUS : out std_logic_vector(7 downto 0) := "00000000";
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     DSSEN : in std_ulogic := '0';
     PSCLK : in std_ulogic := '0';
     PSEN : in std_ulogic := '0';
     PSINCDEC : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  DCM : component is "PRIMITIVE";

----- component DCM_ADV -----
component DCM_ADV
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := false;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DCM_AUTOCALIBRATION : boolean := true;
     DCM_PERFORMANCE_MODE : string := "MAX_SPEED";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"F0F0";
     PHASE_SHIFT : integer := 0;
     SIM_DEVICE : string := "VIRTEX4";
     STARTUP_WAIT : boolean := false
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     DO : out std_logic_vector(15 downto 0) := "0000000000000000";
     DRDY : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     DADDR : in std_logic_vector(6 downto 0) := "0000000";
     DCLK : in std_ulogic := '0';
     DEN : in std_ulogic := '0';
     DI : in std_logic_vector(15 downto 0) := "0000000000000000";
     DWE : in std_ulogic := '0';
     PSCLK : in std_ulogic := '0';
     PSEN : in std_ulogic := '0';
     PSINCDEC : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  DCM_ADV : component is "PRIMITIVE";

----- component DCM_BASE -----
component DCM_BASE
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := FALSE;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DCM_AUTOCALIBRATION : boolean := TRUE;
     DCM_PERFORMANCE_MODE : string := "MAX_SPEED";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DUTY_CYCLE_CORRECTION : boolean := TRUE;
     FACTORY_JF : bit_vector := X"F0F0";
     PHASE_SHIFT : integer := 0;
     STARTUP_WAIT : boolean := false
  );
  port (
     CLK0 : out std_ulogic;
     CLK180 : out std_ulogic;
     CLK270 : out std_ulogic;
     CLK2X : out std_ulogic;
     CLK2X180 : out std_ulogic;
     CLK90 : out std_ulogic;
     CLKDV : out std_ulogic;
     CLKFX : out std_ulogic;
     CLKFX180 : out std_ulogic;
     LOCKED : out std_ulogic;
     CLKFB : in std_ulogic;
     CLKIN : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DCM_BASE : component is "PRIMITIVE";

----- component DCM_CLKGEN -----
component DCM_CLKGEN
  generic (
     CLKFXDV_DIVIDE : integer := 2;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MD_MAX : real := 0.0;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_PERIOD : real := 10.0;
     SPREAD_SPECTRUM : string := "NONE";
     STARTUP_WAIT : boolean := FALSE
  );
  port (
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     CLKFXDV : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PROGDONE : out std_ulogic := '0';
     STATUS : out std_logic_vector(2 downto 1) := "00";
     CLKIN : in std_ulogic := 'L';
     FREEZEDCM : in std_ulogic := 'L';
     PROGCLK : in std_ulogic := 'L';
     PROGDATA : in std_ulogic := 'L';
     PROGEN : in std_ulogic := 'L';
     RST : in std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  DCM_CLKGEN : component is "PRIMITIVE";

----- component DCM_PS -----
component DCM_PS
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := FALSE;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DCM_AUTOCALIBRATION : boolean := TRUE;
     DCM_PERFORMANCE_MODE : string := "MAX_SPEED";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DUTY_CYCLE_CORRECTION : boolean := TRUE;
     FACTORY_JF : bit_vector := X"F0F0";
     PHASE_SHIFT : integer := 0;
     STARTUP_WAIT : boolean := FALSE
  );
  port (
     CLK0 : out std_ulogic;
     CLK180 : out std_ulogic;
     CLK270 : out std_ulogic;
     CLK2X : out std_ulogic;
     CLK2X180 : out std_ulogic;
     CLK90 : out std_ulogic;
     CLKDV : out std_ulogic;
     CLKFX : out std_ulogic;
     CLKFX180 : out std_ulogic;
     DO : out std_logic_vector(15 downto 0);
     LOCKED : out std_ulogic;
     PSDONE : out std_ulogic;
     CLKFB : in std_ulogic;
     CLKIN : in std_ulogic;
     PSCLK : in std_ulogic;
     PSEN : in std_ulogic;
     PSINCDEC : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DCM_PS : component is "PRIMITIVE";

----- component DCM_SP -----
component DCM_SP
  generic (
     CLKDV_DIVIDE : real := 2.0;
     CLKFX_DIVIDE : integer := 1;
     CLKFX_MULTIPLY : integer := 4;
     CLKIN_DIVIDE_BY_2 : boolean := false;
     CLKIN_PERIOD : real := 10.0;
     CLKOUT_PHASE_SHIFT : string := "NONE";
     CLK_FEEDBACK : string := "1X";
     DESKEW_ADJUST : string := "SYSTEM_SYNCHRONOUS";
     DFS_FREQUENCY_MODE : string := "LOW";
     DLL_FREQUENCY_MODE : string := "LOW";
     DSS_MODE : string := "NONE";
     DUTY_CYCLE_CORRECTION : boolean := true;
     FACTORY_JF : bit_vector := X"C080";
     PHASE_SHIFT : integer := 0;
     STARTUP_WAIT : boolean := false
  );
  port (
     CLK0 : out std_ulogic := '0';
     CLK180 : out std_ulogic := '0';
     CLK270 : out std_ulogic := '0';
     CLK2X : out std_ulogic := '0';
     CLK2X180 : out std_ulogic := '0';
     CLK90 : out std_ulogic := '0';
     CLKDV : out std_ulogic := '0';
     CLKFX : out std_ulogic := '0';
     CLKFX180 : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     STATUS : out std_logic_vector(7 downto 0) := "00000000";
     CLKFB : in std_ulogic := '0';
     CLKIN : in std_ulogic := '0';
     DSSEN : in std_ulogic := '0';
     PSCLK : in std_ulogic := '0';
     PSEN : in std_ulogic := '0';
     PSINCDEC : in std_ulogic := '0';
     RST : in std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  DCM_SP : component is "PRIMITIVE";

----- component DNA_PORT -----
component DNA_PORT
  generic (
     SIM_DNA_VALUE : bit_vector := X"000000000000000"
  );
  port (
     DOUT : out std_ulogic;
     CLK : in std_ulogic;
     DIN : in std_ulogic;
     READ : in std_ulogic;
     SHIFT : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DNA_PORT : component is "PRIMITIVE";

----- component DSP48 -----
component DSP48
  generic (
     AREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSELREG : integer := 1;
     CREG : integer := 1;
     LEGACY_MODE : string := "MULT18X18S";
     MREG : integer := 1;
     OPMODEREG : integer := 1;
     PREG : integer := 1;
     SUBTRACTREG : integer := 1
  );
  port (
     BCOUT : out std_logic_vector(17 downto 0);
     P : out std_logic_vector(47 downto 0);
     PCOUT : out std_logic_vector(47 downto 0);
     A : in std_logic_vector(17 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYIN : in std_ulogic;
     CARRYINSEL : in std_logic_vector(1 downto 0);
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CECINSUB : in std_ulogic;
     CECTRL : in std_ulogic;
     CEM : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     OPMODE : in std_logic_vector(6 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCARRYIN : in std_ulogic;
     RSTCTRL : in std_ulogic;
     RSTM : in std_ulogic;
     RSTP : in std_ulogic;
     SUBTRACT : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DSP48 : component is "PRIMITIVE";

----- component DSP48A -----
component DSP48A
  generic (
     A0REG : integer := 0;
     A1REG : integer := 1;
     B0REG : integer := 0;
     B1REG : integer := 1;
     CARRYINREG : integer := 1;
     CARRYINSEL : string := "CARRYIN";
     CREG : integer := 1;
     DREG : integer := 1;
     MREG : integer := 1;
     OPMODEREG : integer := 1;
     PREG : integer := 1;
     RSTTYPE : string := "SYNC"
  );
  port (
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYOUT : out std_ulogic;
     P : out std_logic_vector(47 downto 0);
     PCOUT : out std_logic_vector(47 downto 0);
     A : in std_logic_vector(17 downto 0);
     B : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYIN : in std_ulogic;
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CED : in std_ulogic;
     CEM : in std_ulogic;
     CEOPMODE : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     D : in std_logic_vector(17 downto 0);
     OPMODE : in std_logic_vector(7 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCARRYIN : in std_ulogic;
     RSTD : in std_ulogic;
     RSTM : in std_ulogic;
     RSTOPMODE : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DSP48A : component is "PRIMITIVE";

----- component DSP48A1 -----
component DSP48A1
  generic (
     A0REG : integer := 0;
     A1REG : integer := 1;
     B0REG : integer := 0;
     B1REG : integer := 1;
     CARRYINREG : integer := 1;
     CARRYINSEL : string := "OPMODE5";
     CARRYOUTREG : integer := 1;
     CREG : integer := 1;
     DREG : integer := 1;
     MREG : integer := 1;
     OPMODEREG : integer := 1;
     PREG : integer := 1;
     RSTTYPE : string := "SYNC"
  );
  port (
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYOUT : out std_ulogic;
     CARRYOUTF : out std_ulogic;
     M : out std_logic_vector(35 downto 0);
     P : out std_logic_vector(47 downto 0);
     PCOUT : out std_logic_vector(47 downto 0);
     A : in std_logic_vector(17 downto 0);
     B : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYIN : in std_ulogic := 'L';
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CED : in std_ulogic;
     CEM : in std_ulogic;
     CEOPMODE : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     D : in std_logic_vector(17 downto 0);
     OPMODE : in std_logic_vector(7 downto 0);
     PCIN : in std_logic_vector(47 downto 0) := (others => 'L');
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCARRYIN : in std_ulogic;
     RSTD : in std_ulogic;
     RSTM : in std_ulogic;
     RSTOPMODE : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DSP48A1 : component is "PRIMITIVE";

----- component DSP48E -----
component DSP48E
  generic (
     ACASCREG : integer := 1;
     ALUMODEREG : integer := 1;
     AREG : integer := 1;
     AUTORESET_PATTERN_DETECT : boolean := FALSE;
     AUTORESET_PATTERN_DETECT_OPTINV : string := "MATCH";
     A_INPUT : string := "DIRECT";
     BCASCREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSELREG : integer := 1;
     CREG : integer := 1;
     MASK : bit_vector := X"3FFFFFFFFFFF";
     MREG : integer := 1;
     MULTCARRYINREG : integer := 1;
     OPMODEREG : integer := 1;
     PATTERN : bit_vector := X"000000000000";
     PREG : integer := 1;
     SEL_MASK : string := "MASK";
     SEL_PATTERN : string := "PATTERN";
     SEL_ROUNDING_MASK : string := "SEL_MASK";
     SIM_MODE : string := "SAFE";
     USE_MULT : string := "MULT_S";
     USE_PATTERN_DETECT : string := "NO_PATDET";
     USE_SIMD : string := "ONE48"
  );
  port (
     ACOUT : out std_logic_vector(29 downto 0);
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYCASCOUT : out std_ulogic;
     CARRYOUT : out std_logic_vector(3 downto 0);
     MULTSIGNOUT : out std_ulogic;
     OVERFLOW : out std_ulogic;
     P : out std_logic_vector(47 downto 0);
     PATTERNBDETECT : out std_ulogic;
     PATTERNDETECT : out std_ulogic;
     PCOUT : out std_logic_vector(47 downto 0);
     UNDERFLOW : out std_ulogic;
     A : in std_logic_vector(29 downto 0);
     ACIN : in std_logic_vector(29 downto 0);
     ALUMODE : in std_logic_vector(3 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYCASCIN : in std_ulogic;
     CARRYIN : in std_ulogic;
     CARRYINSEL : in std_logic_vector(2 downto 0);
     CEA1 : in std_ulogic;
     CEA2 : in std_ulogic;
     CEALUMODE : in std_ulogic;
     CEB1 : in std_ulogic;
     CEB2 : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CECTRL : in std_ulogic;
     CEM : in std_ulogic;
     CEMULTCARRYIN : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     MULTSIGNIN : in std_ulogic;
     OPMODE : in std_logic_vector(6 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTALLCARRYIN : in std_ulogic;
     RSTALUMODE : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCTRL : in std_ulogic;
     RSTM : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DSP48E : component is "PRIMITIVE";

----- component DSP48E1 -----
component DSP48E1
  generic (
     ACASCREG : integer := 1;
     ADREG : integer := 1;
     ALUMODEREG : integer := 1;
     AREG : integer := 1;
     AUTORESET_PATDET : string := "NO_RESET";
     A_INPUT : string := "DIRECT";
     BCASCREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     CARRYINREG : integer := 1;
     CARRYINSELREG : integer := 1;
     CREG : integer := 1;
     DREG : integer := 1;
     INMODEREG : integer := 1;
     MASK : bit_vector := X"3FFFFFFFFFFF";
     MREG : integer := 1;
     OPMODEREG : integer := 1;
     PATTERN : bit_vector := X"000000000000";
     PREG : integer := 1;
     SEL_MASK : string := "MASK";
     SEL_PATTERN : string := "PATTERN";
     USE_DPORT : boolean := FALSE;
     USE_MULT : string := "MULTIPLY";
     USE_PATTERN_DETECT : string := "NO_PATDET";
     USE_SIMD : string := "ONE48"
  );
  port (
     ACOUT : out std_logic_vector(29 downto 0);
     BCOUT : out std_logic_vector(17 downto 0);
     CARRYCASCOUT : out std_ulogic;
     CARRYOUT : out std_logic_vector(3 downto 0);
     MULTSIGNOUT : out std_ulogic;
     OVERFLOW : out std_ulogic;
     P : out std_logic_vector(47 downto 0);
     PATTERNBDETECT : out std_ulogic;
     PATTERNDETECT : out std_ulogic;
     PCOUT : out std_logic_vector(47 downto 0);
     UNDERFLOW : out std_ulogic;
     A : in std_logic_vector(29 downto 0);
     ACIN : in std_logic_vector(29 downto 0);
     ALUMODE : in std_logic_vector(3 downto 0);
     B : in std_logic_vector(17 downto 0);
     BCIN : in std_logic_vector(17 downto 0);
     C : in std_logic_vector(47 downto 0);
     CARRYCASCIN : in std_ulogic;
     CARRYIN : in std_ulogic;
     CARRYINSEL : in std_logic_vector(2 downto 0);
     CEA1 : in std_ulogic;
     CEA2 : in std_ulogic;
     CEAD : in std_ulogic;
     CEALUMODE : in std_ulogic;
     CEB1 : in std_ulogic;
     CEB2 : in std_ulogic;
     CEC : in std_ulogic;
     CECARRYIN : in std_ulogic;
     CECTRL : in std_ulogic;
     CED : in std_ulogic;
     CEINMODE : in std_ulogic;
     CEM : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     D : in std_logic_vector(24 downto 0);
     INMODE : in std_logic_vector(4 downto 0);
     MULTSIGNIN : in std_ulogic;
     OPMODE : in std_logic_vector(6 downto 0);
     PCIN : in std_logic_vector(47 downto 0);
     RSTA : in std_ulogic;
     RSTALLCARRYIN : in std_ulogic;
     RSTALUMODE : in std_ulogic;
     RSTB : in std_ulogic;
     RSTC : in std_ulogic;
     RSTCTRL : in std_ulogic;
     RSTD : in std_ulogic;
     RSTINMODE : in std_ulogic;
     RSTM : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  DSP48E1 : component is "PRIMITIVE";

----- component EFUSE_USR -----
component EFUSE_USR
  generic (
     SIM_EFUSE_VALUE : bit_vector := X"00000000"
  );
  port (
     EFUSEUSR : out std_logic_vector(31 downto 0)
  );
end component;
attribute BOX_TYPE of
  EFUSE_USR : component is "PRIMITIVE";

----- component EMAC -----
component EMAC
  generic (
     IN_DELAY : time := 0 ps
  );
  port (
     DCRHOSTDONEIR : out std_ulogic;
     EMAC0CLIENTANINTERRUPT : out std_ulogic;
     EMAC0CLIENTRXBADFRAME : out std_ulogic;
     EMAC0CLIENTRXCLIENTCLKOUT : out std_ulogic;
     EMAC0CLIENTRXD : out std_logic_vector(15 downto 0);
     EMAC0CLIENTRXDVLD : out std_ulogic;
     EMAC0CLIENTRXDVLDMSW : out std_ulogic;
     EMAC0CLIENTRXDVREG6 : out std_ulogic;
     EMAC0CLIENTRXFRAMEDROP : out std_ulogic;
     EMAC0CLIENTRXGOODFRAME : out std_ulogic;
     EMAC0CLIENTRXSTATS : out std_logic_vector(6 downto 0);
     EMAC0CLIENTRXSTATSBYTEVLD : out std_ulogic;
     EMAC0CLIENTRXSTATSVLD : out std_ulogic;
     EMAC0CLIENTTXACK : out std_ulogic;
     EMAC0CLIENTTXCLIENTCLKOUT : out std_ulogic;
     EMAC0CLIENTTXCOLLISION : out std_ulogic;
     EMAC0CLIENTTXGMIIMIICLKOUT : out std_ulogic;
     EMAC0CLIENTTXRETRANSMIT : out std_ulogic;
     EMAC0CLIENTTXSTATS : out std_ulogic;
     EMAC0CLIENTTXSTATSBYTEVLD : out std_ulogic;
     EMAC0CLIENTTXSTATSVLD : out std_ulogic;
     EMAC0PHYENCOMMAALIGN : out std_ulogic;
     EMAC0PHYLOOPBACKMSB : out std_ulogic;
     EMAC0PHYMCLKOUT : out std_ulogic;
     EMAC0PHYMDOUT : out std_ulogic;
     EMAC0PHYMDTRI : out std_ulogic;
     EMAC0PHYMGTRXRESET : out std_ulogic;
     EMAC0PHYMGTTXRESET : out std_ulogic;
     EMAC0PHYPOWERDOWN : out std_ulogic;
     EMAC0PHYSYNCACQSTATUS : out std_ulogic;
     EMAC0PHYTXCHARDISPMODE : out std_ulogic;
     EMAC0PHYTXCHARDISPVAL : out std_ulogic;
     EMAC0PHYTXCHARISK : out std_ulogic;
     EMAC0PHYTXCLK : out std_ulogic;
     EMAC0PHYTXD : out std_logic_vector(7 downto 0);
     EMAC0PHYTXEN : out std_ulogic;
     EMAC0PHYTXER : out std_ulogic;
     EMAC1CLIENTANINTERRUPT : out std_ulogic;
     EMAC1CLIENTRXBADFRAME : out std_ulogic;
     EMAC1CLIENTRXCLIENTCLKOUT : out std_ulogic;
     EMAC1CLIENTRXD : out std_logic_vector(15 downto 0);
     EMAC1CLIENTRXDVLD : out std_ulogic;
     EMAC1CLIENTRXDVLDMSW : out std_ulogic;
     EMAC1CLIENTRXDVREG6 : out std_ulogic;
     EMAC1CLIENTRXFRAMEDROP : out std_ulogic;
     EMAC1CLIENTRXGOODFRAME : out std_ulogic;
     EMAC1CLIENTRXSTATS : out std_logic_vector(6 downto 0);
     EMAC1CLIENTRXSTATSBYTEVLD : out std_ulogic;
     EMAC1CLIENTRXSTATSVLD : out std_ulogic;
     EMAC1CLIENTTXACK : out std_ulogic;
     EMAC1CLIENTTXCLIENTCLKOUT : out std_ulogic;
     EMAC1CLIENTTXCOLLISION : out std_ulogic;
     EMAC1CLIENTTXGMIIMIICLKOUT : out std_ulogic;
     EMAC1CLIENTTXRETRANSMIT : out std_ulogic;
     EMAC1CLIENTTXSTATS : out std_ulogic;
     EMAC1CLIENTTXSTATSBYTEVLD : out std_ulogic;
     EMAC1CLIENTTXSTATSVLD : out std_ulogic;
     EMAC1PHYENCOMMAALIGN : out std_ulogic;
     EMAC1PHYLOOPBACKMSB : out std_ulogic;
     EMAC1PHYMCLKOUT : out std_ulogic;
     EMAC1PHYMDOUT : out std_ulogic;
     EMAC1PHYMDTRI : out std_ulogic;
     EMAC1PHYMGTRXRESET : out std_ulogic;
     EMAC1PHYMGTTXRESET : out std_ulogic;
     EMAC1PHYPOWERDOWN : out std_ulogic;
     EMAC1PHYSYNCACQSTATUS : out std_ulogic;
     EMAC1PHYTXCHARDISPMODE : out std_ulogic;
     EMAC1PHYTXCHARDISPVAL : out std_ulogic;
     EMAC1PHYTXCHARISK : out std_ulogic;
     EMAC1PHYTXCLK : out std_ulogic;
     EMAC1PHYTXD : out std_logic_vector(7 downto 0);
     EMAC1PHYTXEN : out std_ulogic;
     EMAC1PHYTXER : out std_ulogic;
     EMACDCRACK : out std_ulogic;
     EMACDCRDBUS : out std_logic_vector(0 to 31);
     HOSTMIIMRDY : out std_ulogic;
     HOSTRDDATA : out std_logic_vector(31 downto 0);
     CLIENTEMAC0DCMLOCKED : in std_ulogic;
     CLIENTEMAC0PAUSEREQ : in std_ulogic;
     CLIENTEMAC0PAUSEVAL : in std_logic_vector(15 downto 0);
     CLIENTEMAC0RXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC0TXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC0TXD : in std_logic_vector(15 downto 0);
     CLIENTEMAC0TXDVLD : in std_ulogic;
     CLIENTEMAC0TXDVLDMSW : in std_ulogic;
     CLIENTEMAC0TXFIRSTBYTE : in std_ulogic;
     CLIENTEMAC0TXGMIIMIICLKIN : in std_ulogic;
     CLIENTEMAC0TXIFGDELAY : in std_logic_vector(7 downto 0);
     CLIENTEMAC0TXUNDERRUN : in std_ulogic;
     CLIENTEMAC1DCMLOCKED : in std_ulogic;
     CLIENTEMAC1PAUSEREQ : in std_ulogic;
     CLIENTEMAC1PAUSEVAL : in std_logic_vector(15 downto 0);
     CLIENTEMAC1RXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC1TXCLIENTCLKIN : in std_ulogic;
     CLIENTEMAC1TXD : in std_logic_vector(15 downto 0);
     CLIENTEMAC1TXDVLD : in std_ulogic;
     CLIENTEMAC1TXDVLDMSW : in std_ulogic;
     CLIENTEMAC1TXFIRSTBYTE : in std_ulogic;
     CLIENTEMAC1TXGMIIMIICLKIN : in std_ulogic;
     CLIENTEMAC1TXIFGDELAY : in std_logic_vector(7 downto 0);
     CLIENTEMAC1TXUNDERRUN : in std_ulogic;
     DCREMACABUS : in std_logic_vector(8 to 9);
     DCREMACCLK : in std_ulogic;
     DCREMACDBUS : in std_logic_vector(0 to 31);
     DCREMACENABLE : in std_ulogic;
     DCREMACREAD : in std_ulogic;
     DCREMACWRITE : in std_ulogic;
     HOSTADDR : in std_logic_vector(9 downto 0);
     HOSTCLK : in std_ulogic;
     HOSTEMAC1SEL : in std_ulogic;
     HOSTMIIMSEL : in std_ulogic;
     HOSTOPCODE : in std_logic_vector(1 downto 0);
     HOSTREQ : in std_ulogic;
     HOSTWRDATA : in std_logic_vector(31 downto 0);
     PHYEMAC0COL : in std_ulogic;
     PHYEMAC0CRS : in std_ulogic;
     PHYEMAC0GTXCLK : in std_ulogic;
     PHYEMAC0MCLKIN : in std_ulogic;
     PHYEMAC0MDIN : in std_ulogic;
     PHYEMAC0MIITXCLK : in std_ulogic;
     PHYEMAC0PHYAD : in std_logic_vector(4 downto 0);
     PHYEMAC0RXBUFERR : in std_ulogic;
     PHYEMAC0RXBUFSTATUS : in std_logic_vector(1 downto 0);
     PHYEMAC0RXCHARISCOMMA : in std_ulogic;
     PHYEMAC0RXCHARISK : in std_ulogic;
     PHYEMAC0RXCHECKINGCRC : in std_ulogic;
     PHYEMAC0RXCLK : in std_ulogic;
     PHYEMAC0RXCLKCORCNT : in std_logic_vector(2 downto 0);
     PHYEMAC0RXCOMMADET : in std_ulogic;
     PHYEMAC0RXD : in std_logic_vector(7 downto 0);
     PHYEMAC0RXDISPERR : in std_ulogic;
     PHYEMAC0RXDV : in std_ulogic;
     PHYEMAC0RXER : in std_ulogic;
     PHYEMAC0RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
     PHYEMAC0RXNOTINTABLE : in std_ulogic;
     PHYEMAC0RXRUNDISP : in std_ulogic;
     PHYEMAC0SIGNALDET : in std_ulogic;
     PHYEMAC0TXBUFERR : in std_ulogic;
     PHYEMAC1COL : in std_ulogic;
     PHYEMAC1CRS : in std_ulogic;
     PHYEMAC1GTXCLK : in std_ulogic;
     PHYEMAC1MCLKIN : in std_ulogic;
     PHYEMAC1MDIN : in std_ulogic;
     PHYEMAC1MIITXCLK : in std_ulogic;
     PHYEMAC1PHYAD : in std_logic_vector(4 downto 0);
     PHYEMAC1RXBUFERR : in std_ulogic;
     PHYEMAC1RXBUFSTATUS : in std_logic_vector(1 downto 0);
     PHYEMAC1RXCHARISCOMMA : in std_ulogic;
     PHYEMAC1RXCHARISK : in std_ulogic;
     PHYEMAC1RXCHECKINGCRC : in std_ulogic;
     PHYEMAC1RXCLK : in std_ulogic;
     PHYEMAC1RXCLKCORCNT : in std_logic_vector(2 downto 0);
     PHYEMAC1RXCOMMADET : in std_ulogic;
     PHYEMAC1RXD : in std_logic_vector(7 downto 0);
     PHYEMAC1RXDISPERR : in std_ulogic;
     PHYEMAC1RXDV : in std_ulogic;
     PHYEMAC1RXER : in std_ulogic;
     PHYEMAC1RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
     PHYEMAC1RXNOTINTABLE : in std_ulogic;
     PHYEMAC1RXRUNDISP : in std_ulogic;
     PHYEMAC1SIGNALDET : in std_ulogic;
     PHYEMAC1TXBUFERR : in std_ulogic;
     RESET : in std_ulogic;
     TIEEMAC0CONFIGVEC : in std_logic_vector(79 downto 0);
     TIEEMAC0UNICASTADDR : in std_logic_vector(47 downto 0);
     TIEEMAC1CONFIGVEC : in std_logic_vector(79 downto 0);
     TIEEMAC1UNICASTADDR : in std_logic_vector(47 downto 0)
  );
end component;
attribute BOX_TYPE of
  EMAC : component is "PRIMITIVE";

----- component FD -----
component FD
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FD : component is "PRIMITIVE";

----- component FDC -----
component FDC
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDC : component is "PRIMITIVE";

----- component FDCE -----
component FDCE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDCE : component is "PRIMITIVE";

----- component FDCE_1 -----
component FDCE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDCE_1 : component is "PRIMITIVE";

----- component FDCP -----
component FDCP
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDCP : component is "PRIMITIVE";

----- component FDCPE -----
component FDCPE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDCPE : component is "PRIMITIVE";

----- component FDCPE_1 -----
component FDCPE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDCPE_1 : component is "PRIMITIVE";

----- component FDCP_1 -----
component FDCP_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDCP_1 : component is "PRIMITIVE";

----- component FDC_1 -----
component FDC_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDC_1 : component is "PRIMITIVE";

----- component FDD -----
component FDD
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     D : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDD : component is "PRIMITIVE";

----- component FDDC -----
component FDDC
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     CLR : in STD_ULOGIC;
     D : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDDC : component is "PRIMITIVE";

----- component FDDCE -----
component FDDCE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     CE : in STD_ULOGIC;
     CLR : in STD_ULOGIC;
     D : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDDCE : component is "PRIMITIVE";

----- component FDDCP -----
component FDDCP
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     CLR : in STD_ULOGIC;
     D : in STD_ULOGIC;
     PRE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDDCP : component is "PRIMITIVE";

----- component FDDCPE -----
component FDDCPE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     CE : in STD_ULOGIC;
     CLR : in STD_ULOGIC;
     D : in STD_ULOGIC;
     PRE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDDCPE : component is "PRIMITIVE";

----- component FDDP -----
component FDDP
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     D : in STD_ULOGIC;
     PRE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDDP : component is "PRIMITIVE";

----- component FDDPE -----
component FDDPE
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     CE : in STD_ULOGIC;
     D : in STD_ULOGIC;
     PRE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDDPE : component is "PRIMITIVE";

----- component FDDRCPE -----
component FDDRCPE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDDRCPE : component is "PRIMITIVE";

----- component FDDRRSE -----
component FDDRRSE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDDRRSE : component is "PRIMITIVE";

----- component FDE -----
component FDE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDE : component is "PRIMITIVE";

----- component FDE_1 -----
component FDE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDE_1 : component is "PRIMITIVE";

----- component FDP -----
component FDP
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDP : component is "PRIMITIVE";

----- component FDPE -----
component FDPE
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDPE : component is "PRIMITIVE";

----- component FDPE_1 -----
component FDPE_1
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDPE_1 : component is "PRIMITIVE";

----- component FDP_1 -----
component FDP_1
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDP_1 : component is "PRIMITIVE";

----- component FDR -----
component FDR
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDR : component is "PRIMITIVE";

----- component FDRE -----
component FDRE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDRE : component is "PRIMITIVE";

----- component FDRE_1 -----
component FDRE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDRE_1 : component is "PRIMITIVE";

----- component FDRS -----
component FDRS
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDRS : component is "PRIMITIVE";

----- component FDRSE -----
component FDRSE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDRSE : component is "PRIMITIVE";

----- component FDRSE_1 -----
component FDRSE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDRSE_1 : component is "PRIMITIVE";

----- component FDRS_1 -----
component FDRS_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDRS_1 : component is "PRIMITIVE";

----- component FDR_1 -----
component FDR_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out STD_ULOGIC;
     C : in STD_ULOGIC;
     D : in STD_ULOGIC;
     R : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  FDR_1 : component is "PRIMITIVE";

----- component FDS -----
component FDS
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDS : component is "PRIMITIVE";

----- component FDSE -----
component FDSE
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDSE : component is "PRIMITIVE";

----- component FDSE_1 -----
component FDSE_1
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDSE_1 : component is "PRIMITIVE";

----- component FDS_1 -----
component FDS_1
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FDS_1 : component is "PRIMITIVE";

----- component FD_1 -----
component FD_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     D : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FD_1 : component is "PRIMITIVE";

----- component FIFO16 -----
component FIFO16
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DATA_WIDTH : integer := 36;
     FIRST_WORD_FALL_THROUGH : boolean := false
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (11 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (11 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO16 : component is "PRIMITIVE";

----- component FIFO18 -----
component FIFO18
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     SIM_MODE : string := "SAFE"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (15 downto 0);
     DOP : out std_logic_vector (1 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (11 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (11 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (15 downto 0);
     DIP : in std_logic_vector (1 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO18 : component is "PRIMITIVE";

----- component FIFO18E1 -----
component FIFO18E1
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIFO_MODE : string := "FIFO18";
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     INIT : bit_vector := X"000000000";
     SRVAL : bit_vector := X"000000000"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (11 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (11 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     RST : in std_ulogic;
     RSTREG : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO18E1 : component is "PRIMITIVE";

----- component FIFO18_36 -----
component FIFO18_36
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     SIM_MODE : string := "SAFE"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (8 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (8 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO18_36 : component is "PRIMITIVE";

----- component FIFO36 -----
component FIFO36
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     SIM_MODE : string := "SAFE"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO36 : component is "PRIMITIVE";

----- component FIFO36E1 -----
component FIFO36E1
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     EN_SYN : boolean := FALSE;
     FIFO_MODE : string := "FIFO36";
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     INIT : bit_vector := X"000000000000000000";
     SRVAL : bit_vector := X"000000000000000000"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DBITERR : out std_ulogic;
     DO : out std_logic_vector (63 downto 0);
     DOP : out std_logic_vector (7 downto 0);
     ECCPARITY : out std_logic_vector (7 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     SBITERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (63 downto 0);
     DIP : in std_logic_vector (7 downto 0);
     INJECTDBITERR : in std_ulogic;
     INJECTSBITERR : in std_ulogic;
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     RST : in std_ulogic;
     RSTREG : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO36E1 : component is "PRIMITIVE";

----- component FIFO36_72 -----
component FIFO36_72
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DO_REG : integer := 1;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     SIM_MODE : string := "SAFE"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DBITERR : out std_ulogic;
     DO : out std_logic_vector (63 downto 0);
     DOP : out std_logic_vector (7 downto 0);
     ECCPARITY : out std_logic_vector (7 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (8 downto 0);
     RDERR : out std_ulogic;
     SBITERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (8 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (63 downto 0);
     DIP : in std_logic_vector (7 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     RST : in std_ulogic;
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO36_72 : component is "PRIMITIVE";

----- component FIFO36_72_EXP -----
component FIFO36_72_EXP
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"080";
     ALMOST_FULL_OFFSET : bit_vector := X"080";
     DO_REG : integer := 1;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     SIM_MODE : string := "SAFE"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DBITERR : out std_ulogic;
     DO : out std_logic_vector (63 downto 0);
     DOP : out std_logic_vector (7 downto 0);
     ECCPARITY : out std_logic_vector (7 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     SBITERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (63 downto 0);
     DIP : in std_logic_vector (7 downto 0);
     RDCLKL : in std_ulogic;
     RDCLKU : in std_ulogic;
     RDEN : in std_ulogic;
     RDRCLKL : in std_ulogic;
     RDRCLKU : in std_ulogic;
     RST : in std_ulogic;
     WRCLKL : in std_ulogic;
     WRCLKU : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO36_72_EXP : component is "PRIMITIVE";

----- component FIFO36_EXP -----
component FIFO36_EXP
  generic (
     ALMOST_EMPTY_OFFSET : bit_vector := X"0080";
     ALMOST_FULL_OFFSET : bit_vector := X"0080";
     DATA_WIDTH : integer := 4;
     DO_REG : integer := 1;
     EN_SYN : boolean := FALSE;
     FIRST_WORD_FALL_THROUGH : boolean := FALSE;
     SIM_MODE : string := "SAFE"
  );
  port (
     ALMOSTEMPTY : out std_ulogic;
     ALMOSTFULL : out std_ulogic;
     DO : out std_logic_vector (31 downto 0);
     DOP : out std_logic_vector (3 downto 0);
     EMPTY : out std_ulogic;
     FULL : out std_ulogic;
     RDCOUNT : out std_logic_vector (12 downto 0);
     RDERR : out std_ulogic;
     WRCOUNT : out std_logic_vector (12 downto 0);
     WRERR : out std_ulogic;
     DI : in std_logic_vector (31 downto 0);
     DIP : in std_logic_vector (3 downto 0);
     RDCLKL : in std_ulogic;
     RDCLKU : in std_ulogic;
     RDEN : in std_ulogic;
     RDRCLKL : in std_ulogic;
     RDRCLKU : in std_ulogic;
     RST : in std_ulogic;
     WRCLKL : in std_ulogic;
     WRCLKU : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FIFO36_EXP : component is "PRIMITIVE";

----- component FMAP -----
component FMAP
  port (
     I1 : in std_ulogic := 'X';
     I2 : in std_ulogic := 'X';
     I3 : in std_ulogic := 'X';
     I4 : in std_ulogic := 'X';
     O : in std_ulogic := 'X'
  );
end component;
attribute BOX_TYPE of
  FMAP : component is "PRIMITIVE";

----- component FRAME_ECC_VIRTEX4 -----
component FRAME_ECC_VIRTEX4
  port (
     ERROR : out std_ulogic;
     SYNDROME : out std_logic_vector(11 downto 0);
     SYNDROMEVALID : out std_ulogic
  );
end component;
attribute BOX_TYPE of
  FRAME_ECC_VIRTEX4 : component is "PRIMITIVE";

----- component FRAME_ECC_VIRTEX5 -----
component FRAME_ECC_VIRTEX5
  port (
     CRCERROR : out std_ulogic;
     ECCERROR : out std_ulogic;
     SYNDROME : out std_logic_vector(11 downto 0);
     SYNDROMEVALID : out std_ulogic
  );
end component;
attribute BOX_TYPE of
  FRAME_ECC_VIRTEX5 : component is "PRIMITIVE";

----- component FRAME_ECC_VIRTEX6 -----
component FRAME_ECC_VIRTEX6
  generic (
     FARSRC : string:= "EFAR";
     FRAME_RBT_IN_FILENAME : string := "frame_rbt_v6.txt"
  );
  port (
     CRCERROR : out std_ulogic;
     ECCERROR : out std_ulogic;
     ECCERRORSINGLE : out std_ulogic;
     FAR : out std_logic_vector(23 downto 0);
     SYNBIT : out std_logic_vector(4 downto 0);
     SYNDROME : out std_logic_vector(12 downto 0);
     SYNDROMEVALID : out std_ulogic;
     SYNWORD : out std_logic_vector(6 downto 0)
  );
end component;
attribute BOX_TYPE of
  FRAME_ECC_VIRTEX6 : component is "PRIMITIVE";

----- component FTC -----
component FTC
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CLR : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FTC : component is "PRIMITIVE";

----- component FTCP -----
component FTCP
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CLR : in std_ulogic;
     PRE : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FTCP : component is "PRIMITIVE";

----- component FTP -----
component FTP
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     PRE : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  FTP : component is "PRIMITIVE";

----- component GND -----
component GND
  port (
     G : out std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  GND : component is "PRIMITIVE";

----- component GT11 -----
component GT11
  generic (
     ALIGN_COMMA_WORD : integer := 4;
     BANDGAPSEL : boolean := FALSE;
     BIASRESSEL : boolean := FALSE;
     CCCB_ARBITRATOR_DISABLE : boolean := FALSE;
     CHAN_BOND_LIMIT : integer := 16;
     CHAN_BOND_MODE : string := "NONE";
     CHAN_BOND_ONE_SHOT : boolean := FALSE;
     CHAN_BOND_SEQ_1_1 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_2 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_3 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_4 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_MASK : bit_vector := "1110";
     CHAN_BOND_SEQ_2_1 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_2 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_3 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_4 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_MASK : bit_vector := "1110";
     CHAN_BOND_SEQ_2_USE : boolean := FALSE;
     CHAN_BOND_SEQ_LEN : integer := 1;
     CLK_CORRECT_USE : boolean := FALSE;
     CLK_COR_8B10B_DE : boolean := FALSE;
     CLK_COR_MAX_LAT : integer := 48;
     CLK_COR_MIN_LAT : integer := 36;
     CLK_COR_SEQ_1_1 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_2 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_3 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_4 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_MASK : bit_vector := "1110";
     CLK_COR_SEQ_2_1 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_2 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_3 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_4 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_MASK : bit_vector := "1110";
     CLK_COR_SEQ_2_USE : boolean := FALSE;
     CLK_COR_SEQ_DROP : boolean := FALSE;
     CLK_COR_SEQ_LEN : integer := 1;
     COMMA32 : boolean := FALSE;
     COMMA_10B_MASK : bit_vector := X"3FF";
     CYCLE_LIMIT_SEL : bit_vector := "00";
     DCDR_FILTER : bit_vector := "010";
     DEC_MCOMMA_DETECT : boolean := TRUE;
     DEC_PCOMMA_DETECT : boolean := TRUE;
     DEC_VALID_COMMA_ONLY : boolean := TRUE;
     DIGRX_FWDCLK : bit_vector := "00";
     DIGRX_SYNC_MODE : boolean := FALSE;
     ENABLE_DCDR : boolean := FALSE;
     FDET_HYS_CAL : bit_vector := "010";
     FDET_HYS_SEL : bit_vector := "100";
     FDET_LCK_CAL : bit_vector := "100";
     FDET_LCK_SEL : bit_vector := "001";
     GT11_MODE : string := "DONT_CARE";
     IN_DELAY : time := 0 ps;
     IREFBIASMODE : bit_vector := "11";
     LOOPCAL_WAIT : bit_vector := "00";
     MCOMMA_32B_VALUE : bit_vector := X"00000000";
     MCOMMA_DETECT : boolean := TRUE;
     OPPOSITE_SELECT : boolean := FALSE;
     PCOMMA_32B_VALUE : bit_vector := X"00000000";
     PCOMMA_DETECT : boolean := TRUE;
     PCS_BIT_SLIP : boolean := FALSE;
     PMACLKENABLE : boolean := TRUE;
     PMACOREPWRENABLE : boolean := TRUE;
     PMAIREFTRIM : bit_vector := "0111";
     PMAVBGCTRL : bit_vector := "00000";
     PMAVREFTRIM : bit_vector := "0111";
     PMA_BIT_SLIP : boolean := FALSE;
     POWER_ENABLE : boolean := TRUE;
     REPEATER : boolean := FALSE;
     RXACTST : boolean := FALSE;
     RXAFEEQ : bit_vector := "000000000";
     RXAFEPD : boolean := FALSE;
     RXAFETST : boolean := FALSE;
     RXAPD : boolean := FALSE;
     RXAREGCTRL : bit_vector := "00000";
     RXASYNCDIVIDE : bit_vector := "11";
     RXBY_32 : boolean := FALSE;
     RXCDRLOS : bit_vector := "000000";
     RXCLK0_FORCE_PMACLK : boolean := FALSE;
     RXCLKMODE : bit_vector := "110001";
     RXCLMODE : bit_vector := "00";
     RXCMADJ : bit_vector := "01";
     RXCPSEL : boolean := TRUE;
     RXCPTST : boolean := FALSE;
     RXCRCCLOCKDOUBLE : boolean := FALSE;
     RXCRCENABLE : boolean := FALSE;
     RXCRCINITVAL : bit_vector := X"00000000";
     RXCRCINVERTGEN : boolean := FALSE;
     RXCRCSAMECLOCK : boolean := FALSE;
     RXCTRL1 : bit_vector := X"200";
     RXCYCLE_LIMIT_SEL : bit_vector := "00";
     RXDATA_SEL : bit_vector := "00";
     RXDCCOUPLE : boolean := FALSE;
     RXDIGRESET : boolean := FALSE;
     RXDIGRX : boolean := FALSE;
     RXEQ : bit_vector := X"4000000000000000";
     RXFDCAL_CLOCK_DIVIDE : string := "NONE";
     RXFDET_HYS_CAL : bit_vector := "010";
     RXFDET_HYS_SEL : bit_vector := "100";
     RXFDET_LCK_CAL : bit_vector := "100";
     RXFDET_LCK_SEL : bit_vector := "001";
     RXFECONTROL1 : bit_vector := "00";
     RXFECONTROL2 : bit_vector := "000";
     RXFETUNE : bit_vector := "01";
     RXLB : boolean := FALSE;
     RXLKADJ : bit_vector := "00000";
     RXLKAPD : boolean := FALSE;
     RXLOOPCAL_WAIT : bit_vector := "00";
     RXLOOPFILT : bit_vector := "0111";
     RXMODE : bit_vector := "000000";
     RXOUTDIV2SEL : integer := 1;
     RXPD : boolean := FALSE;
     RXPDDTST : boolean := TRUE;
     RXPLLNDIVSEL : integer := 8;
     RXPMACLKSEL : string := "REFCLK1";
     RXRCPADJ : bit_vector := "011";
     RXRCPPD : boolean := FALSE;
     RXRECCLK1_USE_SYNC : boolean := FALSE;
     RXRIBADJ : bit_vector := "11";
     RXRPDPD : boolean := FALSE;
     RXRSDPD : boolean := FALSE;
     RXSLOWDOWN_CAL : bit_vector := "00";
     RXTUNE : bit_vector := X"0000";
     RXUSRDIVISOR : integer := 1;
     RXVCODAC_INIT : bit_vector := "1010000000";
     RXVCO_CTRL_ENABLE : boolean := FALSE;
     RX_BUFFER_USE : boolean := TRUE;
     RX_CLOCK_DIVIDER : bit_vector := "00";
     SAMPLE_8X : boolean := FALSE;
     SH_CNT_MAX : integer := 64;
     SH_INVALID_CNT_MAX : integer := 16;
     SLOWDOWN_CAL : bit_vector := "00";
     TXABPMACLKSEL : string := "REFCLK1";
     TXAPD : boolean := FALSE;
     TXAREFBIASSEL : boolean := TRUE;
     TXASYNCDIVIDE : bit_vector := "11";
     TXCLK0_FORCE_PMACLK : boolean := FALSE;
     TXCLKMODE : bit_vector := "1001";
     TXCLMODE : bit_vector := "00";
     TXCPSEL : boolean := TRUE;
     TXCRCCLOCKDOUBLE : boolean := FALSE;
     TXCRCENABLE : boolean := FALSE;
     TXCRCINITVAL : bit_vector := X"00000000";
     TXCRCINVERTGEN : boolean := FALSE;
     TXCRCSAMECLOCK : boolean := FALSE;
     TXCTRL1 : bit_vector := X"200";
     TXDATA_SEL : bit_vector := "00";
     TXDAT_PRDRV_DAC : bit_vector := "111";
     TXDAT_TAP_DAC : bit_vector := "10110";
     TXDIGPD : boolean := FALSE;
     TXFDCAL_CLOCK_DIVIDE : string := "NONE";
     TXHIGHSIGNALEN : boolean := TRUE;
     TXLOOPFILT : bit_vector := "0111";
     TXLVLSHFTPD : boolean := FALSE;
     TXOUTCLK1_USE_SYNC : boolean := FALSE;
     TXOUTDIV2SEL : integer := 1;
     TXPD : boolean := FALSE;
     TXPHASESEL : boolean := FALSE;
     TXPLLNDIVSEL : integer := 8;
     TXPOST_PRDRV_DAC : bit_vector := "111";
     TXPOST_TAP_DAC : bit_vector := "01110";
     TXPOST_TAP_PD : boolean := TRUE;
     TXPRE_PRDRV_DAC : bit_vector := "111";
     TXPRE_TAP_DAC : bit_vector := "00000";
     TXPRE_TAP_PD : boolean := TRUE;
     TXSLEWRATE : boolean := FALSE;
     TXTERMTRIM : bit_vector := "1100";
     TXTUNE : bit_vector := X"0000";
     TX_BUFFER_USE : boolean := TRUE;
     TX_CLOCK_DIVIDER : bit_vector := "00";
     VCODAC_INIT : bit_vector := "1010000000";
     VCO_CTRL_ENABLE : boolean := FALSE;
     VREFBIASMODE : bit_vector := "11"
  );
  port (
     CHBONDO : out std_logic_vector(4 downto 0);
     COMBUSOUT : out std_logic_vector(15 downto 0);
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic;
     RXBUFERR : out std_ulogic;
     RXCALFAIL : out std_ulogic;
     RXCHARISCOMMA : out std_logic_vector(7 downto 0);
     RXCHARISK : out std_logic_vector(7 downto 0);
     RXCOMMADET : out std_ulogic;
     RXCRCOUT : out std_logic_vector(31 downto 0);
     RXCYCLELIMIT : out std_ulogic;
     RXDATA : out std_logic_vector(63 downto 0);
     RXDISPERR : out std_logic_vector(7 downto 0);
     RXLOCK : out std_ulogic;
     RXLOSSOFSYNC : out std_logic_vector(1 downto 0);
     RXMCLK : out std_ulogic;
     RXNOTINTABLE : out std_logic_vector(7 downto 0);
     RXPCSHCLKOUT : out std_ulogic;
     RXREALIGN : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRECCLK2 : out std_ulogic;
     RXRUNDISP : out std_logic_vector(7 downto 0);
     RXSIGDET : out std_ulogic;
     RXSTATUS : out std_logic_vector(5 downto 0);
     TX1N : out std_ulogic;
     TX1P : out std_ulogic;
     TXBUFERR : out std_ulogic;
     TXCALFAIL : out std_ulogic;
     TXCRCOUT : out std_logic_vector(31 downto 0);
     TXCYCLELIMIT : out std_ulogic;
     TXKERR : out std_logic_vector(7 downto 0);
     TXLOCK : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXOUTCLK2 : out std_ulogic;
     TXPCSHCLKOUT : out std_ulogic;
     TXRUNDISP : out std_logic_vector(7 downto 0);
     CHBONDI : in std_logic_vector(4 downto 0);
     COMBUSIN : in std_logic_vector(15 downto 0);
     DADDR : in std_logic_vector(7 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     ENCHANSYNC : in std_ulogic;
     ENMCOMMAALIGN : in std_ulogic;
     ENPCOMMAALIGN : in std_ulogic;
     GREFCLK : in std_ulogic;
     LOOPBACK : in std_logic_vector(1 downto 0);
     POWERDOWN : in std_ulogic;
     REFCLK1 : in std_ulogic;
     REFCLK2 : in std_ulogic;
     RX1N : in std_ulogic;
     RX1P : in std_ulogic;
     RXBLOCKSYNC64B66BUSE : in std_ulogic;
     RXCLKSTABLE : in std_ulogic;
     RXCOMMADETUSE : in std_ulogic;
     RXCRCCLK : in std_ulogic;
     RXCRCDATAVALID : in std_ulogic;
     RXCRCDATAWIDTH : in std_logic_vector(2 downto 0);
     RXCRCIN : in std_logic_vector(63 downto 0);
     RXCRCINIT : in std_ulogic;
     RXCRCINTCLK : in std_ulogic;
     RXCRCPD : in std_ulogic;
     RXCRCRESET : in std_ulogic;
     RXDATAWIDTH : in std_logic_vector(1 downto 0);
     RXDEC64B66BUSE : in std_ulogic;
     RXDEC8B10BUSE : in std_ulogic;
     RXDESCRAM64B66BUSE : in std_ulogic;
     RXIGNOREBTF : in std_ulogic;
     RXINTDATAWIDTH : in std_logic_vector(1 downto 0);
     RXPMARESET : in std_ulogic;
     RXPOLARITY : in std_ulogic;
     RXRESET : in std_ulogic;
     RXSLIDE : in std_ulogic;
     RXSYNC : in std_ulogic;
     RXUSRCLK : in std_ulogic;
     RXUSRCLK2 : in std_ulogic;
     TXBYPASS8B10B : in std_logic_vector(7 downto 0);
     TXCHARDISPMODE : in std_logic_vector(7 downto 0);
     TXCHARDISPVAL : in std_logic_vector(7 downto 0);
     TXCHARISK : in std_logic_vector(7 downto 0);
     TXCLKSTABLE : in std_ulogic;
     TXCRCCLK : in std_ulogic;
     TXCRCDATAVALID : in std_ulogic;
     TXCRCDATAWIDTH : in std_logic_vector(2 downto 0);
     TXCRCIN : in std_logic_vector(63 downto 0);
     TXCRCINIT : in std_ulogic;
     TXCRCINTCLK : in std_ulogic;
     TXCRCPD : in std_ulogic;
     TXCRCRESET : in std_ulogic;
     TXDATA : in std_logic_vector(63 downto 0);
     TXDATAWIDTH : in std_logic_vector(1 downto 0);
     TXENC64B66BUSE : in std_ulogic;
     TXENC8B10BUSE : in std_ulogic;
     TXENOOB : in std_ulogic;
     TXGEARBOX64B66BUSE : in std_ulogic;
     TXINHIBIT : in std_ulogic;
     TXINTDATAWIDTH : in std_logic_vector(1 downto 0);
     TXPMARESET : in std_ulogic;
     TXPOLARITY : in std_ulogic;
     TXRESET : in std_ulogic;
     TXSCRAM64B66BUSE : in std_ulogic;
     TXSYNC : in std_ulogic;
     TXUSRCLK : in std_ulogic;
     TXUSRCLK2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GT11 : component is "PRIMITIVE";

----- component GT11CLK -----
component GT11CLK
  generic (
     REFCLKSEL : string := "MGTCLK";
     SYNCLK1OUTEN : string := "ENABLE";
     SYNCLK2OUTEN : string := "DISABLE"
  );
  port (
     SYNCLK1OUT : out std_ulogic;
     SYNCLK2OUT : out std_ulogic;
     MGTCLKN : in std_ulogic;
     MGTCLKP : in std_ulogic;
     REFCLK : in std_ulogic;
     RXBCLK : in std_ulogic;
     SYNCLK1IN : in std_ulogic;
     SYNCLK2IN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GT11CLK : component is "PRIMITIVE";

----- component GT11CLK_MGT -----
component GT11CLK_MGT
  generic (
     SYNCLK1OUTEN : string := "ENABLE";
     SYNCLK2OUTEN : string := "DISABLE"
  );
  port (
     SYNCLK1OUT : out std_ulogic;
     SYNCLK2OUT : out std_ulogic;
     MGTCLKN : in std_ulogic;
     MGTCLKP : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GT11CLK_MGT : component is "PRIMITIVE";

----- component GT11_CUSTOM -----
component GT11_CUSTOM
  generic (
     ALIGN_COMMA_WORD : integer := 4;
     BANDGAPSEL : boolean := FALSE;
     BIASRESSEL : boolean := FALSE;
     CCCB_ARBITRATOR_DISABLE : boolean := FALSE;
     CHAN_BOND_LIMIT : integer := 16;
     CHAN_BOND_MODE : string := "NONE";
     CHAN_BOND_ONE_SHOT : boolean := FALSE;
     CHAN_BOND_SEQ_1_1 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_2 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_3 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_4 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_MASK : bit_vector := "1110";
     CHAN_BOND_SEQ_2_1 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_2 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_3 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_4 : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_MASK : bit_vector := "1110";
     CHAN_BOND_SEQ_2_USE : boolean := FALSE;
     CHAN_BOND_SEQ_LEN : integer := 1;
     CLK_CORRECT_USE : boolean := FALSE;
     CLK_COR_8B10B_DE : boolean := FALSE;
     CLK_COR_MAX_LAT : integer := 48;
     CLK_COR_MIN_LAT : integer := 36;
     CLK_COR_SEQ_1_1 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_2 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_3 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_4 : bit_vector := "00000000000";
     CLK_COR_SEQ_1_MASK : bit_vector := "1110";
     CLK_COR_SEQ_2_1 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_2 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_3 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_4 : bit_vector := "00000000000";
     CLK_COR_SEQ_2_MASK : bit_vector := "1110";
     CLK_COR_SEQ_2_USE : boolean := FALSE;
     CLK_COR_SEQ_DROP : boolean := FALSE;
     CLK_COR_SEQ_LEN : integer := 1;
     COMMA32 : boolean := FALSE;
     COMMA_10B_MASK : bit_vector := X"3FF";
     CYCLE_LIMIT_SEL : bit_vector := "00";
     DCDR_FILTER : bit_vector := "010";
     DEC_MCOMMA_DETECT : boolean := TRUE;
     DEC_PCOMMA_DETECT : boolean := TRUE;
     DEC_VALID_COMMA_ONLY : boolean := TRUE;
     DIGRX_FWDCLK : bit_vector := "00";
     DIGRX_SYNC_MODE : boolean := FALSE;
     ENABLE_DCDR : boolean := FALSE;
     FDET_HYS_CAL : bit_vector := "010";
     FDET_HYS_SEL : bit_vector := "100";
     FDET_LCK_CAL : bit_vector := "100";
     FDET_LCK_SEL : bit_vector := "001";
     IREFBIASMODE : bit_vector := "11";
     LOOPCAL_WAIT : bit_vector := "00";
     MCOMMA_32B_VALUE : bit_vector := X"00000000";
     MCOMMA_DETECT : boolean := TRUE;
     OPPOSITE_SELECT : boolean := FALSE;
     PCOMMA_32B_VALUE : bit_vector := X"00000000";
     PCOMMA_DETECT : boolean := TRUE;
     PCS_BIT_SLIP : boolean := FALSE;
     PMACLKENABLE : boolean := TRUE;
     PMACOREPWRENABLE : boolean := TRUE;
     PMAIREFTRIM : bit_vector := "0111";
     PMAVBGCTRL : bit_vector := "00000";
     PMAVREFTRIM : bit_vector := "0111";
     PMA_BIT_SLIP : boolean := FALSE;
     POWER_ENABLE : boolean := TRUE;
     REPEATER : boolean := FALSE;
     RXACTST : boolean := FALSE;
     RXAFEEQ : bit_vector := "000000000";
     RXAFEPD : boolean := FALSE;
     RXAFETST : boolean := FALSE;
     RXAPD : boolean := FALSE;
     RXAREGCTRL : bit_vector := "00000";
     RXASYNCDIVIDE : bit_vector := "11";
     RXBY_32 : boolean := FALSE;
     RXCDRLOS : bit_vector := "000000";
     RXCLK0_FORCE_PMACLK : boolean := FALSE;
     RXCLKMODE : bit_vector := "110001";
     RXCLMODE : bit_vector := "00";
     RXCMADJ : bit_vector := "01";
     RXCPSEL : boolean := TRUE;
     RXCPTST : boolean := FALSE;
     RXCRCCLOCKDOUBLE : boolean := FALSE;
     RXCRCENABLE : boolean := FALSE;
     RXCRCINITVAL : bit_vector := X"00000000";
     RXCRCINVERTGEN : boolean := FALSE;
     RXCRCSAMECLOCK : boolean := FALSE;
     RXCTRL1 : bit_vector := X"200";
     RXCYCLE_LIMIT_SEL : bit_vector := "00";
     RXDATA_SEL : bit_vector := "00";
     RXDCCOUPLE : boolean := FALSE;
     RXDIGRESET : boolean := FALSE;
     RXDIGRX : boolean := FALSE;
     RXEQ : bit_vector := X"4000000000000000";
     RXFDCAL_CLOCK_DIVIDE : string := "NONE";
     RXFDET_HYS_CAL : bit_vector := "010";
     RXFDET_HYS_SEL : bit_vector := "100";
     RXFDET_LCK_CAL : bit_vector := "100";
     RXFDET_LCK_SEL : bit_vector := "001";
     RXFECONTROL1 : bit_vector := "00";
     RXFECONTROL2 : bit_vector := "000";
     RXFETUNE : bit_vector := "01";
     RXLB : boolean := FALSE;
     RXLKADJ : bit_vector := "00000";
     RXLKAPD : boolean := FALSE;
     RXLOOPCAL_WAIT : bit_vector := "00";
     RXLOOPFILT : bit_vector := "0111";
     RXMODE : bit_vector := "000000";
     RXOUTDIV2SEL : integer := 1;
     RXPD : boolean := FALSE;
     RXPDDTST : boolean := TRUE;
     RXPLLNDIVSEL : integer := 8;
     RXPMACLKSEL : string := "REFCLK1";
     RXRCPADJ : bit_vector := "011";
     RXRCPPD : boolean := FALSE;
     RXRECCLK1_USE_SYNC : boolean := FALSE;
     RXRIBADJ : bit_vector := "11";
     RXRPDPD : boolean := FALSE;
     RXRSDPD : boolean := FALSE;
     RXSLOWDOWN_CAL : bit_vector := "00";
     RXTUNE : bit_vector := X"0000";
     RXUSRDIVISOR : integer := 1;
     RXVCODAC_INIT : bit_vector := "1010000000";
     RXVCO_CTRL_ENABLE : boolean := FALSE;
     RX_BUFFER_USE : boolean := TRUE;
     RX_CLOCK_DIVIDER : bit_vector := "00";
     SAMPLE_8X : boolean := FALSE;
     SH_CNT_MAX : integer := 64;
     SH_INVALID_CNT_MAX : integer := 16;
     SLOWDOWN_CAL : bit_vector := "00";
     TXABPMACLKSEL : string := "REFCLK1";
     TXAPD : boolean := FALSE;
     TXAREFBIASSEL : boolean := TRUE;
     TXASYNCDIVIDE : bit_vector := "11";
     TXCLK0_FORCE_PMACLK : boolean := FALSE;
     TXCLKMODE : bit_vector := "1001";
     TXCLMODE : bit_vector := "00";
     TXCPSEL : boolean := TRUE;
     TXCRCCLOCKDOUBLE : boolean := FALSE;
     TXCRCENABLE : boolean := FALSE;
     TXCRCINITVAL : bit_vector := X"00000000";
     TXCRCINVERTGEN : boolean := FALSE;
     TXCRCSAMECLOCK : boolean := FALSE;
     TXCTRL1 : bit_vector := X"200";
     TXDATA_SEL : bit_vector := "00";
     TXDAT_PRDRV_DAC : bit_vector := "111";
     TXDAT_TAP_DAC : bit_vector := "10110";
     TXDIGPD : boolean := FALSE;
     TXFDCAL_CLOCK_DIVIDE : string := "NONE";
     TXHIGHSIGNALEN : boolean := TRUE;
     TXLOOPFILT : bit_vector := "0111";
     TXLVLSHFTPD : boolean := FALSE;
     TXOUTCLK1_USE_SYNC : boolean := FALSE;
     TXOUTDIV2SEL : integer := 1;
     TXPD : boolean := FALSE;
     TXPHASESEL : boolean := FALSE;
     TXPLLNDIVSEL : integer := 8;
     TXPOST_PRDRV_DAC : bit_vector := "111";
     TXPOST_TAP_DAC : bit_vector := "01110";
     TXPOST_TAP_PD : boolean := TRUE;
     TXPRE_PRDRV_DAC : bit_vector := "111";
     TXPRE_TAP_DAC : bit_vector := "00000";
     TXPRE_TAP_PD : boolean := TRUE;
     TXSLEWRATE : boolean := FALSE;
     TXTERMTRIM : bit_vector := "1100";
     TXTUNE : bit_vector := X"0000";
     TX_BUFFER_USE : boolean := TRUE;
     TX_CLOCK_DIVIDER : bit_vector := "00";
     VCODAC_INIT : bit_vector := "1010000000";
     VCO_CTRL_ENABLE : boolean := FALSE;
     VREFBIASMODE : bit_vector := "11"
  );
  port (
     CHBONDO : out std_logic_vector(4 downto 0);
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic;
     RXBUFERR : out std_ulogic;
     RXCALFAIL : out std_ulogic;
     RXCHARISCOMMA : out std_logic_vector(7 downto 0);
     RXCHARISK : out std_logic_vector(7 downto 0);
     RXCOMMADET : out std_ulogic;
     RXCRCOUT : out std_logic_vector(31 downto 0);
     RXCYCLELIMIT : out std_ulogic;
     RXDATA : out std_logic_vector(63 downto 0);
     RXDISPERR : out std_logic_vector(7 downto 0);
     RXLOCK : out std_ulogic;
     RXLOSSOFSYNC : out std_logic_vector(1 downto 0);
     RXMCLK : out std_ulogic;
     RXNOTINTABLE : out std_logic_vector(7 downto 0);
     RXPCSHCLKOUT : out std_ulogic;
     RXREALIGN : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRECCLK2 : out std_ulogic;
     RXRUNDISP : out std_logic_vector(7 downto 0);
     RXSIGDET : out std_ulogic;
     RXSTATUS : out std_logic_vector(5 downto 0);
     TX1N : out std_ulogic;
     TX1P : out std_ulogic;
     TXBUFERR : out std_ulogic;
     TXCALFAIL : out std_ulogic;
     TXCRCOUT : out std_logic_vector(31 downto 0);
     TXCYCLELIMIT : out std_ulogic;
     TXKERR : out std_logic_vector(7 downto 0);
     TXLOCK : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXOUTCLK2 : out std_ulogic;
     TXPCSHCLKOUT : out std_ulogic;
     TXRUNDISP : out std_logic_vector(7 downto 0);
     CHBONDI : in std_logic_vector(4 downto 0);
     DADDR : in std_logic_vector(7 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     ENCHANSYNC : in std_ulogic;
     ENMCOMMAALIGN : in std_ulogic;
     ENPCOMMAALIGN : in std_ulogic;
     GREFCLK : in std_ulogic;
     LOOPBACK : in std_logic_vector(1 downto 0);
     POWERDOWN : in std_ulogic;
     REFCLK1 : in std_ulogic;
     REFCLK2 : in std_ulogic;
     RX1N : in std_ulogic;
     RX1P : in std_ulogic;
     RXBLOCKSYNC64B66BUSE : in std_ulogic;
     RXCLKSTABLE : in std_ulogic;
     RXCOMMADETUSE : in std_ulogic;
     RXCRCCLK : in std_ulogic;
     RXCRCDATAVALID : in std_ulogic;
     RXCRCDATAWIDTH : in std_logic_vector(2 downto 0);
     RXCRCIN : in std_logic_vector(63 downto 0);
     RXCRCINIT : in std_ulogic;
     RXCRCINTCLK : in std_ulogic;
     RXCRCPD : in std_ulogic;
     RXCRCRESET : in std_ulogic;
     RXDATAWIDTH : in std_logic_vector(1 downto 0);
     RXDEC64B66BUSE : in std_ulogic;
     RXDEC8B10BUSE : in std_ulogic;
     RXDESCRAM64B66BUSE : in std_ulogic;
     RXIGNOREBTF : in std_ulogic;
     RXINTDATAWIDTH : in std_logic_vector(1 downto 0);
     RXPMARESET : in std_ulogic;
     RXPOLARITY : in std_ulogic;
     RXRESET : in std_ulogic;
     RXSLIDE : in std_ulogic;
     RXSYNC : in std_ulogic;
     RXUSRCLK : in std_ulogic;
     RXUSRCLK2 : in std_ulogic;
     TXBYPASS8B10B : in std_logic_vector(7 downto 0);
     TXCHARDISPMODE : in std_logic_vector(7 downto 0);
     TXCHARDISPVAL : in std_logic_vector(7 downto 0);
     TXCHARISK : in std_logic_vector(7 downto 0);
     TXCLKSTABLE : in std_ulogic;
     TXCRCCLK : in std_ulogic;
     TXCRCDATAVALID : in std_ulogic;
     TXCRCDATAWIDTH : in std_logic_vector(2 downto 0);
     TXCRCIN : in std_logic_vector(63 downto 0);
     TXCRCINIT : in std_ulogic;
     TXCRCINTCLK : in std_ulogic;
     TXCRCPD : in std_ulogic;
     TXCRCRESET : in std_ulogic;
     TXDATA : in std_logic_vector(63 downto 0);
     TXDATAWIDTH : in std_logic_vector(1 downto 0);
     TXENC64B66BUSE : in std_ulogic;
     TXENC8B10BUSE : in std_ulogic;
     TXENOOB : in std_ulogic;
     TXGEARBOX64B66BUSE : in std_ulogic;
     TXINHIBIT : in std_ulogic;
     TXINTDATAWIDTH : in std_logic_vector(1 downto 0);
     TXPMARESET : in std_ulogic;
     TXPOLARITY : in std_ulogic;
     TXRESET : in std_ulogic;
     TXSCRAM64B66BUSE : in std_ulogic;
     TXSYNC : in std_ulogic;
     TXUSRCLK : in std_ulogic;
     TXUSRCLK2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GT11_CUSTOM : component is "PRIMITIVE";

----- component GT11_DUAL -----
component GT11_DUAL
  generic (
     ALIGN_COMMA_WORD_A : integer := 4;
     ALIGN_COMMA_WORD_B : integer := 4;
     BANDGAPSEL_A : boolean := FALSE;
     BANDGAPSEL_B : boolean := FALSE;
     BIASRESSEL_A : boolean := FALSE;
     BIASRESSEL_B : boolean := FALSE;
     CCCB_ARBITRATOR_DISABLE_A : boolean := FALSE;
     CCCB_ARBITRATOR_DISABLE_B : boolean := FALSE;
     CHAN_BOND_LIMIT_A : integer := 16;
     CHAN_BOND_LIMIT_B : integer := 16;
     CHAN_BOND_MODE_A : string := "NONE";
     CHAN_BOND_MODE_B : string := "NONE";
     CHAN_BOND_ONE_SHOT_A : boolean := FALSE;
     CHAN_BOND_ONE_SHOT_B : boolean := FALSE;
     CHAN_BOND_SEQ_1_1_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_1_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_2_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_2_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_3_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_3_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_4_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_4_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_1_MASK_A : bit_vector := "1110";
     CHAN_BOND_SEQ_1_MASK_B : bit_vector := "1110";
     CHAN_BOND_SEQ_2_1_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_1_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_2_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_2_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_3_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_3_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_4_A : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_4_B : bit_vector := "00000000000";
     CHAN_BOND_SEQ_2_MASK_A : bit_vector := "1110";
     CHAN_BOND_SEQ_2_MASK_B : bit_vector := "1110";
     CHAN_BOND_SEQ_2_USE_A : boolean := FALSE;
     CHAN_BOND_SEQ_2_USE_B : boolean := FALSE;
     CHAN_BOND_SEQ_LEN_A : integer := 1;
     CHAN_BOND_SEQ_LEN_B : integer := 1;
     CLK_CORRECT_USE_A : boolean := FALSE;
     CLK_CORRECT_USE_B : boolean := FALSE;
     CLK_COR_8B10B_DE_A : boolean := FALSE;
     CLK_COR_8B10B_DE_B : boolean := FALSE;
     CLK_COR_MAX_LAT_A : integer := 48;
     CLK_COR_MAX_LAT_B : integer := 48;
     CLK_COR_MIN_LAT_A : integer := 36;
     CLK_COR_MIN_LAT_B : integer := 36;
     CLK_COR_SEQ_1_1_A : bit_vector := "00000000000";
     CLK_COR_SEQ_1_1_B : bit_vector := "00000000000";
     CLK_COR_SEQ_1_2_A : bit_vector := "00000000000";
     CLK_COR_SEQ_1_2_B : bit_vector := "00000000000";
     CLK_COR_SEQ_1_3_A : bit_vector := "00000000000";
     CLK_COR_SEQ_1_3_B : bit_vector := "00000000000";
     CLK_COR_SEQ_1_4_A : bit_vector := "00000000000";
     CLK_COR_SEQ_1_4_B : bit_vector := "00000000000";
     CLK_COR_SEQ_1_MASK_A : bit_vector := "1110";
     CLK_COR_SEQ_1_MASK_B : bit_vector := "1110";
     CLK_COR_SEQ_2_1_A : bit_vector := "00000000000";
     CLK_COR_SEQ_2_1_B : bit_vector := "00000000000";
     CLK_COR_SEQ_2_2_A : bit_vector := "00000000000";
     CLK_COR_SEQ_2_2_B : bit_vector := "00000000000";
     CLK_COR_SEQ_2_3_A : bit_vector := "00000000000";
     CLK_COR_SEQ_2_3_B : bit_vector := "00000000000";
     CLK_COR_SEQ_2_4_A : bit_vector := "00000000000";
     CLK_COR_SEQ_2_4_B : bit_vector := "00000000000";
     CLK_COR_SEQ_2_MASK_A : bit_vector := "1110";
     CLK_COR_SEQ_2_MASK_B : bit_vector := "1110";
     CLK_COR_SEQ_2_USE_A : boolean := FALSE;
     CLK_COR_SEQ_2_USE_B : boolean := FALSE;
     CLK_COR_SEQ_DROP_A : boolean := FALSE;
     CLK_COR_SEQ_DROP_B : boolean := FALSE;
     CLK_COR_SEQ_LEN_A : integer := 1;
     CLK_COR_SEQ_LEN_B : integer := 1;
     COMMA32_A : boolean := FALSE;
     COMMA32_B : boolean := FALSE;
     COMMA_10B_MASK_A : bit_vector := X"3FF";
     COMMA_10B_MASK_B : bit_vector := X"3FF";
     CYCLE_LIMIT_SEL_A : bit_vector := "00";
     CYCLE_LIMIT_SEL_B : bit_vector := "00";
     DCDR_FILTER_A : bit_vector := "010";
     DCDR_FILTER_B : bit_vector := "010";
     DEC_MCOMMA_DETECT_A : boolean := TRUE;
     DEC_MCOMMA_DETECT_B : boolean := TRUE;
     DEC_PCOMMA_DETECT_A : boolean := TRUE;
     DEC_PCOMMA_DETECT_B : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_A : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_B : boolean := TRUE;
     DIGRX_FWDCLK_A : bit_vector := "00";
     DIGRX_FWDCLK_B : bit_vector := "00";
     DIGRX_SYNC_MODE_A : boolean := FALSE;
     DIGRX_SYNC_MODE_B : boolean := FALSE;
     ENABLE_DCDR_A : boolean := FALSE;
     ENABLE_DCDR_B : boolean := FALSE;
     FDET_HYS_CAL_A : bit_vector := "010";
     FDET_HYS_CAL_B : bit_vector := "010";
     FDET_HYS_SEL_A : bit_vector := "100";
     FDET_HYS_SEL_B : bit_vector := "100";
     FDET_LCK_CAL_A : bit_vector := "100";
     FDET_LCK_CAL_B : bit_vector := "100";
     FDET_LCK_SEL_A : bit_vector := "001";
     FDET_LCK_SEL_B : bit_vector := "001";
     IREFBIASMODE_A : bit_vector := "11";
     IREFBIASMODE_B : bit_vector := "11";
     LOOPCAL_WAIT_A : bit_vector := "00";
     LOOPCAL_WAIT_B : bit_vector := "00";
     MCOMMA_32B_VALUE_A : bit_vector := X"00000000";
     MCOMMA_32B_VALUE_B : bit_vector := X"00000000";
     MCOMMA_DETECT_A : boolean := TRUE;
     MCOMMA_DETECT_B : boolean := TRUE;
     OPPOSITE_SELECT_A : boolean := FALSE;
     OPPOSITE_SELECT_B : boolean := FALSE;
     PCOMMA_32B_VALUE_A : bit_vector := X"00000000";
     PCOMMA_32B_VALUE_B : bit_vector := X"00000000";
     PCOMMA_DETECT_A : boolean := TRUE;
     PCOMMA_DETECT_B : boolean := TRUE;
     PCS_BIT_SLIP_A : boolean := FALSE;
     PCS_BIT_SLIP_B : boolean := FALSE;
     PMACLKENABLE_A : boolean := TRUE;
     PMACLKENABLE_B : boolean := TRUE;
     PMACOREPWRENABLE_A : boolean := TRUE;
     PMACOREPWRENABLE_B : boolean := TRUE;
     PMAIREFTRIM_A : bit_vector := "0111";
     PMAIREFTRIM_B : bit_vector := "0111";
     PMAVBGCTRL_A : bit_vector := "00000";
     PMAVBGCTRL_B : bit_vector := "00000";
     PMAVREFTRIM_A : bit_vector := "0111";
     PMAVREFTRIM_B : bit_vector := "0111";
     PMA_BIT_SLIP_A : boolean := FALSE;
     PMA_BIT_SLIP_B : boolean := FALSE;
     POWER_ENABLE_A : boolean := TRUE;
     POWER_ENABLE_B : boolean := TRUE;
     REPEATER_A : boolean := FALSE;
     REPEATER_B : boolean := FALSE;
     RXACTST_A : boolean := FALSE;
     RXACTST_B : boolean := FALSE;
     RXAFEEQ_A : bit_vector := "000000000";
     RXAFEEQ_B : bit_vector := "000000000";
     RXAFEPD_A : boolean := FALSE;
     RXAFEPD_B : boolean := FALSE;
     RXAFETST_A : boolean := FALSE;
     RXAFETST_B : boolean := FALSE;
     RXAPD_A : boolean := FALSE;
     RXAPD_B : boolean := FALSE;
     RXAREGCTRL_A : bit_vector := "00000";
     RXAREGCTRL_B : bit_vector := "00000";
     RXASYNCDIVIDE_A : bit_vector := "11";
     RXASYNCDIVIDE_B : bit_vector := "11";
     RXBY_32_A : boolean := FALSE;
     RXBY_32_B : boolean := FALSE;
     RXCDRLOS_A : bit_vector := "000000";
     RXCDRLOS_B : bit_vector := "000000";
     RXCLK0_FORCE_PMACLK_A : boolean := FALSE;
     RXCLK0_FORCE_PMACLK_B : boolean := FALSE;
     RXCLKMODE_A : bit_vector := "110001";
     RXCLKMODE_B : bit_vector := "110001";
     RXCLMODE_A : bit_vector := "00";
     RXCLMODE_B : bit_vector := "00";
     RXCMADJ_A : bit_vector := "01";
     RXCMADJ_B : bit_vector := "01";
     RXCPSEL_A : boolean := TRUE;
     RXCPSEL_B : boolean := TRUE;
     RXCPTST_A : boolean := FALSE;
     RXCPTST_B : boolean := FALSE;
     RXCRCCLOCKDOUBLE_A : boolean := FALSE;
     RXCRCCLOCKDOUBLE_B : boolean := FALSE;
     RXCRCENABLE_A : boolean := FALSE;
     RXCRCENABLE_B : boolean := FALSE;
     RXCRCINITVAL_A : bit_vector := X"00000000";
     RXCRCINITVAL_B : bit_vector := X"00000000";
     RXCRCINVERTGEN_A : boolean := FALSE;
     RXCRCINVERTGEN_B : boolean := FALSE;
     RXCRCSAMECLOCK_A : boolean := FALSE;
     RXCRCSAMECLOCK_B : boolean := FALSE;
     RXCTRL1_A : bit_vector := X"200";
     RXCTRL1_B : bit_vector := X"200";
     RXCYCLE_LIMIT_SEL_A : bit_vector := "00";
     RXCYCLE_LIMIT_SEL_B : bit_vector := "00";
     RXDATA_SEL_A : bit_vector := "00";
     RXDATA_SEL_B : bit_vector := "00";
     RXDCCOUPLE_A : boolean := FALSE;
     RXDCCOUPLE_B : boolean := FALSE;
     RXDIGRESET_A : boolean := FALSE;
     RXDIGRESET_B : boolean := FALSE;
     RXDIGRX_A : boolean := FALSE;
     RXDIGRX_B : boolean := FALSE;
     RXEQ_A : bit_vector := X"4000000000000000";
     RXEQ_B : bit_vector := X"4000000000000000";
     RXFDCAL_CLOCK_DIVIDE_A : string := "NONE";
     RXFDCAL_CLOCK_DIVIDE_B : string := "NONE";
     RXFDET_HYS_CAL_A : bit_vector := "010";
     RXFDET_HYS_CAL_B : bit_vector := "010";
     RXFDET_HYS_SEL_A : bit_vector := "100";
     RXFDET_HYS_SEL_B : bit_vector := "100";
     RXFDET_LCK_CAL_A : bit_vector := "100";
     RXFDET_LCK_CAL_B : bit_vector := "100";
     RXFDET_LCK_SEL_A : bit_vector := "001";
     RXFDET_LCK_SEL_B : bit_vector := "001";
     RXFECONTROL1_A : bit_vector := "00";
     RXFECONTROL1_B : bit_vector := "00";
     RXFECONTROL2_A : bit_vector := "000";
     RXFECONTROL2_B : bit_vector := "000";
     RXFETUNE_A : bit_vector := "01";
     RXFETUNE_B : bit_vector := "01";
     RXLB_A : boolean := FALSE;
     RXLB_B : boolean := FALSE;
     RXLKADJ_A : bit_vector := "00000";
     RXLKADJ_B : bit_vector := "00000";
     RXLKAPD_A : boolean := FALSE;
     RXLKAPD_B : boolean := FALSE;
     RXLOOPCAL_WAIT_A : bit_vector := "00";
     RXLOOPCAL_WAIT_B : bit_vector := "00";
     RXLOOPFILT_A : bit_vector := "0111";
     RXLOOPFILT_B : bit_vector := "0111";
     RXMODE_A : bit_vector := "000000";
     RXMODE_B : bit_vector := "000000";
     RXOUTDIV2SEL_A : integer := 1;
     RXOUTDIV2SEL_B : integer := 1;
     RXPDDTST_A : boolean := TRUE;
     RXPDDTST_B : boolean := TRUE;
     RXPD_A : boolean := FALSE;
     RXPD_B : boolean := FALSE;
     RXPLLNDIVSEL_A : integer := 8;
     RXPLLNDIVSEL_B : integer := 8;
     RXPMACLKSEL_A : string := "REFCLK1";
     RXPMACLKSEL_B : string := "REFCLK1";
     RXRCPADJ_A : bit_vector := "011";
     RXRCPADJ_B : bit_vector := "011";
     RXRCPPD_A : boolean := FALSE;
     RXRCPPD_B : boolean := FALSE;
     RXRECCLK1_USE_SYNC_A : boolean := FALSE;
     RXRECCLK1_USE_SYNC_B : boolean := FALSE;
     RXRIBADJ_A : bit_vector := "11";
     RXRIBADJ_B : bit_vector := "11";
     RXRPDPD_A : boolean := FALSE;
     RXRPDPD_B : boolean := FALSE;
     RXRSDPD_A : boolean := FALSE;
     RXRSDPD_B : boolean := FALSE;
     RXSLOWDOWN_CAL_A : bit_vector := "00";
     RXSLOWDOWN_CAL_B : bit_vector := "00";
     RXTUNE_A : bit_vector := X"0000";
     RXTUNE_B : bit_vector := X"0000";
     RXUSRDIVISOR_A : integer := 1;
     RXUSRDIVISOR_B : integer := 1;
     RXVCODAC_INIT_A : bit_vector := "1010000000";
     RXVCODAC_INIT_B : bit_vector := "1010000000";
     RXVCO_CTRL_ENABLE_A : boolean := FALSE;
     RXVCO_CTRL_ENABLE_B : boolean := FALSE;
     RX_BUFFER_USE_A : boolean := TRUE;
     RX_BUFFER_USE_B : boolean := TRUE;
     RX_CLOCK_DIVIDER_A : bit_vector := "00";
     RX_CLOCK_DIVIDER_B : bit_vector := "00";
     SAMPLE_8X_A : boolean := FALSE;
     SAMPLE_8X_B : boolean := FALSE;
     SH_CNT_MAX_A : integer := 64;
     SH_CNT_MAX_B : integer := 64;
     SH_INVALID_CNT_MAX_A : integer := 16;
     SH_INVALID_CNT_MAX_B : integer := 16;
     SLOWDOWN_CAL_A : bit_vector := "00";
     SLOWDOWN_CAL_B : bit_vector := "00";
     TXABPMACLKSEL_A : string := "REFCLK1";
     TXABPMACLKSEL_B : string := "REFCLK1";
     TXAPD_A : boolean := FALSE;
     TXAPD_B : boolean := FALSE;
     TXAREFBIASSEL_A : boolean := TRUE;
     TXAREFBIASSEL_B : boolean := TRUE;
     TXASYNCDIVIDE_A : bit_vector := "11";
     TXASYNCDIVIDE_B : bit_vector := "11";
     TXCLK0_FORCE_PMACLK_A : boolean := FALSE;
     TXCLK0_FORCE_PMACLK_B : boolean := FALSE;
     TXCLKMODE_A : bit_vector := "1001";
     TXCLKMODE_B : bit_vector := "1001";
     TXCLMODE_A : bit_vector := "00";
     TXCLMODE_B : bit_vector := "00";
     TXCPSEL_A : boolean := TRUE;
     TXCPSEL_B : boolean := TRUE;
     TXCRCCLOCKDOUBLE_A : boolean := FALSE;
     TXCRCCLOCKDOUBLE_B : boolean := FALSE;
     TXCRCENABLE_A : boolean := FALSE;
     TXCRCENABLE_B : boolean := FALSE;
     TXCRCINITVAL_A : bit_vector := X"00000000";
     TXCRCINITVAL_B : bit_vector := X"00000000";
     TXCRCINVERTGEN_A : boolean := FALSE;
     TXCRCINVERTGEN_B : boolean := FALSE;
     TXCRCSAMECLOCK_A : boolean := FALSE;
     TXCRCSAMECLOCK_B : boolean := FALSE;
     TXCTRL1_A : bit_vector := X"200";
     TXCTRL1_B : bit_vector := X"200";
     TXDATA_SEL_A : bit_vector := "00";
     TXDATA_SEL_B : bit_vector := "00";
     TXDAT_PRDRV_DAC_A : bit_vector := "111";
     TXDAT_PRDRV_DAC_B : bit_vector := "111";
     TXDAT_TAP_DAC_A : bit_vector := "10110";
     TXDAT_TAP_DAC_B : bit_vector := "10110";
     TXDIGPD_A : boolean := FALSE;
     TXDIGPD_B : boolean := FALSE;
     TXFDCAL_CLOCK_DIVIDE_A : string := "NONE";
     TXFDCAL_CLOCK_DIVIDE_B : string := "NONE";
     TXHIGHSIGNALEN_A : boolean := TRUE;
     TXHIGHSIGNALEN_B : boolean := TRUE;
     TXLOOPFILT_A : bit_vector := "0111";
     TXLOOPFILT_B : bit_vector := "0111";
     TXLVLSHFTPD_A : boolean := FALSE;
     TXLVLSHFTPD_B : boolean := FALSE;
     TXOUTCLK1_USE_SYNC_A : boolean := FALSE;
     TXOUTCLK1_USE_SYNC_B : boolean := FALSE;
     TXOUTDIV2SEL_A : integer := 1;
     TXOUTDIV2SEL_B : integer := 1;
     TXPD_A : boolean := FALSE;
     TXPD_B : boolean := FALSE;
     TXPHASESEL_A : boolean := FALSE;
     TXPHASESEL_B : boolean := FALSE;
     TXPLLNDIVSEL_A : integer := 8;
     TXPLLNDIVSEL_B : integer := 8;
     TXPOST_PRDRV_DAC_A : bit_vector := "111";
     TXPOST_PRDRV_DAC_B : bit_vector := "111";
     TXPOST_TAP_DAC_A : bit_vector := "01110";
     TXPOST_TAP_DAC_B : bit_vector := "01110";
     TXPOST_TAP_PD_A : boolean := TRUE;
     TXPOST_TAP_PD_B : boolean := TRUE;
     TXPRE_PRDRV_DAC_A : bit_vector := "111";
     TXPRE_PRDRV_DAC_B : bit_vector := "111";
     TXPRE_TAP_DAC_A : bit_vector := "00000";
     TXPRE_TAP_DAC_B : bit_vector := "00000";
     TXPRE_TAP_PD_A : boolean := TRUE;
     TXPRE_TAP_PD_B : boolean := TRUE;
     TXSLEWRATE_A : boolean := FALSE;
     TXSLEWRATE_B : boolean := FALSE;
     TXTERMTRIM_A : bit_vector := "1100";
     TXTERMTRIM_B : bit_vector := "1100";
     TXTUNE_A : bit_vector := X"0000";
     TXTUNE_B : bit_vector := X"0000";
     TX_BUFFER_USE_A : boolean := TRUE;
     TX_BUFFER_USE_B : boolean := TRUE;
     TX_CLOCK_DIVIDER_A : bit_vector := "00";
     TX_CLOCK_DIVIDER_B : bit_vector := "00";
     VCODAC_INIT_A : bit_vector := "1010000000";
     VCODAC_INIT_B : bit_vector := "1010000000";
     VCO_CTRL_ENABLE_A : boolean := FALSE;
     VCO_CTRL_ENABLE_B : boolean := FALSE;
     VREFBIASMODE_A : bit_vector := "11";
     VREFBIASMODE_B : bit_vector := "11"
  );
  port (
     CHBONDOA : out std_logic_vector(4 downto 0);
     CHBONDOB : out std_logic_vector(4 downto 0);
     DOA : out std_logic_vector(15 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DRDYA : out std_ulogic;
     DRDYB : out std_ulogic;
     RXBUFERRA : out std_ulogic;
     RXBUFERRB : out std_ulogic;
     RXCALFAILA : out std_ulogic;
     RXCALFAILB : out std_ulogic;
     RXCHARISCOMMAA : out std_logic_vector(7 downto 0);
     RXCHARISCOMMAB : out std_logic_vector(7 downto 0);
     RXCHARISKA : out std_logic_vector(7 downto 0);
     RXCHARISKB : out std_logic_vector(7 downto 0);
     RXCOMMADETA : out std_ulogic;
     RXCOMMADETB : out std_ulogic;
     RXCRCOUTA : out std_logic_vector(31 downto 0);
     RXCRCOUTB : out std_logic_vector(31 downto 0);
     RXCYCLELIMITA : out std_ulogic;
     RXCYCLELIMITB : out std_ulogic;
     RXDATAA : out std_logic_vector(63 downto 0);
     RXDATAB : out std_logic_vector(63 downto 0);
     RXDISPERRA : out std_logic_vector(7 downto 0);
     RXDISPERRB : out std_logic_vector(7 downto 0);
     RXLOCKA : out std_ulogic;
     RXLOCKB : out std_ulogic;
     RXLOSSOFSYNCA : out std_logic_vector(1 downto 0);
     RXLOSSOFSYNCB : out std_logic_vector(1 downto 0);
     RXMCLKA : out std_ulogic;
     RXMCLKB : out std_ulogic;
     RXNOTINTABLEA : out std_logic_vector(7 downto 0);
     RXNOTINTABLEB : out std_logic_vector(7 downto 0);
     RXPCSHCLKOUTA : out std_ulogic;
     RXPCSHCLKOUTB : out std_ulogic;
     RXREALIGNA : out std_ulogic;
     RXREALIGNB : out std_ulogic;
     RXRECCLK1A : out std_ulogic;
     RXRECCLK1B : out std_ulogic;
     RXRECCLK2A : out std_ulogic;
     RXRECCLK2B : out std_ulogic;
     RXRUNDISPA : out std_logic_vector(7 downto 0);
     RXRUNDISPB : out std_logic_vector(7 downto 0);
     RXSIGDETA : out std_ulogic;
     RXSIGDETB : out std_ulogic;
     RXSTATUSA : out std_logic_vector(5 downto 0);
     RXSTATUSB : out std_logic_vector(5 downto 0);
     TX1NA : out std_ulogic;
     TX1NB : out std_ulogic;
     TX1PA : out std_ulogic;
     TX1PB : out std_ulogic;
     TXBUFERRA : out std_ulogic;
     TXBUFERRB : out std_ulogic;
     TXCALFAILA : out std_ulogic;
     TXCALFAILB : out std_ulogic;
     TXCRCOUTA : out std_logic_vector(31 downto 0);
     TXCRCOUTB : out std_logic_vector(31 downto 0);
     TXCYCLELIMITA : out std_ulogic;
     TXCYCLELIMITB : out std_ulogic;
     TXKERRA : out std_logic_vector(7 downto 0);
     TXKERRB : out std_logic_vector(7 downto 0);
     TXLOCKA : out std_ulogic;
     TXLOCKB : out std_ulogic;
     TXOUTCLK1A : out std_ulogic;
     TXOUTCLK1B : out std_ulogic;
     TXOUTCLK2A : out std_ulogic;
     TXOUTCLK2B : out std_ulogic;
     TXPCSHCLKOUTA : out std_ulogic;
     TXPCSHCLKOUTB : out std_ulogic;
     TXRUNDISPA : out std_logic_vector(7 downto 0);
     TXRUNDISPB : out std_logic_vector(7 downto 0);
     CHBONDIA : in std_logic_vector(4 downto 0);
     CHBONDIB : in std_logic_vector(4 downto 0);
     DADDRA : in std_logic_vector(7 downto 0);
     DADDRB : in std_logic_vector(7 downto 0);
     DCLKA : in std_ulogic;
     DCLKB : in std_ulogic;
     DENA : in std_ulogic;
     DENB : in std_ulogic;
     DIA : in std_logic_vector(15 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DWEA : in std_ulogic;
     DWEB : in std_ulogic;
     ENCHANSYNCA : in std_ulogic;
     ENCHANSYNCB : in std_ulogic;
     ENMCOMMAALIGNA : in std_ulogic;
     ENMCOMMAALIGNB : in std_ulogic;
     ENPCOMMAALIGNA : in std_ulogic;
     ENPCOMMAALIGNB : in std_ulogic;
     GREFCLKA : in std_ulogic;
     GREFCLKB : in std_ulogic;
     LOOPBACKA : in std_logic_vector(1 downto 0);
     LOOPBACKB : in std_logic_vector(1 downto 0);
     POWERDOWNA : in std_ulogic;
     POWERDOWNB : in std_ulogic;
     REFCLK1A : in std_ulogic;
     REFCLK1B : in std_ulogic;
     REFCLK2A : in std_ulogic;
     REFCLK2B : in std_ulogic;
     RX1NA : in std_ulogic;
     RX1NB : in std_ulogic;
     RX1PA : in std_ulogic;
     RX1PB : in std_ulogic;
     RXBLOCKSYNC64B66BUSEA : in std_ulogic;
     RXBLOCKSYNC64B66BUSEB : in std_ulogic;
     RXCLKSTABLEA : in std_ulogic;
     RXCLKSTABLEB : in std_ulogic;
     RXCOMMADETUSEA : in std_ulogic;
     RXCOMMADETUSEB : in std_ulogic;
     RXCRCCLKA : in std_ulogic;
     RXCRCCLKB : in std_ulogic;
     RXCRCDATAVALIDA : in std_ulogic;
     RXCRCDATAVALIDB : in std_ulogic;
     RXCRCDATAWIDTHA : in std_logic_vector(2 downto 0);
     RXCRCDATAWIDTHB : in std_logic_vector(2 downto 0);
     RXCRCINA : in std_logic_vector(63 downto 0);
     RXCRCINB : in std_logic_vector(63 downto 0);
     RXCRCINITA : in std_ulogic;
     RXCRCINITB : in std_ulogic;
     RXCRCINTCLKA : in std_ulogic;
     RXCRCINTCLKB : in std_ulogic;
     RXCRCPDA : in std_ulogic;
     RXCRCPDB : in std_ulogic;
     RXCRCRESETA : in std_ulogic;
     RXCRCRESETB : in std_ulogic;
     RXDATAWIDTHA : in std_logic_vector(1 downto 0);
     RXDATAWIDTHB : in std_logic_vector(1 downto 0);
     RXDEC64B66BUSEA : in std_ulogic;
     RXDEC64B66BUSEB : in std_ulogic;
     RXDEC8B10BUSEA : in std_ulogic;
     RXDEC8B10BUSEB : in std_ulogic;
     RXDESCRAM64B66BUSEA : in std_ulogic;
     RXDESCRAM64B66BUSEB : in std_ulogic;
     RXIGNOREBTFA : in std_ulogic;
     RXIGNOREBTFB : in std_ulogic;
     RXINTDATAWIDTHA : in std_logic_vector(1 downto 0);
     RXINTDATAWIDTHB : in std_logic_vector(1 downto 0);
     RXPMARESETA : in std_ulogic;
     RXPMARESETB : in std_ulogic;
     RXPOLARITYA : in std_ulogic;
     RXPOLARITYB : in std_ulogic;
     RXRESETA : in std_ulogic;
     RXRESETB : in std_ulogic;
     RXSLIDEA : in std_ulogic;
     RXSLIDEB : in std_ulogic;
     RXSYNCA : in std_ulogic;
     RXSYNCB : in std_ulogic;
     RXUSRCLK2A : in std_ulogic;
     RXUSRCLK2B : in std_ulogic;
     RXUSRCLKA : in std_ulogic;
     RXUSRCLKB : in std_ulogic;
     TXBYPASS8B10BA : in std_logic_vector(7 downto 0);
     TXBYPASS8B10BB : in std_logic_vector(7 downto 0);
     TXCHARDISPMODEA : in std_logic_vector(7 downto 0);
     TXCHARDISPMODEB : in std_logic_vector(7 downto 0);
     TXCHARDISPVALA : in std_logic_vector(7 downto 0);
     TXCHARDISPVALB : in std_logic_vector(7 downto 0);
     TXCHARISKA : in std_logic_vector(7 downto 0);
     TXCHARISKB : in std_logic_vector(7 downto 0);
     TXCLKSTABLEA : in std_ulogic;
     TXCLKSTABLEB : in std_ulogic;
     TXCRCCLKA : in std_ulogic;
     TXCRCCLKB : in std_ulogic;
     TXCRCDATAVALIDA : in std_ulogic;
     TXCRCDATAVALIDB : in std_ulogic;
     TXCRCDATAWIDTHA : in std_logic_vector(2 downto 0);
     TXCRCDATAWIDTHB : in std_logic_vector(2 downto 0);
     TXCRCINA : in std_logic_vector(63 downto 0);
     TXCRCINB : in std_logic_vector(63 downto 0);
     TXCRCINITA : in std_ulogic;
     TXCRCINITB : in std_ulogic;
     TXCRCINTCLKA : in std_ulogic;
     TXCRCINTCLKB : in std_ulogic;
     TXCRCPDA : in std_ulogic;
     TXCRCPDB : in std_ulogic;
     TXCRCRESETA : in std_ulogic;
     TXCRCRESETB : in std_ulogic;
     TXDATAA : in std_logic_vector(63 downto 0);
     TXDATAB : in std_logic_vector(63 downto 0);
     TXDATAWIDTHA : in std_logic_vector(1 downto 0);
     TXDATAWIDTHB : in std_logic_vector(1 downto 0);
     TXENC64B66BUSEA : in std_ulogic;
     TXENC64B66BUSEB : in std_ulogic;
     TXENC8B10BUSEA : in std_ulogic;
     TXENC8B10BUSEB : in std_ulogic;
     TXENOOBA : in std_ulogic;
     TXENOOBB : in std_ulogic;
     TXGEARBOX64B66BUSEA : in std_ulogic;
     TXGEARBOX64B66BUSEB : in std_ulogic;
     TXINHIBITA : in std_ulogic;
     TXINHIBITB : in std_ulogic;
     TXINTDATAWIDTHA : in std_logic_vector(1 downto 0);
     TXINTDATAWIDTHB : in std_logic_vector(1 downto 0);
     TXPMARESETA : in std_ulogic;
     TXPMARESETB : in std_ulogic;
     TXPOLARITYA : in std_ulogic;
     TXPOLARITYB : in std_ulogic;
     TXRESETA : in std_ulogic;
     TXRESETB : in std_ulogic;
     TXSCRAM64B66BUSEA : in std_ulogic;
     TXSCRAM64B66BUSEB : in std_ulogic;
     TXSYNCA : in std_ulogic;
     TXSYNCB : in std_ulogic;
     TXUSRCLK2A : in std_ulogic;
     TXUSRCLK2B : in std_ulogic;
     TXUSRCLKA : in std_ulogic;
     TXUSRCLKB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GT11_DUAL : component is "PRIMITIVE";

----- component GTHE1_QUAD -----
component GTHE1_QUAD
  generic (
     BER_CONST_PTRN0 : bit_vector := X"0000";
     BER_CONST_PTRN1 : bit_vector := X"0000";
     BUFFER_CONFIG_LANE0 : bit_vector := X"4004";
     BUFFER_CONFIG_LANE1 : bit_vector := X"4004";
     BUFFER_CONFIG_LANE2 : bit_vector := X"4004";
     BUFFER_CONFIG_LANE3 : bit_vector := X"4004";
     DFE_TRAIN_CTRL_LANE0 : bit_vector := X"0000";
     DFE_TRAIN_CTRL_LANE1 : bit_vector := X"0000";
     DFE_TRAIN_CTRL_LANE2 : bit_vector := X"0000";
     DFE_TRAIN_CTRL_LANE3 : bit_vector := X"0000";
     DLL_CFG0 : bit_vector := X"4201";
     DLL_CFG1 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE0 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE1 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE2 : bit_vector := X"0000";
     E10GBASEKR_LD_COEFF_UPD_LANE3 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE0 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE1 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE2 : bit_vector := X"0000";
     E10GBASEKR_LP_COEFF_UPD_LANE3 : bit_vector := X"0000";
     E10GBASEKR_PMA_CTRL_LANE0 : bit_vector := X"0002";
     E10GBASEKR_PMA_CTRL_LANE1 : bit_vector := X"0002";
     E10GBASEKR_PMA_CTRL_LANE2 : bit_vector := X"0002";
     E10GBASEKR_PMA_CTRL_LANE3 : bit_vector := X"0002";
     E10GBASEKX_CTRL_LANE0 : bit_vector := X"0000";
     E10GBASEKX_CTRL_LANE1 : bit_vector := X"0000";
     E10GBASEKX_CTRL_LANE2 : bit_vector := X"0000";
     E10GBASEKX_CTRL_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_CFG_LANE0 : bit_vector := X"070C";
     E10GBASER_PCS_CFG_LANE1 : bit_vector := X"070C";
     E10GBASER_PCS_CFG_LANE2 : bit_vector := X"070C";
     E10GBASER_PCS_CFG_LANE3 : bit_vector := X"070C";
     E10GBASER_PCS_SEEDA0_LANE0 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA0_LANE1 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA0_LANE2 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA0_LANE3 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDA1_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA1_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA1_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA1_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA2_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDA3_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB0_LANE0 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB0_LANE1 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB0_LANE2 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB0_LANE3 : bit_vector := X"0001";
     E10GBASER_PCS_SEEDB1_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB1_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB1_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB1_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB2_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_SEEDB3_LANE3 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE0 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE1 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE2 : bit_vector := X"0000";
     E10GBASER_PCS_TEST_CTRL_LANE3 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE0 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE1 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE2 : bit_vector := X"0000";
     E10GBASEX_PCS_TSTCTRL_LANE3 : bit_vector := X"0000";
     GLBL0_NOISE_CTRL : bit_vector := X"F0B8";
     GLBL_AMON_SEL : bit_vector := X"0000";
     GLBL_DMON_SEL : bit_vector := X"0200";
     GLBL_PWR_CTRL : bit_vector := X"0000";
     GTH_CFG_PWRUP_LANE0 : bit := '1';
     GTH_CFG_PWRUP_LANE1 : bit := '1';
     GTH_CFG_PWRUP_LANE2 : bit := '1';
     GTH_CFG_PWRUP_LANE3 : bit := '1';
     LANE_AMON_SEL : bit_vector := X"00F0";
     LANE_DMON_SEL : bit_vector := X"0000";
     LANE_LNK_CFGOVRD : bit_vector := X"0000";
     LANE_PWR_CTRL_LANE0 : bit_vector := X"0400";
     LANE_PWR_CTRL_LANE1 : bit_vector := X"0400";
     LANE_PWR_CTRL_LANE2 : bit_vector := X"0400";
     LANE_PWR_CTRL_LANE3 : bit_vector := X"0400";
     LNK_TRN_CFG_LANE0 : bit_vector := X"0000";
     LNK_TRN_CFG_LANE1 : bit_vector := X"0000";
     LNK_TRN_CFG_LANE2 : bit_vector := X"0000";
     LNK_TRN_CFG_LANE3 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE0 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE1 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE2 : bit_vector := X"0000";
     LNK_TRN_COEFF_REQ_LANE3 : bit_vector := X"0000";
     MISC_CFG : bit_vector := X"0004";
     MODE_CFG1 : bit_vector := X"0000";
     MODE_CFG2 : bit_vector := X"0000";
     MODE_CFG3 : bit_vector := X"0000";
     MODE_CFG4 : bit_vector := X"0000";
     MODE_CFG5 : bit_vector := X"0000";
     MODE_CFG6 : bit_vector := X"0000";
     MODE_CFG7 : bit_vector := X"0000";
     PCS_ABILITY_LANE0 : bit_vector := X"0010";
     PCS_ABILITY_LANE1 : bit_vector := X"0010";
     PCS_ABILITY_LANE2 : bit_vector := X"0010";
     PCS_ABILITY_LANE3 : bit_vector := X"0010";
     PCS_CTRL1_LANE0 : bit_vector := X"2040";
     PCS_CTRL1_LANE1 : bit_vector := X"2040";
     PCS_CTRL1_LANE2 : bit_vector := X"2040";
     PCS_CTRL1_LANE3 : bit_vector := X"2040";
     PCS_CTRL2_LANE0 : bit_vector := X"0000";
     PCS_CTRL2_LANE1 : bit_vector := X"0000";
     PCS_CTRL2_LANE2 : bit_vector := X"0000";
     PCS_CTRL2_LANE3 : bit_vector := X"0000";
     PCS_MISC_CFG_0_LANE0 : bit_vector := X"1117";
     PCS_MISC_CFG_0_LANE1 : bit_vector := X"1117";
     PCS_MISC_CFG_0_LANE2 : bit_vector := X"1117";
     PCS_MISC_CFG_0_LANE3 : bit_vector := X"1117";
     PCS_MISC_CFG_1_LANE0 : bit_vector := X"0000";
     PCS_MISC_CFG_1_LANE1 : bit_vector := X"0000";
     PCS_MISC_CFG_1_LANE2 : bit_vector := X"0000";
     PCS_MISC_CFG_1_LANE3 : bit_vector := X"0000";
     PCS_MODE_LANE0 : bit_vector := X"0000";
     PCS_MODE_LANE1 : bit_vector := X"0000";
     PCS_MODE_LANE2 : bit_vector := X"0000";
     PCS_MODE_LANE3 : bit_vector := X"0000";
     PCS_RESET_1_LANE0 : bit_vector := X"0002";
     PCS_RESET_1_LANE1 : bit_vector := X"0002";
     PCS_RESET_1_LANE2 : bit_vector := X"0002";
     PCS_RESET_1_LANE3 : bit_vector := X"0002";
     PCS_RESET_LANE0 : bit_vector := X"0000";
     PCS_RESET_LANE1 : bit_vector := X"0000";
     PCS_RESET_LANE2 : bit_vector := X"0000";
     PCS_RESET_LANE3 : bit_vector := X"0000";
     PCS_TYPE_LANE0 : bit_vector := X"002C";
     PCS_TYPE_LANE1 : bit_vector := X"002C";
     PCS_TYPE_LANE2 : bit_vector := X"002C";
     PCS_TYPE_LANE3 : bit_vector := X"002C";
     PLL_CFG0 : bit_vector := X"58C0";
     PLL_CFG1 : bit_vector := X"8440";
     PLL_CFG2 : bit_vector := X"0424";
     PMA_CTRL1_LANE0 : bit_vector := X"0000";
     PMA_CTRL1_LANE1 : bit_vector := X"0000";
     PMA_CTRL1_LANE2 : bit_vector := X"0000";
     PMA_CTRL1_LANE3 : bit_vector := X"0000";
     PMA_CTRL2_LANE0 : bit_vector := X"000B";
     PMA_CTRL2_LANE1 : bit_vector := X"000B";
     PMA_CTRL2_LANE2 : bit_vector := X"000B";
     PMA_CTRL2_LANE3 : bit_vector := X"000B";
     PMA_LPBK_CTRL_LANE0 : bit_vector := X"0004";
     PMA_LPBK_CTRL_LANE1 : bit_vector := X"0004";
     PMA_LPBK_CTRL_LANE2 : bit_vector := X"0004";
     PMA_LPBK_CTRL_LANE3 : bit_vector := X"0004";
     PRBS_BER_CFG0_LANE0 : bit_vector := X"0000";
     PRBS_BER_CFG0_LANE1 : bit_vector := X"0000";
     PRBS_BER_CFG0_LANE2 : bit_vector := X"0000";
     PRBS_BER_CFG0_LANE3 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE0 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE1 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE2 : bit_vector := X"0000";
     PRBS_BER_CFG1_LANE3 : bit_vector := X"0000";
     PRBS_CFG_LANE0 : bit_vector := X"000A";
     PRBS_CFG_LANE1 : bit_vector := X"000A";
     PRBS_CFG_LANE2 : bit_vector := X"000A";
     PRBS_CFG_LANE3 : bit_vector := X"000A";
     PTRN_CFG0_LSB : bit_vector := X"5555";
     PTRN_CFG0_MSB : bit_vector := X"5555";
     PTRN_LEN_CFG : bit_vector := X"001F";
     PWRUP_DLY : bit_vector := X"0000";
     RX_AEQ_VAL0_LANE0 : bit_vector := X"0100";
     RX_AEQ_VAL0_LANE1 : bit_vector := X"0100";
     RX_AEQ_VAL0_LANE2 : bit_vector := X"0100";
     RX_AEQ_VAL0_LANE3 : bit_vector := X"0100";
     RX_AEQ_VAL1_LANE0 : bit_vector := X"0000";
     RX_AEQ_VAL1_LANE1 : bit_vector := X"0000";
     RX_AEQ_VAL1_LANE2 : bit_vector := X"0000";
     RX_AEQ_VAL1_LANE3 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE0 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE1 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE2 : bit_vector := X"0000";
     RX_AGC_CTRL_LANE3 : bit_vector := X"0000";
     RX_CDR_CTRL0_LANE0 : bit_vector := X"0005";
     RX_CDR_CTRL0_LANE1 : bit_vector := X"0005";
     RX_CDR_CTRL0_LANE2 : bit_vector := X"0005";
     RX_CDR_CTRL0_LANE3 : bit_vector := X"0005";
     RX_CDR_CTRL1_LANE0 : bit_vector := X"4300";
     RX_CDR_CTRL1_LANE1 : bit_vector := X"4300";
     RX_CDR_CTRL1_LANE2 : bit_vector := X"4300";
     RX_CDR_CTRL1_LANE3 : bit_vector := X"4300";
     RX_CDR_CTRL2_LANE0 : bit_vector := X"2000";
     RX_CDR_CTRL2_LANE1 : bit_vector := X"2000";
     RX_CDR_CTRL2_LANE2 : bit_vector := X"2000";
     RX_CDR_CTRL2_LANE3 : bit_vector := X"2000";
     RX_CFG0_LANE0 : bit_vector := X"0B06";
     RX_CFG0_LANE1 : bit_vector := X"0B06";
     RX_CFG0_LANE2 : bit_vector := X"0B06";
     RX_CFG0_LANE3 : bit_vector := X"0B06";
     RX_CFG1_LANE0 : bit_vector := X"817F";
     RX_CFG1_LANE1 : bit_vector := X"817F";
     RX_CFG1_LANE2 : bit_vector := X"817F";
     RX_CFG1_LANE3 : bit_vector := X"817F";
     RX_CFG2_LANE0 : bit_vector := X"1000";
     RX_CFG2_LANE1 : bit_vector := X"1000";
     RX_CFG2_LANE2 : bit_vector := X"1000";
     RX_CFG2_LANE3 : bit_vector := X"1000";
     RX_CTLE_CTRL_LANE0 : bit_vector := X"007F";
     RX_CTLE_CTRL_LANE1 : bit_vector := X"007F";
     RX_CTLE_CTRL_LANE2 : bit_vector := X"007F";
     RX_CTLE_CTRL_LANE3 : bit_vector := X"007F";
     RX_CTRL_OVRD_LANE0 : bit_vector := X"000C";
     RX_CTRL_OVRD_LANE1 : bit_vector := X"000C";
     RX_CTRL_OVRD_LANE2 : bit_vector := X"000C";
     RX_CTRL_OVRD_LANE3 : bit_vector := X"000C";
     RX_FABRIC_WIDTH0 : integer := 6466;
     RX_FABRIC_WIDTH1 : integer := 6466;
     RX_FABRIC_WIDTH2 : integer := 6466;
     RX_FABRIC_WIDTH3 : integer := 6466;
     RX_LOOP_CTRL_LANE0 : bit_vector := X"0070";
     RX_LOOP_CTRL_LANE1 : bit_vector := X"0070";
     RX_LOOP_CTRL_LANE2 : bit_vector := X"0070";
     RX_LOOP_CTRL_LANE3 : bit_vector := X"0070";
     RX_MVAL0_LANE0 : bit_vector := X"0000";
     RX_MVAL0_LANE1 : bit_vector := X"0000";
     RX_MVAL0_LANE2 : bit_vector := X"0000";
     RX_MVAL0_LANE3 : bit_vector := X"0000";
     RX_MVAL1_LANE0 : bit_vector := X"0000";
     RX_MVAL1_LANE1 : bit_vector := X"0000";
     RX_MVAL1_LANE2 : bit_vector := X"0000";
     RX_MVAL1_LANE3 : bit_vector := X"0000";
     RX_P0S_CTRL : bit_vector := X"1206";
     RX_P0_CTRL : bit_vector := X"11F0";
     RX_P1_CTRL : bit_vector := X"120F";
     RX_P2_CTRL : bit_vector := X"0E0F";
     RX_PI_CTRL0 : bit_vector := X"B2F2";
     RX_PI_CTRL1 : bit_vector := X"0080";
     SIM_GTHRESET_SPEEDUP : integer := 1;
     SIM_VERSION : string := "1.0";
     SLICE_CFG : bit_vector := X"0000";
     SLICE_NOISE_CTRL_0_LANE01 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_0_LANE23 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_1_LANE01 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_1_LANE23 : bit_vector := X"0000";
     SLICE_NOISE_CTRL_2_LANE01 : bit_vector := X"EFFF";
     SLICE_NOISE_CTRL_2_LANE23 : bit_vector := X"EFFF";
     SLICE_TX_RESET_LANE01 : bit_vector := X"0000";
     SLICE_TX_RESET_LANE23 : bit_vector := X"0000";
     TERM_CTRL_LANE0 : bit_vector := X"0000";
     TERM_CTRL_LANE1 : bit_vector := X"0000";
     TERM_CTRL_LANE2 : bit_vector := X"0000";
     TERM_CTRL_LANE3 : bit_vector := X"0000";
     TX_CFG0_LANE0 : bit_vector := X"203D";
     TX_CFG0_LANE1 : bit_vector := X"203D";
     TX_CFG0_LANE2 : bit_vector := X"203D";
     TX_CFG0_LANE3 : bit_vector := X"203D";
     TX_CFG1_LANE0 : bit_vector := X"0C83";
     TX_CFG1_LANE1 : bit_vector := X"0C83";
     TX_CFG1_LANE2 : bit_vector := X"0C83";
     TX_CFG1_LANE3 : bit_vector := X"0C83";
     TX_CFG2_LANE0 : bit_vector := X"0001";
     TX_CFG2_LANE1 : bit_vector := X"0001";
     TX_CFG2_LANE2 : bit_vector := X"0001";
     TX_CFG2_LANE3 : bit_vector := X"0001";
     TX_CLK_SEL0_LANE0 : bit_vector := X"2F2F";
     TX_CLK_SEL0_LANE1 : bit_vector := X"2F2F";
     TX_CLK_SEL0_LANE2 : bit_vector := X"2F2F";
     TX_CLK_SEL0_LANE3 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE0 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE1 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE2 : bit_vector := X"2F2F";
     TX_CLK_SEL1_LANE3 : bit_vector := X"2F2F";
     TX_DISABLE_LANE0 : bit_vector := X"0000";
     TX_DISABLE_LANE1 : bit_vector := X"0000";
     TX_DISABLE_LANE2 : bit_vector := X"0000";
     TX_DISABLE_LANE3 : bit_vector := X"0000";
     TX_FABRIC_WIDTH0 : integer := 6466;
     TX_FABRIC_WIDTH1 : integer := 6466;
     TX_FABRIC_WIDTH2 : integer := 6466;
     TX_FABRIC_WIDTH3 : integer := 6466;
     TX_P0P0S_CTRL : bit_vector := X"060C";
     TX_P1P2_CTRL : bit_vector := X"0C39";
     TX_PREEMPH_LANE0 : bit_vector := X"A0F0";
     TX_PREEMPH_LANE1 : bit_vector := X"A0F0";
     TX_PREEMPH_LANE2 : bit_vector := X"A0F0";
     TX_PREEMPH_LANE3 : bit_vector := X"A0F0";
     TX_PWR_RATE_OVRD_LANE0 : bit_vector := X"0060";
     TX_PWR_RATE_OVRD_LANE1 : bit_vector := X"0060";
     TX_PWR_RATE_OVRD_LANE2 : bit_vector := X"0060";
     TX_PWR_RATE_OVRD_LANE3 : bit_vector := X"0060"
  );
  port (
     DRDY : out std_ulogic;
     DRPDO : out std_logic_vector(15 downto 0);
     GTHINITDONE : out std_ulogic;
     MGMTPCSRDACK : out std_ulogic;
     MGMTPCSRDDATA : out std_logic_vector(15 downto 0);
     RXCODEERR0 : out std_logic_vector(7 downto 0);
     RXCODEERR1 : out std_logic_vector(7 downto 0);
     RXCODEERR2 : out std_logic_vector(7 downto 0);
     RXCODEERR3 : out std_logic_vector(7 downto 0);
     RXCTRL0 : out std_logic_vector(7 downto 0);
     RXCTRL1 : out std_logic_vector(7 downto 0);
     RXCTRL2 : out std_logic_vector(7 downto 0);
     RXCTRL3 : out std_logic_vector(7 downto 0);
     RXCTRLACK0 : out std_ulogic;
     RXCTRLACK1 : out std_ulogic;
     RXCTRLACK2 : out std_ulogic;
     RXCTRLACK3 : out std_ulogic;
     RXDATA0 : out std_logic_vector(63 downto 0);
     RXDATA1 : out std_logic_vector(63 downto 0);
     RXDATA2 : out std_logic_vector(63 downto 0);
     RXDATA3 : out std_logic_vector(63 downto 0);
     RXDATATAP0 : out std_ulogic;
     RXDATATAP1 : out std_ulogic;
     RXDATATAP2 : out std_ulogic;
     RXDATATAP3 : out std_ulogic;
     RXDISPERR0 : out std_logic_vector(7 downto 0);
     RXDISPERR1 : out std_logic_vector(7 downto 0);
     RXDISPERR2 : out std_logic_vector(7 downto 0);
     RXDISPERR3 : out std_logic_vector(7 downto 0);
     RXPCSCLKSMPL0 : out std_ulogic;
     RXPCSCLKSMPL1 : out std_ulogic;
     RXPCSCLKSMPL2 : out std_ulogic;
     RXPCSCLKSMPL3 : out std_ulogic;
     RXUSERCLKOUT0 : out std_ulogic;
     RXUSERCLKOUT1 : out std_ulogic;
     RXUSERCLKOUT2 : out std_ulogic;
     RXUSERCLKOUT3 : out std_ulogic;
     RXVALID0 : out std_logic_vector(7 downto 0);
     RXVALID1 : out std_logic_vector(7 downto 0);
     RXVALID2 : out std_logic_vector(7 downto 0);
     RXVALID3 : out std_logic_vector(7 downto 0);
     TSTPATH : out std_ulogic;
     TSTREFCLKFAB : out std_ulogic;
     TSTREFCLKOUT : out std_ulogic;
     TXCTRLACK0 : out std_ulogic;
     TXCTRLACK1 : out std_ulogic;
     TXCTRLACK2 : out std_ulogic;
     TXCTRLACK3 : out std_ulogic;
     TXDATATAP10 : out std_ulogic;
     TXDATATAP11 : out std_ulogic;
     TXDATATAP12 : out std_ulogic;
     TXDATATAP13 : out std_ulogic;
     TXDATATAP20 : out std_ulogic;
     TXDATATAP21 : out std_ulogic;
     TXDATATAP22 : out std_ulogic;
     TXDATATAP23 : out std_ulogic;
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXN2 : out std_ulogic;
     TXN3 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXP2 : out std_ulogic;
     TXP3 : out std_ulogic;
     TXPCSCLKSMPL0 : out std_ulogic;
     TXPCSCLKSMPL1 : out std_ulogic;
     TXPCSCLKSMPL2 : out std_ulogic;
     TXPCSCLKSMPL3 : out std_ulogic;
     TXUSERCLKOUT0 : out std_ulogic;
     TXUSERCLKOUT1 : out std_ulogic;
     TXUSERCLKOUT2 : out std_ulogic;
     TXUSERCLKOUT3 : out std_ulogic;
     DADDR : in std_logic_vector(15 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DFETRAINCTRL0 : in std_ulogic;
     DFETRAINCTRL1 : in std_ulogic;
     DFETRAINCTRL2 : in std_ulogic;
     DFETRAINCTRL3 : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DISABLEDRP : in std_ulogic;
     DWE : in std_ulogic;
     GTHINIT : in std_ulogic;
     GTHRESET : in std_ulogic;
     GTHX2LANE01 : in std_ulogic;
     GTHX2LANE23 : in std_ulogic;
     GTHX4LANE : in std_ulogic;
     MGMTPCSLANESEL : in std_logic_vector(3 downto 0);
     MGMTPCSMMDADDR : in std_logic_vector(4 downto 0);
     MGMTPCSREGADDR : in std_logic_vector(15 downto 0);
     MGMTPCSREGRD : in std_ulogic;
     MGMTPCSREGWR : in std_ulogic;
     MGMTPCSWRDATA : in std_logic_vector(15 downto 0);
     PLLPCSCLKDIV : in std_logic_vector(5 downto 0);
     PLLREFCLKSEL : in std_logic_vector(2 downto 0);
     POWERDOWN0 : in std_ulogic;
     POWERDOWN1 : in std_ulogic;
     POWERDOWN2 : in std_ulogic;
     POWERDOWN3 : in std_ulogic;
     REFCLK : in std_ulogic;
     RXBUFRESET0 : in std_ulogic;
     RXBUFRESET1 : in std_ulogic;
     RXBUFRESET2 : in std_ulogic;
     RXBUFRESET3 : in std_ulogic;
     RXENCOMMADET0 : in std_ulogic;
     RXENCOMMADET1 : in std_ulogic;
     RXENCOMMADET2 : in std_ulogic;
     RXENCOMMADET3 : in std_ulogic;
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXN2 : in std_ulogic;
     RXN3 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXP2 : in std_ulogic;
     RXP3 : in std_ulogic;
     RXPOLARITY0 : in std_ulogic;
     RXPOLARITY1 : in std_ulogic;
     RXPOLARITY2 : in std_ulogic;
     RXPOLARITY3 : in std_ulogic;
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN2 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN3 : in std_logic_vector(1 downto 0);
     RXRATE0 : in std_logic_vector(1 downto 0);
     RXRATE1 : in std_logic_vector(1 downto 0);
     RXRATE2 : in std_logic_vector(1 downto 0);
     RXRATE3 : in std_logic_vector(1 downto 0);
     RXSLIP0 : in std_ulogic;
     RXSLIP1 : in std_ulogic;
     RXSLIP2 : in std_ulogic;
     RXSLIP3 : in std_ulogic;
     RXUSERCLKIN0 : in std_ulogic;
     RXUSERCLKIN1 : in std_ulogic;
     RXUSERCLKIN2 : in std_ulogic;
     RXUSERCLKIN3 : in std_ulogic;
     SAMPLERATE0 : in std_logic_vector(2 downto 0);
     SAMPLERATE1 : in std_logic_vector(2 downto 0);
     SAMPLERATE2 : in std_logic_vector(2 downto 0);
     SAMPLERATE3 : in std_logic_vector(2 downto 0);
     TXBUFRESET0 : in std_ulogic;
     TXBUFRESET1 : in std_ulogic;
     TXBUFRESET2 : in std_ulogic;
     TXBUFRESET3 : in std_ulogic;
     TXCTRL0 : in std_logic_vector(7 downto 0);
     TXCTRL1 : in std_logic_vector(7 downto 0);
     TXCTRL2 : in std_logic_vector(7 downto 0);
     TXCTRL3 : in std_logic_vector(7 downto 0);
     TXDATA0 : in std_logic_vector(63 downto 0);
     TXDATA1 : in std_logic_vector(63 downto 0);
     TXDATA2 : in std_logic_vector(63 downto 0);
     TXDATA3 : in std_logic_vector(63 downto 0);
     TXDATAMSB0 : in std_logic_vector(7 downto 0);
     TXDATAMSB1 : in std_logic_vector(7 downto 0);
     TXDATAMSB2 : in std_logic_vector(7 downto 0);
     TXDATAMSB3 : in std_logic_vector(7 downto 0);
     TXDEEMPH0 : in std_ulogic;
     TXDEEMPH1 : in std_ulogic;
     TXDEEMPH2 : in std_ulogic;
     TXDEEMPH3 : in std_ulogic;
     TXMARGIN0 : in std_logic_vector(2 downto 0);
     TXMARGIN1 : in std_logic_vector(2 downto 0);
     TXMARGIN2 : in std_logic_vector(2 downto 0);
     TXMARGIN3 : in std_logic_vector(2 downto 0);
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN2 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN3 : in std_logic_vector(1 downto 0);
     TXRATE0 : in std_logic_vector(1 downto 0);
     TXRATE1 : in std_logic_vector(1 downto 0);
     TXRATE2 : in std_logic_vector(1 downto 0);
     TXRATE3 : in std_logic_vector(1 downto 0);
     TXUSERCLKIN0 : in std_ulogic;
     TXUSERCLKIN1 : in std_ulogic;
     TXUSERCLKIN2 : in std_ulogic;
     TXUSERCLKIN3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GTHE1_QUAD : component is "PRIMITIVE";

----- component GTPA1_DUAL -----
component GTPA1_DUAL
  generic (
     AC_CAP_DIS_0 : boolean := TRUE;
     AC_CAP_DIS_1 : boolean := TRUE;
     ALIGN_COMMA_WORD_0 : integer := 1;
     ALIGN_COMMA_WORD_1 : integer := 1;
     CB2_INH_CC_PERIOD_0 : integer := 8;
     CB2_INH_CC_PERIOD_1 : integer := 8;
     CDR_PH_ADJ_TIME_0 : bit_vector := "01010";
     CDR_PH_ADJ_TIME_1 : bit_vector := "01010";
     CHAN_BOND_1_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_1_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_0 : integer := 1;
     CHAN_BOND_2_MAX_SKEW_1 : integer := 1;
     CHAN_BOND_KEEP_ALIGN_0 : boolean := FALSE;
     CHAN_BOND_KEEP_ALIGN_1 : boolean := FALSE;
     CHAN_BOND_SEQ_1_1_0 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_1_1 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_2_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_2_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_4_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_4_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_1_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_1_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_2_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_2_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_USE_0 : boolean := FALSE;
     CHAN_BOND_SEQ_2_USE_1 : boolean := FALSE;
     CHAN_BOND_SEQ_LEN_0 : integer := 1;
     CHAN_BOND_SEQ_LEN_1 : integer := 1;
     CLK25_DIVIDER_0 : integer := 4;
     CLK25_DIVIDER_1 : integer := 4;
     CLKINDC_B_0 : boolean := TRUE;
     CLKINDC_B_1 : boolean := TRUE;
     CLKRCV_TRST_0 : boolean := TRUE;
     CLKRCV_TRST_1 : boolean := TRUE;
     CLK_CORRECT_USE_0 : boolean := TRUE;
     CLK_CORRECT_USE_1 : boolean := TRUE;
     CLK_COR_ADJ_LEN_0 : integer := 1;
     CLK_COR_ADJ_LEN_1 : integer := 1;
     CLK_COR_DET_LEN_0 : integer := 1;
     CLK_COR_DET_LEN_1 : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG_0 : boolean := FALSE;
     CLK_COR_INSERT_IDLE_FLAG_1 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_0 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_1 : boolean := FALSE;
     CLK_COR_MAX_LAT_0 : integer := 20;
     CLK_COR_MAX_LAT_1 : integer := 20;
     CLK_COR_MIN_LAT_0 : integer := 18;
     CLK_COR_MIN_LAT_1 : integer := 18;
     CLK_COR_PRECEDENCE_0 : boolean := TRUE;
     CLK_COR_PRECEDENCE_1 : boolean := TRUE;
     CLK_COR_REPEAT_WAIT_0 : integer := 0;
     CLK_COR_REPEAT_WAIT_1 : integer := 0;
     CLK_COR_SEQ_1_1_0 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_1_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_1_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_USE_0 : boolean := FALSE;
     CLK_COR_SEQ_2_USE_1 : boolean := FALSE;
     CLK_OUT_GTP_SEL_0 : string := "REFCLKPLL0";
     CLK_OUT_GTP_SEL_1 : string := "REFCLKPLL1";
     CM_TRIM_0 : bit_vector := "00";
     CM_TRIM_1 : bit_vector := "00";
     COMMA_10B_ENABLE_0 : bit_vector := "1111111111";
     COMMA_10B_ENABLE_1 : bit_vector := "1111111111";
     COM_BURST_VAL_0 : bit_vector := "1111";
     COM_BURST_VAL_1 : bit_vector := "1111";
     DEC_MCOMMA_DETECT_0 : boolean := TRUE;
     DEC_MCOMMA_DETECT_1 : boolean := TRUE;
     DEC_PCOMMA_DETECT_0 : boolean := TRUE;
     DEC_PCOMMA_DETECT_1 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_0 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_1 : boolean := TRUE;
     GTP_CFG_PWRUP_0 : boolean := TRUE;
     GTP_CFG_PWRUP_1 : boolean := TRUE;
     MCOMMA_10B_VALUE_0 : bit_vector := "1010000011";
     MCOMMA_10B_VALUE_1 : bit_vector := "1010000011";
     MCOMMA_DETECT_0 : boolean := TRUE;
     MCOMMA_DETECT_1 : boolean := TRUE;
     OOBDETECT_THRESHOLD_0 : bit_vector := "110";
     OOBDETECT_THRESHOLD_1 : bit_vector := "110";
     OOB_CLK_DIVIDER_0 : integer := 4;
     OOB_CLK_DIVIDER_1 : integer := 4;
     PCI_EXPRESS_MODE_0 : boolean := FALSE;
     PCI_EXPRESS_MODE_1 : boolean := FALSE;
     PCOMMA_10B_VALUE_0 : bit_vector := "0101111100";
     PCOMMA_10B_VALUE_1 : bit_vector := "0101111100";
     PCOMMA_DETECT_0 : boolean := TRUE;
     PCOMMA_DETECT_1 : boolean := TRUE;
     PLLLKDET_CFG_0 : bit_vector := "101";
     PLLLKDET_CFG_1 : bit_vector := "101";
     PLL_COM_CFG_0 : bit_vector := X"21680A";
     PLL_COM_CFG_1 : bit_vector := X"21680A";
     PLL_CP_CFG_0 : bit_vector := X"00";
     PLL_CP_CFG_1 : bit_vector := X"00";
     PLL_DIVSEL_FB_0 : integer := 5;
     PLL_DIVSEL_FB_1 : integer := 5;
     PLL_DIVSEL_REF_0 : integer := 2;
     PLL_DIVSEL_REF_1 : integer := 2;
     PLL_RXDIVSEL_OUT_0 : integer := 1;
     PLL_RXDIVSEL_OUT_1 : integer := 1;
     PLL_SATA_0 : boolean := FALSE;
     PLL_SATA_1 : boolean := FALSE;
     PLL_SOURCE_0 : string := "PLL0";
     PLL_SOURCE_1 : string := "PLL0";
     PLL_TXDIVSEL_OUT_0 : integer := 1;
     PLL_TXDIVSEL_OUT_1 : integer := 1;
     PMA_CDR_SCAN_0 : bit_vector := X"6404040";
     PMA_CDR_SCAN_1 : bit_vector := X"6404040";
     PMA_COM_CFG_EAST : bit_vector := X"000008000";
     PMA_COM_CFG_WEST : bit_vector := X"000008000";
     PMA_RXSYNC_CFG_0 : bit_vector := X"00";
     PMA_RXSYNC_CFG_1 : bit_vector := X"00";
     PMA_RX_CFG_0 : bit_vector := X"05CE048";
     PMA_RX_CFG_1 : bit_vector := X"05CE048";
     PMA_TX_CFG_0 : bit_vector := X"00082";
     PMA_TX_CFG_1 : bit_vector := X"00082";
     RCV_TERM_GND_0 : boolean := FALSE;
     RCV_TERM_GND_1 : boolean := FALSE;
     RCV_TERM_VTTRX_0 : boolean := TRUE;
     RCV_TERM_VTTRX_1 : boolean := TRUE;
     RXEQ_CFG_0 : bit_vector := "01111011";
     RXEQ_CFG_1 : bit_vector := "01111011";
     RXPRBSERR_LOOPBACK_0 : bit := '0';
     RXPRBSERR_LOOPBACK_1 : bit := '0';
     RX_BUFFER_USE_0 : boolean := TRUE;
     RX_BUFFER_USE_1 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_0 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_1 : boolean := TRUE;
     RX_EN_IDLE_HOLD_CDR_0 : boolean := FALSE;
     RX_EN_IDLE_HOLD_CDR_1 : boolean := FALSE;
     RX_EN_IDLE_RESET_BUF_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_FR_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_FR_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_PH_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_PH_1 : boolean := TRUE;
     RX_EN_MODE_RESET_BUF_0 : boolean := TRUE;
     RX_EN_MODE_RESET_BUF_1 : boolean := TRUE;
     RX_IDLE_HI_CNT_0 : bit_vector := "1000";
     RX_IDLE_HI_CNT_1 : bit_vector := "1000";
     RX_IDLE_LO_CNT_0 : bit_vector := "0000";
     RX_IDLE_LO_CNT_1 : bit_vector := "0000";
     RX_LOSS_OF_SYNC_FSM_0 : boolean := FALSE;
     RX_LOSS_OF_SYNC_FSM_1 : boolean := FALSE;
     RX_LOS_INVALID_INCR_0 : integer := 1;
     RX_LOS_INVALID_INCR_1 : integer := 1;
     RX_LOS_THRESHOLD_0 : integer := 4;
     RX_LOS_THRESHOLD_1 : integer := 4;
     RX_SLIDE_MODE_0 : string := "PCS";
     RX_SLIDE_MODE_1 : string := "PCS";
     RX_STATUS_FMT_0 : string := "PCIE";
     RX_STATUS_FMT_1 : string := "PCIE";
     RX_XCLK_SEL_0 : string := "RXREC";
     RX_XCLK_SEL_1 : string := "RXREC";
     SATA_BURST_VAL_0 : bit_vector := "100";
     SATA_BURST_VAL_1 : bit_vector := "100";
     SATA_IDLE_VAL_0 : bit_vector := "011";
     SATA_IDLE_VAL_1 : bit_vector := "011";
     SATA_MAX_BURST_0 : integer := 7;
     SATA_MAX_BURST_1 : integer := 7;
     SATA_MAX_INIT_0 : integer := 22;
     SATA_MAX_INIT_1 : integer := 22;
     SATA_MAX_WAKE_0 : integer := 7;
     SATA_MAX_WAKE_1 : integer := 7;
     SATA_MIN_BURST_0 : integer := 4;
     SATA_MIN_BURST_1 : integer := 4;
     SATA_MIN_INIT_0 : integer := 12;
     SATA_MIN_INIT_1 : integer := 12;
     SATA_MIN_WAKE_0 : integer := 4;
     SATA_MIN_WAKE_1 : integer := 4;
     SIM_GTPRESET_SPEEDUP : integer := 0;
     SIM_RECEIVER_DETECT_PASS : boolean := FALSE;
     SIM_REFCLK0_SOURCE : bit_vector := "000";
     SIM_REFCLK1_SOURCE : bit_vector := "000";
     SIM_TX_ELEC_IDLE_LEVEL : string := "X";
     SIM_VERSION : string := "2.0";
     TERMINATION_CTRL_0 : bit_vector := "10100";
     TERMINATION_CTRL_1 : bit_vector := "10100";
     TERMINATION_OVRD_0 : boolean := FALSE;
     TERMINATION_OVRD_1 : boolean := FALSE;
     TRANS_TIME_FROM_P2_0 : bit_vector := X"03C";
     TRANS_TIME_FROM_P2_1 : bit_vector := X"03C";
     TRANS_TIME_NON_P2_0 : bit_vector := X"19";
     TRANS_TIME_NON_P2_1 : bit_vector := X"19";
     TRANS_TIME_TO_P2_0 : bit_vector := X"064";
     TRANS_TIME_TO_P2_1 : bit_vector := X"064";
     TST_ATTR_0 : bit_vector := X"00000000";
     TST_ATTR_1 : bit_vector := X"00000000";
     TXRX_INVERT_0 : bit_vector := "011";
     TXRX_INVERT_1 : bit_vector := "011";
     TX_BUFFER_USE_0 : boolean := FALSE;
     TX_BUFFER_USE_1 : boolean := FALSE;
     TX_DETECT_RX_CFG_0 : bit_vector := X"1832";
     TX_DETECT_RX_CFG_1 : bit_vector := X"1832";
     TX_IDLE_DELAY_0 : bit_vector := "011";
     TX_IDLE_DELAY_1 : bit_vector := "011";
     TX_TDCC_CFG_0 : bit_vector := "00";
     TX_TDCC_CFG_1 : bit_vector := "00";
     TX_XCLK_SEL_0 : string := "TXUSR";
     TX_XCLK_SEL_1 : string := "TXUSR"
  );
  port (
     DRDY : out std_ulogic;
     DRPDO : out std_logic_vector(15 downto 0);
     GTPCLKFBEAST : out std_logic_vector(1 downto 0);
     GTPCLKFBWEST : out std_logic_vector(1 downto 0);
     GTPCLKOUT0 : out std_logic_vector(1 downto 0);
     GTPCLKOUT1 : out std_logic_vector(1 downto 0);
     PHYSTATUS0 : out std_ulogic;
     PHYSTATUS1 : out std_ulogic;
     PLLLKDET0 : out std_ulogic;
     PLLLKDET1 : out std_ulogic;
     RCALOUTEAST : out std_logic_vector(4 downto 0);
     RCALOUTWEST : out std_logic_vector(4 downto 0);
     REFCLKOUT0 : out std_ulogic;
     REFCLKOUT1 : out std_ulogic;
     REFCLKPLL0 : out std_ulogic;
     REFCLKPLL1 : out std_ulogic;
     RESETDONE0 : out std_ulogic;
     RESETDONE1 : out std_ulogic;
     RXBUFSTATUS0 : out std_logic_vector(2 downto 0);
     RXBUFSTATUS1 : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED0 : out std_ulogic;
     RXBYTEISALIGNED1 : out std_ulogic;
     RXBYTEREALIGN0 : out std_ulogic;
     RXBYTEREALIGN1 : out std_ulogic;
     RXCHANBONDSEQ0 : out std_ulogic;
     RXCHANBONDSEQ1 : out std_ulogic;
     RXCHANISALIGNED0 : out std_ulogic;
     RXCHANISALIGNED1 : out std_ulogic;
     RXCHANREALIGN0 : out std_ulogic;
     RXCHANREALIGN1 : out std_ulogic;
     RXCHARISCOMMA0 : out std_logic_vector(3 downto 0);
     RXCHARISCOMMA1 : out std_logic_vector(3 downto 0);
     RXCHARISK0 : out std_logic_vector(3 downto 0);
     RXCHARISK1 : out std_logic_vector(3 downto 0);
     RXCHBONDO : out std_logic_vector(2 downto 0);
     RXCLKCORCNT0 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT1 : out std_logic_vector(2 downto 0);
     RXCOMMADET0 : out std_ulogic;
     RXCOMMADET1 : out std_ulogic;
     RXDATA0 : out std_logic_vector(31 downto 0);
     RXDATA1 : out std_logic_vector(31 downto 0);
     RXDISPERR0 : out std_logic_vector(3 downto 0);
     RXDISPERR1 : out std_logic_vector(3 downto 0);
     RXELECIDLE0 : out std_ulogic;
     RXELECIDLE1 : out std_ulogic;
     RXLOSSOFSYNC0 : out std_logic_vector(1 downto 0);
     RXLOSSOFSYNC1 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE0 : out std_logic_vector(3 downto 0);
     RXNOTINTABLE1 : out std_logic_vector(3 downto 0);
     RXPRBSERR0 : out std_ulogic;
     RXPRBSERR1 : out std_ulogic;
     RXRECCLK0 : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRUNDISP0 : out std_logic_vector(3 downto 0);
     RXRUNDISP1 : out std_logic_vector(3 downto 0);
     RXSTATUS0 : out std_logic_vector(2 downto 0);
     RXSTATUS1 : out std_logic_vector(2 downto 0);
     RXVALID0 : out std_ulogic;
     RXVALID1 : out std_ulogic;
     TSTOUT0 : out std_logic_vector(4 downto 0);
     TSTOUT1 : out std_logic_vector(4 downto 0);
     TXBUFSTATUS0 : out std_logic_vector(1 downto 0);
     TXBUFSTATUS1 : out std_logic_vector(1 downto 0);
     TXKERR0 : out std_logic_vector(3 downto 0);
     TXKERR1 : out std_logic_vector(3 downto 0);
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXOUTCLK0 : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXRUNDISP0 : out std_logic_vector(3 downto 0);
     TXRUNDISP1 : out std_logic_vector(3 downto 0);
     CLK00 : in std_ulogic;
     CLK01 : in std_ulogic;
     CLK10 : in std_ulogic;
     CLK11 : in std_ulogic;
     CLKINEAST0 : in std_ulogic;
     CLKINEAST1 : in std_ulogic;
     CLKINWEST0 : in std_ulogic;
     CLKINWEST1 : in std_ulogic;
     DADDR : in std_logic_vector(7 downto 0);
     DCLK : in std_ulogic := 'L';
     DEN : in std_ulogic := 'L';
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic := 'L';
     GATERXELECIDLE0 : in std_ulogic := 'L';
     GATERXELECIDLE1 : in std_ulogic := 'L';
     GCLK00 : in std_ulogic;
     GCLK01 : in std_ulogic;
     GCLK10 : in std_ulogic;
     GCLK11 : in std_ulogic;
     GTPCLKFBSEL0EAST : in std_logic_vector(1 downto 0);
     GTPCLKFBSEL0WEST : in std_logic_vector(1 downto 0);
     GTPCLKFBSEL1EAST : in std_logic_vector(1 downto 0);
     GTPCLKFBSEL1WEST : in std_logic_vector(1 downto 0);
     GTPRESET0 : in std_ulogic := 'L';
     GTPRESET1 : in std_ulogic := 'L';
     GTPTEST0 : in std_logic_vector(7 downto 0);
     GTPTEST1 : in std_logic_vector(7 downto 0);
     IGNORESIGDET0 : in std_ulogic := 'L';
     IGNORESIGDET1 : in std_ulogic := 'L';
     INTDATAWIDTH0 : in std_ulogic := 'L';
     INTDATAWIDTH1 : in std_ulogic := 'L';
     LOOPBACK0 : in std_logic_vector(2 downto 0);
     LOOPBACK1 : in std_logic_vector(2 downto 0);
     PLLCLK00 : in std_ulogic;
     PLLCLK01 : in std_ulogic;
     PLLCLK10 : in std_ulogic;
     PLLCLK11 : in std_ulogic;
     PLLLKDETEN0 : in std_ulogic := 'L';
     PLLLKDETEN1 : in std_ulogic := 'L';
     PLLPOWERDOWN0 : in std_ulogic := 'L';
     PLLPOWERDOWN1 : in std_ulogic := 'L';
     PRBSCNTRESET0 : in std_ulogic := 'L';
     PRBSCNTRESET1 : in std_ulogic := 'L';
     RCALINEAST : in std_logic_vector(4 downto 0);
     RCALINWEST : in std_logic_vector(4 downto 0);
     REFCLKPWRDNB0 : in std_ulogic := 'H';
     REFCLKPWRDNB1 : in std_ulogic := 'H';
     REFSELDYPLL0 : in std_logic_vector(2 downto 0);
     REFSELDYPLL1 : in std_logic_vector(2 downto 0);
     RXBUFRESET0 : in std_ulogic := 'L';
     RXBUFRESET1 : in std_ulogic := 'L';
     RXCDRRESET0 : in std_ulogic := 'L';
     RXCDRRESET1 : in std_ulogic := 'L';
     RXCHBONDI : in std_logic_vector(2 downto 0);
     RXCHBONDMASTER0 : in std_ulogic := 'L';
     RXCHBONDMASTER1 : in std_ulogic := 'L';
     RXCHBONDSLAVE0 : in std_ulogic := 'L';
     RXCHBONDSLAVE1 : in std_ulogic := 'L';
     RXCOMMADETUSE0 : in std_ulogic := 'L';
     RXCOMMADETUSE1 : in std_ulogic := 'L';
     RXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     RXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     RXDEC8B10BUSE0 : in std_ulogic := 'L';
     RXDEC8B10BUSE1 : in std_ulogic := 'L';
     RXENCHANSYNC0 : in std_ulogic := 'L';
     RXENCHANSYNC1 : in std_ulogic := 'L';
     RXENMCOMMAALIGN0 : in std_ulogic := 'L';
     RXENMCOMMAALIGN1 : in std_ulogic := 'L';
     RXENPCOMMAALIGN0 : in std_ulogic := 'L';
     RXENPCOMMAALIGN1 : in std_ulogic := 'L';
     RXENPMAPHASEALIGN0 : in std_ulogic := 'L';
     RXENPMAPHASEALIGN1 : in std_ulogic := 'L';
     RXENPRBSTST0 : in std_logic_vector(2 downto 0);
     RXENPRBSTST1 : in std_logic_vector(2 downto 0);
     RXEQMIX0 : in std_logic_vector(1 downto 0);
     RXEQMIX1 : in std_logic_vector(1 downto 0);
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXPMASETPHASE0 : in std_ulogic := 'L';
     RXPMASETPHASE1 : in std_ulogic := 'L';
     RXPOLARITY0 : in std_ulogic := 'L';
     RXPOLARITY1 : in std_ulogic := 'L';
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXRESET0 : in std_ulogic := 'L';
     RXRESET1 : in std_ulogic := 'L';
     RXSLIDE0 : in std_ulogic := 'L';
     RXSLIDE1 : in std_ulogic := 'L';
     RXUSRCLK0 : in std_ulogic := 'L';
     RXUSRCLK1 : in std_ulogic := 'L';
     RXUSRCLK20 : in std_ulogic := 'L';
     RXUSRCLK21 : in std_ulogic := 'L';
     TSTCLK0 : in std_ulogic := 'L';
     TSTCLK1 : in std_ulogic := 'L';
     TSTIN0 : in std_logic_vector(11 downto 0);
     TSTIN1 : in std_logic_vector(11 downto 0);
     TXBUFDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXBUFDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B0 : in std_logic_vector(3 downto 0);
     TXBYPASS8B10B1 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE0 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE1 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL0 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL1 : in std_logic_vector(3 downto 0);
     TXCHARISK0 : in std_logic_vector(3 downto 0);
     TXCHARISK1 : in std_logic_vector(3 downto 0);
     TXCOMSTART0 : in std_ulogic := 'L';
     TXCOMSTART1 : in std_ulogic := 'L';
     TXCOMTYPE0 : in std_ulogic := 'L';
     TXCOMTYPE1 : in std_ulogic := 'L';
     TXDATA0 : in std_logic_vector(31 downto 0);
     TXDATA1 : in std_logic_vector(31 downto 0);
     TXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     TXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     TXDETECTRX0 : in std_ulogic := 'L';
     TXDETECTRX1 : in std_ulogic := 'L';
     TXDIFFCTRL0 : in std_logic_vector(3 downto 0);
     TXDIFFCTRL1 : in std_logic_vector(3 downto 0);
     TXELECIDLE0 : in std_ulogic := 'L';
     TXELECIDLE1 : in std_ulogic := 'L';
     TXENC8B10BUSE0 : in std_ulogic := 'L';
     TXENC8B10BUSE1 : in std_ulogic := 'L';
     TXENPMAPHASEALIGN0 : in std_ulogic := 'L';
     TXENPMAPHASEALIGN1 : in std_ulogic := 'L';
     TXENPRBSTST0 : in std_logic_vector(2 downto 0);
     TXENPRBSTST1 : in std_logic_vector(2 downto 0);
     TXINHIBIT0 : in std_ulogic := 'L';
     TXINHIBIT1 : in std_ulogic := 'L';
     TXPDOWNASYNCH0 : in std_ulogic := 'L';
     TXPDOWNASYNCH1 : in std_ulogic := 'L';
     TXPMASETPHASE0 : in std_ulogic := 'L';
     TXPMASETPHASE1 : in std_ulogic := 'L';
     TXPOLARITY0 : in std_ulogic := 'L';
     TXPOLARITY1 : in std_ulogic := 'L';
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPRBSFORCEERR0 : in std_ulogic := 'L';
     TXPRBSFORCEERR1 : in std_ulogic := 'L';
     TXPREEMPHASIS0 : in std_logic_vector(2 downto 0);
     TXPREEMPHASIS1 : in std_logic_vector(2 downto 0);
     TXRESET0 : in std_ulogic := 'L';
     TXRESET1 : in std_ulogic := 'L';
     TXUSRCLK0 : in std_ulogic := 'L';
     TXUSRCLK1 : in std_ulogic := 'L';
     TXUSRCLK20 : in std_ulogic := 'L';
     TXUSRCLK21 : in std_ulogic := 'L';
     USRCODEERR0 : in std_ulogic := 'L';
     USRCODEERR1 : in std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  GTPA1_DUAL : component is "PRIMITIVE";

----- component GTP_DUAL -----
component GTP_DUAL
  generic (
     AC_CAP_DIS_0 : boolean := TRUE;
     AC_CAP_DIS_1 : boolean := TRUE;
     ALIGN_COMMA_WORD_0 : integer := 1;
     ALIGN_COMMA_WORD_1 : integer := 1;
     CHAN_BOND_1_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_1_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_0 : integer := 1;
     CHAN_BOND_2_MAX_SKEW_1 : integer := 1;
     CHAN_BOND_LEVEL_0 : integer := 0;
     CHAN_BOND_LEVEL_1 : integer := 0;
     CHAN_BOND_MODE_0 : string := "OFF";
     CHAN_BOND_MODE_1 : string := "OFF";
     CHAN_BOND_SEQ_1_1_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_1_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_2_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_2_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_0 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3_1 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_4_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_4_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_1_0 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_1_1 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_2_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_2_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_0 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_4_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CHAN_BOND_SEQ_2_USE_0 : boolean := TRUE;
     CHAN_BOND_SEQ_2_USE_1 : boolean := TRUE;
     CHAN_BOND_SEQ_LEN_0 : integer := 4;
     CHAN_BOND_SEQ_LEN_1 : integer := 4;
     CLK25_DIVIDER : integer := 4;
     CLKINDC_B : boolean := TRUE;
     CLK_CORRECT_USE_0 : boolean := TRUE;
     CLK_CORRECT_USE_1 : boolean := TRUE;
     CLK_COR_ADJ_LEN_0 : integer := 1;
     CLK_COR_ADJ_LEN_1 : integer := 1;
     CLK_COR_DET_LEN_0 : integer := 1;
     CLK_COR_DET_LEN_1 : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG_0 : boolean := FALSE;
     CLK_COR_INSERT_IDLE_FLAG_1 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_0 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_1 : boolean := FALSE;
     CLK_COR_MAX_LAT_0 : integer := 18;
     CLK_COR_MAX_LAT_1 : integer := 18;
     CLK_COR_MIN_LAT_0 : integer := 16;
     CLK_COR_MIN_LAT_1 : integer := 16;
     CLK_COR_PRECEDENCE_0 : boolean := TRUE;
     CLK_COR_PRECEDENCE_1 : boolean := TRUE;
     CLK_COR_REPEAT_WAIT_0 : integer := 5;
     CLK_COR_REPEAT_WAIT_1 : integer := 5;
     CLK_COR_SEQ_1_1_0 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_1_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_1_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_1_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE_0 : bit_vector := "1111";
     CLK_COR_SEQ_2_ENABLE_1 : bit_vector := "1111";
     CLK_COR_SEQ_2_USE_0 : boolean := FALSE;
     CLK_COR_SEQ_2_USE_1 : boolean := FALSE;
     COMMA_10B_ENABLE_0 : bit_vector := "1111111111";
     COMMA_10B_ENABLE_1 : bit_vector := "1111111111";
     COMMA_DOUBLE_0 : boolean := FALSE;
     COMMA_DOUBLE_1 : boolean := FALSE;
     COM_BURST_VAL_0 : bit_vector := "1111";
     COM_BURST_VAL_1 : bit_vector := "1111";
     DEC_MCOMMA_DETECT_0 : boolean := TRUE;
     DEC_MCOMMA_DETECT_1 : boolean := TRUE;
     DEC_PCOMMA_DETECT_0 : boolean := TRUE;
     DEC_PCOMMA_DETECT_1 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_0 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_1 : boolean := TRUE;
     MCOMMA_10B_VALUE_0 : bit_vector := "1010000011";
     MCOMMA_10B_VALUE_1 : bit_vector := "1010000011";
     MCOMMA_DETECT_0 : boolean := TRUE;
     MCOMMA_DETECT_1 : boolean := TRUE;
     OOBDETECT_THRESHOLD_0 : bit_vector := "001";
     OOBDETECT_THRESHOLD_1 : bit_vector := "001";
     OOB_CLK_DIVIDER : integer := 4;
     OVERSAMPLE_MODE : boolean := FALSE;
     PCI_EXPRESS_MODE_0 : boolean := TRUE;
     PCI_EXPRESS_MODE_1 : boolean := TRUE;
     PCOMMA_10B_VALUE_0 : bit_vector := "0101111100";
     PCOMMA_10B_VALUE_1 : bit_vector := "0101111100";
     PCOMMA_DETECT_0 : boolean := TRUE;
     PCOMMA_DETECT_1 : boolean := TRUE;
     PCS_COM_CFG : bit_vector := X"1680a0e";
     PLL_DIVSEL_FB : integer := 5;
     PLL_DIVSEL_REF : integer := 2;
     PLL_RXDIVSEL_OUT_0 : integer := 1;
     PLL_RXDIVSEL_OUT_1 : integer := 1;
     PLL_SATA_0 : boolean := FALSE;
     PLL_SATA_1 : boolean := FALSE;
     PLL_TXDIVSEL_COMM_OUT : integer := 1;
     PLL_TXDIVSEL_OUT_0 : integer := 1;
     PLL_TXDIVSEL_OUT_1 : integer := 1;
     PMA_CDR_SCAN_0 : bit_vector := X"6c07640";
     PMA_CDR_SCAN_1 : bit_vector := X"6c07640";
     PMA_RX_CFG_0 : bit_vector := X"09f0089";
     PMA_RX_CFG_1 : bit_vector := X"09f0089";
     PRBS_ERR_THRESHOLD_0 : bit_vector := X"00000001";
     PRBS_ERR_THRESHOLD_1 : bit_vector := X"00000001";
     RCV_TERM_GND_0 : boolean := TRUE;
     RCV_TERM_GND_1 : boolean := TRUE;
     RCV_TERM_MID_0 : boolean := FALSE;
     RCV_TERM_MID_1 : boolean := FALSE;
     RCV_TERM_VTTRX_0 : boolean := FALSE;
     RCV_TERM_VTTRX_1 : boolean := FALSE;
     RX_BUFFER_USE_0 : boolean := TRUE;
     RX_BUFFER_USE_1 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_0 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_1 : boolean := TRUE;
     RX_LOSS_OF_SYNC_FSM_0 : boolean := FALSE;
     RX_LOSS_OF_SYNC_FSM_1 : boolean := FALSE;
     RX_LOS_INVALID_INCR_0 : integer := 8;
     RX_LOS_INVALID_INCR_1 : integer := 8;
     RX_LOS_THRESHOLD_0 : integer := 128;
     RX_LOS_THRESHOLD_1 : integer := 128;
     RX_SLIDE_MODE_0 : string := "PCS";
     RX_SLIDE_MODE_1 : string := "PCS";
     RX_STATUS_FMT_0 : string := "PCIE";
     RX_STATUS_FMT_1 : string := "PCIE";
     RX_XCLK_SEL_0 : string := "RXREC";
     RX_XCLK_SEL_1 : string := "RXREC";
     SATA_BURST_VAL_0 : bit_vector := "100";
     SATA_BURST_VAL_1 : bit_vector := "100";
     SATA_IDLE_VAL_0 : bit_vector := "011";
     SATA_IDLE_VAL_1 : bit_vector := "011";
     SATA_MAX_BURST_0 : integer := 7;
     SATA_MAX_BURST_1 : integer := 7;
     SATA_MAX_INIT_0 : integer := 22;
     SATA_MAX_INIT_1 : integer := 22;
     SATA_MAX_WAKE_0 : integer := 7;
     SATA_MAX_WAKE_1 : integer := 7;
     SATA_MIN_BURST_0 : integer := 4;
     SATA_MIN_BURST_1 : integer := 4;
     SATA_MIN_INIT_0 : integer := 12;
     SATA_MIN_INIT_1 : integer := 12;
     SATA_MIN_WAKE_0 : integer := 4;
     SATA_MIN_WAKE_1 : integer := 4;
     SIM_GTPRESET_SPEEDUP : integer := 0;
     SIM_MODE : string := "FAST";
     SIM_PLL_PERDIV2 : bit_vector := X"190";
     SIM_RECEIVER_DETECT_PASS0 : boolean := FALSE;
     SIM_RECEIVER_DETECT_PASS1 : boolean := FALSE;
     TERMINATION_CTRL : bit_vector := "10100";
     TERMINATION_IMP_0 : integer := 50;
     TERMINATION_IMP_1 : integer := 50;
     TERMINATION_OVRD : boolean := FALSE;
     TRANS_TIME_FROM_P2_0 : bit_vector := X"003c";
     TRANS_TIME_FROM_P2_1 : bit_vector := X"003c";
     TRANS_TIME_NON_P2_0 : bit_vector := X"0019";
     TRANS_TIME_NON_P2_1 : bit_vector := X"0019";
     TRANS_TIME_TO_P2_0 : bit_vector := X"0064";
     TRANS_TIME_TO_P2_1 : bit_vector := X"0064";
     TXRX_INVERT_0 : bit_vector := "00000";
     TXRX_INVERT_1 : bit_vector := "00000";
     TX_BUFFER_USE_0 : boolean := TRUE;
     TX_BUFFER_USE_1 : boolean := TRUE;
     TX_DIFF_BOOST_0 : boolean := TRUE;
     TX_DIFF_BOOST_1 : boolean := TRUE;
     TX_SYNC_FILTERB : integer := 1;
     TX_XCLK_SEL_0 : string := "TXUSR";
     TX_XCLK_SEL_1 : string := "TXUSR"
  );
  port (
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic;
     PHYSTATUS0 : out std_ulogic;
     PHYSTATUS1 : out std_ulogic;
     PLLLKDET : out std_ulogic;
     REFCLKOUT : out std_ulogic;
     RESETDONE0 : out std_ulogic;
     RESETDONE1 : out std_ulogic;
     RXBUFSTATUS0 : out std_logic_vector(2 downto 0);
     RXBUFSTATUS1 : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED0 : out std_ulogic;
     RXBYTEISALIGNED1 : out std_ulogic;
     RXBYTEREALIGN0 : out std_ulogic;
     RXBYTEREALIGN1 : out std_ulogic;
     RXCHANBONDSEQ0 : out std_ulogic;
     RXCHANBONDSEQ1 : out std_ulogic;
     RXCHANISALIGNED0 : out std_ulogic;
     RXCHANISALIGNED1 : out std_ulogic;
     RXCHANREALIGN0 : out std_ulogic;
     RXCHANREALIGN1 : out std_ulogic;
     RXCHARISCOMMA0 : out std_logic_vector(1 downto 0);
     RXCHARISCOMMA1 : out std_logic_vector(1 downto 0);
     RXCHARISK0 : out std_logic_vector(1 downto 0);
     RXCHARISK1 : out std_logic_vector(1 downto 0);
     RXCHBONDO0 : out std_logic_vector(2 downto 0);
     RXCHBONDO1 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT0 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT1 : out std_logic_vector(2 downto 0);
     RXCOMMADET0 : out std_ulogic;
     RXCOMMADET1 : out std_ulogic;
     RXDATA0 : out std_logic_vector(15 downto 0);
     RXDATA1 : out std_logic_vector(15 downto 0);
     RXDISPERR0 : out std_logic_vector(1 downto 0);
     RXDISPERR1 : out std_logic_vector(1 downto 0);
     RXELECIDLE0 : out std_ulogic;
     RXELECIDLE1 : out std_ulogic;
     RXLOSSOFSYNC0 : out std_logic_vector(1 downto 0);
     RXLOSSOFSYNC1 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE0 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE1 : out std_logic_vector(1 downto 0);
     RXOVERSAMPLEERR0 : out std_ulogic;
     RXOVERSAMPLEERR1 : out std_ulogic;
     RXPRBSERR0 : out std_ulogic;
     RXPRBSERR1 : out std_ulogic;
     RXRECCLK0 : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRUNDISP0 : out std_logic_vector(1 downto 0);
     RXRUNDISP1 : out std_logic_vector(1 downto 0);
     RXSTATUS0 : out std_logic_vector(2 downto 0);
     RXSTATUS1 : out std_logic_vector(2 downto 0);
     RXVALID0 : out std_ulogic;
     RXVALID1 : out std_ulogic;
     TXBUFSTATUS0 : out std_logic_vector(1 downto 0);
     TXBUFSTATUS1 : out std_logic_vector(1 downto 0);
     TXKERR0 : out std_logic_vector(1 downto 0);
     TXKERR1 : out std_logic_vector(1 downto 0);
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXOUTCLK0 : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXRUNDISP0 : out std_logic_vector(1 downto 0);
     TXRUNDISP1 : out std_logic_vector(1 downto 0);
     CLKIN : in std_ulogic;
     DADDR : in std_logic_vector(6 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     GTPRESET : in std_ulogic;
     GTPTEST : in std_logic_vector(3 downto 0);
     INTDATAWIDTH : in std_ulogic;
     LOOPBACK0 : in std_logic_vector(2 downto 0);
     LOOPBACK1 : in std_logic_vector(2 downto 0);
     PLLLKDETEN : in std_ulogic;
     PLLPOWERDOWN : in std_ulogic;
     PRBSCNTRESET0 : in std_ulogic;
     PRBSCNTRESET1 : in std_ulogic;
     REFCLKPWRDNB : in std_ulogic;
     RXBUFRESET0 : in std_ulogic;
     RXBUFRESET1 : in std_ulogic;
     RXCDRRESET0 : in std_ulogic;
     RXCDRRESET1 : in std_ulogic;
     RXCHBONDI0 : in std_logic_vector(2 downto 0);
     RXCHBONDI1 : in std_logic_vector(2 downto 0);
     RXCOMMADETUSE0 : in std_ulogic;
     RXCOMMADETUSE1 : in std_ulogic;
     RXDATAWIDTH0 : in std_ulogic;
     RXDATAWIDTH1 : in std_ulogic;
     RXDEC8B10BUSE0 : in std_ulogic;
     RXDEC8B10BUSE1 : in std_ulogic;
     RXELECIDLERESET0 : in std_ulogic;
     RXELECIDLERESET1 : in std_ulogic;
     RXENCHANSYNC0 : in std_ulogic;
     RXENCHANSYNC1 : in std_ulogic;
     RXENELECIDLERESETB : in std_ulogic;
     RXENEQB0 : in std_ulogic;
     RXENEQB1 : in std_ulogic;
     RXENMCOMMAALIGN0 : in std_ulogic;
     RXENMCOMMAALIGN1 : in std_ulogic;
     RXENPCOMMAALIGN0 : in std_ulogic;
     RXENPCOMMAALIGN1 : in std_ulogic;
     RXENPRBSTST0 : in std_logic_vector(1 downto 0);
     RXENPRBSTST1 : in std_logic_vector(1 downto 0);
     RXENSAMPLEALIGN0 : in std_ulogic;
     RXENSAMPLEALIGN1 : in std_ulogic;
     RXEQMIX0 : in std_logic_vector(1 downto 0);
     RXEQMIX1 : in std_logic_vector(1 downto 0);
     RXEQPOLE0 : in std_logic_vector(3 downto 0);
     RXEQPOLE1 : in std_logic_vector(3 downto 0);
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXPMASETPHASE0 : in std_ulogic;
     RXPMASETPHASE1 : in std_ulogic;
     RXPOLARITY0 : in std_ulogic;
     RXPOLARITY1 : in std_ulogic;
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXRESET0 : in std_ulogic;
     RXRESET1 : in std_ulogic;
     RXSLIDE0 : in std_ulogic;
     RXSLIDE1 : in std_ulogic;
     RXUSRCLK0 : in std_ulogic;
     RXUSRCLK1 : in std_ulogic;
     RXUSRCLK20 : in std_ulogic;
     RXUSRCLK21 : in std_ulogic;
     TXBUFDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXBUFDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B0 : in std_logic_vector(1 downto 0);
     TXBYPASS8B10B1 : in std_logic_vector(1 downto 0);
     TXCHARDISPMODE0 : in std_logic_vector(1 downto 0);
     TXCHARDISPMODE1 : in std_logic_vector(1 downto 0);
     TXCHARDISPVAL0 : in std_logic_vector(1 downto 0);
     TXCHARDISPVAL1 : in std_logic_vector(1 downto 0);
     TXCHARISK0 : in std_logic_vector(1 downto 0);
     TXCHARISK1 : in std_logic_vector(1 downto 0);
     TXCOMSTART0 : in std_ulogic;
     TXCOMSTART1 : in std_ulogic;
     TXCOMTYPE0 : in std_ulogic;
     TXCOMTYPE1 : in std_ulogic;
     TXDATA0 : in std_logic_vector(15 downto 0);
     TXDATA1 : in std_logic_vector(15 downto 0);
     TXDATAWIDTH0 : in std_ulogic;
     TXDATAWIDTH1 : in std_ulogic;
     TXDETECTRX0 : in std_ulogic;
     TXDETECTRX1 : in std_ulogic;
     TXDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXELECIDLE0 : in std_ulogic;
     TXELECIDLE1 : in std_ulogic;
     TXENC8B10BUSE0 : in std_ulogic;
     TXENC8B10BUSE1 : in std_ulogic;
     TXENPMAPHASEALIGN : in std_ulogic;
     TXENPRBSTST0 : in std_logic_vector(1 downto 0);
     TXENPRBSTST1 : in std_logic_vector(1 downto 0);
     TXINHIBIT0 : in std_ulogic;
     TXINHIBIT1 : in std_ulogic;
     TXPMASETPHASE : in std_ulogic;
     TXPOLARITY0 : in std_ulogic;
     TXPOLARITY1 : in std_ulogic;
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPREEMPHASIS0 : in std_logic_vector(2 downto 0);
     TXPREEMPHASIS1 : in std_logic_vector(2 downto 0);
     TXRESET0 : in std_ulogic;
     TXRESET1 : in std_ulogic;
     TXUSRCLK0 : in std_ulogic;
     TXUSRCLK1 : in std_ulogic;
     TXUSRCLK20 : in std_ulogic;
     TXUSRCLK21 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GTP_DUAL : component is "PRIMITIVE";

----- component GTXE1 -----
component GTXE1
  generic (
     AC_CAP_DIS : boolean := TRUE;
     ALIGN_COMMA_WORD : integer := 1;
     BGTEST_CFG : bit_vector := "00";
     BIAS_CFG : bit_vector := X"00000";
     CDR_PH_ADJ_TIME : bit_vector := "10100";
     CHAN_BOND_1_MAX_SKEW : integer := 7;
     CHAN_BOND_2_MAX_SKEW : integer := 1;
     CHAN_BOND_KEEP_ALIGN : boolean := FALSE;
     CHAN_BOND_SEQ_1_1 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_2 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_3 : bit_vector := "0001001010";
     CHAN_BOND_SEQ_1_4 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_1_ENABLE : bit_vector := "1111";
     CHAN_BOND_SEQ_2_1 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_2 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_3 : bit_vector := "0110111100";
     CHAN_BOND_SEQ_2_4 : bit_vector := "0100111100";
     CHAN_BOND_SEQ_2_CFG : bit_vector := "00000";
     CHAN_BOND_SEQ_2_ENABLE : bit_vector := "1111";
     CHAN_BOND_SEQ_2_USE : boolean := FALSE;
     CHAN_BOND_SEQ_LEN : integer := 1;
     CLK_CORRECT_USE : boolean := TRUE;
     CLK_COR_ADJ_LEN : integer := 1;
     CLK_COR_DET_LEN : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG : boolean := FALSE;
     CLK_COR_KEEP_IDLE : boolean := FALSE;
     CLK_COR_MAX_LAT : integer := 20;
     CLK_COR_MIN_LAT : integer := 18;
     CLK_COR_PRECEDENCE : boolean := TRUE;
     CLK_COR_REPEAT_WAIT : integer := 0;
     CLK_COR_SEQ_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE : bit_vector := "1111";
     CLK_COR_SEQ_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE : bit_vector := "1111";
     CLK_COR_SEQ_2_USE : boolean := FALSE;
     CM_TRIM : bit_vector := "01";
     COMMA_10B_ENABLE : bit_vector := "1111111111";
     COMMA_DOUBLE : boolean := FALSE;
     COM_BURST_VAL : bit_vector := "1111";
     DEC_MCOMMA_DETECT : boolean := TRUE;
     DEC_PCOMMA_DETECT : boolean := TRUE;
     DEC_VALID_COMMA_ONLY : boolean := TRUE;
     DFE_CAL_TIME : bit_vector := "01100";
     DFE_CFG : bit_vector := "00011011";
     GEARBOX_ENDEC : bit_vector := "000";
     GEN_RXUSRCLK : boolean := TRUE;
     GEN_TXUSRCLK : boolean := TRUE;
     GTX_CFG_PWRUP : boolean := TRUE;
     MCOMMA_10B_VALUE : bit_vector := "1010000011";
     MCOMMA_DETECT : boolean := TRUE;
     OOBDETECT_THRESHOLD : bit_vector := "011";
     PCI_EXPRESS_MODE : boolean := FALSE;
     PCOMMA_10B_VALUE : bit_vector := "0101111100";
     PCOMMA_DETECT : boolean := TRUE;
     PMA_CAS_CLK_EN : boolean := FALSE;
     PMA_CDR_SCAN : bit_vector := X"640404C";
     PMA_CFG : bit_vector := X"0040000040000000003";
     PMA_RXSYNC_CFG : bit_vector := X"00";
     PMA_RX_CFG : bit_vector := X"05CE048";
     PMA_TX_CFG : bit_vector := X"00082";
     POWER_SAVE : bit_vector := "0000110100";
     RCV_TERM_GND : boolean := FALSE;
     RCV_TERM_VTTRX : boolean := TRUE;
     RXGEARBOX_USE : boolean := FALSE;
     RXPLL_COM_CFG : bit_vector := X"21680A";
     RXPLL_CP_CFG : bit_vector := X"00";
     RXPLL_DIVSEL45_FB : integer := 5;
     RXPLL_DIVSEL_FB : integer := 2;
     RXPLL_DIVSEL_OUT : integer := 1;
     RXPLL_DIVSEL_REF : integer := 1;
     RXPLL_LKDET_CFG : bit_vector := "111";
     RXPRBSERR_LOOPBACK : bit := '0';
     RXRECCLK_CTRL : string := "RXRECCLKPCS";
     RXRECCLK_DLY : bit_vector := "0000000000";
     RXUSRCLK_DLY : bit_vector := X"0000";
     RX_BUFFER_USE : boolean := TRUE;
     RX_CLK25_DIVIDER : integer := 6;
     RX_DATA_WIDTH : integer := 20;
     RX_DECODE_SEQ_MATCH : boolean := TRUE;
     RX_DLYALIGN_CTRINC : bit_vector := "0100";
     RX_DLYALIGN_EDGESET : bit_vector := "00110";
     RX_DLYALIGN_LPFINC : bit_vector := "0111";
     RX_DLYALIGN_MONSEL : bit_vector := "000";
     RX_DLYALIGN_OVRDSETTING : bit_vector := "00000000";
     RX_EN_IDLE_HOLD_CDR : boolean := FALSE;
     RX_EN_IDLE_HOLD_DFE : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF : boolean := TRUE;
     RX_EN_IDLE_RESET_FR : boolean := TRUE;
     RX_EN_IDLE_RESET_PH : boolean := TRUE;
     RX_EN_MODE_RESET_BUF : boolean := TRUE;
     RX_EN_RATE_RESET_BUF : boolean := TRUE;
     RX_EN_REALIGN_RESET_BUF : boolean := FALSE;
     RX_EN_REALIGN_RESET_BUF2 : boolean := FALSE;
     RX_EYE_OFFSET : bit_vector := X"4C";
     RX_EYE_SCANMODE : bit_vector := "00";
     RX_FIFO_ADDR_MODE : string := "FULL";
     RX_IDLE_HI_CNT : bit_vector := "1000";
     RX_IDLE_LO_CNT : bit_vector := "0000";
     RX_LOSS_OF_SYNC_FSM : boolean := FALSE;
     RX_LOS_INVALID_INCR : integer := 1;
     RX_LOS_THRESHOLD : integer := 4;
     RX_OVERSAMPLE_MODE : boolean := FALSE;
     RX_SLIDE_AUTO_WAIT : integer := 5;
     RX_SLIDE_MODE : string := "OFF";
     RX_XCLK_SEL : string := "RXREC";
     SAS_MAX_COMSAS : integer := 52;
     SAS_MIN_COMSAS : integer := 40;
     SATA_BURST_VAL : bit_vector := "100";
     SATA_IDLE_VAL : bit_vector := "100";
     SATA_MAX_BURST : integer := 7;
     SATA_MAX_INIT : integer := 22;
     SATA_MAX_WAKE : integer := 7;
     SATA_MIN_BURST : integer := 4;
     SATA_MIN_INIT : integer := 12;
     SATA_MIN_WAKE : integer := 4;
     SHOW_REALIGN_COMMA : boolean := TRUE;
     SIM_GTXRESET_SPEEDUP : integer := 1;
     SIM_RECEIVER_DETECT_PASS : boolean := TRUE;
     SIM_RXREFCLK_SOURCE : bit_vector := "000";
     SIM_TXREFCLK_SOURCE : bit_vector := "000";
     SIM_TX_ELEC_IDLE_LEVEL : string := "X";
     SIM_VERSION : string := "2.0";
     TERMINATION_CTRL : bit_vector := "10100";
     TERMINATION_OVRD : boolean := FALSE;
     TRANS_TIME_FROM_P2 : bit_vector := X"03C";
     TRANS_TIME_NON_P2 : bit_vector := X"19";
     TRANS_TIME_RATE : bit_vector := X"0E";
     TRANS_TIME_TO_P2 : bit_vector := X"064";
     TST_ATTR : bit_vector := X"00000000";
     TXDRIVE_LOOPBACK_HIZ : boolean := FALSE;
     TXDRIVE_LOOPBACK_PD : boolean := FALSE;
     TXGEARBOX_USE : boolean := FALSE;
     TXOUTCLK_CTRL : string := "TXOUTCLKPCS";
     TXOUTCLK_DLY : bit_vector := "0000000000";
     TXPLL_COM_CFG : bit_vector := X"21680A";
     TXPLL_CP_CFG : bit_vector := X"00";
     TXPLL_DIVSEL45_FB : integer := 5;
     TXPLL_DIVSEL_FB : integer := 2;
     TXPLL_DIVSEL_OUT : integer := 1;
     TXPLL_DIVSEL_REF : integer := 1;
     TXPLL_LKDET_CFG : bit_vector := "111";
     TXPLL_SATA : bit_vector := "00";
     TX_BUFFER_USE : boolean := TRUE;
     TX_BYTECLK_CFG : bit_vector := X"00";
     TX_CLK25_DIVIDER : integer := 6;
     TX_CLK_SOURCE : string := "RXPLL";
     TX_DATA_WIDTH : integer := 20;
     TX_DEEMPH_0 : bit_vector := "11010";
     TX_DEEMPH_1 : bit_vector := "10000";
     TX_DETECT_RX_CFG : bit_vector := X"1832";
     TX_DLYALIGN_CTRINC : bit_vector := "0100";
     TX_DLYALIGN_LPFINC : bit_vector := "0110";
     TX_DLYALIGN_MONSEL : bit_vector := "000";
     TX_DLYALIGN_OVRDSETTING : bit_vector := "10000000";
     TX_DRIVE_MODE : string := "DIRECT";
     TX_EN_RATE_RESET_BUF : boolean := TRUE;
     TX_IDLE_ASSERT_DELAY : bit_vector := "100";
     TX_IDLE_DEASSERT_DELAY : bit_vector := "010";
     TX_MARGIN_FULL_0 : bit_vector := "1001110";
     TX_MARGIN_FULL_1 : bit_vector := "1001001";
     TX_MARGIN_FULL_2 : bit_vector := "1000101";
     TX_MARGIN_FULL_3 : bit_vector := "1000010";
     TX_MARGIN_FULL_4 : bit_vector := "1000000";
     TX_MARGIN_LOW_0 : bit_vector := "1000110";
     TX_MARGIN_LOW_1 : bit_vector := "1000100";
     TX_MARGIN_LOW_2 : bit_vector := "1000010";
     TX_MARGIN_LOW_3 : bit_vector := "1000000";
     TX_MARGIN_LOW_4 : bit_vector := "1000000";
     TX_OVERSAMPLE_MODE : boolean := FALSE;
     TX_PMADATA_OPT : bit := '0';
     TX_TDCC_CFG : bit_vector := "11";
     TX_USRCLK_CFG : bit_vector := X"00";
     TX_XCLK_SEL : string := "TXUSR"
  );
  port (
     COMFINISH : out std_ulogic;
     COMINITDET : out std_ulogic;
     COMSASDET : out std_ulogic;
     COMWAKEDET : out std_ulogic;
     DFECLKDLYADJMON : out std_logic_vector(5 downto 0);
     DFEEYEDACMON : out std_logic_vector(4 downto 0);
     DFESENSCAL : out std_logic_vector(2 downto 0);
     DFETAP1MONITOR : out std_logic_vector(4 downto 0);
     DFETAP2MONITOR : out std_logic_vector(4 downto 0);
     DFETAP3MONITOR : out std_logic_vector(3 downto 0);
     DFETAP4MONITOR : out std_logic_vector(3 downto 0);
     DRDY : out std_ulogic;
     DRPDO : out std_logic_vector(15 downto 0);
     MGTREFCLKFAB : out std_logic_vector(1 downto 0);
     PHYSTATUS : out std_ulogic;
     RXBUFSTATUS : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED : out std_ulogic;
     RXBYTEREALIGN : out std_ulogic;
     RXCHANBONDSEQ : out std_ulogic;
     RXCHANISALIGNED : out std_ulogic;
     RXCHANREALIGN : out std_ulogic;
     RXCHARISCOMMA : out std_logic_vector(3 downto 0);
     RXCHARISK : out std_logic_vector(3 downto 0);
     RXCHBONDO : out std_logic_vector(3 downto 0);
     RXCLKCORCNT : out std_logic_vector(2 downto 0);
     RXCOMMADET : out std_ulogic;
     RXDATA : out std_logic_vector(31 downto 0);
     RXDATAVALID : out std_ulogic;
     RXDISPERR : out std_logic_vector(3 downto 0);
     RXDLYALIGNMONITOR : out std_logic_vector(7 downto 0);
     RXELECIDLE : out std_ulogic;
     RXHEADER : out std_logic_vector(2 downto 0);
     RXHEADERVALID : out std_ulogic;
     RXLOSSOFSYNC : out std_logic_vector(1 downto 0);
     RXNOTINTABLE : out std_logic_vector(3 downto 0);
     RXOVERSAMPLEERR : out std_ulogic;
     RXPLLLKDET : out std_ulogic;
     RXPRBSERR : out std_ulogic;
     RXRATEDONE : out std_ulogic;
     RXRECCLK : out std_ulogic;
     RXRECCLKPCS : out std_ulogic;
     RXRESETDONE : out std_ulogic;
     RXRUNDISP : out std_logic_vector(3 downto 0);
     RXSTARTOFSEQ : out std_ulogic;
     RXSTATUS : out std_logic_vector(2 downto 0);
     RXVALID : out std_ulogic;
     TSTOUT : out std_logic_vector(9 downto 0);
     TXBUFSTATUS : out std_logic_vector(1 downto 0);
     TXDLYALIGNMONITOR : out std_logic_vector(7 downto 0);
     TXGEARBOXREADY : out std_ulogic;
     TXKERR : out std_logic_vector(3 downto 0);
     TXN : out std_ulogic;
     TXOUTCLK : out std_ulogic;
     TXOUTCLKPCS : out std_ulogic;
     TXP : out std_ulogic;
     TXPLLLKDET : out std_ulogic;
     TXRATEDONE : out std_ulogic;
     TXRESETDONE : out std_ulogic;
     TXRUNDISP : out std_logic_vector(3 downto 0);
     DADDR : in std_logic_vector(7 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DFECLKDLYADJ : in std_logic_vector(5 downto 0);
     DFEDLYOVRD : in std_ulogic;
     DFETAP1 : in std_logic_vector(4 downto 0);
     DFETAP2 : in std_logic_vector(4 downto 0);
     DFETAP3 : in std_logic_vector(3 downto 0);
     DFETAP4 : in std_logic_vector(3 downto 0);
     DFETAPOVRD : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     GATERXELECIDLE : in std_ulogic;
     GREFCLKRX : in std_ulogic;
     GREFCLKTX : in std_ulogic;
     GTXRXRESET : in std_ulogic;
     GTXTEST : in std_logic_vector(12 downto 0);
     GTXTXRESET : in std_ulogic;
     IGNORESIGDET : in std_ulogic;
     LOOPBACK : in std_logic_vector(2 downto 0);
     MGTREFCLKRX : in std_logic_vector(1 downto 0);
     MGTREFCLKTX : in std_logic_vector(1 downto 0);
     NORTHREFCLKRX : in std_logic_vector(1 downto 0);
     NORTHREFCLKTX : in std_logic_vector(1 downto 0);
     PERFCLKRX : in std_ulogic;
     PERFCLKTX : in std_ulogic;
     PLLRXRESET : in std_ulogic;
     PLLTXRESET : in std_ulogic;
     PRBSCNTRESET : in std_ulogic;
     RXBUFRESET : in std_ulogic;
     RXCDRRESET : in std_ulogic;
     RXCHBONDI : in std_logic_vector(3 downto 0);
     RXCHBONDLEVEL : in std_logic_vector(2 downto 0);
     RXCHBONDMASTER : in std_ulogic;
     RXCHBONDSLAVE : in std_ulogic;
     RXCOMMADETUSE : in std_ulogic;
     RXDEC8B10BUSE : in std_ulogic;
     RXDLYALIGNDISABLE : in std_ulogic;
     RXDLYALIGNMONENB : in std_ulogic := 'H';
     RXDLYALIGNOVERRIDE : in std_ulogic;
     RXDLYALIGNRESET : in std_ulogic;
     RXDLYALIGNSWPPRECURB : in std_ulogic;
     RXDLYALIGNUPDSW : in std_ulogic;
     RXENCHANSYNC : in std_ulogic;
     RXENMCOMMAALIGN : in std_ulogic;
     RXENPCOMMAALIGN : in std_ulogic;
     RXENPMAPHASEALIGN : in std_ulogic;
     RXENPRBSTST : in std_logic_vector(2 downto 0);
     RXENSAMPLEALIGN : in std_ulogic;
     RXEQMIX : in std_logic_vector(9 downto 0);
     RXGEARBOXSLIP : in std_ulogic;
     RXN : in std_ulogic;
     RXP : in std_ulogic;
     RXPLLLKDETEN : in std_ulogic;
     RXPLLPOWERDOWN : in std_ulogic;
     RXPLLREFSELDY : in std_logic_vector(2 downto 0);
     RXPMASETPHASE : in std_ulogic;
     RXPOLARITY : in std_ulogic;
     RXPOWERDOWN : in std_logic_vector(1 downto 0);
     RXRATE : in std_logic_vector(1 downto 0);
     RXRESET : in std_ulogic;
     RXSLIDE : in std_ulogic;
     RXUSRCLK : in std_ulogic;
     RXUSRCLK2 : in std_ulogic;
     SOUTHREFCLKRX : in std_logic_vector(1 downto 0);
     SOUTHREFCLKTX : in std_logic_vector(1 downto 0);
     TSTCLK0 : in std_ulogic;
     TSTCLK1 : in std_ulogic;
     TSTIN : in std_logic_vector(19 downto 0);
     TXBUFDIFFCTRL : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL : in std_logic_vector(3 downto 0);
     TXCHARISK : in std_logic_vector(3 downto 0);
     TXCOMINIT : in std_ulogic;
     TXCOMSAS : in std_ulogic;
     TXCOMWAKE : in std_ulogic;
     TXDATA : in std_logic_vector(31 downto 0);
     TXDEEMPH : in std_ulogic;
     TXDETECTRX : in std_ulogic;
     TXDIFFCTRL : in std_logic_vector(3 downto 0);
     TXDLYALIGNDISABLE : in std_ulogic;
     TXDLYALIGNMONENB : in std_ulogic := 'H';
     TXDLYALIGNOVERRIDE : in std_ulogic;
     TXDLYALIGNRESET : in std_ulogic;
     TXDLYALIGNUPDSW : in std_ulogic;
     TXELECIDLE : in std_ulogic;
     TXENC8B10BUSE : in std_ulogic;
     TXENPMAPHASEALIGN : in std_ulogic;
     TXENPRBSTST : in std_logic_vector(2 downto 0);
     TXHEADER : in std_logic_vector(2 downto 0);
     TXINHIBIT : in std_ulogic;
     TXMARGIN : in std_logic_vector(2 downto 0);
     TXPDOWNASYNCH : in std_ulogic;
     TXPLLLKDETEN : in std_ulogic;
     TXPLLPOWERDOWN : in std_ulogic;
     TXPLLREFSELDY : in std_logic_vector(2 downto 0);
     TXPMASETPHASE : in std_ulogic;
     TXPOLARITY : in std_ulogic;
     TXPOSTEMPHASIS : in std_logic_vector(4 downto 0);
     TXPOWERDOWN : in std_logic_vector(1 downto 0);
     TXPRBSFORCEERR : in std_ulogic;
     TXPREEMPHASIS : in std_logic_vector(3 downto 0);
     TXRATE : in std_logic_vector(1 downto 0);
     TXRESET : in std_ulogic;
     TXSEQUENCE : in std_logic_vector(6 downto 0);
     TXSTARTSEQ : in std_ulogic;
     TXSWING : in std_ulogic;
     TXUSRCLK : in std_ulogic;
     TXUSRCLK2 : in std_ulogic;
     USRCODEERR : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GTXE1 : component is "PRIMITIVE";

----- component GTX_DUAL -----
component GTX_DUAL
  generic (
     AC_CAP_DIS_0 : boolean := TRUE;
     AC_CAP_DIS_1 : boolean := TRUE;
     ALIGN_COMMA_WORD_0 : integer := 1;
     ALIGN_COMMA_WORD_1 : integer := 1;
     CB2_INH_CC_PERIOD_0 : integer := 8;
     CB2_INH_CC_PERIOD_1 : integer := 8;
     CDR_PH_ADJ_TIME : bit_vector := "01010";
     CHAN_BOND_1_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_1_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_0 : integer := 7;
     CHAN_BOND_2_MAX_SKEW_1 : integer := 7;
     CHAN_BOND_KEEP_ALIGN_0 : boolean := FALSE;
     CHAN_BOND_KEEP_ALIGN_1 : boolean := FALSE;
     CHAN_BOND_LEVEL_0 : integer := 0;
     CHAN_BOND_LEVEL_1 : integer := 0;
     CHAN_BOND_MODE_0 : string := "OFF";
     CHAN_BOND_MODE_1 : string := "OFF";
     CHAN_BOND_SEQ_1_1_0 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_1_1 : bit_vector := "0101111100";
     CHAN_BOND_SEQ_1_2_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_2_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_3_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_3_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_4_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_4_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_1_ENABLE_0 : bit_vector := "0001";
     CHAN_BOND_SEQ_1_ENABLE_1 : bit_vector := "0001";
     CHAN_BOND_SEQ_2_1_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_1_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_2_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_2_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_3_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_3_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_4_0 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_4_1 : bit_vector := "0000000000";
     CHAN_BOND_SEQ_2_ENABLE_0 : bit_vector := "0000";
     CHAN_BOND_SEQ_2_ENABLE_1 : bit_vector := "0000";
     CHAN_BOND_SEQ_2_USE_0 : boolean := FALSE;
     CHAN_BOND_SEQ_2_USE_1 : boolean := FALSE;
     CHAN_BOND_SEQ_LEN_0 : integer := 1;
     CHAN_BOND_SEQ_LEN_1 : integer := 1;
     CLK25_DIVIDER : integer := 10;
     CLKINDC_B : boolean := TRUE;
     CLKRCV_TRST : boolean := TRUE;
     CLK_CORRECT_USE_0 : boolean := TRUE;
     CLK_CORRECT_USE_1 : boolean := TRUE;
     CLK_COR_ADJ_LEN_0 : integer := 1;
     CLK_COR_ADJ_LEN_1 : integer := 1;
     CLK_COR_DET_LEN_0 : integer := 1;
     CLK_COR_DET_LEN_1 : integer := 1;
     CLK_COR_INSERT_IDLE_FLAG_0 : boolean := FALSE;
     CLK_COR_INSERT_IDLE_FLAG_1 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_0 : boolean := FALSE;
     CLK_COR_KEEP_IDLE_1 : boolean := FALSE;
     CLK_COR_MAX_LAT_0 : integer := 20;
     CLK_COR_MAX_LAT_1 : integer := 20;
     CLK_COR_MIN_LAT_0 : integer := 18;
     CLK_COR_MIN_LAT_1 : integer := 18;
     CLK_COR_PRECEDENCE_0 : boolean := TRUE;
     CLK_COR_PRECEDENCE_1 : boolean := TRUE;
     CLK_COR_REPEAT_WAIT_0 : integer := 0;
     CLK_COR_REPEAT_WAIT_1 : integer := 0;
     CLK_COR_SEQ_1_1_0 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_1_1 : bit_vector := "0100011100";
     CLK_COR_SEQ_1_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_1_ENABLE_0 : bit_vector := "0001";
     CLK_COR_SEQ_1_ENABLE_1 : bit_vector := "0001";
     CLK_COR_SEQ_2_1_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_1_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_2_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_3_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_0 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_4_1 : bit_vector := "0000000000";
     CLK_COR_SEQ_2_ENABLE_0 : bit_vector := "0000";
     CLK_COR_SEQ_2_ENABLE_1 : bit_vector := "0000";
     CLK_COR_SEQ_2_USE_0 : boolean := FALSE;
     CLK_COR_SEQ_2_USE_1 : boolean := FALSE;
     CM_TRIM_0 : bit_vector := "10";
     CM_TRIM_1 : bit_vector := "10";
     COMMA_10B_ENABLE_0 : bit_vector := "0001111111";
     COMMA_10B_ENABLE_1 : bit_vector := "0001111111";
     COMMA_DOUBLE_0 : boolean := FALSE;
     COMMA_DOUBLE_1 : boolean := FALSE;
     COM_BURST_VAL_0 : bit_vector := "1111";
     COM_BURST_VAL_1 : bit_vector := "1111";
     DEC_MCOMMA_DETECT_0 : boolean := TRUE;
     DEC_MCOMMA_DETECT_1 : boolean := TRUE;
     DEC_PCOMMA_DETECT_0 : boolean := TRUE;
     DEC_PCOMMA_DETECT_1 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_0 : boolean := TRUE;
     DEC_VALID_COMMA_ONLY_1 : boolean := TRUE;
     DFE_CAL_TIME : bit_vector := "00110";
     DFE_CFG_0 : bit_vector := "1101111011";
     DFE_CFG_1 : bit_vector := "1101111011";
     GEARBOX_ENDEC_0 : bit_vector := "000";
     GEARBOX_ENDEC_1 : bit_vector := "000";
     MCOMMA_10B_VALUE_0 : bit_vector := "1010000011";
     MCOMMA_10B_VALUE_1 : bit_vector := "1010000011";
     MCOMMA_DETECT_0 : boolean := TRUE;
     MCOMMA_DETECT_1 : boolean := TRUE;
     OOBDETECT_THRESHOLD_0 : bit_vector := "110";
     OOBDETECT_THRESHOLD_1 : bit_vector := "110";
     OOB_CLK_DIVIDER : integer := 6;
     OVERSAMPLE_MODE : boolean := FALSE;
     PCI_EXPRESS_MODE_0 : boolean := FALSE;
     PCI_EXPRESS_MODE_1 : boolean := FALSE;
     PCOMMA_10B_VALUE_0 : bit_vector := "0101111100";
     PCOMMA_10B_VALUE_1 : bit_vector := "0101111100";
     PCOMMA_DETECT_0 : boolean := TRUE;
     PCOMMA_DETECT_1 : boolean := TRUE;
     PLL_COM_CFG : bit_vector := X"21680a";
     PLL_CP_CFG : bit_vector := X"00";
     PLL_DIVSEL_FB : integer := 2;
     PLL_DIVSEL_REF : integer := 1;
     PLL_FB_DCCEN : boolean := FALSE;
     PLL_LKDET_CFG : bit_vector := "101";
     PLL_RXDIVSEL_OUT_0 : integer := 1;
     PLL_RXDIVSEL_OUT_1 : integer := 1;
     PLL_SATA_0 : boolean := FALSE;
     PLL_SATA_1 : boolean := FALSE;
     PLL_TDCC_CFG : bit_vector := "000";
     PLL_TXDIVSEL_OUT_0 : integer := 1;
     PLL_TXDIVSEL_OUT_1 : integer := 1;
     PMA_CDR_SCAN_0 : bit_vector := X"6404035";
     PMA_CDR_SCAN_1 : bit_vector := X"6404035";
     PMA_COM_CFG : bit_vector := X"000000000000000000";
     PMA_RXSYNC_CFG_0 : bit_vector := X"00";
     PMA_RXSYNC_CFG_1 : bit_vector := X"00";
     PMA_RX_CFG_0 : bit_vector := X"0f44089";
     PMA_RX_CFG_1 : bit_vector := X"0f44089";
     PMA_TX_CFG_0 : bit_vector := X"80082";
     PMA_TX_CFG_1 : bit_vector := X"80082";
     PRBS_ERR_THRESHOLD_0 : bit_vector := X"00000001";
     PRBS_ERR_THRESHOLD_1 : bit_vector := X"00000001";
     RCV_TERM_GND_0 : boolean := FALSE;
     RCV_TERM_GND_1 : boolean := FALSE;
     RCV_TERM_VTTRX_0 : boolean := FALSE;
     RCV_TERM_VTTRX_1 : boolean := FALSE;
     RXGEARBOX_USE_0 : boolean := FALSE;
     RXGEARBOX_USE_1 : boolean := FALSE;
     RX_BUFFER_USE_0 : boolean := TRUE;
     RX_BUFFER_USE_1 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_0 : boolean := TRUE;
     RX_DECODE_SEQ_MATCH_1 : boolean := TRUE;
     RX_EN_IDLE_HOLD_CDR : boolean := FALSE;
     RX_EN_IDLE_HOLD_DFE_0 : boolean := TRUE;
     RX_EN_IDLE_HOLD_DFE_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF_0 : boolean := TRUE;
     RX_EN_IDLE_RESET_BUF_1 : boolean := TRUE;
     RX_EN_IDLE_RESET_FR : boolean := TRUE;
     RX_EN_IDLE_RESET_PH : boolean := TRUE;
     RX_IDLE_HI_CNT_0 : bit_vector := "1000";
     RX_IDLE_HI_CNT_1 : bit_vector := "1000";
     RX_IDLE_LO_CNT_0 : bit_vector := "0000";
     RX_IDLE_LO_CNT_1 : bit_vector := "0000";
     RX_LOSS_OF_SYNC_FSM_0 : boolean := FALSE;
     RX_LOSS_OF_SYNC_FSM_1 : boolean := FALSE;
     RX_LOS_INVALID_INCR_0 : integer := 1;
     RX_LOS_INVALID_INCR_1 : integer := 1;
     RX_LOS_THRESHOLD_0 : integer := 4;
     RX_LOS_THRESHOLD_1 : integer := 4;
     RX_SLIDE_MODE_0 : string := "PCS";
     RX_SLIDE_MODE_1 : string := "PCS";
     RX_STATUS_FMT_0 : string := "PCIE";
     RX_STATUS_FMT_1 : string := "PCIE";
     RX_XCLK_SEL_0 : string := "RXREC";
     RX_XCLK_SEL_1 : string := "RXREC";
     SATA_BURST_VAL_0 : bit_vector := "100";
     SATA_BURST_VAL_1 : bit_vector := "100";
     SATA_IDLE_VAL_0 : bit_vector := "100";
     SATA_IDLE_VAL_1 : bit_vector := "100";
     SATA_MAX_BURST_0 : integer := 7;
     SATA_MAX_BURST_1 : integer := 7;
     SATA_MAX_INIT_0 : integer := 22;
     SATA_MAX_INIT_1 : integer := 22;
     SATA_MAX_WAKE_0 : integer := 7;
     SATA_MAX_WAKE_1 : integer := 7;
     SATA_MIN_BURST_0 : integer := 4;
     SATA_MIN_BURST_1 : integer := 4;
     SATA_MIN_INIT_0 : integer := 12;
     SATA_MIN_INIT_1 : integer := 12;
     SATA_MIN_WAKE_0 : integer := 4;
     SATA_MIN_WAKE_1 : integer := 4;
     SIM_GTXRESET_SPEEDUP : integer := 1;
     SIM_MODE : string := "FAST";
     SIM_PLL_PERDIV2 : bit_vector := X"140";
     SIM_RECEIVER_DETECT_PASS_0 : boolean := TRUE;
     SIM_RECEIVER_DETECT_PASS_1 : boolean := TRUE;
     TERMINATION_CTRL : bit_vector := "10100";
     TERMINATION_IMP_0 : integer := 50;
     TERMINATION_IMP_1 : integer := 50;
     TERMINATION_OVRD : boolean := FALSE;
     TRANS_TIME_FROM_P2_0 : bit_vector := X"03c";
     TRANS_TIME_FROM_P2_1 : bit_vector := X"03c";
     TRANS_TIME_NON_P2_0 : bit_vector := X"19";
     TRANS_TIME_NON_P2_1 : bit_vector := X"19";
     TRANS_TIME_TO_P2_0 : bit_vector := X"064";
     TRANS_TIME_TO_P2_1 : bit_vector := X"064";
     TXGEARBOX_USE_0 : boolean := FALSE;
     TXGEARBOX_USE_1 : boolean := FALSE;
     TXRX_INVERT_0 : bit_vector := "011";
     TXRX_INVERT_1 : bit_vector := "011";
     TX_BUFFER_USE_0 : boolean := TRUE;
     TX_BUFFER_USE_1 : boolean := TRUE;
     TX_DETECT_RX_CFG_0 : bit_vector := X"1832";
     TX_DETECT_RX_CFG_1 : bit_vector := X"1832";
     TX_IDLE_DELAY_0 : bit_vector := "010";
     TX_IDLE_DELAY_1 : bit_vector := "010";
     TX_XCLK_SEL_0 : string := "TXOUT";
     TX_XCLK_SEL_1 : string := "TXOUT"
  );
  port (
     DFECLKDLYADJMONITOR0 : out std_logic_vector(5 downto 0);
     DFECLKDLYADJMONITOR1 : out std_logic_vector(5 downto 0);
     DFEEYEDACMONITOR0 : out std_logic_vector(4 downto 0);
     DFEEYEDACMONITOR1 : out std_logic_vector(4 downto 0);
     DFESENSCAL0 : out std_logic_vector(2 downto 0);
     DFESENSCAL1 : out std_logic_vector(2 downto 0);
     DFETAP1MONITOR0 : out std_logic_vector(4 downto 0);
     DFETAP1MONITOR1 : out std_logic_vector(4 downto 0);
     DFETAP2MONITOR0 : out std_logic_vector(4 downto 0);
     DFETAP2MONITOR1 : out std_logic_vector(4 downto 0);
     DFETAP3MONITOR0 : out std_logic_vector(3 downto 0);
     DFETAP3MONITOR1 : out std_logic_vector(3 downto 0);
     DFETAP4MONITOR0 : out std_logic_vector(3 downto 0);
     DFETAP4MONITOR1 : out std_logic_vector(3 downto 0);
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic;
     PHYSTATUS0 : out std_ulogic;
     PHYSTATUS1 : out std_ulogic;
     PLLLKDET : out std_ulogic;
     REFCLKOUT : out std_ulogic;
     RESETDONE0 : out std_ulogic;
     RESETDONE1 : out std_ulogic;
     RXBUFSTATUS0 : out std_logic_vector(2 downto 0);
     RXBUFSTATUS1 : out std_logic_vector(2 downto 0);
     RXBYTEISALIGNED0 : out std_ulogic;
     RXBYTEISALIGNED1 : out std_ulogic;
     RXBYTEREALIGN0 : out std_ulogic;
     RXBYTEREALIGN1 : out std_ulogic;
     RXCHANBONDSEQ0 : out std_ulogic;
     RXCHANBONDSEQ1 : out std_ulogic;
     RXCHANISALIGNED0 : out std_ulogic;
     RXCHANISALIGNED1 : out std_ulogic;
     RXCHANREALIGN0 : out std_ulogic;
     RXCHANREALIGN1 : out std_ulogic;
     RXCHARISCOMMA0 : out std_logic_vector(3 downto 0);
     RXCHARISCOMMA1 : out std_logic_vector(3 downto 0);
     RXCHARISK0 : out std_logic_vector(3 downto 0);
     RXCHARISK1 : out std_logic_vector(3 downto 0);
     RXCHBONDO0 : out std_logic_vector(3 downto 0);
     RXCHBONDO1 : out std_logic_vector(3 downto 0);
     RXCLKCORCNT0 : out std_logic_vector(2 downto 0);
     RXCLKCORCNT1 : out std_logic_vector(2 downto 0);
     RXCOMMADET0 : out std_ulogic;
     RXCOMMADET1 : out std_ulogic;
     RXDATA0 : out std_logic_vector(31 downto 0);
     RXDATA1 : out std_logic_vector(31 downto 0);
     RXDATAVALID0 : out std_ulogic;
     RXDATAVALID1 : out std_ulogic;
     RXDISPERR0 : out std_logic_vector(3 downto 0);
     RXDISPERR1 : out std_logic_vector(3 downto 0);
     RXELECIDLE0 : out std_ulogic;
     RXELECIDLE1 : out std_ulogic;
     RXHEADER0 : out std_logic_vector(2 downto 0);
     RXHEADER1 : out std_logic_vector(2 downto 0);
     RXHEADERVALID0 : out std_ulogic;
     RXHEADERVALID1 : out std_ulogic;
     RXLOSSOFSYNC0 : out std_logic_vector(1 downto 0);
     RXLOSSOFSYNC1 : out std_logic_vector(1 downto 0);
     RXNOTINTABLE0 : out std_logic_vector(3 downto 0);
     RXNOTINTABLE1 : out std_logic_vector(3 downto 0);
     RXOVERSAMPLEERR0 : out std_ulogic;
     RXOVERSAMPLEERR1 : out std_ulogic;
     RXPRBSERR0 : out std_ulogic;
     RXPRBSERR1 : out std_ulogic;
     RXRECCLK0 : out std_ulogic;
     RXRECCLK1 : out std_ulogic;
     RXRUNDISP0 : out std_logic_vector(3 downto 0);
     RXRUNDISP1 : out std_logic_vector(3 downto 0);
     RXSTARTOFSEQ0 : out std_ulogic;
     RXSTARTOFSEQ1 : out std_ulogic;
     RXSTATUS0 : out std_logic_vector(2 downto 0);
     RXSTATUS1 : out std_logic_vector(2 downto 0);
     RXVALID0 : out std_ulogic;
     RXVALID1 : out std_ulogic;
     TXBUFSTATUS0 : out std_logic_vector(1 downto 0);
     TXBUFSTATUS1 : out std_logic_vector(1 downto 0);
     TXGEARBOXREADY0 : out std_ulogic;
     TXGEARBOXREADY1 : out std_ulogic;
     TXKERR0 : out std_logic_vector(3 downto 0);
     TXKERR1 : out std_logic_vector(3 downto 0);
     TXN0 : out std_ulogic;
     TXN1 : out std_ulogic;
     TXOUTCLK0 : out std_ulogic;
     TXOUTCLK1 : out std_ulogic;
     TXP0 : out std_ulogic;
     TXP1 : out std_ulogic;
     TXRUNDISP0 : out std_logic_vector(3 downto 0);
     TXRUNDISP1 : out std_logic_vector(3 downto 0);
     CLKIN : in std_ulogic;
     DADDR : in std_logic_vector(6 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DFECLKDLYADJ0 : in std_logic_vector(5 downto 0);
     DFECLKDLYADJ1 : in std_logic_vector(5 downto 0);
     DFETAP10 : in std_logic_vector(4 downto 0);
     DFETAP11 : in std_logic_vector(4 downto 0);
     DFETAP20 : in std_logic_vector(4 downto 0);
     DFETAP21 : in std_logic_vector(4 downto 0);
     DFETAP30 : in std_logic_vector(3 downto 0);
     DFETAP31 : in std_logic_vector(3 downto 0);
     DFETAP40 : in std_logic_vector(3 downto 0);
     DFETAP41 : in std_logic_vector(3 downto 0);
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     GTXRESET : in std_ulogic;
     GTXTEST : in std_logic_vector(13 downto 0);
     INTDATAWIDTH : in std_ulogic;
     LOOPBACK0 : in std_logic_vector(2 downto 0);
     LOOPBACK1 : in std_logic_vector(2 downto 0);
     PLLLKDETEN : in std_ulogic;
     PLLPOWERDOWN : in std_ulogic;
     PRBSCNTRESET0 : in std_ulogic;
     PRBSCNTRESET1 : in std_ulogic;
     REFCLKPWRDNB : in std_ulogic;
     RXBUFRESET0 : in std_ulogic;
     RXBUFRESET1 : in std_ulogic;
     RXCDRRESET0 : in std_ulogic;
     RXCDRRESET1 : in std_ulogic;
     RXCHBONDI0 : in std_logic_vector(3 downto 0);
     RXCHBONDI1 : in std_logic_vector(3 downto 0);
     RXCOMMADETUSE0 : in std_ulogic;
     RXCOMMADETUSE1 : in std_ulogic;
     RXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     RXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     RXDEC8B10BUSE0 : in std_ulogic;
     RXDEC8B10BUSE1 : in std_ulogic;
     RXENCHANSYNC0 : in std_ulogic;
     RXENCHANSYNC1 : in std_ulogic;
     RXENEQB0 : in std_ulogic;
     RXENEQB1 : in std_ulogic;
     RXENMCOMMAALIGN0 : in std_ulogic;
     RXENMCOMMAALIGN1 : in std_ulogic;
     RXENPCOMMAALIGN0 : in std_ulogic;
     RXENPCOMMAALIGN1 : in std_ulogic;
     RXENPMAPHASEALIGN0 : in std_ulogic;
     RXENPMAPHASEALIGN1 : in std_ulogic;
     RXENPRBSTST0 : in std_logic_vector(1 downto 0);
     RXENPRBSTST1 : in std_logic_vector(1 downto 0);
     RXENSAMPLEALIGN0 : in std_ulogic;
     RXENSAMPLEALIGN1 : in std_ulogic;
     RXEQMIX0 : in std_logic_vector(1 downto 0);
     RXEQMIX1 : in std_logic_vector(1 downto 0);
     RXEQPOLE0 : in std_logic_vector(3 downto 0);
     RXEQPOLE1 : in std_logic_vector(3 downto 0);
     RXGEARBOXSLIP0 : in std_ulogic;
     RXGEARBOXSLIP1 : in std_ulogic;
     RXN0 : in std_ulogic;
     RXN1 : in std_ulogic;
     RXP0 : in std_ulogic;
     RXP1 : in std_ulogic;
     RXPMASETPHASE0 : in std_ulogic;
     RXPMASETPHASE1 : in std_ulogic;
     RXPOLARITY0 : in std_ulogic;
     RXPOLARITY1 : in std_ulogic;
     RXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     RXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     RXRESET0 : in std_ulogic;
     RXRESET1 : in std_ulogic;
     RXSLIDE0 : in std_ulogic;
     RXSLIDE1 : in std_ulogic;
     RXUSRCLK0 : in std_ulogic;
     RXUSRCLK1 : in std_ulogic;
     RXUSRCLK20 : in std_ulogic;
     RXUSRCLK21 : in std_ulogic;
     TXBUFDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXBUFDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXBYPASS8B10B0 : in std_logic_vector(3 downto 0);
     TXBYPASS8B10B1 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE0 : in std_logic_vector(3 downto 0);
     TXCHARDISPMODE1 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL0 : in std_logic_vector(3 downto 0);
     TXCHARDISPVAL1 : in std_logic_vector(3 downto 0);
     TXCHARISK0 : in std_logic_vector(3 downto 0);
     TXCHARISK1 : in std_logic_vector(3 downto 0);
     TXCOMSTART0 : in std_ulogic;
     TXCOMSTART1 : in std_ulogic;
     TXCOMTYPE0 : in std_ulogic;
     TXCOMTYPE1 : in std_ulogic;
     TXDATA0 : in std_logic_vector(31 downto 0);
     TXDATA1 : in std_logic_vector(31 downto 0);
     TXDATAWIDTH0 : in std_logic_vector(1 downto 0);
     TXDATAWIDTH1 : in std_logic_vector(1 downto 0);
     TXDETECTRX0 : in std_ulogic;
     TXDETECTRX1 : in std_ulogic;
     TXDIFFCTRL0 : in std_logic_vector(2 downto 0);
     TXDIFFCTRL1 : in std_logic_vector(2 downto 0);
     TXELECIDLE0 : in std_ulogic;
     TXELECIDLE1 : in std_ulogic;
     TXENC8B10BUSE0 : in std_ulogic;
     TXENC8B10BUSE1 : in std_ulogic;
     TXENPMAPHASEALIGN0 : in std_ulogic;
     TXENPMAPHASEALIGN1 : in std_ulogic;
     TXENPRBSTST0 : in std_logic_vector(1 downto 0);
     TXENPRBSTST1 : in std_logic_vector(1 downto 0);
     TXHEADER0 : in std_logic_vector(2 downto 0);
     TXHEADER1 : in std_logic_vector(2 downto 0);
     TXINHIBIT0 : in std_ulogic;
     TXINHIBIT1 : in std_ulogic;
     TXPMASETPHASE0 : in std_ulogic;
     TXPMASETPHASE1 : in std_ulogic;
     TXPOLARITY0 : in std_ulogic;
     TXPOLARITY1 : in std_ulogic;
     TXPOWERDOWN0 : in std_logic_vector(1 downto 0);
     TXPOWERDOWN1 : in std_logic_vector(1 downto 0);
     TXPREEMPHASIS0 : in std_logic_vector(3 downto 0);
     TXPREEMPHASIS1 : in std_logic_vector(3 downto 0);
     TXRESET0 : in std_ulogic;
     TXRESET1 : in std_ulogic;
     TXSEQUENCE0 : in std_logic_vector(6 downto 0);
     TXSEQUENCE1 : in std_logic_vector(6 downto 0);
     TXSTARTSEQ0 : in std_ulogic;
     TXSTARTSEQ1 : in std_ulogic;
     TXUSRCLK0 : in std_ulogic;
     TXUSRCLK1 : in std_ulogic;
     TXUSRCLK20 : in std_ulogic;
     TXUSRCLK21 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  GTX_DUAL : component is "PRIMITIVE";

----- component IBUF -----
component IBUF
  generic (
     CAPACITANCE : string := "DONT_CARE";
     IBUF_DELAY_VALUE : string := "0";
     IBUF_LOW_PWR : boolean := TRUE;
     IFD_DELAY_VALUE : string := "AUTO";
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF : component is "PRIMITIVE";

----- component IBUFDS -----
component IBUFDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DIFF_TERM : boolean := FALSE;
     IBUF_DELAY_VALUE : string := "0";
     IBUF_LOW_PWR : boolean := TRUE;
     IFD_DELAY_VALUE : string := "AUTO";
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS : component is "PRIMITIVE";

----- component IBUFDS_BLVDS_25 -----
component IBUFDS_BLVDS_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_BLVDS_25 : component is "PRIMITIVE";

----- component IBUFDS_DIFF_OUT -----
component IBUFDS_DIFF_OUT
  generic (
     DIFF_TERM : boolean := FALSE;
     IBUF_LOW_PWR : boolean := TRUE;
     IOSTANDARD : string := "LVDS_25"
  );
  port (
     O : out STD_ULOGIC;
     OB : out STD_ULOGIC;
     I : in STD_ULOGIC;
     IB : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  IBUFDS_DIFF_OUT : component is "PRIMITIVE";

----- component IBUFDS_DLY_ADJ -----
component IBUFDS_DLY_ADJ
  generic (
     DELAY_OFFSET : string := "OFF";
     DIFF_TERM : boolean := FALSE;
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic;
     S : in std_logic_vector (2 downto 0)
  );
end component;
attribute BOX_TYPE of
  IBUFDS_DLY_ADJ : component is "PRIMITIVE";

----- component IBUFDS_GTHE1 -----
component IBUFDS_GTHE1
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_GTHE1 : component is "PRIMITIVE";

----- component IBUFDS_GTXE1 -----
component IBUFDS_GTXE1
  generic (
     CLKCM_CFG : boolean := TRUE;
     CLKRCV_TRST : boolean := TRUE;
     REFCLKOUT_DLY : bit_vector := b"0000000000"
  );
  port (
     O : out std_ulogic;
     ODIV2 : out std_ulogic;
     CEB : in std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_GTXE1 : component is "PRIMITIVE";

----- component IBUFDS_LDT_25 -----
component IBUFDS_LDT_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LDT_25 : component is "PRIMITIVE";

----- component IBUFDS_LVDSEXT_25 -----
component IBUFDS_LVDSEXT_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDSEXT_25 : component is "PRIMITIVE";

----- component IBUFDS_LVDSEXT_25_DCI -----
component IBUFDS_LVDSEXT_25_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDSEXT_25_DCI : component is "PRIMITIVE";

----- component IBUFDS_LVDSEXT_33 -----
component IBUFDS_LVDSEXT_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDSEXT_33 : component is "PRIMITIVE";

----- component IBUFDS_LVDSEXT_33_DCI -----
component IBUFDS_LVDSEXT_33_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDSEXT_33_DCI : component is "PRIMITIVE";

----- component IBUFDS_LVDS_25 -----
component IBUFDS_LVDS_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDS_25 : component is "PRIMITIVE";

----- component IBUFDS_LVDS_25_DCI -----
component IBUFDS_LVDS_25_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDS_25_DCI : component is "PRIMITIVE";

----- component IBUFDS_LVDS_33 -----
component IBUFDS_LVDS_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDS_33 : component is "PRIMITIVE";

----- component IBUFDS_LVDS_33_DCI -----
component IBUFDS_LVDS_33_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVDS_33_DCI : component is "PRIMITIVE";

----- component IBUFDS_LVPECL_25 -----
component IBUFDS_LVPECL_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVPECL_25 : component is "PRIMITIVE";

----- component IBUFDS_LVPECL_33 -----
component IBUFDS_LVPECL_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_LVPECL_33 : component is "PRIMITIVE";

----- component IBUFDS_ULVDS_25 -----
component IBUFDS_ULVDS_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFDS_ULVDS_25 : component is "PRIMITIVE";

----- component IBUFG -----
component IBUFG
  generic (
     CAPACITANCE : string := "DONT_CARE";
     IBUF_DELAY_VALUE : string := "0";
     IBUF_LOW_PWR : boolean := TRUE;
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG : component is "PRIMITIVE";

----- component IBUFGDS -----
component IBUFGDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DIFF_TERM : boolean := FALSE;
     IBUF_DELAY_VALUE : string := "0";
     IBUF_LOW_PWR : boolean := TRUE;
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS : component is "PRIMITIVE";

----- component IBUFGDS_BLVDS_25 -----
component IBUFGDS_BLVDS_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_BLVDS_25 : component is "PRIMITIVE";

----- component IBUFGDS_DIFF_OUT -----
component IBUFGDS_DIFF_OUT
  generic (
     DIFF_TERM : boolean := FALSE;
     IBUF_LOW_PWR : boolean := TRUE;
     IOSTANDARD : string := "LVDS_25"
  );
  port (
     O : out STD_ULOGIC;
     OB : out STD_ULOGIC;
     I : in STD_ULOGIC;
     IB : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_DIFF_OUT : component is "PRIMITIVE";

----- component IBUFGDS_LDT_25 -----
component IBUFGDS_LDT_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LDT_25 : component is "PRIMITIVE";

----- component IBUFGDS_LVDSEXT_25 -----
component IBUFGDS_LVDSEXT_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDSEXT_25 : component is "PRIMITIVE";

----- component IBUFGDS_LVDSEXT_25_DCI -----
component IBUFGDS_LVDSEXT_25_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDSEXT_25_DCI : component is "PRIMITIVE";

----- component IBUFGDS_LVDSEXT_33 -----
component IBUFGDS_LVDSEXT_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDSEXT_33 : component is "PRIMITIVE";

----- component IBUFGDS_LVDSEXT_33_DCI -----
component IBUFGDS_LVDSEXT_33_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDSEXT_33_DCI : component is "PRIMITIVE";

----- component IBUFGDS_LVDS_25 -----
component IBUFGDS_LVDS_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDS_25 : component is "PRIMITIVE";

----- component IBUFGDS_LVDS_25_DCI -----
component IBUFGDS_LVDS_25_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDS_25_DCI : component is "PRIMITIVE";

----- component IBUFGDS_LVDS_33 -----
component IBUFGDS_LVDS_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDS_33 : component is "PRIMITIVE";

----- component IBUFGDS_LVDS_33_DCI -----
component IBUFGDS_LVDS_33_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVDS_33_DCI : component is "PRIMITIVE";

----- component IBUFGDS_LVPECL_25 -----
component IBUFGDS_LVPECL_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVPECL_25 : component is "PRIMITIVE";

----- component IBUFGDS_LVPECL_33 -----
component IBUFGDS_LVPECL_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_LVPECL_33 : component is "PRIMITIVE";

----- component IBUFGDS_ULVDS_25 -----
component IBUFGDS_ULVDS_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     IB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFGDS_ULVDS_25 : component is "PRIMITIVE";

----- component IBUFG_AGP -----
component IBUFG_AGP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_AGP : component is "PRIMITIVE";

----- component IBUFG_CTT -----
component IBUFG_CTT
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_CTT : component is "PRIMITIVE";

----- component IBUFG_GTL -----
component IBUFG_GTL
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_GTL : component is "PRIMITIVE";

----- component IBUFG_GTLP -----
component IBUFG_GTLP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_GTLP : component is "PRIMITIVE";

----- component IBUFG_GTLP_DCI -----
component IBUFG_GTLP_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_GTLP_DCI : component is "PRIMITIVE";

----- component IBUFG_GTL_DCI -----
component IBUFG_GTL_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_GTL_DCI : component is "PRIMITIVE";

----- component IBUFG_HSTL_I -----
component IBUFG_HSTL_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_I : component is "PRIMITIVE";

----- component IBUFG_HSTL_II -----
component IBUFG_HSTL_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_II : component is "PRIMITIVE";

----- component IBUFG_HSTL_III -----
component IBUFG_HSTL_III
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_III : component is "PRIMITIVE";

----- component IBUFG_HSTL_III_18 -----
component IBUFG_HSTL_III_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_III_18 : component is "PRIMITIVE";

----- component IBUFG_HSTL_III_DCI -----
component IBUFG_HSTL_III_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_III_DCI : component is "PRIMITIVE";

----- component IBUFG_HSTL_III_DCI_18 -----
component IBUFG_HSTL_III_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_III_DCI_18 : component is "PRIMITIVE";

----- component IBUFG_HSTL_II_18 -----
component IBUFG_HSTL_II_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_II_18 : component is "PRIMITIVE";

----- component IBUFG_HSTL_II_DCI -----
component IBUFG_HSTL_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_II_DCI : component is "PRIMITIVE";

----- component IBUFG_HSTL_II_DCI_18 -----
component IBUFG_HSTL_II_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_II_DCI_18 : component is "PRIMITIVE";

----- component IBUFG_HSTL_IV -----
component IBUFG_HSTL_IV
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_IV : component is "PRIMITIVE";

----- component IBUFG_HSTL_IV_18 -----
component IBUFG_HSTL_IV_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_IV_18 : component is "PRIMITIVE";

----- component IBUFG_HSTL_IV_DCI -----
component IBUFG_HSTL_IV_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_IV_DCI : component is "PRIMITIVE";

----- component IBUFG_HSTL_IV_DCI_18 -----
component IBUFG_HSTL_IV_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_IV_DCI_18 : component is "PRIMITIVE";

----- component IBUFG_HSTL_I_18 -----
component IBUFG_HSTL_I_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_I_18 : component is "PRIMITIVE";

----- component IBUFG_HSTL_I_DCI -----
component IBUFG_HSTL_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_I_DCI : component is "PRIMITIVE";

----- component IBUFG_HSTL_I_DCI_18 -----
component IBUFG_HSTL_I_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_HSTL_I_DCI_18 : component is "PRIMITIVE";

----- component IBUFG_LVCMOS12 -----
component IBUFG_LVCMOS12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVCMOS12 : component is "PRIMITIVE";

----- component IBUFG_LVCMOS15 -----
component IBUFG_LVCMOS15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVCMOS15 : component is "PRIMITIVE";

----- component IBUFG_LVCMOS18 -----
component IBUFG_LVCMOS18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVCMOS18 : component is "PRIMITIVE";

----- component IBUFG_LVCMOS2 -----
component IBUFG_LVCMOS2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVCMOS2 : component is "PRIMITIVE";

----- component IBUFG_LVCMOS25 -----
component IBUFG_LVCMOS25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVCMOS25 : component is "PRIMITIVE";

----- component IBUFG_LVCMOS33 -----
component IBUFG_LVCMOS33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVCMOS33 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_15 -----
component IBUFG_LVDCI_15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_15 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_18 -----
component IBUFG_LVDCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_18 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_25 -----
component IBUFG_LVDCI_25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_25 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_33 -----
component IBUFG_LVDCI_33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_33 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_DV2_15 -----
component IBUFG_LVDCI_DV2_15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_DV2_15 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_DV2_18 -----
component IBUFG_LVDCI_DV2_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_DV2_18 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_DV2_25 -----
component IBUFG_LVDCI_DV2_25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_DV2_25 : component is "PRIMITIVE";

----- component IBUFG_LVDCI_DV2_33 -----
component IBUFG_LVDCI_DV2_33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDCI_DV2_33 : component is "PRIMITIVE";

----- component IBUFG_LVDS -----
component IBUFG_LVDS
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVDS : component is "PRIMITIVE";

----- component IBUFG_LVPECL -----
component IBUFG_LVPECL
  port (
     O : out STD_ULOGIC;
     I : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVPECL : component is "PRIMITIVE";

----- component IBUFG_LVTTL -----
component IBUFG_LVTTL
  port (
     O : out STD_ULOGIC;
     I : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  IBUFG_LVTTL : component is "PRIMITIVE";

----- component IBUFG_PCI33_3 -----
component IBUFG_PCI33_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_PCI33_3 : component is "PRIMITIVE";

----- component IBUFG_PCI33_5 -----
component IBUFG_PCI33_5
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_PCI33_5 : component is "PRIMITIVE";

----- component IBUFG_PCI66_3 -----
component IBUFG_PCI66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_PCI66_3 : component is "PRIMITIVE";

----- component IBUFG_PCIX -----
component IBUFG_PCIX
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_PCIX : component is "PRIMITIVE";

----- component IBUFG_PCIX66_3 -----
component IBUFG_PCIX66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_PCIX66_3 : component is "PRIMITIVE";

----- component IBUFG_SSTL18_I -----
component IBUFG_SSTL18_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL18_I : component is "PRIMITIVE";

----- component IBUFG_SSTL18_II -----
component IBUFG_SSTL18_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL18_II : component is "PRIMITIVE";

----- component IBUFG_SSTL18_II_DCI -----
component IBUFG_SSTL18_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL18_II_DCI : component is "PRIMITIVE";

----- component IBUFG_SSTL18_I_DCI -----
component IBUFG_SSTL18_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL18_I_DCI : component is "PRIMITIVE";

----- component IBUFG_SSTL2_I -----
component IBUFG_SSTL2_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL2_I : component is "PRIMITIVE";

----- component IBUFG_SSTL2_II -----
component IBUFG_SSTL2_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL2_II : component is "PRIMITIVE";

----- component IBUFG_SSTL2_II_DCI -----
component IBUFG_SSTL2_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL2_II_DCI : component is "PRIMITIVE";

----- component IBUFG_SSTL2_I_DCI -----
component IBUFG_SSTL2_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL2_I_DCI : component is "PRIMITIVE";

----- component IBUFG_SSTL3_I -----
component IBUFG_SSTL3_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL3_I : component is "PRIMITIVE";

----- component IBUFG_SSTL3_II -----
component IBUFG_SSTL3_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL3_II : component is "PRIMITIVE";

----- component IBUFG_SSTL3_II_DCI -----
component IBUFG_SSTL3_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL3_II_DCI : component is "PRIMITIVE";

----- component IBUFG_SSTL3_I_DCI -----
component IBUFG_SSTL3_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUFG_SSTL3_I_DCI : component is "PRIMITIVE";

----- component IBUF_AGP -----
component IBUF_AGP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_AGP : component is "PRIMITIVE";

----- component IBUF_CTT -----
component IBUF_CTT
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_CTT : component is "PRIMITIVE";

----- component IBUF_DLY_ADJ -----
component IBUF_DLY_ADJ
  generic (
     DELAY_OFFSET : string := "OFF";
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     S : in std_logic_vector (2 downto 0)
  );
end component;
attribute BOX_TYPE of
  IBUF_DLY_ADJ : component is "PRIMITIVE";

----- component IBUF_GTL -----
component IBUF_GTL
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_GTL : component is "PRIMITIVE";

----- component IBUF_GTLP -----
component IBUF_GTLP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_GTLP : component is "PRIMITIVE";

----- component IBUF_GTLP_DCI -----
component IBUF_GTLP_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_GTLP_DCI : component is "PRIMITIVE";

----- component IBUF_GTL_DCI -----
component IBUF_GTL_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_GTL_DCI : component is "PRIMITIVE";

----- component IBUF_HSTL_I -----
component IBUF_HSTL_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_I : component is "PRIMITIVE";

----- component IBUF_HSTL_II -----
component IBUF_HSTL_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_II : component is "PRIMITIVE";

----- component IBUF_HSTL_III -----
component IBUF_HSTL_III
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_III : component is "PRIMITIVE";

----- component IBUF_HSTL_III_18 -----
component IBUF_HSTL_III_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_III_18 : component is "PRIMITIVE";

----- component IBUF_HSTL_III_DCI -----
component IBUF_HSTL_III_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_III_DCI : component is "PRIMITIVE";

----- component IBUF_HSTL_III_DCI_18 -----
component IBUF_HSTL_III_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_III_DCI_18 : component is "PRIMITIVE";

----- component IBUF_HSTL_II_18 -----
component IBUF_HSTL_II_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_II_18 : component is "PRIMITIVE";

----- component IBUF_HSTL_II_DCI -----
component IBUF_HSTL_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_II_DCI : component is "PRIMITIVE";

----- component IBUF_HSTL_II_DCI_18 -----
component IBUF_HSTL_II_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_II_DCI_18 : component is "PRIMITIVE";

----- component IBUF_HSTL_IV -----
component IBUF_HSTL_IV
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_IV : component is "PRIMITIVE";

----- component IBUF_HSTL_IV_18 -----
component IBUF_HSTL_IV_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_IV_18 : component is "PRIMITIVE";

----- component IBUF_HSTL_IV_DCI -----
component IBUF_HSTL_IV_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_IV_DCI : component is "PRIMITIVE";

----- component IBUF_HSTL_IV_DCI_18 -----
component IBUF_HSTL_IV_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_IV_DCI_18 : component is "PRIMITIVE";

----- component IBUF_HSTL_I_18 -----
component IBUF_HSTL_I_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_I_18 : component is "PRIMITIVE";

----- component IBUF_HSTL_I_DCI -----
component IBUF_HSTL_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_I_DCI : component is "PRIMITIVE";

----- component IBUF_HSTL_I_DCI_18 -----
component IBUF_HSTL_I_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_HSTL_I_DCI_18 : component is "PRIMITIVE";

----- component IBUF_LVCMOS12 -----
component IBUF_LVCMOS12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVCMOS12 : component is "PRIMITIVE";

----- component IBUF_LVCMOS15 -----
component IBUF_LVCMOS15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVCMOS15 : component is "PRIMITIVE";

----- component IBUF_LVCMOS18 -----
component IBUF_LVCMOS18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVCMOS18 : component is "PRIMITIVE";

----- component IBUF_LVCMOS2 -----
component IBUF_LVCMOS2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVCMOS2 : component is "PRIMITIVE";

----- component IBUF_LVCMOS25 -----
component IBUF_LVCMOS25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVCMOS25 : component is "PRIMITIVE";

----- component IBUF_LVCMOS33 -----
component IBUF_LVCMOS33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVCMOS33 : component is "PRIMITIVE";

----- component IBUF_LVDCI_15 -----
component IBUF_LVDCI_15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_15 : component is "PRIMITIVE";

----- component IBUF_LVDCI_18 -----
component IBUF_LVDCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_18 : component is "PRIMITIVE";

----- component IBUF_LVDCI_25 -----
component IBUF_LVDCI_25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_25 : component is "PRIMITIVE";

----- component IBUF_LVDCI_33 -----
component IBUF_LVDCI_33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_33 : component is "PRIMITIVE";

----- component IBUF_LVDCI_DV2_15 -----
component IBUF_LVDCI_DV2_15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_DV2_15 : component is "PRIMITIVE";

----- component IBUF_LVDCI_DV2_18 -----
component IBUF_LVDCI_DV2_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_DV2_18 : component is "PRIMITIVE";

----- component IBUF_LVDCI_DV2_25 -----
component IBUF_LVDCI_DV2_25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_DV2_25 : component is "PRIMITIVE";

----- component IBUF_LVDCI_DV2_33 -----
component IBUF_LVDCI_DV2_33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDCI_DV2_33 : component is "PRIMITIVE";

----- component IBUF_LVDS -----
component IBUF_LVDS
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVDS : component is "PRIMITIVE";

----- component IBUF_LVPECL -----
component IBUF_LVPECL
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVPECL : component is "PRIMITIVE";

----- component IBUF_LVTTL -----
component IBUF_LVTTL
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_LVTTL : component is "PRIMITIVE";

----- component IBUF_PCI33_3 -----
component IBUF_PCI33_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_PCI33_3 : component is "PRIMITIVE";

----- component IBUF_PCI33_5 -----
component IBUF_PCI33_5
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_PCI33_5 : component is "PRIMITIVE";

----- component IBUF_PCI66_3 -----
component IBUF_PCI66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_PCI66_3 : component is "PRIMITIVE";

----- component IBUF_PCIX -----
component IBUF_PCIX
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_PCIX : component is "PRIMITIVE";

----- component IBUF_PCIX66_3 -----
component IBUF_PCIX66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_PCIX66_3 : component is "PRIMITIVE";

----- component IBUF_SSTL18_I -----
component IBUF_SSTL18_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL18_I : component is "PRIMITIVE";

----- component IBUF_SSTL18_II -----
component IBUF_SSTL18_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL18_II : component is "PRIMITIVE";

----- component IBUF_SSTL18_II_DCI -----
component IBUF_SSTL18_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL18_II_DCI : component is "PRIMITIVE";

----- component IBUF_SSTL18_I_DCI -----
component IBUF_SSTL18_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL18_I_DCI : component is "PRIMITIVE";

----- component IBUF_SSTL2_I -----
component IBUF_SSTL2_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL2_I : component is "PRIMITIVE";

----- component IBUF_SSTL2_II -----
component IBUF_SSTL2_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL2_II : component is "PRIMITIVE";

----- component IBUF_SSTL2_II_DCI -----
component IBUF_SSTL2_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL2_II_DCI : component is "PRIMITIVE";

----- component IBUF_SSTL2_I_DCI -----
component IBUF_SSTL2_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL2_I_DCI : component is "PRIMITIVE";

----- component IBUF_SSTL3_I -----
component IBUF_SSTL3_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL3_I : component is "PRIMITIVE";

----- component IBUF_SSTL3_II -----
component IBUF_SSTL3_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL3_II : component is "PRIMITIVE";

----- component IBUF_SSTL3_II_DCI -----
component IBUF_SSTL3_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL3_II_DCI : component is "PRIMITIVE";

----- component IBUF_SSTL3_I_DCI -----
component IBUF_SSTL3_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IBUF_SSTL3_I_DCI : component is "PRIMITIVE";

----- component ICAP_SPARTAN3A -----
component ICAP_SPARTAN3A
  port (
     BUSY : out std_ulogic;
     O : out std_logic_vector(7 downto 0);
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_logic_vector(7 downto 0);
     WRITE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ICAP_SPARTAN3A : component is "PRIMITIVE";

----- component ICAP_SPARTAN6 -----
component ICAP_SPARTAN6
  generic (
     DEVICE_ID : bit_vector := X"02000093";
     SIM_CFG_FILE_NAME : string := "NONE"
  );
  port (
     BUSY : out std_ulogic := '1';
     O : out std_logic_vector(15 downto 0);
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_logic_vector(15 downto 0);
     WRITE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ICAP_SPARTAN6 : component is "PRIMITIVE";

----- component ICAP_VIRTEX4 -----
component ICAP_VIRTEX4
  generic (
     ICAP_WIDTH : string := "X8"
  );
  port (
     BUSY : out std_ulogic;
     O : out std_logic_vector(31 downto 0);
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_logic_vector(31 downto 0);
     WRITE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ICAP_VIRTEX4 : component is "PRIMITIVE";

----- component ICAP_VIRTEX5 -----
component ICAP_VIRTEX5
  generic (
     ICAP_WIDTH : string := "X8"
  );
  port (
     BUSY : out std_ulogic;
     O : out std_logic_vector(31 downto 0);
     CE : in std_ulogic;
     CLK : in std_ulogic;
     I : in std_logic_vector(31 downto 0);
     WRITE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ICAP_VIRTEX5 : component is "PRIMITIVE";

----- component ICAP_VIRTEX6 -----
component ICAP_VIRTEX6
  generic (
     DEVICE_ID : bit_vector := X"04244093";
     ICAP_WIDTH : string := "X8";
     SIM_CFG_FILE_NAME : string := "NONE"
  );
  port (
     BUSY : out std_ulogic := '1';
     O : out std_logic_vector(31 downto 0);
     CLK : in std_ulogic;
     CSB : in std_ulogic;
     I : in std_logic_vector(31 downto 0);
     RDWRB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ICAP_VIRTEX6 : component is "PRIMITIVE";

----- component IDDR -----
component IDDR
  generic (
     DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     SRTYPE : string := "SYNC"
  );
  port (
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  IDDR : component is "PRIMITIVE";

----- component IDDR2 -----
component IDDR2
  generic (
     DDR_ALIGNMENT : string := "NONE";
     INIT_Q0 : bit := '0';
     INIT_Q1 : bit := '0';
     SRTYPE : string := "SYNC"
  );
  port (
     Q0 : out std_ulogic;
     Q1 : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic := 'H';
     D : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  IDDR2 : component is "PRIMITIVE";

----- component IDDR_2CLK -----
component IDDR_2CLK
  generic (
     DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     SRTYPE : string := "SYNC"
  );
  port (
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     C : in std_ulogic;
     CB : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IDDR_2CLK : component is "PRIMITIVE";

----- component IDELAY -----
component IDELAY
  generic (
     IOBDELAY_TYPE : string := "DEFAULT";
     IOBDELAY_VALUE : integer := 0
  );
  port (
     O : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     I : in std_ulogic;
     INC : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IDELAY : component is "PRIMITIVE";

----- component IDELAYCTRL -----
component IDELAYCTRL
  port (
     RDY : out std_ulogic;
     REFCLK : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IDELAYCTRL : component is "PRIMITIVE";

----- component IFDDRCPE -----
component IFDDRCPE
  port (
     Q0 : out std_ulogic;
     Q1 : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IFDDRCPE : component is "PRIMITIVE";

----- component IFDDRRSE -----
component IFDDRRSE
  port (
     Q0 : out std_ulogic;
     Q1 : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     D : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IFDDRRSE : component is "PRIMITIVE";

----- component ILD -----
component ILD
  port (
     Q : out std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ILD : component is "PRIMITIVE";

----- component INV -----
component INV
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  INV : component is "PRIMITIVE";

----- component IOBUF -----
component IOBUF
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DRIVE : integer := 12;
     IBUF_DELAY_VALUE : string := "0";
     IBUF_LOW_PWR : boolean := TRUE;
     IFD_DELAY_VALUE : string := "AUTO";
     IOSTANDARD : string := "DEFAULT";
     SLEW : string := "SLOW"
  );
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF : component is "PRIMITIVE";

----- component IOBUFDS -----
component IOBUFDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DIFF_TERM : boolean := FALSE;
     IBUF_DELAY_VALUE : string := "0";
     IBUF_LOW_PWR : boolean := TRUE;
     IFD_DELAY_VALUE : string := "AUTO";
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     IOB : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUFDS : component is "PRIMITIVE";

----- component IOBUFDS_BLVDS_25 -----
component IOBUFDS_BLVDS_25
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     IOB : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUFDS_BLVDS_25 : component is "PRIMITIVE";

----- component IOBUFDS_DIFF_OUT -----
component IOBUFDS_DIFF_OUT
  generic (
     DIFF_TERM : boolean := FALSE;
     IBUF_LOW_PWR : boolean := TRUE;
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     IO : inout std_ulogic;
     IOB : inout std_ulogic;
     I : in std_ulogic;
     TM : in std_ulogic;
     TS : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUFDS_DIFF_OUT : component is "PRIMITIVE";

----- component IOBUFE -----
component IOBUFE
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     E : in std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUFE : component is "PRIMITIVE";

----- component IOBUF_AGP -----
component IOBUF_AGP
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_AGP : component is "PRIMITIVE";

----- component IOBUF_CTT -----
component IOBUF_CTT
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_CTT : component is "PRIMITIVE";

----- component IOBUF_F_12 -----
component IOBUF_F_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_F_12 : component is "PRIMITIVE";

----- component IOBUF_F_16 -----
component IOBUF_F_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_F_16 : component is "PRIMITIVE";

----- component IOBUF_F_2 -----
component IOBUF_F_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_F_2 : component is "PRIMITIVE";

----- component IOBUF_F_24 -----
component IOBUF_F_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_F_24 : component is "PRIMITIVE";

----- component IOBUF_F_4 -----
component IOBUF_F_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_F_4 : component is "PRIMITIVE";

----- component IOBUF_F_6 -----
component IOBUF_F_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_F_6 : component is "PRIMITIVE";

----- component IOBUF_F_8 -----
component IOBUF_F_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_F_8 : component is "PRIMITIVE";

----- component IOBUF_GTL -----
component IOBUF_GTL
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_GTL : component is "PRIMITIVE";

----- component IOBUF_GTLP -----
component IOBUF_GTLP
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_GTLP : component is "PRIMITIVE";

----- component IOBUF_GTLP_DCI -----
component IOBUF_GTLP_DCI
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_GTLP_DCI : component is "PRIMITIVE";

----- component IOBUF_GTL_DCI -----
component IOBUF_GTL_DCI
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_GTL_DCI : component is "PRIMITIVE";

----- component IOBUF_HSTL_I -----
component IOBUF_HSTL_I
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_I : component is "PRIMITIVE";

----- component IOBUF_HSTL_II -----
component IOBUF_HSTL_II
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_II : component is "PRIMITIVE";

----- component IOBUF_HSTL_III -----
component IOBUF_HSTL_III
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_III : component is "PRIMITIVE";

----- component IOBUF_HSTL_III_18 -----
component IOBUF_HSTL_III_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_III_18 : component is "PRIMITIVE";

----- component IOBUF_HSTL_II_18 -----
component IOBUF_HSTL_II_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_II_18 : component is "PRIMITIVE";

----- component IOBUF_HSTL_II_DCI -----
component IOBUF_HSTL_II_DCI
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_II_DCI : component is "PRIMITIVE";

----- component IOBUF_HSTL_II_DCI_18 -----
component IOBUF_HSTL_II_DCI_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_II_DCI_18 : component is "PRIMITIVE";

----- component IOBUF_HSTL_IV -----
component IOBUF_HSTL_IV
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_IV : component is "PRIMITIVE";

----- component IOBUF_HSTL_IV_18 -----
component IOBUF_HSTL_IV_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_IV_18 : component is "PRIMITIVE";

----- component IOBUF_HSTL_IV_DCI -----
component IOBUF_HSTL_IV_DCI
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_IV_DCI : component is "PRIMITIVE";

----- component IOBUF_HSTL_IV_DCI_18 -----
component IOBUF_HSTL_IV_DCI_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_IV_DCI_18 : component is "PRIMITIVE";

----- component IOBUF_HSTL_I_18 -----
component IOBUF_HSTL_I_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_HSTL_I_18 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12 -----
component IOBUF_LVCMOS12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_F_2 -----
component IOBUF_LVCMOS12_F_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_F_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_F_4 -----
component IOBUF_LVCMOS12_F_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_F_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_F_6 -----
component IOBUF_LVCMOS12_F_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_F_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_F_8 -----
component IOBUF_LVCMOS12_F_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_F_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_S_2 -----
component IOBUF_LVCMOS12_S_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_S_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_S_4 -----
component IOBUF_LVCMOS12_S_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_S_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_S_6 -----
component IOBUF_LVCMOS12_S_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_S_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS12_S_8 -----
component IOBUF_LVCMOS12_S_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS12_S_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15 -----
component IOBUF_LVCMOS15
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_F_12 -----
component IOBUF_LVCMOS15_F_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_F_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_F_16 -----
component IOBUF_LVCMOS15_F_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_F_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_F_2 -----
component IOBUF_LVCMOS15_F_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_F_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_F_4 -----
component IOBUF_LVCMOS15_F_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_F_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_F_6 -----
component IOBUF_LVCMOS15_F_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_F_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_F_8 -----
component IOBUF_LVCMOS15_F_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_F_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_S_12 -----
component IOBUF_LVCMOS15_S_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_S_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_S_16 -----
component IOBUF_LVCMOS15_S_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_S_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_S_2 -----
component IOBUF_LVCMOS15_S_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_S_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_S_4 -----
component IOBUF_LVCMOS15_S_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_S_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_S_6 -----
component IOBUF_LVCMOS15_S_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_S_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS15_S_8 -----
component IOBUF_LVCMOS15_S_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS15_S_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18 -----
component IOBUF_LVCMOS18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_F_12 -----
component IOBUF_LVCMOS18_F_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_F_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_F_16 -----
component IOBUF_LVCMOS18_F_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_F_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_F_2 -----
component IOBUF_LVCMOS18_F_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_F_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_F_4 -----
component IOBUF_LVCMOS18_F_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_F_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_F_6 -----
component IOBUF_LVCMOS18_F_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_F_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_F_8 -----
component IOBUF_LVCMOS18_F_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_F_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_S_12 -----
component IOBUF_LVCMOS18_S_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_S_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_S_16 -----
component IOBUF_LVCMOS18_S_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_S_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_S_2 -----
component IOBUF_LVCMOS18_S_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_S_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_S_4 -----
component IOBUF_LVCMOS18_S_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_S_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_S_6 -----
component IOBUF_LVCMOS18_S_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_S_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS18_S_8 -----
component IOBUF_LVCMOS18_S_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS18_S_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS2 -----
component IOBUF_LVCMOS2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25 -----
component IOBUF_LVCMOS25
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_F_12 -----
component IOBUF_LVCMOS25_F_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_F_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_F_16 -----
component IOBUF_LVCMOS25_F_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_F_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_F_2 -----
component IOBUF_LVCMOS25_F_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_F_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_F_24 -----
component IOBUF_LVCMOS25_F_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_F_24 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_F_4 -----
component IOBUF_LVCMOS25_F_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_F_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_F_6 -----
component IOBUF_LVCMOS25_F_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_F_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_F_8 -----
component IOBUF_LVCMOS25_F_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_F_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_S_12 -----
component IOBUF_LVCMOS25_S_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_S_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_S_16 -----
component IOBUF_LVCMOS25_S_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_S_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_S_2 -----
component IOBUF_LVCMOS25_S_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_S_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_S_24 -----
component IOBUF_LVCMOS25_S_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_S_24 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_S_4 -----
component IOBUF_LVCMOS25_S_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_S_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_S_6 -----
component IOBUF_LVCMOS25_S_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_S_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS25_S_8 -----
component IOBUF_LVCMOS25_S_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS25_S_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33 -----
component IOBUF_LVCMOS33
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_F_12 -----
component IOBUF_LVCMOS33_F_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_F_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_F_16 -----
component IOBUF_LVCMOS33_F_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_F_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_F_2 -----
component IOBUF_LVCMOS33_F_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_F_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_F_24 -----
component IOBUF_LVCMOS33_F_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_F_24 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_F_4 -----
component IOBUF_LVCMOS33_F_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_F_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_F_6 -----
component IOBUF_LVCMOS33_F_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_F_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_F_8 -----
component IOBUF_LVCMOS33_F_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_F_8 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_S_12 -----
component IOBUF_LVCMOS33_S_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_S_12 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_S_16 -----
component IOBUF_LVCMOS33_S_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_S_16 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_S_2 -----
component IOBUF_LVCMOS33_S_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_S_2 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_S_24 -----
component IOBUF_LVCMOS33_S_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_S_24 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_S_4 -----
component IOBUF_LVCMOS33_S_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_S_4 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_S_6 -----
component IOBUF_LVCMOS33_S_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_S_6 : component is "PRIMITIVE";

----- component IOBUF_LVCMOS33_S_8 -----
component IOBUF_LVCMOS33_S_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVCMOS33_S_8 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_15 -----
component IOBUF_LVDCI_15
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_15 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_18 -----
component IOBUF_LVDCI_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_18 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_25 -----
component IOBUF_LVDCI_25
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_25 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_33 -----
component IOBUF_LVDCI_33
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_33 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_DV2_15 -----
component IOBUF_LVDCI_DV2_15
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_DV2_15 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_DV2_18 -----
component IOBUF_LVDCI_DV2_18
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_DV2_18 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_DV2_25 -----
component IOBUF_LVDCI_DV2_25
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_DV2_25 : component is "PRIMITIVE";

----- component IOBUF_LVDCI_DV2_33 -----
component IOBUF_LVDCI_DV2_33
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDCI_DV2_33 : component is "PRIMITIVE";

----- component IOBUF_LVDS -----
component IOBUF_LVDS
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVDS : component is "PRIMITIVE";

----- component IOBUF_LVPECL -----
component IOBUF_LVPECL
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVPECL : component is "PRIMITIVE";

----- component IOBUF_LVTTL -----
component IOBUF_LVTTL
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL : component is "PRIMITIVE";

----- component IOBUF_LVTTL_F_12 -----
component IOBUF_LVTTL_F_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_F_12 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_F_16 -----
component IOBUF_LVTTL_F_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_F_16 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_F_2 -----
component IOBUF_LVTTL_F_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_F_2 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_F_24 -----
component IOBUF_LVTTL_F_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_F_24 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_F_4 -----
component IOBUF_LVTTL_F_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_F_4 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_F_6 -----
component IOBUF_LVTTL_F_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_F_6 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_F_8 -----
component IOBUF_LVTTL_F_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_F_8 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_S_12 -----
component IOBUF_LVTTL_S_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_S_12 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_S_16 -----
component IOBUF_LVTTL_S_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_S_16 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_S_2 -----
component IOBUF_LVTTL_S_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_S_2 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_S_24 -----
component IOBUF_LVTTL_S_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_S_24 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_S_4 -----
component IOBUF_LVTTL_S_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_S_4 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_S_6 -----
component IOBUF_LVTTL_S_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_S_6 : component is "PRIMITIVE";

----- component IOBUF_LVTTL_S_8 -----
component IOBUF_LVTTL_S_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_LVTTL_S_8 : component is "PRIMITIVE";

----- component IOBUF_PCI33_3 -----
component IOBUF_PCI33_3
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_PCI33_3 : component is "PRIMITIVE";

----- component IOBUF_PCI33_5 -----
component IOBUF_PCI33_5
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_PCI33_5 : component is "PRIMITIVE";

----- component IOBUF_PCI66_3 -----
component IOBUF_PCI66_3
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_PCI66_3 : component is "PRIMITIVE";

----- component IOBUF_PCIX -----
component IOBUF_PCIX
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_PCIX : component is "PRIMITIVE";

----- component IOBUF_PCIX66_3 -----
component IOBUF_PCIX66_3
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_PCIX66_3 : component is "PRIMITIVE";

----- component IOBUF_SSTL18_I -----
component IOBUF_SSTL18_I
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL18_I : component is "PRIMITIVE";

----- component IOBUF_SSTL18_II -----
component IOBUF_SSTL18_II
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL18_II : component is "PRIMITIVE";

----- component IOBUF_SSTL18_II_DCI -----
component IOBUF_SSTL18_II_DCI
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL18_II_DCI : component is "PRIMITIVE";

----- component IOBUF_SSTL2_I -----
component IOBUF_SSTL2_I
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL2_I : component is "PRIMITIVE";

----- component IOBUF_SSTL2_II -----
component IOBUF_SSTL2_II
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL2_II : component is "PRIMITIVE";

----- component IOBUF_SSTL2_II_DCI -----
component IOBUF_SSTL2_II_DCI
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL2_II_DCI : component is "PRIMITIVE";

----- component IOBUF_SSTL3_I -----
component IOBUF_SSTL3_I
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL3_I : component is "PRIMITIVE";

----- component IOBUF_SSTL3_II -----
component IOBUF_SSTL3_II
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL3_II : component is "PRIMITIVE";

----- component IOBUF_SSTL3_II_DCI -----
component IOBUF_SSTL3_II_DCI
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_SSTL3_II_DCI : component is "PRIMITIVE";

----- component IOBUF_S_12 -----
component IOBUF_S_12
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_S_12 : component is "PRIMITIVE";

----- component IOBUF_S_16 -----
component IOBUF_S_16
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_S_16 : component is "PRIMITIVE";

----- component IOBUF_S_2 -----
component IOBUF_S_2
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_S_2 : component is "PRIMITIVE";

----- component IOBUF_S_24 -----
component IOBUF_S_24
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_S_24 : component is "PRIMITIVE";

----- component IOBUF_S_4 -----
component IOBUF_S_4
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_S_4 : component is "PRIMITIVE";

----- component IOBUF_S_6 -----
component IOBUF_S_6
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_S_6 : component is "PRIMITIVE";

----- component IOBUF_S_8 -----
component IOBUF_S_8
  port (
     O : out std_ulogic;
     IO : inout std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IOBUF_S_8 : component is "PRIMITIVE";

----- component IODELAY -----
component IODELAY
  generic (
     DELAY_SRC : string := "I";
     HIGH_PERFORMANCE_MODE : boolean := true;
     IDELAY_TYPE : string := "DEFAULT";
     IDELAY_VALUE : integer := 0;
     ODELAY_VALUE : integer := 0;
     REFCLK_FREQUENCY : real := 200.0;
     SIGNAL_PATTERN : string := "DATA"
  );
  port (
     DATAOUT : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     DATAIN : in std_ulogic;
     IDATAIN : in std_ulogic;
     INC : in std_ulogic;
     ODATAIN : in std_ulogic;
     RST : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IODELAY : component is "PRIMITIVE";

----- component IODELAY2 -----
component IODELAY2
  generic (
     COUNTER_WRAPAROUND : string := "WRAPAROUND";
     DATA_RATE : string := "SDR";
     DELAY_SRC : string := "IO";
     IDELAY2_VALUE : integer := 0;
     IDELAY_MODE : string := "NORMAL";
     IDELAY_TYPE : string := "DEFAULT";
     IDELAY_VALUE : integer := 0;
     ODELAY_VALUE : integer := 0;
     SERDES_MODE : string := "NONE";
     SIM_TAPDELAY_VALUE : integer := 75
  );
  port (
     BUSY : out std_ulogic;
     DATAOUT : out std_ulogic;
     DATAOUT2 : out std_ulogic;
     DOUT : out std_ulogic;
     TOUT : out std_ulogic;
     CAL : in std_ulogic;
     CE : in std_ulogic;
     CLK : in std_ulogic;
     IDATAIN : in std_ulogic;
     INC : in std_ulogic;
     IOCLK0 : in std_ulogic;
     IOCLK1 : in std_ulogic;
     ODATAIN : in std_ulogic;
     RST : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IODELAY2 : component is "PRIMITIVE";

----- component IODELAYE1 -----
component IODELAYE1
  generic (
     CINVCTRL_SEL : boolean := FALSE;
     DELAY_SRC : string := "I";
     HIGH_PERFORMANCE_MODE : boolean := FALSE;
     IDELAY_TYPE : string := "DEFAULT";
     IDELAY_VALUE : integer := 0;
     ODELAY_TYPE : string := "FIXED";
     ODELAY_VALUE : integer := 0;
     REFCLK_FREQUENCY : real := 200.0;
     SIGNAL_PATTERN : string := "DATA"
  );
  port (
     CNTVALUEOUT : out std_logic_vector(4 downto 0);
     DATAOUT : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     CINVCTRL : in std_ulogic;
     CLKIN : in std_ulogic;
     CNTVALUEIN : in std_logic_vector(4 downto 0);
     DATAIN : in std_ulogic;
     IDATAIN : in std_ulogic;
     INC : in std_ulogic;
     ODATAIN : in std_ulogic;
     RST : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IODELAYE1 : component is "PRIMITIVE";

----- component IODRP2 -----
component IODRP2
  generic (
     DATA_RATE : string := "SDR";
     SIM_TAPDELAY_VALUE : integer := 75
  );
  port (
     DATAOUT : out std_ulogic;
     DATAOUT2 : out std_ulogic;
     DOUT : out std_ulogic;
     SDO : out std_ulogic;
     TOUT : out std_ulogic;
     ADD : in std_ulogic;
     BKST : in std_ulogic;
     CLK : in std_ulogic;
     CS : in std_ulogic;
     IDATAIN : in std_ulogic;
     IOCLK0 : in std_ulogic;
     IOCLK1 : in std_ulogic;
     ODATAIN : in std_ulogic;
     SDI : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IODRP2 : component is "PRIMITIVE";

----- component IODRP2_MCB -----
component IODRP2_MCB
  generic (
     DATA_RATE : string := "SDR";
     IDELAY_VALUE : integer := 0;
     MCB_ADDRESS : integer := 0;
     ODELAY_VALUE : integer := 0;
     SERDES_MODE : string := "NONE";
     SIM_TAPDELAY_VALUE : integer := 75
  );
  port (
     AUXSDO : out std_ulogic;
     DATAOUT : out std_ulogic;
     DATAOUT2 : out std_ulogic;
     DOUT : out std_ulogic;
     DQSOUTN : out std_ulogic;
     DQSOUTP : out std_ulogic;
     SDO : out std_ulogic;
     TOUT : out std_ulogic;
     ADD : in std_ulogic;
     AUXADDR : in std_logic_vector(4 downto 0);
     AUXSDOIN : in std_ulogic;
     BKST : in std_ulogic;
     CLK : in std_ulogic;
     CS : in std_ulogic;
     IDATAIN : in std_ulogic;
     IOCLK0 : in std_ulogic;
     IOCLK1 : in std_ulogic;
     MEMUPDATE : in std_ulogic;
     ODATAIN : in std_ulogic;
     SDI : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  IODRP2_MCB : component is "PRIMITIVE";

----- component ISERDES -----
component ISERDES
  generic (
     BITSLIP_ENABLE : boolean := false;
     DATA_RATE : string := "DDR";
     DATA_WIDTH : integer := 4;
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     INIT_Q3 : bit := '0';
     INIT_Q4 : bit := '0';
     INTERFACE_TYPE : string := "MEMORY";
     IOBDELAY : string := "NONE";
     IOBDELAY_TYPE : string := "DEFAULT";
     IOBDELAY_VALUE : integer := 0;
     NUM_CE : integer := 2;
     SERDES_MODE : string := "MASTER";
     SRVAL_Q1 : bit := '0';
     SRVAL_Q2 : bit := '0';
     SRVAL_Q3 : bit := '0';
     SRVAL_Q4 : bit := '0'
  );
  port (
     O : out std_ulogic;
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     Q5 : out std_ulogic;
     Q6 : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     BITSLIP : in std_ulogic;
     CE1 : in std_ulogic;
     CE2 : in std_ulogic;
     CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     DLYCE : in std_ulogic;
     DLYINC : in std_ulogic;
     DLYRST : in std_ulogic;
     OCLK : in std_ulogic;
     REV : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     SR : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ISERDES : component is "PRIMITIVE";

----- component ISERDES2 -----
component ISERDES2
  generic (
     BITSLIP_ENABLE : boolean := FALSE;
     DATA_RATE : string := "SDR";
     DATA_WIDTH : integer := 1;
     INTERFACE_TYPE : string := "NETWORKING";
     SERDES_MODE : string := "NONE"
  );
  port (
     CFB0 : out std_ulogic;
     CFB1 : out std_ulogic;
     DFB : out std_ulogic;
     FABRICOUT : out std_ulogic;
     INCDEC : out std_ulogic;
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     SHIFTOUT : out std_ulogic;
     VALID : out std_ulogic;
     BITSLIP : in std_ulogic := 'L';
     CE0 : in std_ulogic := 'H';
     CLK0 : in std_ulogic;
     CLK1 : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     IOCE : in std_ulogic := 'H';
     RST : in std_ulogic := 'L';
     SHIFTIN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ISERDES2 : component is "PRIMITIVE";

----- component ISERDESE1 -----
component ISERDESE1
  generic (
     DATA_RATE : string := "DDR";
     DATA_WIDTH : integer := 4;
     DYN_CLKDIV_INV_EN : boolean := FALSE;
     DYN_CLK_INV_EN : boolean := FALSE;
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     INIT_Q3 : bit := '0';
     INIT_Q4 : bit := '0';
     INTERFACE_TYPE : string := "MEMORY";
     IOBDELAY : string := "NONE";
     NUM_CE : integer := 2;
     OFB_USED : boolean := FALSE;
     SERDES_MODE : string := "MASTER";
     SRVAL_Q1 : bit := '0';
     SRVAL_Q2 : bit := '0';
     SRVAL_Q3 : bit := '0';
     SRVAL_Q4 : bit := '0'
  );
  port (
     O : out std_ulogic;
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     Q5 : out std_ulogic;
     Q6 : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     BITSLIP : in std_ulogic;
     CE1 : in std_ulogic;
     CE2 : in std_ulogic;
     CLK : in std_ulogic;
     CLKB : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     DDLY : in std_ulogic;
     DYNCLKDIVSEL : in std_ulogic;
     DYNCLKSEL : in std_ulogic;
     OCLK : in std_ulogic;
     OFB : in std_ulogic;
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ISERDESE1 : component is "PRIMITIVE";

----- component ISERDES_NODELAY -----
component ISERDES_NODELAY
  generic (
     BITSLIP_ENABLE : boolean := false;
     DATA_RATE : string := "DDR";
     DATA_WIDTH : integer := 4;
     INIT_Q1 : bit := '0';
     INIT_Q2 : bit := '0';
     INIT_Q3 : bit := '0';
     INIT_Q4 : bit := '0';
     INTERFACE_TYPE : string := "MEMORY";
     NUM_CE : integer := 2;
     SERDES_MODE : string := "MASTER"
  );
  port (
     Q1 : out std_ulogic;
     Q2 : out std_ulogic;
     Q3 : out std_ulogic;
     Q4 : out std_ulogic;
     Q5 : out std_ulogic;
     Q6 : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     BITSLIP : in std_ulogic;
     CE1 : in std_ulogic;
     CE2 : in std_ulogic;
     CLK : in std_ulogic;
     CLKB : in std_ulogic;
     CLKDIV : in std_ulogic;
     D : in std_ulogic;
     OCLK : in std_ulogic;
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ISERDES_NODELAY : component is "PRIMITIVE";

----- component JTAGPPC -----
component JTAGPPC
  port (
     TCK : out std_ulogic;
     TDIPPC : out std_ulogic;
     TMS : out std_ulogic;
     TDOPPC : in std_ulogic;
     TDOTSPPC : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  JTAGPPC : component is "PRIMITIVE";

----- component JTAGPPC440 -----
component JTAGPPC440
  port (
     TCK : out std_ulogic;
     TDIPPC : out std_ulogic;
     TMS : out std_ulogic;
     TDOPPC : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  JTAGPPC440 : component is "PRIMITIVE";

----- component JTAG_SIM_SPARTAN3A -----
component JTAG_SIM_SPARTAN3A
  generic (
     PART_NAME : string := "3S200A"
  );
  port (
     TDO : out std_ulogic;
     TCK : in std_ulogic;
     TDI : in std_ulogic;
     TMS : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  JTAG_SIM_SPARTAN3A : component is "PRIMITIVE";

----- component JTAG_SIM_SPARTAN6 -----
component JTAG_SIM_SPARTAN6
  generic (
     PART_NAME : string := "LX4"
  );
  port (
     TDO : out std_ulogic;
     TCK : in std_ulogic;
     TDI : in std_ulogic;
     TMS : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  JTAG_SIM_SPARTAN6 : component is "PRIMITIVE";

----- component JTAG_SIM_VIRTEX4 -----
component JTAG_SIM_VIRTEX4
  generic (
     PART_NAME : string := "LX15"
  );
  port (
     TDO : out std_ulogic;
     TCK : in std_ulogic;
     TDI : in std_ulogic;
     TMS : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  JTAG_SIM_VIRTEX4 : component is "PRIMITIVE";

----- component JTAG_SIM_VIRTEX5 -----
component JTAG_SIM_VIRTEX5
  generic (
     PART_NAME : string := "LX50"
  );
  port (
     TDO : out std_ulogic;
     TCK : in std_ulogic;
     TDI : in std_ulogic;
     TMS : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  JTAG_SIM_VIRTEX5 : component is "PRIMITIVE";

----- component JTAG_SIM_VIRTEX6 -----
component JTAG_SIM_VIRTEX6
  generic (
     PART_NAME : string := "LX75T"
  );
  port (
     TDO : out std_ulogic;
     TCK : in std_ulogic;
     TDI : in std_ulogic;
     TMS : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  JTAG_SIM_VIRTEX6 : component is "PRIMITIVE";

----- component KEEP -----
component KEEP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  KEEP : component is "PRIMITIVE";

----- component KEEPER -----
component KEEPER
  port (
     O : inout std_ulogic := 'W'
  );
end component;
attribute BOX_TYPE of
  KEEPER : component is "PRIMITIVE";

----- component KEY_CLEAR -----
component KEY_CLEAR
  port (
     KEYCLEARB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  KEY_CLEAR : component is "PRIMITIVE";

----- component LD -----
component LD
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic := '0';
     D : in std_ulogic;
     G : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LD : component is "PRIMITIVE";

----- component LDC -----
component LDC
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDC : component is "PRIMITIVE";

----- component LDCE -----
component LDCE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDCE : component is "PRIMITIVE";

----- component LDCE_1 -----
component LDCE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDCE_1 : component is "PRIMITIVE";

----- component LDCP -----
component LDCP
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDCP : component is "PRIMITIVE";

----- component LDCPE -----
component LDCPE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDCPE : component is "PRIMITIVE";

----- component LDCPE_1 -----
component LDCPE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDCPE_1 : component is "PRIMITIVE";

----- component LDCP_1 -----
component LDCP_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDCP_1 : component is "PRIMITIVE";

----- component LDC_1 -----
component LDC_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic;
     CLR : in std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDC_1 : component is "PRIMITIVE";

----- component LDE -----
component LDE
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic := '0';
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDE : component is "PRIMITIVE";

----- component LDE_1 -----
component LDE_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic := '0';
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDE_1 : component is "PRIMITIVE";

----- component LDG -----
component LDG
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out STD_ULOGIC;
     D : in STD_ULOGIC;
     G : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  LDG : component is "PRIMITIVE";

----- component LDP -----
component LDP
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDP : component is "PRIMITIVE";

----- component LDPE -----
component LDPE
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDPE : component is "PRIMITIVE";

----- component LDPE_1 -----
component LDPE_1
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     GE : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDPE_1 : component is "PRIMITIVE";

----- component LDP_1 -----
component LDP_1
  generic (
     INIT : bit := '1'
  );
  port (
     Q : out std_ulogic;
     D : in std_ulogic;
     G : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LDP_1 : component is "PRIMITIVE";

----- component LD_1 -----
component LD_1
  generic (
     INIT : bit := '0'
  );
  port (
     Q : out std_ulogic := '0';
     D : in std_ulogic;
     G : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LD_1 : component is "PRIMITIVE";

----- component LUT1 -----
component LUT1
  generic (
     INIT : bit_vector := X"0"
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT1 : component is "PRIMITIVE";

----- component LUT1_D -----
component LUT1_D
  generic (
     INIT : bit_vector := X"0"
  );
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT1_D : component is "PRIMITIVE";

----- component LUT1_L -----
component LUT1_L
  generic (
     INIT : bit_vector := X"0"
  );
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT1_L : component is "PRIMITIVE";

----- component LUT2 -----
component LUT2
  generic (
     INIT : bit_vector := X"0"
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT2 : component is "PRIMITIVE";

----- component LUT2_D -----
component LUT2_D
  generic (
     INIT : bit_vector := X"0"
  );
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT2_D : component is "PRIMITIVE";

----- component LUT2_L -----
component LUT2_L
  generic (
     INIT : bit_vector := X"0"
  );
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT2_L : component is "PRIMITIVE";

----- component LUT3 -----
component LUT3
  generic (
     INIT : bit_vector := X"00"
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT3 : component is "PRIMITIVE";

----- component LUT3_D -----
component LUT3_D
  generic (
     INIT : bit_vector := X"00"
  );
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT3_D : component is "PRIMITIVE";

----- component LUT3_L -----
component LUT3_L
  generic (
     INIT : bit_vector := X"00"
  );
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT3_L : component is "PRIMITIVE";

----- component LUT4 -----
component LUT4
  generic (
     INIT : bit_vector := X"0000"
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT4 : component is "PRIMITIVE";

----- component LUT4_D -----
component LUT4_D
  generic (
     INIT : bit_vector := X"0000"
  );
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT4_D : component is "PRIMITIVE";

----- component LUT4_L -----
component LUT4_L
  generic (
     INIT : bit_vector := X"0000"
  );
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT4_L : component is "PRIMITIVE";

----- component LUT5 -----
component LUT5
  generic (
     INIT : bit_vector := X"00000000"
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT5 : component is "PRIMITIVE";

----- component LUT5_D -----
component LUT5_D
  generic (
     INIT : bit_vector := X"00000000"
  );
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT5_D : component is "PRIMITIVE";

----- component LUT5_L -----
component LUT5_L
  generic (
     INIT : bit_vector := X"00000000"
  );
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT5_L : component is "PRIMITIVE";

----- component LUT6 -----
component LUT6
  generic (
     INIT : bit_vector := X"0000000000000000"
  );
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT6 : component is "PRIMITIVE";

----- component LUT6_2 -----
component LUT6_2
  generic (
     INIT : bit_vector := X"0000000000000000"
  );
  port (
     O5 : out std_ulogic;
     O6 : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT6_2 : component is "PRIMITIVE";

----- component LUT6_D -----
component LUT6_D
  generic (
     INIT : bit_vector := X"0000000000000000"
  );
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT6_D : component is "PRIMITIVE";

----- component LUT6_L -----
component LUT6_L
  generic (
     INIT : bit_vector := X"0000000000000000"
  );
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  LUT6_L : component is "PRIMITIVE";

----- component MCB -----
component MCB
  generic (
     ARB_NUM_TIME_SLOTS : integer := 12;
     ARB_TIME_SLOT_0 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_1 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_10 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_11 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_2 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_3 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_4 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_5 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_6 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_7 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_8 : bit_vector := "111111111111111111";
     ARB_TIME_SLOT_9 : bit_vector := "111111111111111111";
     CAL_BA : bit_vector := X"0";
     CAL_BYPASS : string := "YES";
     CAL_CA : bit_vector := X"000";
     CAL_CALIBRATION_MODE : string := "NOCALIBRATION";
     CAL_CLK_DIV : integer := 1;
     CAL_DELAY : string := "QUARTER";
     CAL_RA : bit_vector := X"0000";
     MEM_ADDR_ORDER : string := "BANK_ROW_COLUMN";
     MEM_BA_SIZE : integer := 3;
     MEM_BURST_LEN : integer := 8;
     MEM_CAS_LATENCY : integer := 4;
     MEM_CA_SIZE : integer := 11;
     MEM_DDR1_2_ODS : string := "FULL";
     MEM_DDR2_3_HIGH_TEMP_SR : string := "NORMAL";
     MEM_DDR2_3_PA_SR : string := "FULL";
     MEM_DDR2_ADD_LATENCY : integer := 0;
     MEM_DDR2_DIFF_DQS_EN : string := "YES";
     MEM_DDR2_RTT : string := "50OHMS";
     MEM_DDR2_WRT_RECOVERY : integer := 4;
     MEM_DDR3_ADD_LATENCY : string := "OFF";
     MEM_DDR3_AUTO_SR : string := "ENABLED";
     MEM_DDR3_CAS_LATENCY : integer := 7;
     MEM_DDR3_CAS_WR_LATENCY : integer := 5;
     MEM_DDR3_DYN_WRT_ODT : string := "OFF";
     MEM_DDR3_ODS : string := "DIV7";
     MEM_DDR3_RTT : string := "DIV2";
     MEM_DDR3_WRT_RECOVERY : integer := 7;
     MEM_MDDR_ODS : string := "FULL";
     MEM_MOBILE_PA_SR : string := "FULL";
     MEM_MOBILE_TC_SR : integer := 0;
     MEM_RAS_VAL : integer := 0;
     MEM_RA_SIZE : integer := 13;
     MEM_RCD_VAL : integer := 1;
     MEM_REFI_VAL : integer := 0;
     MEM_RFC_VAL : integer := 0;
     MEM_RP_VAL : integer := 0;
     MEM_RTP_VAL : integer := 0;
     MEM_TYPE : string := "DDR3";
     MEM_WIDTH : integer := 4;
     MEM_WR_VAL : integer := 0;
     MEM_WTR_VAL : integer := 3;
     PORT_CONFIG : string := "B32_B32_B32_B32"
  );
  port (
     ADDR : out std_logic_vector(14 downto 0);
     BA : out std_logic_vector(2 downto 0);
     CAS : out std_ulogic;
     CKE : out std_ulogic;
     DQIOWEN0 : out std_ulogic;
     DQON : out std_logic_vector(15 downto 0);
     DQOP : out std_logic_vector(15 downto 0);
     DQSIOWEN90N : out std_ulogic;
     DQSIOWEN90P : out std_ulogic;
     IOIDRPADD : out std_ulogic;
     IOIDRPADDR : out std_logic_vector(4 downto 0);
     IOIDRPBROADCAST : out std_ulogic;
     IOIDRPCLK : out std_ulogic;
     IOIDRPCS : out std_ulogic;
     IOIDRPSDO : out std_ulogic;
     IOIDRPTRAIN : out std_ulogic;
     IOIDRPUPDATE : out std_ulogic;
     LDMN : out std_ulogic;
     LDMP : out std_ulogic;
     ODT : out std_ulogic;
     P0CMDEMPTY : out std_ulogic;
     P0CMDFULL : out std_ulogic;
     P0RDCOUNT : out std_logic_vector(6 downto 0);
     P0RDDATA : out std_logic_vector(31 downto 0);
     P0RDEMPTY : out std_ulogic;
     P0RDERROR : out std_ulogic;
     P0RDFULL : out std_ulogic;
     P0RDOVERFLOW : out std_ulogic;
     P0WRCOUNT : out std_logic_vector(6 downto 0);
     P0WREMPTY : out std_ulogic;
     P0WRERROR : out std_ulogic;
     P0WRFULL : out std_ulogic;
     P0WRUNDERRUN : out std_ulogic;
     P1CMDEMPTY : out std_ulogic;
     P1CMDFULL : out std_ulogic;
     P1RDCOUNT : out std_logic_vector(6 downto 0);
     P1RDDATA : out std_logic_vector(31 downto 0);
     P1RDEMPTY : out std_ulogic;
     P1RDERROR : out std_ulogic;
     P1RDFULL : out std_ulogic;
     P1RDOVERFLOW : out std_ulogic;
     P1WRCOUNT : out std_logic_vector(6 downto 0);
     P1WREMPTY : out std_ulogic;
     P1WRERROR : out std_ulogic;
     P1WRFULL : out std_ulogic;
     P1WRUNDERRUN : out std_ulogic;
     P2CMDEMPTY : out std_ulogic;
     P2CMDFULL : out std_ulogic;
     P2COUNT : out std_logic_vector(6 downto 0);
     P2EMPTY : out std_ulogic;
     P2ERROR : out std_ulogic;
     P2FULL : out std_ulogic;
     P2RDDATA : out std_logic_vector(31 downto 0);
     P2RDOVERFLOW : out std_ulogic;
     P2WRUNDERRUN : out std_ulogic;
     P3CMDEMPTY : out std_ulogic;
     P3CMDFULL : out std_ulogic;
     P3COUNT : out std_logic_vector(6 downto 0);
     P3EMPTY : out std_ulogic;
     P3ERROR : out std_ulogic;
     P3FULL : out std_ulogic;
     P3RDDATA : out std_logic_vector(31 downto 0);
     P3RDOVERFLOW : out std_ulogic;
     P3WRUNDERRUN : out std_ulogic;
     P4CMDEMPTY : out std_ulogic;
     P4CMDFULL : out std_ulogic;
     P4COUNT : out std_logic_vector(6 downto 0);
     P4EMPTY : out std_ulogic;
     P4ERROR : out std_ulogic;
     P4FULL : out std_ulogic;
     P4RDDATA : out std_logic_vector(31 downto 0);
     P4RDOVERFLOW : out std_ulogic;
     P4WRUNDERRUN : out std_ulogic;
     P5CMDEMPTY : out std_ulogic;
     P5CMDFULL : out std_ulogic;
     P5COUNT : out std_logic_vector(6 downto 0);
     P5EMPTY : out std_ulogic;
     P5ERROR : out std_ulogic;
     P5FULL : out std_ulogic;
     P5RDDATA : out std_logic_vector(31 downto 0);
     P5RDOVERFLOW : out std_ulogic;
     P5WRUNDERRUN : out std_ulogic;
     RAS : out std_ulogic;
     RST : out std_ulogic;
     SELFREFRESHMODE : out std_ulogic;
     STATUS : out std_logic_vector(31 downto 0);
     UDMN : out std_ulogic;
     UDMP : out std_ulogic;
     UOCALSTART : out std_ulogic;
     UOCMDREADYIN : out std_ulogic;
     UODATA : out std_logic_vector(7 downto 0);
     UODATAVALID : out std_ulogic;
     UODONECAL : out std_ulogic;
     UOREFRSHFLAG : out std_ulogic;
     UOSDO : out std_ulogic;
     WE : out std_ulogic;
     DQI : in std_logic_vector(15 downto 0);
     DQSIOIN : in std_ulogic;
     DQSIOIP : in std_ulogic;
     IOIDRPSDI : in std_ulogic;
     P0ARBEN : in std_ulogic;
     P0CMDBA : in std_logic_vector(2 downto 0);
     P0CMDBL : in std_logic_vector(5 downto 0);
     P0CMDCA : in std_logic_vector(11 downto 0);
     P0CMDCLK : in std_ulogic;
     P0CMDEN : in std_ulogic;
     P0CMDINSTR : in std_logic_vector(2 downto 0);
     P0CMDRA : in std_logic_vector(14 downto 0);
     P0RDCLK : in std_ulogic;
     P0RDEN : in std_ulogic;
     P0RWRMASK : in std_logic_vector(3 downto 0);
     P0WRCLK : in std_ulogic;
     P0WRDATA : in std_logic_vector(31 downto 0);
     P0WREN : in std_ulogic;
     P1ARBEN : in std_ulogic;
     P1CMDBA : in std_logic_vector(2 downto 0);
     P1CMDBL : in std_logic_vector(5 downto 0);
     P1CMDCA : in std_logic_vector(11 downto 0);
     P1CMDCLK : in std_ulogic;
     P1CMDEN : in std_ulogic;
     P1CMDINSTR : in std_logic_vector(2 downto 0);
     P1CMDRA : in std_logic_vector(14 downto 0);
     P1RDCLK : in std_ulogic;
     P1RDEN : in std_ulogic;
     P1RWRMASK : in std_logic_vector(3 downto 0);
     P1WRCLK : in std_ulogic;
     P1WRDATA : in std_logic_vector(31 downto 0);
     P1WREN : in std_ulogic;
     P2ARBEN : in std_ulogic;
     P2CLK : in std_ulogic;
     P2CMDBA : in std_logic_vector(2 downto 0);
     P2CMDBL : in std_logic_vector(5 downto 0);
     P2CMDCA : in std_logic_vector(11 downto 0);
     P2CMDCLK : in std_ulogic;
     P2CMDEN : in std_ulogic;
     P2CMDINSTR : in std_logic_vector(2 downto 0);
     P2CMDRA : in std_logic_vector(14 downto 0);
     P2EN : in std_ulogic;
     P2WRDATA : in std_logic_vector(31 downto 0);
     P2WRMASK : in std_logic_vector(3 downto 0);
     P3ARBEN : in std_ulogic;
     P3CLK : in std_ulogic;
     P3CMDBA : in std_logic_vector(2 downto 0);
     P3CMDBL : in std_logic_vector(5 downto 0);
     P3CMDCA : in std_logic_vector(11 downto 0);
     P3CMDCLK : in std_ulogic;
     P3CMDEN : in std_ulogic;
     P3CMDINSTR : in std_logic_vector(2 downto 0);
     P3CMDRA : in std_logic_vector(14 downto 0);
     P3EN : in std_ulogic;
     P3WRDATA : in std_logic_vector(31 downto 0);
     P3WRMASK : in std_logic_vector(3 downto 0);
     P4ARBEN : in std_ulogic;
     P4CLK : in std_ulogic;
     P4CMDBA : in std_logic_vector(2 downto 0);
     P4CMDBL : in std_logic_vector(5 downto 0);
     P4CMDCA : in std_logic_vector(11 downto 0);
     P4CMDCLK : in std_ulogic;
     P4CMDEN : in std_ulogic;
     P4CMDINSTR : in std_logic_vector(2 downto 0);
     P4CMDRA : in std_logic_vector(14 downto 0);
     P4EN : in std_ulogic;
     P4WRDATA : in std_logic_vector(31 downto 0);
     P4WRMASK : in std_logic_vector(3 downto 0);
     P5ARBEN : in std_ulogic;
     P5CLK : in std_ulogic;
     P5CMDBA : in std_logic_vector(2 downto 0);
     P5CMDBL : in std_logic_vector(5 downto 0);
     P5CMDCA : in std_logic_vector(11 downto 0);
     P5CMDCLK : in std_ulogic;
     P5CMDEN : in std_ulogic;
     P5CMDINSTR : in std_logic_vector(2 downto 0);
     P5CMDRA : in std_logic_vector(14 downto 0);
     P5EN : in std_ulogic;
     P5WRDATA : in std_logic_vector(31 downto 0);
     P5WRMASK : in std_logic_vector(3 downto 0);
     PLLCE : in std_logic_vector(1 downto 0);
     PLLCLK : in std_logic_vector(1 downto 0);
     PLLLOCK : in std_ulogic;
     RECAL : in std_ulogic;
     SELFREFRESHENTER : in std_ulogic;
     SYSRST : in std_ulogic;
     UDQSIOIN : in std_ulogic;
     UDQSIOIP : in std_ulogic;
     UIADD : in std_ulogic;
     UIADDR : in std_logic_vector(4 downto 0);
     UIBROADCAST : in std_ulogic;
     UICLK : in std_ulogic;
     UICMD : in std_ulogic;
     UICMDEN : in std_ulogic;
     UICMDIN : in std_ulogic;
     UICS : in std_ulogic;
     UIDONECAL : in std_ulogic;
     UIDQCOUNT : in std_logic_vector(3 downto 0);
     UIDQLOWERDEC : in std_ulogic;
     UIDQLOWERINC : in std_ulogic;
     UIDQUPPERDEC : in std_ulogic;
     UIDQUPPERINC : in std_ulogic;
     UIDRPUPDATE : in std_ulogic;
     UILDQSDEC : in std_ulogic;
     UILDQSINC : in std_ulogic;
     UIREAD : in std_ulogic;
     UISDI : in std_ulogic;
     UIUDQSDEC : in std_ulogic;
     UIUDQSINC : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MCB : component is "PRIMITIVE";

----- component MERGE -----
component MERGE
  port (
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MERGE : component is "PRIMITIVE";

----- component MIN_OFF -----
component MIN_OFF
  port (
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MIN_OFF : component is "PRIMITIVE";

----- component MMCM_ADV -----
component MMCM_ADV
  generic (
     BANDWIDTH : string := "OPTIMIZED";
     CLKFBOUT_MULT_F : real := 5.000;
     CLKFBOUT_PHASE : real := 0.000;
     CLKFBOUT_USE_FINE_PS : boolean := FALSE;
     CLKIN1_PERIOD : real := 0.000;
     CLKIN2_PERIOD : real := 0.000;
     CLKOUT0_DIVIDE_F : real := 1.000;
     CLKOUT0_DUTY_CYCLE : real := 0.500;
     CLKOUT0_PHASE : real := 0.000;
     CLKOUT0_USE_FINE_PS : boolean := FALSE;
     CLKOUT1_DIVIDE : integer := 1;
     CLKOUT1_DUTY_CYCLE : real := 0.500;
     CLKOUT1_PHASE : real := 0.000;
     CLKOUT1_USE_FINE_PS : boolean := FALSE;
     CLKOUT2_DIVIDE : integer := 1;
     CLKOUT2_DUTY_CYCLE : real := 0.500;
     CLKOUT2_PHASE : real := 0.000;
     CLKOUT2_USE_FINE_PS : boolean := FALSE;
     CLKOUT3_DIVIDE : integer := 1;
     CLKOUT3_DUTY_CYCLE : real := 0.500;
     CLKOUT3_PHASE : real := 0.000;
     CLKOUT3_USE_FINE_PS : boolean := FALSE;
     CLKOUT4_CASCADE : boolean := FALSE;
     CLKOUT4_DIVIDE : integer := 1;
     CLKOUT4_DUTY_CYCLE : real := 0.500;
     CLKOUT4_PHASE : real := 0.000;
     CLKOUT4_USE_FINE_PS : boolean := FALSE;
     CLKOUT5_DIVIDE : integer := 1;
     CLKOUT5_DUTY_CYCLE : real := 0.500;
     CLKOUT5_PHASE : real := 0.000;
     CLKOUT5_USE_FINE_PS : boolean := FALSE;
     CLKOUT6_DIVIDE : integer := 1;
     CLKOUT6_DUTY_CYCLE : real := 0.500;
     CLKOUT6_PHASE : real := 0.000;
     CLKOUT6_USE_FINE_PS : boolean := FALSE;
     CLOCK_HOLD : boolean := FALSE;
     COMPENSATION : string := "ZHOLD";
     DIVCLK_DIVIDE : integer := 1;
     REF_JITTER1 : real := 0.0;
     REF_JITTER2 : real := 0.0;
     STARTUP_WAIT : boolean := FALSE
  );
  port (
     CLKFBOUT : out std_ulogic := '0';
     CLKFBOUTB : out std_ulogic := '0';
     CLKFBSTOPPED : out std_ulogic := '0';
     CLKINSTOPPED : out std_ulogic := '0';
     CLKOUT0 : out std_ulogic := '0';
     CLKOUT0B : out std_ulogic := '0';
     CLKOUT1 : out std_ulogic := '0';
     CLKOUT1B : out std_ulogic := '0';
     CLKOUT2 : out std_ulogic := '0';
     CLKOUT2B : out std_ulogic := '0';
     CLKOUT3 : out std_ulogic := '0';
     CLKOUT3B : out std_ulogic := '0';
     CLKOUT4 : out std_ulogic := '0';
     CLKOUT5 : out std_ulogic := '0';
     CLKOUT6 : out std_ulogic := '0';
     DO : out std_logic_vector (15 downto 0);
     DRDY : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     PSDONE : out std_ulogic := '0';
     CLKFBIN : in std_ulogic;
     CLKIN1 : in std_ulogic;
     CLKIN2 : in std_ulogic;
     CLKINSEL : in std_ulogic;
     DADDR : in std_logic_vector(6 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     PSCLK : in std_ulogic;
     PSEN : in std_ulogic;
     PSINCDEC : in std_ulogic;
     PWRDWN : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MMCM_ADV : component is "PRIMITIVE";

----- component MMCM_BASE -----
component MMCM_BASE
  generic (
     BANDWIDTH : string := "OPTIMIZED";
     CLKFBOUT_MULT_F : real := 5.000;
     CLKFBOUT_PHASE : real := 0.000;
     CLKIN1_PERIOD : real := 0.000;
     CLKOUT0_DIVIDE_F : real := 1.000;
     CLKOUT0_DUTY_CYCLE : real := 0.500;
     CLKOUT0_PHASE : real := 0.000;
     CLKOUT1_DIVIDE : integer := 1;
     CLKOUT1_DUTY_CYCLE : real := 0.500;
     CLKOUT1_PHASE : real := 0.000;
     CLKOUT2_DIVIDE : integer := 1;
     CLKOUT2_DUTY_CYCLE : real := 0.500;
     CLKOUT2_PHASE : real := 0.000;
     CLKOUT3_DIVIDE : integer := 1;
     CLKOUT3_DUTY_CYCLE : real := 0.500;
     CLKOUT3_PHASE : real := 0.000;
     CLKOUT4_CASCADE : boolean := FALSE;
     CLKOUT4_DIVIDE : integer := 1;
     CLKOUT4_DUTY_CYCLE : real := 0.500;
     CLKOUT4_PHASE : real := 0.000;
     CLKOUT5_DIVIDE : integer := 1;
     CLKOUT5_DUTY_CYCLE : real := 0.500;
     CLKOUT5_PHASE : real := 0.000;
     CLKOUT6_DIVIDE : integer := 1;
     CLKOUT6_DUTY_CYCLE : real := 0.500;
     CLKOUT6_PHASE : real := 0.000;
     CLOCK_HOLD : boolean := FALSE;
     DIVCLK_DIVIDE : integer := 1;
     REF_JITTER1 : real := 0.010;
     STARTUP_WAIT : boolean := FALSE
  );
  port (
     CLKFBOUT : out std_ulogic;
     CLKFBOUTB : out std_ulogic;
     CLKOUT0 : out std_ulogic;
     CLKOUT0B : out std_ulogic;
     CLKOUT1 : out std_ulogic;
     CLKOUT1B : out std_ulogic;
     CLKOUT2 : out std_ulogic;
     CLKOUT2B : out std_ulogic;
     CLKOUT3 : out std_ulogic;
     CLKOUT3B : out std_ulogic;
     CLKOUT4 : out std_ulogic;
     CLKOUT5 : out std_ulogic;
     CLKOUT6 : out std_ulogic;
     LOCKED : out std_ulogic;
     CLKFBIN : in std_ulogic;
     CLKIN1 : in std_ulogic;
     PWRDWN : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MMCM_BASE : component is "PRIMITIVE";

----- component MULT18X18 -----
component MULT18X18
  port (
     P : out std_logic_vector (35 downto 0);
     A : in std_logic_vector (17 downto 0);
     B : in std_logic_vector (17 downto 0)
  );
end component;
attribute BOX_TYPE of
  MULT18X18 : component is "PRIMITIVE";

----- component MULT18X18S -----
component MULT18X18S
  port (
     P : out std_logic_vector (35 downto 0);
     A : in std_logic_vector (17 downto 0);
     B : in std_logic_vector (17 downto 0);
     C : in std_ulogic;
     CE : in std_ulogic;
     R : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MULT18X18S : component is "PRIMITIVE";

----- component MULT18X18SIO -----
component MULT18X18SIO
  generic (
     AREG : integer := 1;
     BREG : integer := 1;
     B_INPUT : string := "DIRECT";
     PREG : integer := 1
  );
  port (
     BCOUT : out std_logic_vector (17 downto 0);
     P : out std_logic_vector (35 downto 0);
     A : in std_logic_vector (17 downto 0);
     B : in std_logic_vector (17 downto 0);
     BCIN : in std_logic_vector (17 downto 0);
     CEA : in std_ulogic;
     CEB : in std_ulogic;
     CEP : in std_ulogic;
     CLK : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     RSTP : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MULT18X18SIO : component is "PRIMITIVE";

----- component MULT_AND -----
component MULT_AND
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MULT_AND : component is "PRIMITIVE";

----- component MUXCY -----
component MUXCY
  port (
     O : out std_ulogic;
     CI : in std_ulogic;
     DI : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXCY : component is "PRIMITIVE";

----- component MUXCY_D -----
component MUXCY_D
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     CI : in std_ulogic;
     DI : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXCY_D : component is "PRIMITIVE";

----- component MUXCY_L -----
component MUXCY_L
  port (
     LO : out std_ulogic;
     CI : in std_ulogic;
     DI : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXCY_L : component is "PRIMITIVE";

----- component MUXF5 -----
component MUXF5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF5 : component is "PRIMITIVE";

----- component MUXF5_D -----
component MUXF5_D
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF5_D : component is "PRIMITIVE";

----- component MUXF5_L -----
component MUXF5_L
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF5_L : component is "PRIMITIVE";

----- component MUXF6 -----
component MUXF6
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF6 : component is "PRIMITIVE";

----- component MUXF6_D -----
component MUXF6_D
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF6_D : component is "PRIMITIVE";

----- component MUXF6_L -----
component MUXF6_L
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF6_L : component is "PRIMITIVE";

----- component MUXF7 -----
component MUXF7
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF7 : component is "PRIMITIVE";

----- component MUXF7_D -----
component MUXF7_D
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF7_D : component is "PRIMITIVE";

----- component MUXF7_L -----
component MUXF7_L
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF7_L : component is "PRIMITIVE";

----- component MUXF8 -----
component MUXF8
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF8 : component is "PRIMITIVE";

----- component MUXF8_D -----
component MUXF8_D
  port (
     LO : out std_ulogic;
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF8_D : component is "PRIMITIVE";

----- component MUXF8_L -----
component MUXF8_L
  port (
     LO : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  MUXF8_L : component is "PRIMITIVE";

----- component NAND2 -----
component NAND2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND2 : component is "PRIMITIVE";

----- component NAND2B1 -----
component NAND2B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND2B1 : component is "PRIMITIVE";

----- component NAND2B2 -----
component NAND2B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND2B2 : component is "PRIMITIVE";

----- component NAND3 -----
component NAND3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND3 : component is "PRIMITIVE";

----- component NAND3B1 -----
component NAND3B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND3B1 : component is "PRIMITIVE";

----- component NAND3B2 -----
component NAND3B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND3B2 : component is "PRIMITIVE";

----- component NAND3B3 -----
component NAND3B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND3B3 : component is "PRIMITIVE";

----- component NAND4 -----
component NAND4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND4 : component is "PRIMITIVE";

----- component NAND4B1 -----
component NAND4B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND4B1 : component is "PRIMITIVE";

----- component NAND4B2 -----
component NAND4B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND4B2 : component is "PRIMITIVE";

----- component NAND4B3 -----
component NAND4B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND4B3 : component is "PRIMITIVE";

----- component NAND4B4 -----
component NAND4B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND4B4 : component is "PRIMITIVE";

----- component NAND5 -----
component NAND5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND5 : component is "PRIMITIVE";

----- component NAND5B1 -----
component NAND5B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND5B1 : component is "PRIMITIVE";

----- component NAND5B2 -----
component NAND5B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND5B2 : component is "PRIMITIVE";

----- component NAND5B3 -----
component NAND5B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND5B3 : component is "PRIMITIVE";

----- component NAND5B4 -----
component NAND5B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND5B4 : component is "PRIMITIVE";

----- component NAND5B5 -----
component NAND5B5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NAND5B5 : component is "PRIMITIVE";

----- component NOR2 -----
component NOR2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NOR2 : component is "PRIMITIVE";

----- component NOR2B1 -----
component NOR2B1
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR2B1 : component is "PRIMITIVE";

----- component NOR2B2 -----
component NOR2B2
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR2B2 : component is "PRIMITIVE";

----- component NOR3 -----
component NOR3
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR3 : component is "PRIMITIVE";

----- component NOR3B1 -----
component NOR3B1
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR3B1 : component is "PRIMITIVE";

----- component NOR3B2 -----
component NOR3B2
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR3B2 : component is "PRIMITIVE";

----- component NOR3B3 -----
component NOR3B3
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR3B3 : component is "PRIMITIVE";

----- component NOR4 -----
component NOR4
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC;
     I3 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR4 : component is "PRIMITIVE";

----- component NOR4B1 -----
component NOR4B1
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC;
     I3 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR4B1 : component is "PRIMITIVE";

----- component NOR4B2 -----
component NOR4B2
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC;
     I3 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR4B2 : component is "PRIMITIVE";

----- component NOR4B3 -----
component NOR4B3
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC;
     I3 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR4B3 : component is "PRIMITIVE";

----- component NOR4B4 -----
component NOR4B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NOR4B4 : component is "PRIMITIVE";

----- component NOR5 -----
component NOR5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NOR5 : component is "PRIMITIVE";

----- component NOR5B1 -----
component NOR5B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NOR5B1 : component is "PRIMITIVE";

----- component NOR5B2 -----
component NOR5B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NOR5B2 : component is "PRIMITIVE";

----- component NOR5B3 -----
component NOR5B3
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC;
     I3 : in STD_ULOGIC;
     I4 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR5B3 : component is "PRIMITIVE";

----- component NOR5B4 -----
component NOR5B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  NOR5B4 : component is "PRIMITIVE";

----- component NOR5B5 -----
component NOR5B5
  port (
     O : out STD_ULOGIC;
     I0 : in STD_ULOGIC;
     I1 : in STD_ULOGIC;
     I2 : in STD_ULOGIC;
     I3 : in STD_ULOGIC;
     I4 : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  NOR5B5 : component is "PRIMITIVE";

----- component OBUF -----
component OBUF
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DRIVE : integer := 12;
     IOSTANDARD : string := "DEFAULT";
     SLEW : string := "SLOW"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF : component is "PRIMITIVE";

----- component OBUFDS -----
component OBUFDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS : component is "PRIMITIVE";

----- component OBUFDS_BLVDS_25 -----
component OBUFDS_BLVDS_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_BLVDS_25 : component is "PRIMITIVE";

----- component OBUFDS_LDT_25 -----
component OBUFDS_LDT_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_LDT_25 : component is "PRIMITIVE";

----- component OBUFDS_LVDSEXT_25 -----
component OBUFDS_LVDSEXT_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_LVDSEXT_25 : component is "PRIMITIVE";

----- component OBUFDS_LVDSEXT_33 -----
component OBUFDS_LVDSEXT_33
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_LVDSEXT_33 : component is "PRIMITIVE";

----- component OBUFDS_LVDS_25 -----
component OBUFDS_LVDS_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_LVDS_25 : component is "PRIMITIVE";

----- component OBUFDS_LVDS_33 -----
component OBUFDS_LVDS_33
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_LVDS_33 : component is "PRIMITIVE";

----- component OBUFDS_LVPECL_25 -----
component OBUFDS_LVPECL_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_LVPECL_25 : component is "PRIMITIVE";

----- component OBUFDS_LVPECL_33 -----
component OBUFDS_LVPECL_33
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_LVPECL_33 : component is "PRIMITIVE";

----- component OBUFDS_ULVDS_25 -----
component OBUFDS_ULVDS_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFDS_ULVDS_25 : component is "PRIMITIVE";

----- component OBUFE -----
component OBUFE
  port (
     O : out std_ulogic;
     E : in std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFE : component is "PRIMITIVE";

----- component OBUFT -----
component OBUFT
  generic (
     CAPACITANCE : string := "DONT_CARE";
     DRIVE : integer := 12;
     IOSTANDARD : string := "DEFAULT";
     SLEW : string := "SLOW"
  );
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT : component is "PRIMITIVE";

----- component OBUFTDS -----
component OBUFTDS
  generic (
     CAPACITANCE : string := "DONT_CARE";
     IOSTANDARD : string := "DEFAULT"
  );
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS : component is "PRIMITIVE";

----- component OBUFTDS_BLVDS_25 -----
component OBUFTDS_BLVDS_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_BLVDS_25 : component is "PRIMITIVE";

----- component OBUFTDS_LDT_25 -----
component OBUFTDS_LDT_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_LDT_25 : component is "PRIMITIVE";

----- component OBUFTDS_LVDSEXT_25 -----
component OBUFTDS_LVDSEXT_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_LVDSEXT_25 : component is "PRIMITIVE";

----- component OBUFTDS_LVDSEXT_33 -----
component OBUFTDS_LVDSEXT_33
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_LVDSEXT_33 : component is "PRIMITIVE";

----- component OBUFTDS_LVDS_25 -----
component OBUFTDS_LVDS_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_LVDS_25 : component is "PRIMITIVE";

----- component OBUFTDS_LVDS_33 -----
component OBUFTDS_LVDS_33
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_LVDS_33 : component is "PRIMITIVE";

----- component OBUFTDS_LVPECL_25 -----
component OBUFTDS_LVPECL_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_LVPECL_25 : component is "PRIMITIVE";

----- component OBUFTDS_LVPECL_33 -----
component OBUFTDS_LVPECL_33
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_LVPECL_33 : component is "PRIMITIVE";

----- component OBUFTDS_ULVDS_25 -----
component OBUFTDS_ULVDS_25
  port (
     O : out std_ulogic;
     OB : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFTDS_ULVDS_25 : component is "PRIMITIVE";

----- component OBUFT_AGP -----
component OBUFT_AGP
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_AGP : component is "PRIMITIVE";

----- component OBUFT_CTT -----
component OBUFT_CTT
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_CTT : component is "PRIMITIVE";

----- component OBUFT_F_12 -----
component OBUFT_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_F_12 : component is "PRIMITIVE";

----- component OBUFT_F_16 -----
component OBUFT_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_F_16 : component is "PRIMITIVE";

----- component OBUFT_F_2 -----
component OBUFT_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_F_2 : component is "PRIMITIVE";

----- component OBUFT_F_24 -----
component OBUFT_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_F_24 : component is "PRIMITIVE";

----- component OBUFT_F_4 -----
component OBUFT_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_F_4 : component is "PRIMITIVE";

----- component OBUFT_F_6 -----
component OBUFT_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_F_6 : component is "PRIMITIVE";

----- component OBUFT_F_8 -----
component OBUFT_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_F_8 : component is "PRIMITIVE";

----- component OBUFT_GTL -----
component OBUFT_GTL
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_GTL : component is "PRIMITIVE";

----- component OBUFT_GTLP -----
component OBUFT_GTLP
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_GTLP : component is "PRIMITIVE";

----- component OBUFT_GTLP_DCI -----
component OBUFT_GTLP_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_GTLP_DCI : component is "PRIMITIVE";

----- component OBUFT_GTL_DCI -----
component OBUFT_GTL_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_GTL_DCI : component is "PRIMITIVE";

----- component OBUFT_HSTL_I -----
component OBUFT_HSTL_I
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_I : component is "PRIMITIVE";

----- component OBUFT_HSTL_II -----
component OBUFT_HSTL_II
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_II : component is "PRIMITIVE";

----- component OBUFT_HSTL_III -----
component OBUFT_HSTL_III
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_III : component is "PRIMITIVE";

----- component OBUFT_HSTL_III_18 -----
component OBUFT_HSTL_III_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_III_18 : component is "PRIMITIVE";

----- component OBUFT_HSTL_III_DCI -----
component OBUFT_HSTL_III_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_III_DCI : component is "PRIMITIVE";

----- component OBUFT_HSTL_III_DCI_18 -----
component OBUFT_HSTL_III_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_III_DCI_18 : component is "PRIMITIVE";

----- component OBUFT_HSTL_II_18 -----
component OBUFT_HSTL_II_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_II_18 : component is "PRIMITIVE";

----- component OBUFT_HSTL_II_DCI -----
component OBUFT_HSTL_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_II_DCI : component is "PRIMITIVE";

----- component OBUFT_HSTL_II_DCI_18 -----
component OBUFT_HSTL_II_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_II_DCI_18 : component is "PRIMITIVE";

----- component OBUFT_HSTL_IV -----
component OBUFT_HSTL_IV
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_IV : component is "PRIMITIVE";

----- component OBUFT_HSTL_IV_18 -----
component OBUFT_HSTL_IV_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_IV_18 : component is "PRIMITIVE";

----- component OBUFT_HSTL_IV_DCI -----
component OBUFT_HSTL_IV_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_IV_DCI : component is "PRIMITIVE";

----- component OBUFT_HSTL_IV_DCI_18 -----
component OBUFT_HSTL_IV_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_IV_DCI_18 : component is "PRIMITIVE";

----- component OBUFT_HSTL_I_18 -----
component OBUFT_HSTL_I_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_I_18 : component is "PRIMITIVE";

----- component OBUFT_HSTL_I_DCI -----
component OBUFT_HSTL_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_I_DCI : component is "PRIMITIVE";

----- component OBUFT_HSTL_I_DCI_18 -----
component OBUFT_HSTL_I_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_HSTL_I_DCI_18 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12 -----
component OBUFT_LVCMOS12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_F_2 -----
component OBUFT_LVCMOS12_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_F_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_F_4 -----
component OBUFT_LVCMOS12_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_F_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_F_6 -----
component OBUFT_LVCMOS12_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_F_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_F_8 -----
component OBUFT_LVCMOS12_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_F_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_S_2 -----
component OBUFT_LVCMOS12_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_S_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_S_4 -----
component OBUFT_LVCMOS12_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_S_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_S_6 -----
component OBUFT_LVCMOS12_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_S_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS12_S_8 -----
component OBUFT_LVCMOS12_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS12_S_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15 -----
component OBUFT_LVCMOS15
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_F_12 -----
component OBUFT_LVCMOS15_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_F_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_F_16 -----
component OBUFT_LVCMOS15_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_F_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_F_2 -----
component OBUFT_LVCMOS15_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_F_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_F_4 -----
component OBUFT_LVCMOS15_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_F_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_F_6 -----
component OBUFT_LVCMOS15_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_F_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_F_8 -----
component OBUFT_LVCMOS15_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_F_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_S_12 -----
component OBUFT_LVCMOS15_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_S_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_S_16 -----
component OBUFT_LVCMOS15_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_S_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_S_2 -----
component OBUFT_LVCMOS15_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_S_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_S_4 -----
component OBUFT_LVCMOS15_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_S_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_S_6 -----
component OBUFT_LVCMOS15_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_S_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS15_S_8 -----
component OBUFT_LVCMOS15_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS15_S_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18 -----
component OBUFT_LVCMOS18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_F_12 -----
component OBUFT_LVCMOS18_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_F_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_F_16 -----
component OBUFT_LVCMOS18_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_F_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_F_2 -----
component OBUFT_LVCMOS18_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_F_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_F_4 -----
component OBUFT_LVCMOS18_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_F_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_F_6 -----
component OBUFT_LVCMOS18_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_F_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_F_8 -----
component OBUFT_LVCMOS18_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_F_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_S_12 -----
component OBUFT_LVCMOS18_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_S_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_S_16 -----
component OBUFT_LVCMOS18_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_S_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_S_2 -----
component OBUFT_LVCMOS18_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_S_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_S_4 -----
component OBUFT_LVCMOS18_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_S_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_S_6 -----
component OBUFT_LVCMOS18_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_S_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS18_S_8 -----
component OBUFT_LVCMOS18_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS18_S_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS2 -----
component OBUFT_LVCMOS2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25 -----
component OBUFT_LVCMOS25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_F_12 -----
component OBUFT_LVCMOS25_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_F_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_F_16 -----
component OBUFT_LVCMOS25_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_F_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_F_2 -----
component OBUFT_LVCMOS25_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_F_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_F_24 -----
component OBUFT_LVCMOS25_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_F_24 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_F_4 -----
component OBUFT_LVCMOS25_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_F_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_F_6 -----
component OBUFT_LVCMOS25_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_F_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_F_8 -----
component OBUFT_LVCMOS25_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_F_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_S_12 -----
component OBUFT_LVCMOS25_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_S_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_S_16 -----
component OBUFT_LVCMOS25_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_S_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_S_2 -----
component OBUFT_LVCMOS25_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_S_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_S_24 -----
component OBUFT_LVCMOS25_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_S_24 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_S_4 -----
component OBUFT_LVCMOS25_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_S_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_S_6 -----
component OBUFT_LVCMOS25_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_S_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS25_S_8 -----
component OBUFT_LVCMOS25_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS25_S_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33 -----
component OBUFT_LVCMOS33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_F_12 -----
component OBUFT_LVCMOS33_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_F_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_F_16 -----
component OBUFT_LVCMOS33_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_F_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_F_2 -----
component OBUFT_LVCMOS33_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_F_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_F_24 -----
component OBUFT_LVCMOS33_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_F_24 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_F_4 -----
component OBUFT_LVCMOS33_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_F_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_F_6 -----
component OBUFT_LVCMOS33_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_F_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_F_8 -----
component OBUFT_LVCMOS33_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_F_8 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_S_12 -----
component OBUFT_LVCMOS33_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_S_12 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_S_16 -----
component OBUFT_LVCMOS33_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_S_16 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_S_2 -----
component OBUFT_LVCMOS33_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_S_2 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_S_24 -----
component OBUFT_LVCMOS33_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_S_24 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_S_4 -----
component OBUFT_LVCMOS33_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_S_4 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_S_6 -----
component OBUFT_LVCMOS33_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_S_6 : component is "PRIMITIVE";

----- component OBUFT_LVCMOS33_S_8 -----
component OBUFT_LVCMOS33_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVCMOS33_S_8 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_15 -----
component OBUFT_LVDCI_15
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_15 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_18 -----
component OBUFT_LVDCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_18 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_25 -----
component OBUFT_LVDCI_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_25 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_33 -----
component OBUFT_LVDCI_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_33 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_DV2_15 -----
component OBUFT_LVDCI_DV2_15
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_DV2_15 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_DV2_18 -----
component OBUFT_LVDCI_DV2_18
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_DV2_18 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_DV2_25 -----
component OBUFT_LVDCI_DV2_25
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_DV2_25 : component is "PRIMITIVE";

----- component OBUFT_LVDCI_DV2_33 -----
component OBUFT_LVDCI_DV2_33
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDCI_DV2_33 : component is "PRIMITIVE";

----- component OBUFT_LVDS -----
component OBUFT_LVDS
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVDS : component is "PRIMITIVE";

----- component OBUFT_LVPECL -----
component OBUFT_LVPECL
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVPECL : component is "PRIMITIVE";

----- component OBUFT_LVTTL -----
component OBUFT_LVTTL
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL : component is "PRIMITIVE";

----- component OBUFT_LVTTL_F_12 -----
component OBUFT_LVTTL_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_F_12 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_F_16 -----
component OBUFT_LVTTL_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_F_16 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_F_2 -----
component OBUFT_LVTTL_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_F_2 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_F_24 -----
component OBUFT_LVTTL_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_F_24 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_F_4 -----
component OBUFT_LVTTL_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_F_4 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_F_6 -----
component OBUFT_LVTTL_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_F_6 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_F_8 -----
component OBUFT_LVTTL_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_F_8 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_S_12 -----
component OBUFT_LVTTL_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_S_12 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_S_16 -----
component OBUFT_LVTTL_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_S_16 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_S_2 -----
component OBUFT_LVTTL_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_S_2 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_S_24 -----
component OBUFT_LVTTL_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_S_24 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_S_4 -----
component OBUFT_LVTTL_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_S_4 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_S_6 -----
component OBUFT_LVTTL_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_S_6 : component is "PRIMITIVE";

----- component OBUFT_LVTTL_S_8 -----
component OBUFT_LVTTL_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_LVTTL_S_8 : component is "PRIMITIVE";

----- component OBUFT_PCI33_3 -----
component OBUFT_PCI33_3
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_PCI33_3 : component is "PRIMITIVE";

----- component OBUFT_PCI33_5 -----
component OBUFT_PCI33_5
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_PCI33_5 : component is "PRIMITIVE";

----- component OBUFT_PCI66_3 -----
component OBUFT_PCI66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_PCI66_3 : component is "PRIMITIVE";

----- component OBUFT_PCIX -----
component OBUFT_PCIX
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_PCIX : component is "PRIMITIVE";

----- component OBUFT_PCIX66_3 -----
component OBUFT_PCIX66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_PCIX66_3 : component is "PRIMITIVE";

----- component OBUFT_SSTL18_I -----
component OBUFT_SSTL18_I
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL18_I : component is "PRIMITIVE";

----- component OBUFT_SSTL18_II -----
component OBUFT_SSTL18_II
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL18_II : component is "PRIMITIVE";

----- component OBUFT_SSTL18_II_DCI -----
component OBUFT_SSTL18_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL18_II_DCI : component is "PRIMITIVE";

----- component OBUFT_SSTL18_I_DCI -----
component OBUFT_SSTL18_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL18_I_DCI : component is "PRIMITIVE";

----- component OBUFT_SSTL2_I -----
component OBUFT_SSTL2_I
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL2_I : component is "PRIMITIVE";

----- component OBUFT_SSTL2_II -----
component OBUFT_SSTL2_II
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL2_II : component is "PRIMITIVE";

----- component OBUFT_SSTL2_II_DCI -----
component OBUFT_SSTL2_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL2_II_DCI : component is "PRIMITIVE";

----- component OBUFT_SSTL2_I_DCI -----
component OBUFT_SSTL2_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL2_I_DCI : component is "PRIMITIVE";

----- component OBUFT_SSTL3_I -----
component OBUFT_SSTL3_I
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL3_I : component is "PRIMITIVE";

----- component OBUFT_SSTL3_II -----
component OBUFT_SSTL3_II
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL3_II : component is "PRIMITIVE";

----- component OBUFT_SSTL3_II_DCI -----
component OBUFT_SSTL3_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL3_II_DCI : component is "PRIMITIVE";

----- component OBUFT_SSTL3_I_DCI -----
component OBUFT_SSTL3_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_SSTL3_I_DCI : component is "PRIMITIVE";

----- component OBUFT_S_12 -----
component OBUFT_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_S_12 : component is "PRIMITIVE";

----- component OBUFT_S_16 -----
component OBUFT_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_S_16 : component is "PRIMITIVE";

----- component OBUFT_S_2 -----
component OBUFT_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_S_2 : component is "PRIMITIVE";

----- component OBUFT_S_24 -----
component OBUFT_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_S_24 : component is "PRIMITIVE";

----- component OBUFT_S_4 -----
component OBUFT_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_S_4 : component is "PRIMITIVE";

----- component OBUFT_S_6 -----
component OBUFT_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_S_6 : component is "PRIMITIVE";

----- component OBUFT_S_8 -----
component OBUFT_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUFT_S_8 : component is "PRIMITIVE";

----- component OBUF_AGP -----
component OBUF_AGP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_AGP : component is "PRIMITIVE";

----- component OBUF_CTT -----
component OBUF_CTT
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_CTT : component is "PRIMITIVE";

----- component OBUF_F_12 -----
component OBUF_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_F_12 : component is "PRIMITIVE";

----- component OBUF_F_16 -----
component OBUF_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_F_16 : component is "PRIMITIVE";

----- component OBUF_F_2 -----
component OBUF_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_F_2 : component is "PRIMITIVE";

----- component OBUF_F_24 -----
component OBUF_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_F_24 : component is "PRIMITIVE";

----- component OBUF_F_4 -----
component OBUF_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_F_4 : component is "PRIMITIVE";

----- component OBUF_F_6 -----
component OBUF_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_F_6 : component is "PRIMITIVE";

----- component OBUF_F_8 -----
component OBUF_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_F_8 : component is "PRIMITIVE";

----- component OBUF_GTL -----
component OBUF_GTL
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_GTL : component is "PRIMITIVE";

----- component OBUF_GTLP -----
component OBUF_GTLP
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_GTLP : component is "PRIMITIVE";

----- component OBUF_GTLP_DCI -----
component OBUF_GTLP_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_GTLP_DCI : component is "PRIMITIVE";

----- component OBUF_GTL_DCI -----
component OBUF_GTL_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_GTL_DCI : component is "PRIMITIVE";

----- component OBUF_HSTL_I -----
component OBUF_HSTL_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_I : component is "PRIMITIVE";

----- component OBUF_HSTL_II -----
component OBUF_HSTL_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_II : component is "PRIMITIVE";

----- component OBUF_HSTL_III -----
component OBUF_HSTL_III
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_III : component is "PRIMITIVE";

----- component OBUF_HSTL_III_18 -----
component OBUF_HSTL_III_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_III_18 : component is "PRIMITIVE";

----- component OBUF_HSTL_III_DCI -----
component OBUF_HSTL_III_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_III_DCI : component is "PRIMITIVE";

----- component OBUF_HSTL_III_DCI_18 -----
component OBUF_HSTL_III_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_III_DCI_18 : component is "PRIMITIVE";

----- component OBUF_HSTL_II_18 -----
component OBUF_HSTL_II_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_II_18 : component is "PRIMITIVE";

----- component OBUF_HSTL_II_DCI -----
component OBUF_HSTL_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_II_DCI : component is "PRIMITIVE";

----- component OBUF_HSTL_II_DCI_18 -----
component OBUF_HSTL_II_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_II_DCI_18 : component is "PRIMITIVE";

----- component OBUF_HSTL_IV -----
component OBUF_HSTL_IV
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_IV : component is "PRIMITIVE";

----- component OBUF_HSTL_IV_18 -----
component OBUF_HSTL_IV_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_IV_18 : component is "PRIMITIVE";

----- component OBUF_HSTL_IV_DCI -----
component OBUF_HSTL_IV_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_IV_DCI : component is "PRIMITIVE";

----- component OBUF_HSTL_IV_DCI_18 -----
component OBUF_HSTL_IV_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_IV_DCI_18 : component is "PRIMITIVE";

----- component OBUF_HSTL_I_18 -----
component OBUF_HSTL_I_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_I_18 : component is "PRIMITIVE";

----- component OBUF_HSTL_I_DCI -----
component OBUF_HSTL_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_I_DCI : component is "PRIMITIVE";

----- component OBUF_HSTL_I_DCI_18 -----
component OBUF_HSTL_I_DCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_HSTL_I_DCI_18 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12 -----
component OBUF_LVCMOS12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_F_2 -----
component OBUF_LVCMOS12_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_F_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_F_4 -----
component OBUF_LVCMOS12_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_F_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_F_6 -----
component OBUF_LVCMOS12_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_F_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_F_8 -----
component OBUF_LVCMOS12_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_F_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_S_2 -----
component OBUF_LVCMOS12_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_S_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_S_4 -----
component OBUF_LVCMOS12_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_S_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_S_6 -----
component OBUF_LVCMOS12_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_S_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS12_S_8 -----
component OBUF_LVCMOS12_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS12_S_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15 -----
component OBUF_LVCMOS15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_F_12 -----
component OBUF_LVCMOS15_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_F_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_F_16 -----
component OBUF_LVCMOS15_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_F_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_F_2 -----
component OBUF_LVCMOS15_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_F_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_F_4 -----
component OBUF_LVCMOS15_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_F_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_F_6 -----
component OBUF_LVCMOS15_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_F_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_F_8 -----
component OBUF_LVCMOS15_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_F_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_S_12 -----
component OBUF_LVCMOS15_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_S_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_S_16 -----
component OBUF_LVCMOS15_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_S_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_S_2 -----
component OBUF_LVCMOS15_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_S_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_S_4 -----
component OBUF_LVCMOS15_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_S_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_S_6 -----
component OBUF_LVCMOS15_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_S_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS15_S_8 -----
component OBUF_LVCMOS15_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS15_S_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18 -----
component OBUF_LVCMOS18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_F_12 -----
component OBUF_LVCMOS18_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_F_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_F_16 -----
component OBUF_LVCMOS18_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_F_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_F_2 -----
component OBUF_LVCMOS18_F_2
  port (
     O : out STD_ULOGIC;
     I : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_F_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_F_4 -----
component OBUF_LVCMOS18_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_F_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_F_6 -----
component OBUF_LVCMOS18_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_F_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_F_8 -----
component OBUF_LVCMOS18_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_F_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_S_12 -----
component OBUF_LVCMOS18_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_S_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_S_16 -----
component OBUF_LVCMOS18_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_S_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_S_2 -----
component OBUF_LVCMOS18_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_S_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_S_4 -----
component OBUF_LVCMOS18_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_S_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_S_6 -----
component OBUF_LVCMOS18_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_S_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS18_S_8 -----
component OBUF_LVCMOS18_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS18_S_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS2 -----
component OBUF_LVCMOS2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25 -----
component OBUF_LVCMOS25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_F_12 -----
component OBUF_LVCMOS25_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_F_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_F_16 -----
component OBUF_LVCMOS25_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_F_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_F_2 -----
component OBUF_LVCMOS25_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_F_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_F_24 -----
component OBUF_LVCMOS25_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_F_24 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_F_4 -----
component OBUF_LVCMOS25_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_F_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_F_6 -----
component OBUF_LVCMOS25_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_F_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_F_8 -----
component OBUF_LVCMOS25_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_F_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_S_12 -----
component OBUF_LVCMOS25_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_S_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_S_16 -----
component OBUF_LVCMOS25_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_S_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_S_2 -----
component OBUF_LVCMOS25_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_S_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_S_24 -----
component OBUF_LVCMOS25_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_S_24 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_S_4 -----
component OBUF_LVCMOS25_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_S_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_S_6 -----
component OBUF_LVCMOS25_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_S_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS25_S_8 -----
component OBUF_LVCMOS25_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS25_S_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33 -----
component OBUF_LVCMOS33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_F_12 -----
component OBUF_LVCMOS33_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_F_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_F_16 -----
component OBUF_LVCMOS33_F_16
  port (
     O : out STD_ULOGIC;
     I : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_F_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_F_2 -----
component OBUF_LVCMOS33_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_F_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_F_24 -----
component OBUF_LVCMOS33_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_F_24 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_F_4 -----
component OBUF_LVCMOS33_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_F_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_F_6 -----
component OBUF_LVCMOS33_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_F_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_F_8 -----
component OBUF_LVCMOS33_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_F_8 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_S_12 -----
component OBUF_LVCMOS33_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_S_12 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_S_16 -----
component OBUF_LVCMOS33_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_S_16 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_S_2 -----
component OBUF_LVCMOS33_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_S_2 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_S_24 -----
component OBUF_LVCMOS33_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_S_24 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_S_4 -----
component OBUF_LVCMOS33_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_S_4 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_S_6 -----
component OBUF_LVCMOS33_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_S_6 : component is "PRIMITIVE";

----- component OBUF_LVCMOS33_S_8 -----
component OBUF_LVCMOS33_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVCMOS33_S_8 : component is "PRIMITIVE";

----- component OBUF_LVDCI_15 -----
component OBUF_LVDCI_15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_15 : component is "PRIMITIVE";

----- component OBUF_LVDCI_18 -----
component OBUF_LVDCI_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_18 : component is "PRIMITIVE";

----- component OBUF_LVDCI_25 -----
component OBUF_LVDCI_25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_25 : component is "PRIMITIVE";

----- component OBUF_LVDCI_33 -----
component OBUF_LVDCI_33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_33 : component is "PRIMITIVE";

----- component OBUF_LVDCI_DV2_15 -----
component OBUF_LVDCI_DV2_15
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_DV2_15 : component is "PRIMITIVE";

----- component OBUF_LVDCI_DV2_18 -----
component OBUF_LVDCI_DV2_18
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_DV2_18 : component is "PRIMITIVE";

----- component OBUF_LVDCI_DV2_25 -----
component OBUF_LVDCI_DV2_25
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_DV2_25 : component is "PRIMITIVE";

----- component OBUF_LVDCI_DV2_33 -----
component OBUF_LVDCI_DV2_33
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDCI_DV2_33 : component is "PRIMITIVE";

----- component OBUF_LVDS -----
component OBUF_LVDS
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVDS : component is "PRIMITIVE";

----- component OBUF_LVPECL -----
component OBUF_LVPECL
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVPECL : component is "PRIMITIVE";

----- component OBUF_LVTTL -----
component OBUF_LVTTL
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL : component is "PRIMITIVE";

----- component OBUF_LVTTL_F_12 -----
component OBUF_LVTTL_F_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_F_12 : component is "PRIMITIVE";

----- component OBUF_LVTTL_F_16 -----
component OBUF_LVTTL_F_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_F_16 : component is "PRIMITIVE";

----- component OBUF_LVTTL_F_2 -----
component OBUF_LVTTL_F_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_F_2 : component is "PRIMITIVE";

----- component OBUF_LVTTL_F_24 -----
component OBUF_LVTTL_F_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_F_24 : component is "PRIMITIVE";

----- component OBUF_LVTTL_F_4 -----
component OBUF_LVTTL_F_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_F_4 : component is "PRIMITIVE";

----- component OBUF_LVTTL_F_6 -----
component OBUF_LVTTL_F_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_F_6 : component is "PRIMITIVE";

----- component OBUF_LVTTL_F_8 -----
component OBUF_LVTTL_F_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_F_8 : component is "PRIMITIVE";

----- component OBUF_LVTTL_S_12 -----
component OBUF_LVTTL_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_S_12 : component is "PRIMITIVE";

----- component OBUF_LVTTL_S_16 -----
component OBUF_LVTTL_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_S_16 : component is "PRIMITIVE";

----- component OBUF_LVTTL_S_2 -----
component OBUF_LVTTL_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_S_2 : component is "PRIMITIVE";

----- component OBUF_LVTTL_S_24 -----
component OBUF_LVTTL_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_S_24 : component is "PRIMITIVE";

----- component OBUF_LVTTL_S_4 -----
component OBUF_LVTTL_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_S_4 : component is "PRIMITIVE";

----- component OBUF_LVTTL_S_6 -----
component OBUF_LVTTL_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_S_6 : component is "PRIMITIVE";

----- component OBUF_LVTTL_S_8 -----
component OBUF_LVTTL_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_LVTTL_S_8 : component is "PRIMITIVE";

----- component OBUF_PCI33_3 -----
component OBUF_PCI33_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_PCI33_3 : component is "PRIMITIVE";

----- component OBUF_PCI33_5 -----
component OBUF_PCI33_5
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_PCI33_5 : component is "PRIMITIVE";

----- component OBUF_PCI66_3 -----
component OBUF_PCI66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_PCI66_3 : component is "PRIMITIVE";

----- component OBUF_PCIX -----
component OBUF_PCIX
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_PCIX : component is "PRIMITIVE";

----- component OBUF_PCIX66_3 -----
component OBUF_PCIX66_3
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_PCIX66_3 : component is "PRIMITIVE";

----- component OBUF_SSTL18_I -----
component OBUF_SSTL18_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL18_I : component is "PRIMITIVE";

----- component OBUF_SSTL18_II -----
component OBUF_SSTL18_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL18_II : component is "PRIMITIVE";

----- component OBUF_SSTL18_II_DCI -----
component OBUF_SSTL18_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL18_II_DCI : component is "PRIMITIVE";

----- component OBUF_SSTL18_I_DCI -----
component OBUF_SSTL18_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL18_I_DCI : component is "PRIMITIVE";

----- component OBUF_SSTL2_I -----
component OBUF_SSTL2_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL2_I : component is "PRIMITIVE";

----- component OBUF_SSTL2_II -----
component OBUF_SSTL2_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL2_II : component is "PRIMITIVE";

----- component OBUF_SSTL2_II_DCI -----
component OBUF_SSTL2_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL2_II_DCI : component is "PRIMITIVE";

----- component OBUF_SSTL2_I_DCI -----
component OBUF_SSTL2_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL2_I_DCI : component is "PRIMITIVE";

----- component OBUF_SSTL3_I -----
component OBUF_SSTL3_I
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL3_I : component is "PRIMITIVE";

----- component OBUF_SSTL3_II -----
component OBUF_SSTL3_II
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL3_II : component is "PRIMITIVE";

----- component OBUF_SSTL3_II_DCI -----
component OBUF_SSTL3_II_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL3_II_DCI : component is "PRIMITIVE";

----- component OBUF_SSTL3_I_DCI -----
component OBUF_SSTL3_I_DCI
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_SSTL3_I_DCI : component is "PRIMITIVE";

----- component OBUF_S_12 -----
component OBUF_S_12
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_S_12 : component is "PRIMITIVE";

----- component OBUF_S_16 -----
component OBUF_S_16
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_S_16 : component is "PRIMITIVE";

----- component OBUF_S_2 -----
component OBUF_S_2
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_S_2 : component is "PRIMITIVE";

----- component OBUF_S_24 -----
component OBUF_S_24
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_S_24 : component is "PRIMITIVE";

----- component OBUF_S_4 -----
component OBUF_S_4
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_S_4 : component is "PRIMITIVE";

----- component OBUF_S_6 -----
component OBUF_S_6
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_S_6 : component is "PRIMITIVE";

----- component OBUF_S_8 -----
component OBUF_S_8
  port (
     O : out std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OBUF_S_8 : component is "PRIMITIVE";

----- component ODDR -----
component ODDR
  generic (
     DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
     INIT : bit := '0';
     SRTYPE : string := "SYNC"
  );
  port (
     Q : out std_ulogic;
     C : in std_ulogic;
     CE : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  ODDR : component is "PRIMITIVE";

----- component ODDR2 -----
component ODDR2
  generic (
     DDR_ALIGNMENT : string := "NONE";
     INIT : bit := '0';
     SRTYPE : string := "SYNC"
  );
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic := 'H';
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     R : in std_ulogic := 'L';
     S : in std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  ODDR2 : component is "PRIMITIVE";

----- component OFDDRCPE -----
component OFDDRCPE
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     PRE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OFDDRCPE : component is "PRIMITIVE";

----- component OFDDRRSE -----
component OFDDRRSE
  port (
     Q : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OFDDRRSE : component is "PRIMITIVE";

----- component OFDDRTCPE -----
component OFDDRTCPE
  port (
     O : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     CLR : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     PRE : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OFDDRTCPE : component is "PRIMITIVE";

----- component OFDDRTRSE -----
component OFDDRTRSE
  port (
     O : out std_ulogic;
     C0 : in std_ulogic;
     C1 : in std_ulogic;
     CE : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     R : in std_ulogic;
     S : in std_ulogic;
     T : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OFDDRTRSE : component is "PRIMITIVE";

----- component OPT_OFF -----
component OPT_OFF
  port (
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OPT_OFF : component is "PRIMITIVE";

----- component OPT_UIM -----
component OPT_UIM
  port (
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OPT_UIM : component is "PRIMITIVE";

----- component OR2 -----
component OR2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR2 : component is "PRIMITIVE";

----- component OR2B1 -----
component OR2B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR2B1 : component is "PRIMITIVE";

----- component OR2B2 -----
component OR2B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR2B2 : component is "PRIMITIVE";

----- component OR2L -----
component OR2L
  port (
     O : out std_ulogic;
     DI : in std_ulogic;
     SRI : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR2L : component is "PRIMITIVE";

----- component OR3 -----
component OR3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR3 : component is "PRIMITIVE";

----- component OR3B1 -----
component OR3B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR3B1 : component is "PRIMITIVE";

----- component OR3B2 -----
component OR3B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR3B2 : component is "PRIMITIVE";

----- component OR3B3 -----
component OR3B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR3B3 : component is "PRIMITIVE";

----- component OR4 -----
component OR4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR4 : component is "PRIMITIVE";

----- component OR4B1 -----
component OR4B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR4B1 : component is "PRIMITIVE";

----- component OR4B2 -----
component OR4B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR4B2 : component is "PRIMITIVE";

----- component OR4B3 -----
component OR4B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR4B3 : component is "PRIMITIVE";

----- component OR4B4 -----
component OR4B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR4B4 : component is "PRIMITIVE";

----- component OR5 -----
component OR5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR5 : component is "PRIMITIVE";

----- component OR5B1 -----
component OR5B1
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR5B1 : component is "PRIMITIVE";

----- component OR5B2 -----
component OR5B2
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR5B2 : component is "PRIMITIVE";

----- component OR5B3 -----
component OR5B3
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR5B3 : component is "PRIMITIVE";

----- component OR5B4 -----
component OR5B4
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR5B4 : component is "PRIMITIVE";

----- component OR5B5 -----
component OR5B5
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR5B5 : component is "PRIMITIVE";

----- component OR6 -----
component OR6
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR6 : component is "PRIMITIVE";

----- component OR7 -----
component OR7
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR7 : component is "PRIMITIVE";

----- component OR8 -----
component OR8
  port (
     O : out std_ulogic;
     I0 : in std_ulogic;
     I1 : in std_ulogic;
     I2 : in std_ulogic;
     I3 : in std_ulogic;
     I4 : in std_ulogic;
     I5 : in std_ulogic;
     I6 : in std_ulogic;
     I7 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OR8 : component is "PRIMITIVE";

----- component ORCY -----
component ORCY
  port (
     O : out std_ulogic;
     CI : in std_ulogic;
     I : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  ORCY : component is "PRIMITIVE";

----- component OSERDES -----
component OSERDES
  generic (
     DATA_RATE_OQ : string := "DDR";
     DATA_RATE_TQ : string := "DDR";
     DATA_WIDTH : integer := 4;
     INIT_OQ : bit := '0';
     INIT_TQ : bit := '0';
     SERDES_MODE : string := "MASTER";
     SRVAL_OQ : bit := '0';
     SRVAL_TQ : bit := '0';
     TRISTATE_WIDTH : integer := 4
  );
  port (
     OQ : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     TQ : out std_ulogic;
     CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     D4 : in std_ulogic;
     D5 : in std_ulogic;
     D6 : in std_ulogic;
     OCE : in std_ulogic;
     REV : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     SR : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     T3 : in std_ulogic;
     T4 : in std_ulogic;
     TCE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OSERDES : component is "PRIMITIVE";

----- component OSERDES2 -----
component OSERDES2
  generic (
     BYPASS_GCLK_FF : boolean := FALSE;
     DATA_RATE_OQ : string := "DDR";
     DATA_RATE_OT : string := "DDR";
     DATA_WIDTH : integer := 2;
     OUTPUT_MODE : string := "SINGLE_ENDED";
     SERDES_MODE : string := "NONE";
     TRAIN_PATTERN : integer := 0
  );
  port (
     OQ : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     SHIFTOUT3 : out std_ulogic;
     SHIFTOUT4 : out std_ulogic;
     TQ : out std_ulogic;
     CLK0 : in std_ulogic;
     CLK1 : in std_ulogic;
     CLKDIV : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     D4 : in std_ulogic;
     IOCE : in std_ulogic := 'H';
     OCE : in std_ulogic := 'H';
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     SHIFTIN3 : in std_ulogic;
     SHIFTIN4 : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     T3 : in std_ulogic;
     T4 : in std_ulogic;
     TCE : in std_ulogic;
     TRAIN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OSERDES2 : component is "PRIMITIVE";

----- component OSERDESE1 -----
component OSERDESE1
  generic (
     DATA_RATE_OQ : string := "DDR";
     DATA_RATE_TQ : string := "DDR";
     DATA_WIDTH : integer := 4;
     DDR3_DATA : integer := 1;
     INIT_OQ : bit := '0';
     INIT_TQ : bit := '0';
     INTERFACE_TYPE : string := "DEFAULT";
     ODELAY_USED : integer := 0;
     SERDES_MODE : string := "MASTER";
     SRVAL_OQ : bit := '0';
     SRVAL_TQ : bit := '0';
     TRISTATE_WIDTH : integer := 4
  );
  port (
     OCBEXTEND : out std_ulogic;
     OFB : out std_ulogic;
     OQ : out std_ulogic;
     SHIFTOUT1 : out std_ulogic;
     SHIFTOUT2 : out std_ulogic;
     TFB : out std_ulogic;
     TQ : out std_ulogic;
     CLK : in std_ulogic;
     CLKDIV : in std_ulogic;
     CLKPERF : in std_ulogic;
     CLKPERFDELAY : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     D4 : in std_ulogic;
     D5 : in std_ulogic;
     D6 : in std_ulogic;
     OCE : in std_ulogic;
     ODV : in std_ulogic;
     RST : in std_ulogic;
     SHIFTIN1 : in std_ulogic;
     SHIFTIN2 : in std_ulogic;
     T1 : in std_ulogic;
     T2 : in std_ulogic;
     T3 : in std_ulogic;
     T4 : in std_ulogic;
     TCE : in std_ulogic;
     WC : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  OSERDESE1 : component is "PRIMITIVE";

----- component PCIE_2_0 -----
component PCIE_2_0
  generic (
     AER_BASE_PTR : bit_vector := X"128";
     AER_CAP_ECRC_CHECK_CAPABLE : boolean := FALSE;
     AER_CAP_ECRC_GEN_CAPABLE : boolean := FALSE;
     AER_CAP_ID : bit_vector := X"1111";
     AER_CAP_INT_MSG_NUM_MSI : bit_vector := X"0A";
     AER_CAP_INT_MSG_NUM_MSIX : bit_vector := X"15";
     AER_CAP_NEXTPTR : bit_vector := X"160";
     AER_CAP_ON : boolean := FALSE;
     AER_CAP_PERMIT_ROOTERR_UPDATE : boolean := TRUE;
     AER_CAP_VERSION : bit_vector := X"1";
     ALLOW_X8_GEN2 : boolean := FALSE;
     BAR0 : bit_vector := X"FFFFFF00";
     BAR1 : bit_vector := X"FFFF0000";
     BAR2 : bit_vector := X"FFFF000C";
     BAR3 : bit_vector := X"FFFFFFFF";
     BAR4 : bit_vector := X"00000000";
     BAR5 : bit_vector := X"00000000";
     CAPABILITIES_PTR : bit_vector := X"40";
     CARDBUS_CIS_POINTER : bit_vector := X"00000000";
     CLASS_CODE : bit_vector := X"000000";
     CMD_INTX_IMPLEMENTED : boolean := TRUE;
     CPL_TIMEOUT_DISABLE_SUPPORTED : boolean := FALSE;
     CPL_TIMEOUT_RANGES_SUPPORTED : bit_vector := X"0";
     CRM_MODULE_RSTS : bit_vector := X"00";
     DEVICE_ID : bit_vector := X"0007";
     DEV_CAP_ENABLE_SLOT_PWR_LIMIT_SCALE : boolean := TRUE;
     DEV_CAP_ENABLE_SLOT_PWR_LIMIT_VALUE : boolean := TRUE;
     DEV_CAP_ENDPOINT_L0S_LATENCY : integer := 0;
     DEV_CAP_ENDPOINT_L1_LATENCY : integer := 0;
     DEV_CAP_EXT_TAG_SUPPORTED : boolean := TRUE;
     DEV_CAP_FUNCTION_LEVEL_RESET_CAPABLE : boolean := FALSE;
     DEV_CAP_MAX_PAYLOAD_SUPPORTED : integer := 2;
     DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT : integer := 0;
     DEV_CAP_ROLE_BASED_ERROR : boolean := TRUE;
     DEV_CAP_RSVD_14_12 : integer := 0;
     DEV_CAP_RSVD_17_16 : integer := 0;
     DEV_CAP_RSVD_31_29 : integer := 0;
     DEV_CONTROL_AUX_POWER_SUPPORTED : boolean := FALSE;
     DISABLE_ASPM_L1_TIMER : boolean := FALSE;
     DISABLE_BAR_FILTERING : boolean := FALSE;
     DISABLE_ID_CHECK : boolean := FALSE;
     DISABLE_LANE_REVERSAL : boolean := FALSE;
     DISABLE_RX_TC_FILTER : boolean := FALSE;
     DISABLE_SCRAMBLING : boolean := FALSE;
     DNSTREAM_LINK_NUM : bit_vector := X"00";
     DSN_BASE_PTR : bit_vector := X"100";
     DSN_CAP_ID : bit_vector := X"0003";
     DSN_CAP_NEXTPTR : bit_vector := X"000";
     DSN_CAP_ON : boolean := TRUE;
     DSN_CAP_VERSION : bit_vector := X"1";
     ENABLE_MSG_ROUTE : bit_vector := X"000";
     ENABLE_RX_TD_ECRC_TRIM : boolean := FALSE;
     ENTER_RVRY_EI_L0 : boolean := TRUE;
     EXIT_LOOPBACK_ON_EI : boolean := TRUE;
     EXPANSION_ROM : bit_vector := X"FFFFF001";
     EXT_CFG_CAP_PTR : bit_vector := X"3F";
     EXT_CFG_XP_CAP_PTR : bit_vector := X"3FF";
     HEADER_TYPE : bit_vector := X"00";
     INFER_EI : bit_vector := X"00";
     INTERRUPT_PIN : bit_vector := X"01";
     IS_SWITCH : boolean := FALSE;
     LAST_CONFIG_DWORD : bit_vector := X"042";
     LINK_CAP_ASPM_SUPPORT : integer := 1;
     LINK_CAP_CLOCK_POWER_MANAGEMENT : boolean := FALSE;
     LINK_CAP_DLL_LINK_ACTIVE_REPORTING_CAP : boolean := FALSE;
     LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN1 : integer := 7;
     LINK_CAP_L0S_EXIT_LATENCY_COMCLK_GEN2 : integer := 7;
     LINK_CAP_L0S_EXIT_LATENCY_GEN1 : integer := 7;
     LINK_CAP_L0S_EXIT_LATENCY_GEN2 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN1 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_COMCLK_GEN2 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_GEN1 : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY_GEN2 : integer := 7;
     LINK_CAP_LINK_BANDWIDTH_NOTIFICATION_CAP : boolean := FALSE;
     LINK_CAP_MAX_LINK_SPEED : bit_vector := X"1";
     LINK_CAP_MAX_LINK_WIDTH : bit_vector := X"08";
     LINK_CAP_RSVD_23_22 : integer := 0;
     LINK_CAP_SURPRISE_DOWN_ERROR_CAPABLE : boolean := FALSE;
     LINK_CONTROL_RCB : integer := 0;
     LINK_CTRL2_DEEMPHASIS : boolean := FALSE;
     LINK_CTRL2_HW_AUTONOMOUS_SPEED_DISABLE : boolean := FALSE;
     LINK_CTRL2_TARGET_LINK_SPEED : bit_vector := X"2";
     LINK_STATUS_SLOT_CLOCK_CONFIG : boolean := TRUE;
     LL_ACK_TIMEOUT : bit_vector := X"0000";
     LL_ACK_TIMEOUT_EN : boolean := FALSE;
     LL_ACK_TIMEOUT_FUNC : integer := 0;
     LL_REPLAY_TIMEOUT : bit_vector := X"0000";
     LL_REPLAY_TIMEOUT_EN : boolean := FALSE;
     LL_REPLAY_TIMEOUT_FUNC : integer := 0;
     LTSSM_MAX_LINK_WIDTH : bit_vector := X"01";
     MSIX_BASE_PTR : bit_vector := X"9C";
     MSIX_CAP_ID : bit_vector := X"11";
     MSIX_CAP_NEXTPTR : bit_vector := X"00";
     MSIX_CAP_ON : boolean := FALSE;
     MSIX_CAP_PBA_BIR : integer := 0;
     MSIX_CAP_PBA_OFFSET : bit_vector := X"00000050";
     MSIX_CAP_TABLE_BIR : integer := 0;
     MSIX_CAP_TABLE_OFFSET : bit_vector := X"00000040";
     MSIX_CAP_TABLE_SIZE : bit_vector := X"000";
     MSI_BASE_PTR : bit_vector := X"48";
     MSI_CAP_64_BIT_ADDR_CAPABLE : boolean := TRUE;
     MSI_CAP_ID : bit_vector := X"05";
     MSI_CAP_MULTIMSGCAP : integer := 0;
     MSI_CAP_MULTIMSG_EXTENSION : integer := 0;
     MSI_CAP_NEXTPTR : bit_vector := X"60";
     MSI_CAP_ON : boolean := FALSE;
     MSI_CAP_PER_VECTOR_MASKING_CAPABLE : boolean := TRUE;
     N_FTS_COMCLK_GEN1 : integer := 255;
     N_FTS_COMCLK_GEN2 : integer := 255;
     N_FTS_GEN1 : integer := 255;
     N_FTS_GEN2 : integer := 255;
     PCIE_BASE_PTR : bit_vector := X"60";
     PCIE_CAP_CAPABILITY_ID : bit_vector := X"10";
     PCIE_CAP_CAPABILITY_VERSION : bit_vector := X"2";
     PCIE_CAP_DEVICE_PORT_TYPE : bit_vector := X"0";
     PCIE_CAP_INT_MSG_NUM : bit_vector := X"00";
     PCIE_CAP_NEXTPTR : bit_vector := X"00";
     PCIE_CAP_ON : boolean := TRUE;
     PCIE_CAP_RSVD_15_14 : integer := 0;
     PCIE_CAP_SLOT_IMPLEMENTED : boolean := FALSE;
     PCIE_REVISION : integer := 2;
     PGL0_LANE : integer := 0;
     PGL1_LANE : integer := 1;
     PGL2_LANE : integer := 2;
     PGL3_LANE : integer := 3;
     PGL4_LANE : integer := 4;
     PGL5_LANE : integer := 5;
     PGL6_LANE : integer := 6;
     PGL7_LANE : integer := 7;
     PL_AUTO_CONFIG : integer := 0;
     PL_FAST_TRAIN : boolean := FALSE;
     PM_BASE_PTR : bit_vector := X"40";
     PM_CAP_AUXCURRENT : integer := 0;
     PM_CAP_D1SUPPORT : boolean := TRUE;
     PM_CAP_D2SUPPORT : boolean := TRUE;
     PM_CAP_DSI : boolean := FALSE;
     PM_CAP_ID : bit_vector := X"11";
     PM_CAP_NEXTPTR : bit_vector := X"48";
     PM_CAP_ON : boolean := TRUE;
     PM_CAP_PMESUPPORT : bit_vector := X"0F";
     PM_CAP_PME_CLOCK : boolean := FALSE;
     PM_CAP_RSVD_04 : integer := 0;
     PM_CAP_VERSION : integer := 3;
     PM_CSR_B2B3 : boolean := FALSE;
     PM_CSR_BPCCEN : boolean := FALSE;
     PM_CSR_NOSOFTRST : boolean := TRUE;
     PM_DATA0 : bit_vector := X"01";
     PM_DATA1 : bit_vector := X"01";
     PM_DATA2 : bit_vector := X"01";
     PM_DATA3 : bit_vector := X"01";
     PM_DATA4 : bit_vector := X"01";
     PM_DATA5 : bit_vector := X"01";
     PM_DATA6 : bit_vector := X"01";
     PM_DATA7 : bit_vector := X"01";
     PM_DATA_SCALE0 : bit_vector := X"1";
     PM_DATA_SCALE1 : bit_vector := X"1";
     PM_DATA_SCALE2 : bit_vector := X"1";
     PM_DATA_SCALE3 : bit_vector := X"1";
     PM_DATA_SCALE4 : bit_vector := X"1";
     PM_DATA_SCALE5 : bit_vector := X"1";
     PM_DATA_SCALE6 : bit_vector := X"1";
     PM_DATA_SCALE7 : bit_vector := X"1";
     RECRC_CHK : integer := 0;
     RECRC_CHK_TRIM : boolean := FALSE;
     REVISION_ID : bit_vector := X"00";
     ROOT_CAP_CRS_SW_VISIBILITY : boolean := FALSE;
     SELECT_DLL_IF : boolean := FALSE;
     SIM_VERSION : string := "1.0";
     SLOT_CAP_ATT_BUTTON_PRESENT : boolean := FALSE;
     SLOT_CAP_ATT_INDICATOR_PRESENT : boolean := FALSE;
     SLOT_CAP_ELEC_INTERLOCK_PRESENT : boolean := FALSE;
     SLOT_CAP_HOTPLUG_CAPABLE : boolean := FALSE;
     SLOT_CAP_HOTPLUG_SURPRISE : boolean := FALSE;
     SLOT_CAP_MRL_SENSOR_PRESENT : boolean := FALSE;
     SLOT_CAP_NO_CMD_COMPLETED_SUPPORT : boolean := FALSE;
     SLOT_CAP_PHYSICAL_SLOT_NUM : bit_vector := X"0000";
     SLOT_CAP_POWER_CONTROLLER_PRESENT : boolean := FALSE;
     SLOT_CAP_POWER_INDICATOR_PRESENT : boolean := FALSE;
     SLOT_CAP_SLOT_POWER_LIMIT_SCALE : integer := 0;
     SLOT_CAP_SLOT_POWER_LIMIT_VALUE : bit_vector := X"00";
     SPARE_BIT0 : integer := 0;
     SPARE_BIT1 : integer := 0;
     SPARE_BIT2 : integer := 0;
     SPARE_BIT3 : integer := 0;
     SPARE_BIT4 : integer := 0;
     SPARE_BIT5 : integer := 0;
     SPARE_BIT6 : integer := 0;
     SPARE_BIT7 : integer := 0;
     SPARE_BIT8 : integer := 0;
     SPARE_BYTE0 : bit_vector := X"00";
     SPARE_BYTE1 : bit_vector := X"00";
     SPARE_BYTE2 : bit_vector := X"00";
     SPARE_BYTE3 : bit_vector := X"00";
     SPARE_WORD0 : bit_vector := X"00000000";
     SPARE_WORD1 : bit_vector := X"00000000";
     SPARE_WORD2 : bit_vector := X"00000000";
     SPARE_WORD3 : bit_vector := X"00000000";
     SUBSYSTEM_ID : bit_vector := X"0007";
     SUBSYSTEM_VENDOR_ID : bit_vector := X"10EE";
     TL_RBYPASS : boolean := FALSE;
     TL_RX_RAM_RADDR_LATENCY : integer := 0;
     TL_RX_RAM_RDATA_LATENCY : integer := 2;
     TL_RX_RAM_WRITE_LATENCY : integer := 0;
     TL_TFC_DISABLE : boolean := FALSE;
     TL_TX_CHECKS_DISABLE : boolean := FALSE;
     TL_TX_RAM_RADDR_LATENCY : integer := 0;
     TL_TX_RAM_RDATA_LATENCY : integer := 2;
     TL_TX_RAM_WRITE_LATENCY : integer := 0;
     UPCONFIG_CAPABLE : boolean := TRUE;
     UPSTREAM_FACING : boolean := TRUE;
     UR_INV_REQ : boolean := TRUE;
     USER_CLK_FREQ : integer := 3;
     VC0_CPL_INFINITE : boolean := TRUE;
     VC0_RX_RAM_LIMIT : bit_vector := X"03FF";
     VC0_TOTAL_CREDITS_CD : integer := 127;
     VC0_TOTAL_CREDITS_CH : integer := 31;
     VC0_TOTAL_CREDITS_NPH : integer := 12;
     VC0_TOTAL_CREDITS_PD : integer := 288;
     VC0_TOTAL_CREDITS_PH : integer := 32;
     VC0_TX_LASTPACKET : integer := 31;
     VC_BASE_PTR : bit_vector := X"10C";
     VC_CAP_ID : bit_vector := X"0002";
     VC_CAP_NEXTPTR : bit_vector := X"000";
     VC_CAP_ON : boolean := FALSE;
     VC_CAP_REJECT_SNOOP_TRANSACTIONS : boolean := FALSE;
     VC_CAP_VERSION : bit_vector := X"1";
     VENDOR_ID : bit_vector := X"10EE";
     VSEC_BASE_PTR : bit_vector := X"160";
     VSEC_CAP_HDR_ID : bit_vector := X"1234";
     VSEC_CAP_HDR_LENGTH : bit_vector := X"018";
     VSEC_CAP_HDR_REVISION : bit_vector := X"1";
     VSEC_CAP_ID : bit_vector := X"000B";
     VSEC_CAP_IS_LINK_VISIBLE : boolean := TRUE;
     VSEC_CAP_NEXTPTR : bit_vector := X"000";
     VSEC_CAP_ON : boolean := FALSE;
     VSEC_CAP_VERSION : bit_vector := X"1"
  );
  port (
     CFGAERECRCCHECKEN : out std_ulogic;
     CFGAERECRCGENEN : out std_ulogic;
     CFGCOMMANDBUSMASTERENABLE : out std_ulogic;
     CFGCOMMANDINTERRUPTDISABLE : out std_ulogic;
     CFGCOMMANDIOENABLE : out std_ulogic;
     CFGCOMMANDMEMENABLE : out std_ulogic;
     CFGCOMMANDSERREN : out std_ulogic;
     CFGDEVCONTROL2CPLTIMEOUTDIS : out std_ulogic;
     CFGDEVCONTROL2CPLTIMEOUTVAL : out std_logic_vector(3 downto 0);
     CFGDEVCONTROLAUXPOWEREN : out std_ulogic;
     CFGDEVCONTROLCORRERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLENABLERO : out std_ulogic;
     CFGDEVCONTROLEXTTAGEN : out std_ulogic;
     CFGDEVCONTROLFATALERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLMAXPAYLOAD : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLMAXREADREQ : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLNONFATALREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLNOSNOOPEN : out std_ulogic;
     CFGDEVCONTROLPHANTOMEN : out std_ulogic;
     CFGDEVCONTROLURERRREPORTINGEN : out std_ulogic;
     CFGDEVSTATUSCORRERRDETECTED : out std_ulogic;
     CFGDEVSTATUSFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSNONFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSURDETECTED : out std_ulogic;
     CFGDO : out std_logic_vector(31 downto 0);
     CFGERRAERHEADERLOGSETN : out std_ulogic;
     CFGERRCPLRDYN : out std_ulogic;
     CFGINTERRUPTDO : out std_logic_vector(7 downto 0);
     CFGINTERRUPTMMENABLE : out std_logic_vector(2 downto 0);
     CFGINTERRUPTMSIENABLE : out std_ulogic;
     CFGINTERRUPTMSIXENABLE : out std_ulogic;
     CFGINTERRUPTMSIXFM : out std_ulogic;
     CFGINTERRUPTRDYN : out std_ulogic;
     CFGLINKCONTROLASPMCONTROL : out std_logic_vector(1 downto 0);
     CFGLINKCONTROLAUTOBANDWIDTHINTEN : out std_ulogic;
     CFGLINKCONTROLBANDWIDTHINTEN : out std_ulogic;
     CFGLINKCONTROLCLOCKPMEN : out std_ulogic;
     CFGLINKCONTROLCOMMONCLOCK : out std_ulogic;
     CFGLINKCONTROLEXTENDEDSYNC : out std_ulogic;
     CFGLINKCONTROLHWAUTOWIDTHDIS : out std_ulogic;
     CFGLINKCONTROLLINKDISABLE : out std_ulogic;
     CFGLINKCONTROLRCB : out std_ulogic;
     CFGLINKCONTROLRETRAINLINK : out std_ulogic;
     CFGLINKSTATUSAUTOBANDWIDTHSTATUS : out std_ulogic;
     CFGLINKSTATUSBANDWITHSTATUS : out std_ulogic;
     CFGLINKSTATUSCURRENTSPEED : out std_logic_vector(1 downto 0);
     CFGLINKSTATUSDLLACTIVE : out std_ulogic;
     CFGLINKSTATUSLINKTRAINING : out std_ulogic;
     CFGLINKSTATUSNEGOTIATEDWIDTH : out std_logic_vector(3 downto 0);
     CFGMSGDATA : out std_logic_vector(15 downto 0);
     CFGMSGRECEIVED : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTA : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTB : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTC : out std_ulogic;
     CFGMSGRECEIVEDASSERTINTD : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTA : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTB : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTC : out std_ulogic;
     CFGMSGRECEIVEDDEASSERTINTD : out std_ulogic;
     CFGMSGRECEIVEDERRCOR : out std_ulogic;
     CFGMSGRECEIVEDERRFATAL : out std_ulogic;
     CFGMSGRECEIVEDERRNONFATAL : out std_ulogic;
     CFGMSGRECEIVEDPMASNAK : out std_ulogic;
     CFGMSGRECEIVEDPMETO : out std_ulogic;
     CFGMSGRECEIVEDPMETOACK : out std_ulogic;
     CFGMSGRECEIVEDPMPME : out std_ulogic;
     CFGMSGRECEIVEDSETSLOTPOWERLIMIT : out std_ulogic;
     CFGMSGRECEIVEDUNLOCK : out std_ulogic;
     CFGPCIELINKSTATE : out std_logic_vector(2 downto 0);
     CFGPMCSRPMEEN : out std_ulogic;
     CFGPMCSRPMESTATUS : out std_ulogic;
     CFGPMCSRPOWERSTATE : out std_logic_vector(1 downto 0);
     CFGPMRCVASREQL1N : out std_ulogic;
     CFGPMRCVENTERL1N : out std_ulogic;
     CFGPMRCVENTERL23N : out std_ulogic;
     CFGPMRCVREQACKN : out std_ulogic;
     CFGRDWRDONEN : out std_ulogic;
     CFGSLOTCONTROLELECTROMECHILCTLPULSE : out std_ulogic;
     CFGTRANSACTION : out std_ulogic;
     CFGTRANSACTIONADDR : out std_logic_vector(6 downto 0);
     CFGTRANSACTIONTYPE : out std_ulogic;
     CFGVCTCVCMAP : out std_logic_vector(6 downto 0);
     DBGSCLRA : out std_ulogic;
     DBGSCLRB : out std_ulogic;
     DBGSCLRC : out std_ulogic;
     DBGSCLRD : out std_ulogic;
     DBGSCLRE : out std_ulogic;
     DBGSCLRF : out std_ulogic;
     DBGSCLRG : out std_ulogic;
     DBGSCLRH : out std_ulogic;
     DBGSCLRI : out std_ulogic;
     DBGSCLRJ : out std_ulogic;
     DBGSCLRK : out std_ulogic;
     DBGVECA : out std_logic_vector(63 downto 0);
     DBGVECB : out std_logic_vector(63 downto 0);
     DBGVECC : out std_logic_vector(11 downto 0);
     DRPDO : out std_logic_vector(15 downto 0);
     DRPDRDY : out std_ulogic;
     LL2BADDLLPERRN : out std_ulogic;
     LL2BADTLPERRN : out std_ulogic;
     LL2PROTOCOLERRN : out std_ulogic;
     LL2REPLAYROERRN : out std_ulogic;
     LL2REPLAYTOERRN : out std_ulogic;
     LL2SUSPENDOKN : out std_ulogic;
     LL2TFCINIT1SEQN : out std_ulogic;
     LL2TFCINIT2SEQN : out std_ulogic;
     LNKCLKEN : out std_ulogic;
     MIMRXRADDR : out std_logic_vector(12 downto 0);
     MIMRXRCE : out std_ulogic;
     MIMRXREN : out std_ulogic;
     MIMRXWADDR : out std_logic_vector(12 downto 0);
     MIMRXWDATA : out std_logic_vector(67 downto 0);
     MIMRXWEN : out std_ulogic;
     MIMTXRADDR : out std_logic_vector(12 downto 0);
     MIMTXRCE : out std_ulogic;
     MIMTXREN : out std_ulogic;
     MIMTXWADDR : out std_logic_vector(12 downto 0);
     MIMTXWDATA : out std_logic_vector(68 downto 0);
     MIMTXWEN : out std_ulogic;
     PIPERX0POLARITY : out std_ulogic;
     PIPERX1POLARITY : out std_ulogic;
     PIPERX2POLARITY : out std_ulogic;
     PIPERX3POLARITY : out std_ulogic;
     PIPERX4POLARITY : out std_ulogic;
     PIPERX5POLARITY : out std_ulogic;
     PIPERX6POLARITY : out std_ulogic;
     PIPERX7POLARITY : out std_ulogic;
     PIPETX0CHARISK : out std_logic_vector(1 downto 0);
     PIPETX0COMPLIANCE : out std_ulogic;
     PIPETX0DATA : out std_logic_vector(15 downto 0);
     PIPETX0ELECIDLE : out std_ulogic;
     PIPETX0POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX1CHARISK : out std_logic_vector(1 downto 0);
     PIPETX1COMPLIANCE : out std_ulogic;
     PIPETX1DATA : out std_logic_vector(15 downto 0);
     PIPETX1ELECIDLE : out std_ulogic;
     PIPETX1POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX2CHARISK : out std_logic_vector(1 downto 0);
     PIPETX2COMPLIANCE : out std_ulogic;
     PIPETX2DATA : out std_logic_vector(15 downto 0);
     PIPETX2ELECIDLE : out std_ulogic;
     PIPETX2POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX3CHARISK : out std_logic_vector(1 downto 0);
     PIPETX3COMPLIANCE : out std_ulogic;
     PIPETX3DATA : out std_logic_vector(15 downto 0);
     PIPETX3ELECIDLE : out std_ulogic;
     PIPETX3POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX4CHARISK : out std_logic_vector(1 downto 0);
     PIPETX4COMPLIANCE : out std_ulogic;
     PIPETX4DATA : out std_logic_vector(15 downto 0);
     PIPETX4ELECIDLE : out std_ulogic;
     PIPETX4POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX5CHARISK : out std_logic_vector(1 downto 0);
     PIPETX5COMPLIANCE : out std_ulogic;
     PIPETX5DATA : out std_logic_vector(15 downto 0);
     PIPETX5ELECIDLE : out std_ulogic;
     PIPETX5POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX6CHARISK : out std_logic_vector(1 downto 0);
     PIPETX6COMPLIANCE : out std_ulogic;
     PIPETX6DATA : out std_logic_vector(15 downto 0);
     PIPETX6ELECIDLE : out std_ulogic;
     PIPETX6POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETX7CHARISK : out std_logic_vector(1 downto 0);
     PIPETX7COMPLIANCE : out std_ulogic;
     PIPETX7DATA : out std_logic_vector(15 downto 0);
     PIPETX7ELECIDLE : out std_ulogic;
     PIPETX7POWERDOWN : out std_logic_vector(1 downto 0);
     PIPETXDEEMPH : out std_ulogic;
     PIPETXMARGIN : out std_logic_vector(2 downto 0);
     PIPETXRATE : out std_ulogic;
     PIPETXRCVRDET : out std_ulogic;
     PIPETXRESET : out std_ulogic;
     PL2LINKUPN : out std_ulogic;
     PL2RECEIVERERRN : out std_ulogic;
     PL2RECOVERYN : out std_ulogic;
     PL2RXELECIDLE : out std_ulogic;
     PL2SUSPENDOK : out std_ulogic;
     PLDBGVEC : out std_logic_vector(11 downto 0);
     PLINITIALLINKWIDTH : out std_logic_vector(2 downto 0);
     PLLANEREVERSALMODE : out std_logic_vector(1 downto 0);
     PLLINKGEN2CAP : out std_ulogic;
     PLLINKPARTNERGEN2SUPPORTED : out std_ulogic;
     PLLINKUPCFGCAP : out std_ulogic;
     PLLTSSMSTATE : out std_logic_vector(5 downto 0);
     PLPHYLNKUPN : out std_ulogic;
     PLRECEIVEDHOTRST : out std_ulogic;
     PLRXPMSTATE : out std_logic_vector(1 downto 0);
     PLSELLNKRATE : out std_ulogic;
     PLSELLNKWIDTH : out std_logic_vector(1 downto 0);
     PLTXPMSTATE : out std_logic_vector(2 downto 0);
     RECEIVEDFUNCLVLRSTN : out std_ulogic;
     TL2ASPMSUSPENDCREDITCHECKOKN : out std_ulogic;
     TL2ASPMSUSPENDREQN : out std_ulogic;
     TL2PPMSUSPENDOKN : out std_ulogic;
     TRNFCCPLD : out std_logic_vector(11 downto 0);
     TRNFCCPLH : out std_logic_vector(7 downto 0);
     TRNFCNPD : out std_logic_vector(11 downto 0);
     TRNFCNPH : out std_logic_vector(7 downto 0);
     TRNFCPD : out std_logic_vector(11 downto 0);
     TRNFCPH : out std_logic_vector(7 downto 0);
     TRNLNKUPN : out std_ulogic;
     TRNRBARHITN : out std_logic_vector(6 downto 0);
     TRNRD : out std_logic_vector(63 downto 0);
     TRNRDLLPDATA : out std_logic_vector(31 downto 0);
     TRNRDLLPSRCRDYN : out std_ulogic;
     TRNRECRCERRN : out std_ulogic;
     TRNREOFN : out std_ulogic;
     TRNRERRFWDN : out std_ulogic;
     TRNRREMN : out std_ulogic;
     TRNRSOFN : out std_ulogic;
     TRNRSRCDSCN : out std_ulogic;
     TRNRSRCRDYN : out std_ulogic;
     TRNTBUFAV : out std_logic_vector(5 downto 0);
     TRNTCFGREQN : out std_ulogic;
     TRNTDLLPDSTRDYN : out std_ulogic;
     TRNTDSTRDYN : out std_ulogic;
     TRNTERRDROPN : out std_ulogic;
     USERRSTN : out std_ulogic;
     CFGBYTEENN : in std_logic_vector(3 downto 0);
     CFGDI : in std_logic_vector(31 downto 0);
     CFGDSBUSNUMBER : in std_logic_vector(7 downto 0);
     CFGDSDEVICENUMBER : in std_logic_vector(4 downto 0);
     CFGDSFUNCTIONNUMBER : in std_logic_vector(2 downto 0);
     CFGDSN : in std_logic_vector(63 downto 0);
     CFGDWADDR : in std_logic_vector(9 downto 0);
     CFGERRACSN : in std_ulogic;
     CFGERRAERHEADERLOG : in std_logic_vector(127 downto 0);
     CFGERRCORN : in std_ulogic;
     CFGERRCPLABORTN : in std_ulogic;
     CFGERRCPLTIMEOUTN : in std_ulogic;
     CFGERRCPLUNEXPECTN : in std_ulogic;
     CFGERRECRCN : in std_ulogic;
     CFGERRLOCKEDN : in std_ulogic;
     CFGERRPOSTEDN : in std_ulogic;
     CFGERRTLPCPLHEADER : in std_logic_vector(47 downto 0);
     CFGERRURN : in std_ulogic;
     CFGINTERRUPTASSERTN : in std_ulogic;
     CFGINTERRUPTDI : in std_logic_vector(7 downto 0);
     CFGINTERRUPTN : in std_ulogic;
     CFGPMDIRECTASPML1N : in std_ulogic;
     CFGPMSENDPMACKN : in std_ulogic;
     CFGPMSENDPMETON : in std_ulogic;
     CFGPMSENDPMNAKN : in std_ulogic;
     CFGPMTURNOFFOKN : in std_ulogic;
     CFGPMWAKEN : in std_ulogic;
     CFGPORTNUMBER : in std_logic_vector(7 downto 0);
     CFGRDENN : in std_ulogic;
     CFGTRNPENDINGN : in std_ulogic;
     CFGWRENN : in std_ulogic;
     CFGWRREADONLYN : in std_ulogic;
     CFGWRRW1CASRWN : in std_ulogic;
     CMRSTN : in std_ulogic;
     CMSTICKYRSTN : in std_ulogic;
     DBGMODE : in std_logic_vector(1 downto 0);
     DBGSUBMODE : in std_ulogic;
     DLRSTN : in std_ulogic;
     DRPCLK : in std_ulogic;
     DRPDADDR : in std_logic_vector(8 downto 0);
     DRPDEN : in std_ulogic;
     DRPDI : in std_logic_vector(15 downto 0);
     DRPDWE : in std_ulogic;
     FUNCLVLRSTN : in std_ulogic;
     LL2SENDASREQL1N : in std_ulogic;
     LL2SENDENTERL1N : in std_ulogic;
     LL2SENDENTERL23N : in std_ulogic;
     LL2SUSPENDNOWN : in std_ulogic;
     LL2TLPRCVN : in std_ulogic;
     MIMRXRDATA : in std_logic_vector(67 downto 0);
     MIMTXRDATA : in std_logic_vector(68 downto 0);
     PIPECLK : in std_ulogic;
     PIPERX0CHANISALIGNED : in std_ulogic;
     PIPERX0CHARISK : in std_logic_vector(1 downto 0);
     PIPERX0DATA : in std_logic_vector(15 downto 0);
     PIPERX0ELECIDLE : in std_ulogic;
     PIPERX0PHYSTATUS : in std_ulogic;
     PIPERX0STATUS : in std_logic_vector(2 downto 0);
     PIPERX0VALID : in std_ulogic;
     PIPERX1CHANISALIGNED : in std_ulogic;
     PIPERX1CHARISK : in std_logic_vector(1 downto 0);
     PIPERX1DATA : in std_logic_vector(15 downto 0);
     PIPERX1ELECIDLE : in std_ulogic;
     PIPERX1PHYSTATUS : in std_ulogic;
     PIPERX1STATUS : in std_logic_vector(2 downto 0);
     PIPERX1VALID : in std_ulogic;
     PIPERX2CHANISALIGNED : in std_ulogic;
     PIPERX2CHARISK : in std_logic_vector(1 downto 0);
     PIPERX2DATA : in std_logic_vector(15 downto 0);
     PIPERX2ELECIDLE : in std_ulogic;
     PIPERX2PHYSTATUS : in std_ulogic;
     PIPERX2STATUS : in std_logic_vector(2 downto 0);
     PIPERX2VALID : in std_ulogic;
     PIPERX3CHANISALIGNED : in std_ulogic;
     PIPERX3CHARISK : in std_logic_vector(1 downto 0);
     PIPERX3DATA : in std_logic_vector(15 downto 0);
     PIPERX3ELECIDLE : in std_ulogic;
     PIPERX3PHYSTATUS : in std_ulogic;
     PIPERX3STATUS : in std_logic_vector(2 downto 0);
     PIPERX3VALID : in std_ulogic;
     PIPERX4CHANISALIGNED : in std_ulogic;
     PIPERX4CHARISK : in std_logic_vector(1 downto 0);
     PIPERX4DATA : in std_logic_vector(15 downto 0);
     PIPERX4ELECIDLE : in std_ulogic;
     PIPERX4PHYSTATUS : in std_ulogic;
     PIPERX4STATUS : in std_logic_vector(2 downto 0);
     PIPERX4VALID : in std_ulogic;
     PIPERX5CHANISALIGNED : in std_ulogic;
     PIPERX5CHARISK : in std_logic_vector(1 downto 0);
     PIPERX5DATA : in std_logic_vector(15 downto 0);
     PIPERX5ELECIDLE : in std_ulogic;
     PIPERX5PHYSTATUS : in std_ulogic;
     PIPERX5STATUS : in std_logic_vector(2 downto 0);
     PIPERX5VALID : in std_ulogic;
     PIPERX6CHANISALIGNED : in std_ulogic;
     PIPERX6CHARISK : in std_logic_vector(1 downto 0);
     PIPERX6DATA : in std_logic_vector(15 downto 0);
     PIPERX6ELECIDLE : in std_ulogic;
     PIPERX6PHYSTATUS : in std_ulogic;
     PIPERX6STATUS : in std_logic_vector(2 downto 0);
     PIPERX6VALID : in std_ulogic;
     PIPERX7CHANISALIGNED : in std_ulogic;
     PIPERX7CHARISK : in std_logic_vector(1 downto 0);
     PIPERX7DATA : in std_logic_vector(15 downto 0);
     PIPERX7ELECIDLE : in std_ulogic;
     PIPERX7PHYSTATUS : in std_ulogic;
     PIPERX7STATUS : in std_logic_vector(2 downto 0);
     PIPERX7VALID : in std_ulogic;
     PL2DIRECTEDLSTATE : in std_logic_vector(4 downto 0);
     PLDBGMODE : in std_logic_vector(2 downto 0);
     PLDIRECTEDLINKAUTON : in std_ulogic;
     PLDIRECTEDLINKCHANGE : in std_logic_vector(1 downto 0);
     PLDIRECTEDLINKSPEED : in std_ulogic;
     PLDIRECTEDLINKWIDTH : in std_logic_vector(1 downto 0);
     PLDOWNSTREAMDEEMPHSOURCE : in std_ulogic;
     PLRSTN : in std_ulogic;
     PLTRANSMITHOTRST : in std_ulogic;
     PLUPSTREAMPREFERDEEMPH : in std_ulogic;
     SYSRSTN : in std_ulogic;
     TL2ASPMSUSPENDCREDITCHECKN : in std_ulogic;
     TL2PPMSUSPENDREQN : in std_ulogic;
     TLRSTN : in std_ulogic;
     TRNFCSEL : in std_logic_vector(2 downto 0);
     TRNRDSTRDYN : in std_ulogic;
     TRNRNPOKN : in std_ulogic;
     TRNTCFGGNTN : in std_ulogic;
     TRNTD : in std_logic_vector(63 downto 0);
     TRNTDLLPDATA : in std_logic_vector(31 downto 0);
     TRNTDLLPSRCRDYN : in std_ulogic;
     TRNTECRCGENN : in std_ulogic;
     TRNTEOFN : in std_ulogic;
     TRNTERRFWDN : in std_ulogic;
     TRNTREMN : in std_ulogic;
     TRNTSOFN : in std_ulogic;
     TRNTSRCDSCN : in std_ulogic;
     TRNTSRCRDYN : in std_ulogic;
     TRNTSTRN : in std_ulogic;
     USERCLK : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PCIE_2_0 : component is "PRIMITIVE";

----- component PCIE_A1 -----
component PCIE_A1
  generic (
     BAR0 : bit_vector := X"00000000";
     BAR1 : bit_vector := X"00000000";
     BAR2 : bit_vector := X"00000000";
     BAR3 : bit_vector := X"00000000";
     BAR4 : bit_vector := X"00000000";
     BAR5 : bit_vector := X"00000000";
     CARDBUS_CIS_POINTER : bit_vector := X"00000000";
     CLASS_CODE : bit_vector := X"000000";
     DEV_CAP_ENDPOINT_L0S_LATENCY : integer := 7;
     DEV_CAP_ENDPOINT_L1_LATENCY : integer := 7;
     DEV_CAP_EXT_TAG_SUPPORTED : boolean := FALSE;
     DEV_CAP_MAX_PAYLOAD_SUPPORTED : integer := 2;
     DEV_CAP_PHANTOM_FUNCTIONS_SUPPORT : integer := 0;
     DEV_CAP_ROLE_BASED_ERROR : boolean := TRUE;
     DISABLE_BAR_FILTERING : boolean := FALSE;
     DISABLE_ID_CHECK : boolean := FALSE;
     DISABLE_SCRAMBLING : boolean := FALSE;
     ENABLE_RX_TD_ECRC_TRIM : boolean := FALSE;
     EXPANSION_ROM : bit_vector := X"000000";
     FAST_TRAIN : boolean := FALSE;
     GTP_SEL : integer := 0;
     LINK_CAP_ASPM_SUPPORT : integer := 1;
     LINK_CAP_L0S_EXIT_LATENCY : integer := 7;
     LINK_CAP_L1_EXIT_LATENCY : integer := 7;
     LINK_STATUS_SLOT_CLOCK_CONFIG : boolean := FALSE;
     LL_ACK_TIMEOUT : bit_vector := X"0204";
     LL_ACK_TIMEOUT_EN : boolean := FALSE;
     LL_REPLAY_TIMEOUT : bit_vector := X"060D";
     LL_REPLAY_TIMEOUT_EN : boolean := FALSE;
     MSI_CAP_MULTIMSGCAP : integer := 0;
     MSI_CAP_MULTIMSG_EXTENSION : integer := 0;
     PCIE_CAP_CAPABILITY_VERSION : bit_vector := X"1";
     PCIE_CAP_DEVICE_PORT_TYPE : bit_vector := X"0";
     PCIE_CAP_INT_MSG_NUM : bit_vector := "00000";
     PCIE_CAP_SLOT_IMPLEMENTED : boolean := FALSE;
     PCIE_GENERIC : bit_vector := X"000";
     PLM_AUTO_CONFIG : boolean := FALSE;
     PM_CAP_AUXCURRENT : integer := 0;
     PM_CAP_D1SUPPORT : boolean := TRUE;
     PM_CAP_D2SUPPORT : boolean := TRUE;
     PM_CAP_DSI : boolean := FALSE;
     PM_CAP_PMESUPPORT : bit_vector := "01111";
     PM_CAP_PME_CLOCK : boolean := FALSE;
     PM_CAP_VERSION : integer := 3;
     PM_DATA0 : bit_vector := X"1E";
     PM_DATA1 : bit_vector := X"1E";
     PM_DATA2 : bit_vector := X"1E";
     PM_DATA3 : bit_vector := X"1E";
     PM_DATA4 : bit_vector := X"1E";
     PM_DATA5 : bit_vector := X"1E";
     PM_DATA6 : bit_vector := X"1E";
     PM_DATA7 : bit_vector := X"1E";
     PM_DATA_SCALE0 : bit_vector := "01";
     PM_DATA_SCALE1 : bit_vector := "01";
     PM_DATA_SCALE2 : bit_vector := "01";
     PM_DATA_SCALE3 : bit_vector := "01";
     PM_DATA_SCALE4 : bit_vector := "01";
     PM_DATA_SCALE5 : bit_vector := "01";
     PM_DATA_SCALE6 : bit_vector := "01";
     PM_DATA_SCALE7 : bit_vector := "01";
     SIM_VERSION : string := "1.0";
     SLOT_CAP_ATT_BUTTON_PRESENT : boolean := FALSE;
     SLOT_CAP_ATT_INDICATOR_PRESENT : boolean := FALSE;
     SLOT_CAP_POWER_INDICATOR_PRESENT : boolean := FALSE;
     TL_RX_RAM_RADDR_LATENCY : integer := 1;
     TL_RX_RAM_RDATA_LATENCY : integer := 2;
     TL_RX_RAM_WRITE_LATENCY : integer := 0;
     TL_TFC_DISABLE : boolean := FALSE;
     TL_TX_CHECKS_DISABLE : boolean := FALSE;
     TL_TX_RAM_RADDR_LATENCY : integer := 0;
     TL_TX_RAM_RDATA_LATENCY : integer := 2;
     USR_CFG : boolean := FALSE;
     USR_EXT_CFG : boolean := FALSE;
     VC0_CPL_INFINITE : boolean := TRUE;
     VC0_RX_RAM_LIMIT : bit_vector := X"01E";
     VC0_TOTAL_CREDITS_CD : integer := 104;
     VC0_TOTAL_CREDITS_CH : integer := 36;
     VC0_TOTAL_CREDITS_NPH : integer := 8;
     VC0_TOTAL_CREDITS_PD : integer := 288;
     VC0_TOTAL_CREDITS_PH : integer := 32;
     VC0_TX_LASTPACKET : integer := 31
  );
  port (
     CFGBUSNUMBER : out std_logic_vector(7 downto 0);
     CFGCOMMANDBUSMASTERENABLE : out std_ulogic;
     CFGCOMMANDINTERRUPTDISABLE : out std_ulogic;
     CFGCOMMANDIOENABLE : out std_ulogic;
     CFGCOMMANDMEMENABLE : out std_ulogic;
     CFGCOMMANDSERREN : out std_ulogic;
     CFGDEVCONTROLAUXPOWEREN : out std_ulogic;
     CFGDEVCONTROLCORRERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLENABLERO : out std_ulogic;
     CFGDEVCONTROLEXTTAGEN : out std_ulogic;
     CFGDEVCONTROLFATALERRREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLMAXPAYLOAD : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLMAXREADREQ : out std_logic_vector(2 downto 0);
     CFGDEVCONTROLNONFATALREPORTINGEN : out std_ulogic;
     CFGDEVCONTROLNOSNOOPEN : out std_ulogic;
     CFGDEVCONTROLPHANTOMEN : out std_ulogic;
     CFGDEVCONTROLURERRREPORTINGEN : out std_ulogic;
     CFGDEVICENUMBER : out std_logic_vector(4 downto 0);
     CFGDEVSTATUSCORRERRDETECTED : out std_ulogic;
     CFGDEVSTATUSFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSNONFATALERRDETECTED : out std_ulogic;
     CFGDEVSTATUSURDETECTED : out std_ulogic;
     CFGDO : out std_logic_vector(31 downto 0);
     CFGERRCPLRDYN : out std_ulogic;
     CFGFUNCTIONNUMBER : out std_logic_vector(2 downto 0);
     CFGINTERRUPTDO : out std_logic_vector(7 downto 0);
     CFGINTERRUPTMMENABLE : out std_logic_vector(2 downto 0);
     CFGINTERRUPTMSIENABLE : out std_ulogic;
     CFGINTERRUPTRDYN : out std_ulogic;
     CFGLINKCONTOLRCB : out std_ulogic;
     CFGLINKCONTROLASPMCONTROL : out std_logic_vector(1 downto 0);
     CFGLINKCONTROLCOMMONCLOCK : out std_ulogic;
     CFGLINKCONTROLEXTENDEDSYNC : out std_ulogic;
     CFGLTSSMSTATE : out std_logic_vector(4 downto 0);
     CFGPCIELINKSTATEN : out std_logic_vector(2 downto 0);
     CFGRDWRDONEN : out std_ulogic;
     CFGTOTURNOFFN : out std_ulogic;
     DBGBADDLLPSTATUS : out std_ulogic;
     DBGBADTLPLCRC : out std_ulogic;
     DBGBADTLPSEQNUM : out std_ulogic;
     DBGBADTLPSTATUS : out std_ulogic;
     DBGDLPROTOCOLSTATUS : out std_ulogic;
     DBGFCPROTOCOLERRSTATUS : out std_ulogic;
     DBGMLFRMDLENGTH : out std_ulogic;
     DBGMLFRMDMPS : out std_ulogic;
     DBGMLFRMDTCVC : out std_ulogic;
     DBGMLFRMDTLPSTATUS : out std_ulogic;
     DBGMLFRMDUNRECTYPE : out std_ulogic;
     DBGPOISTLPSTATUS : out std_ulogic;
     DBGRCVROVERFLOWSTATUS : out std_ulogic;
     DBGREGDETECTEDCORRECTABLE : out std_ulogic;
     DBGREGDETECTEDFATAL : out std_ulogic;
     DBGREGDETECTEDNONFATAL : out std_ulogic;
     DBGREGDETECTEDUNSUPPORTED : out std_ulogic;
     DBGRPLYROLLOVERSTATUS : out std_ulogic;
     DBGRPLYTIMEOUTSTATUS : out std_ulogic;
     DBGURNOBARHIT : out std_ulogic;
     DBGURPOISCFGWR : out std_ulogic;
     DBGURSTATUS : out std_ulogic;
     DBGURUNSUPMSG : out std_ulogic;
     MIMRXRADDR : out std_logic_vector(11 downto 0);
     MIMRXREN : out std_ulogic;
     MIMRXWADDR : out std_logic_vector(11 downto 0);
     MIMRXWDATA : out std_logic_vector(34 downto 0);
     MIMRXWEN : out std_ulogic;
     MIMTXRADDR : out std_logic_vector(11 downto 0);
     MIMTXREN : out std_ulogic;
     MIMTXWADDR : out std_logic_vector(11 downto 0);
     MIMTXWDATA : out std_logic_vector(35 downto 0);
     MIMTXWEN : out std_ulogic;
     PIPEGTPOWERDOWNA : out std_logic_vector(1 downto 0);
     PIPEGTPOWERDOWNB : out std_logic_vector(1 downto 0);
     PIPEGTTXELECIDLEA : out std_ulogic;
     PIPEGTTXELECIDLEB : out std_ulogic;
     PIPERXPOLARITYA : out std_ulogic;
     PIPERXPOLARITYB : out std_ulogic;
     PIPERXRESETA : out std_ulogic;
     PIPERXRESETB : out std_ulogic;
     PIPETXCHARDISPMODEA : out std_logic_vector(1 downto 0);
     PIPETXCHARDISPMODEB : out std_logic_vector(1 downto 0);
     PIPETXCHARDISPVALA : out std_logic_vector(1 downto 0);
     PIPETXCHARDISPVALB : out std_logic_vector(1 downto 0);
     PIPETXCHARISKA : out std_logic_vector(1 downto 0);
     PIPETXCHARISKB : out std_logic_vector(1 downto 0);
     PIPETXDATAA : out std_logic_vector(15 downto 0);
     PIPETXDATAB : out std_logic_vector(15 downto 0);
     PIPETXRCVRDETA : out std_ulogic;
     PIPETXRCVRDETB : out std_ulogic;
     RECEIVEDHOTRESET : out std_ulogic;
     TRNFCCPLD : out std_logic_vector(11 downto 0);
     TRNFCCPLH : out std_logic_vector(7 downto 0);
     TRNFCNPD : out std_logic_vector(11 downto 0);
     TRNFCNPH : out std_logic_vector(7 downto 0);
     TRNFCPD : out std_logic_vector(11 downto 0);
     TRNFCPH : out std_logic_vector(7 downto 0);
     TRNLNKUPN : out std_ulogic;
     TRNRBARHITN : out std_logic_vector(6 downto 0);
     TRNRD : out std_logic_vector(31 downto 0);
     TRNREOFN : out std_ulogic;
     TRNRERRFWDN : out std_ulogic;
     TRNRSOFN : out std_ulogic;
     TRNRSRCDSCN : out std_ulogic;
     TRNRSRCRDYN : out std_ulogic;
     TRNTBUFAV : out std_logic_vector(5 downto 0);
     TRNTCFGREQN : out std_ulogic;
     TRNTDSTRDYN : out std_ulogic;
     TRNTERRDROPN : out std_ulogic;
     USERRSTN : out std_ulogic;
     CFGDEVID : in std_logic_vector(15 downto 0);
     CFGDSN : in std_logic_vector(63 downto 0);
     CFGDWADDR : in std_logic_vector(9 downto 0);
     CFGERRCORN : in std_ulogic := 'L';
     CFGERRCPLABORTN : in std_ulogic := 'L';
     CFGERRCPLTIMEOUTN : in std_ulogic := 'L';
     CFGERRECRCN : in std_ulogic := 'L';
     CFGERRLOCKEDN : in std_ulogic := 'L';
     CFGERRPOSTEDN : in std_ulogic := 'L';
     CFGERRTLPCPLHEADER : in std_logic_vector(47 downto 0);
     CFGERRURN : in std_ulogic := 'L';
     CFGINTERRUPTASSERTN : in std_ulogic := 'L';
     CFGINTERRUPTDI : in std_logic_vector(7 downto 0);
     CFGINTERRUPTN : in std_ulogic := 'L';
     CFGPMWAKEN : in std_ulogic := 'L';
     CFGRDENN : in std_ulogic := 'L';
     CFGREVID : in std_logic_vector(7 downto 0);
     CFGSUBSYSID : in std_logic_vector(15 downto 0);
     CFGSUBSYSVENID : in std_logic_vector(15 downto 0);
     CFGTRNPENDINGN : in std_ulogic := 'L';
     CFGTURNOFFOKN : in std_ulogic := 'L';
     CFGVENID : in std_logic_vector(15 downto 0);
     CLOCKLOCKED : in std_ulogic := 'L';
     MGTCLK : in std_ulogic := 'L';
     MIMRXRDATA : in std_logic_vector(34 downto 0);
     MIMTXRDATA : in std_logic_vector(35 downto 0);
     PIPEGTRESETDONEA : in std_ulogic := 'L';
     PIPEGTRESETDONEB : in std_ulogic := 'L';
     PIPEPHYSTATUSA : in std_ulogic := 'L';
     PIPEPHYSTATUSB : in std_ulogic := 'L';
     PIPERXCHARISKA : in std_logic_vector(1 downto 0);
     PIPERXCHARISKB : in std_logic_vector(1 downto 0);
     PIPERXDATAA : in std_logic_vector(15 downto 0);
     PIPERXDATAB : in std_logic_vector(15 downto 0);
     PIPERXENTERELECIDLEA : in std_ulogic := 'L';
     PIPERXENTERELECIDLEB : in std_ulogic := 'L';
     PIPERXSTATUSA : in std_logic_vector(2 downto 0);
     PIPERXSTATUSB : in std_logic_vector(2 downto 0);
     SYSRESETN : in std_ulogic := 'L';
     TRNFCSEL : in std_logic_vector(2 downto 0);
     TRNRDSTRDYN : in std_ulogic := 'L';
     TRNRNPOKN : in std_ulogic := 'L';
     TRNTCFGGNTN : in std_ulogic := 'L';
     TRNTD : in std_logic_vector(31 downto 0);
     TRNTEOFN : in std_ulogic := 'L';
     TRNTERRFWDN : in std_ulogic := 'L';
     TRNTSOFN : in std_ulogic := 'L';
     TRNTSRCDSCN : in std_ulogic := 'L';
     TRNTSRCRDYN : in std_ulogic := 'L';
     TRNTSTRN : in std_ulogic := 'L';
     USERCLK : in std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  PCIE_A1 : component is "PRIMITIVE";

----- component PCIE_EP -----
component PCIE_EP
  generic (
     ACTIVELANESIN : bit_vector := X"01";
     AERBASEPTR : bit_vector := X"110";
     AERCAPABILITYNEXTPTR : bit_vector := X"138";
     BAR0ADDRWIDTH : integer := 0;
     BAR0EXIST : boolean := TRUE;
     BAR0IOMEMN : integer := 0;
     BAR0MASKWIDTH : bit_vector := X"14";
     BAR0PREFETCHABLE : boolean := TRUE;
     BAR1ADDRWIDTH : integer := 0;
     BAR1EXIST : boolean := FALSE;
     BAR1IOMEMN : integer := 0;
     BAR1MASKWIDTH : bit_vector := X"00";
     BAR1PREFETCHABLE : boolean := FALSE;
     BAR2ADDRWIDTH : integer := 0;
     BAR2EXIST : boolean := FALSE;
     BAR2IOMEMN : integer := 0;
     BAR2MASKWIDTH : bit_vector := X"00";
     BAR2PREFETCHABLE : boolean := FALSE;
     BAR3ADDRWIDTH : integer := 0;
     BAR3EXIST : boolean := FALSE;
     BAR3IOMEMN : integer := 0;
     BAR3MASKWIDTH : bit_vector := X"00";
     BAR3PREFETCHABLE : boolean := FALSE;
     BAR4ADDRWIDTH : integer := 0;
     BAR4EXIST : boolean := FALSE;
     BAR4IOMEMN : integer := 0;
     BAR4MASKWIDTH : bit_vector := X"00";
     BAR4PREFETCHABLE : boolean := FALSE;
     BAR5EXIST : boolean := FALSE;
     BAR5IOMEMN : integer := 0;
     BAR5MASKWIDTH : bit_vector := X"00";
     BAR5PREFETCHABLE : boolean := FALSE;
     CAPABILITIESPOINTER : bit_vector := X"40";
     CARDBUSCISPOINTER : bit_vector := X"00000000";
     CLASSCODE : bit_vector := X"058000";
     CLKDIVIDED : boolean := FALSE;
     DEVICECAPABILITYENDPOINTL0SLATENCY : bit_vector := X"0";
     DEVICECAPABILITYENDPOINTL1LATENCY : bit_vector := X"0";
     DEVICEID : bit_vector := X"5050";
     DEVICESERIALNUMBER : bit_vector := X"E000000001000A35";
     DSNBASEPTR : bit_vector := X"148";
     DSNCAPABILITYNEXTPTR : bit_vector := X"154";
     INFINITECOMPLETIONS : boolean := TRUE;
     INTERRUPTPIN : bit_vector := X"00";
     L0SEXITLATENCY : integer := 7;
     L0SEXITLATENCYCOMCLK : integer := 7;
     L1EXITLATENCY : integer := 7;
     L1EXITLATENCYCOMCLK : integer := 7;
     LINKCAPABILITYASPMSUPPORT : bit_vector := X"1";
     LINKCAPABILITYMAXLINKWIDTH : bit_vector := X"01";
     LINKSTATUSSLOTCLOCKCONFIG : boolean := FALSE;
     LOWPRIORITYVCCOUNT : integer := 0;
     MSIBASEPTR : bit_vector := X"048";
     MSICAPABILITYMULTIMSGCAP : bit_vector := X"0";
     MSICAPABILITYNEXTPTR : bit_vector := X"60";
     PBBASEPTR : bit_vector := X"138";
     PBCAPABILITYDW0BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW0DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW0PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW0PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW0POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW0TYPE : bit_vector := X"0";
     PBCAPABILITYDW1BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW1DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW1PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW1PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW1POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW1TYPE : bit_vector := X"0";
     PBCAPABILITYDW2BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW2DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW2PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW2PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW2POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW2TYPE : bit_vector := X"0";
     PBCAPABILITYDW3BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW3DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW3PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW3PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW3POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW3TYPE : bit_vector := X"0";
     PBCAPABILITYNEXTPTR : bit_vector := X"148";
     PBCAPABILITYSYSTEMALLOCATED : boolean := FALSE;
     PCIECAPABILITYNEXTPTR : bit_vector := X"00";
     PMBASEPTR : bit_vector := X"040";
     PMCAPABILITYAUXCURRENT : bit_vector := X"0";
     PMCAPABILITYD1SUPPORT : boolean := FALSE;
     PMCAPABILITYD2SUPPORT : boolean := FALSE;
     PMCAPABILITYDSI : boolean := TRUE;
     PMCAPABILITYNEXTPTR : bit_vector := X"60";
     PMCAPABILITYPMESUPPORT : bit_vector := X"00";
     PMDATA0 : bit_vector := X"00";
     PMDATA1 : bit_vector := X"00";
     PMDATA2 : bit_vector := X"00";
     PMDATA3 : bit_vector := X"00";
     PMDATA4 : bit_vector := X"00";
     PMDATA5 : bit_vector := X"00";
     PMDATA6 : bit_vector := X"00";
     PMDATA7 : bit_vector := X"00";
     PMDATASCALE0 : integer := 0;
     PMDATASCALE1 : integer := 0;
     PMDATASCALE2 : integer := 0;
     PMDATASCALE3 : integer := 0;
     PMDATASCALE4 : integer := 0;
     PMDATASCALE5 : integer := 0;
     PMDATASCALE6 : integer := 0;
     PMDATASCALE7 : integer := 0;
     PORTVCCAPABILITYEXTENDEDVCCOUNT : bit_vector := X"0";
     PORTVCCAPABILITYVCARBCAP : bit_vector := X"00";
     PORTVCCAPABILITYVCARBTABLEOFFSET : bit_vector := X"00";
     RESETMODE : boolean := FALSE;
     RETRYRAMREADLATENCY : integer := 3;
     RETRYRAMSIZE : bit_vector := X"009";
     RETRYRAMWRITELATENCY : integer := 1;
     REVISIONID : bit_vector := X"00";
     SUBSYSTEMID : bit_vector := X"5050";
     SUBSYSTEMVENDORID : bit_vector := X"10EE";
     TLRAMREADLATENCY : integer := 3;
     TLRAMWRITELATENCY : integer := 1;
     TXTSNFTS : integer := 255;
     TXTSNFTSCOMCLK : integer := 255;
     VC0RXFIFOBASEC : bit_vector := X"0098";
     VC0RXFIFOBASENP : bit_vector := X"0080";
     VC0RXFIFOBASEP : bit_vector := X"0000";
     VC0RXFIFOLIMITC : bit_vector := X"0117";
     VC0RXFIFOLIMITNP : bit_vector := X"0097";
     VC0RXFIFOLIMITP : bit_vector := X"007f";
     VC0TOTALCREDITSCD : bit_vector := X"000";
     VC0TOTALCREDITSCH : bit_vector := X"00";
     VC0TOTALCREDITSNPH : bit_vector := X"08";
     VC0TOTALCREDITSPD : bit_vector := X"034";
     VC0TOTALCREDITSPH : bit_vector := X"08";
     VC0TXFIFOBASEC : bit_vector := X"0098";
     VC0TXFIFOBASENP : bit_vector := X"0080";
     VC0TXFIFOBASEP : bit_vector := X"0000";
     VC0TXFIFOLIMITC : bit_vector := X"0117";
     VC0TXFIFOLIMITNP : bit_vector := X"0097";
     VC0TXFIFOLIMITP : bit_vector := X"007f";
     VC1RXFIFOBASEC : bit_vector := X"0118";
     VC1RXFIFOBASENP : bit_vector := X"0118";
     VC1RXFIFOBASEP : bit_vector := X"0118";
     VC1RXFIFOLIMITC : bit_vector := X"0118";
     VC1RXFIFOLIMITNP : bit_vector := X"0118";
     VC1RXFIFOLIMITP : bit_vector := X"0118";
     VC1TOTALCREDITSCD : bit_vector := X"000";
     VC1TOTALCREDITSCH : bit_vector := X"00";
     VC1TOTALCREDITSNPH : bit_vector := X"00";
     VC1TOTALCREDITSPD : bit_vector := X"000";
     VC1TOTALCREDITSPH : bit_vector := X"00";
     VC1TXFIFOBASEC : bit_vector := X"0118";
     VC1TXFIFOBASENP : bit_vector := X"0118";
     VC1TXFIFOBASEP : bit_vector := X"0118";
     VC1TXFIFOLIMITC : bit_vector := X"0118";
     VC1TXFIFOLIMITNP : bit_vector := X"0118";
     VC1TXFIFOLIMITP : bit_vector := X"0118";
     VCBASEPTR : bit_vector := X"154";
     VCCAPABILITYNEXTPTR : bit_vector := X"000";
     VENDORID : bit_vector := X"10EE";
     XPBASEPTR : bit_vector := X"60";
     XPDEVICEPORTTYPE : bit_vector := X"0";
     XPMAXPAYLOAD : integer := 0
  );
  port (
     BUSMASTERENABLE : out std_ulogic;
     CRMDOHOTRESETN : out std_ulogic;
     CRMPWRSOFTRESETN : out std_ulogic;
     DLLTXPMDLLPOUTSTANDING : out std_ulogic;
     INTERRUPTDISABLE : out std_ulogic;
     IOSPACEENABLE : out std_ulogic;
     L0CFGLOOPBACKACK : out std_ulogic;
     L0COMPLETERID : out std_logic_vector(12 downto 0);
     L0DLLERRORVECTOR : out std_logic_vector(6 downto 0);
     L0DLLRXACKOUTSTANDING : out std_ulogic;
     L0DLLTXNONFCOUTSTANDING : out std_ulogic;
     L0DLLTXOUTSTANDING : out std_ulogic;
     L0DLLVCSTATUS : out std_logic_vector(7 downto 0);
     L0DLUPDOWN : out std_logic_vector(7 downto 0);
     L0FIRSTCFGWRITEOCCURRED : out std_ulogic;
     L0LTSSMSTATE : out std_logic_vector(3 downto 0);
     L0MACENTEREDL0 : out std_ulogic;
     L0MACLINKTRAINING : out std_ulogic;
     L0MACLINKUP : out std_ulogic;
     L0MACNEGOTIATEDLINKWIDTH : out std_logic_vector(3 downto 0);
     L0MACNEWSTATEACK : out std_ulogic;
     L0MACRXL0SSTATE : out std_ulogic;
     L0MSIENABLE0 : out std_ulogic;
     L0MULTIMSGEN0 : out std_logic_vector(2 downto 0);
     L0PMEACK : out std_ulogic;
     L0PMEEN : out std_ulogic;
     L0PMEREQOUT : out std_ulogic;
     L0PWRL1STATE : out std_ulogic;
     L0PWRL23READYSTATE : out std_ulogic;
     L0PWRSTATE0 : out std_logic_vector(1 downto 0);
     L0PWRTURNOFFREQ : out std_ulogic;
     L0PWRTXL0SSTATE : out std_ulogic;
     L0RXDLLPM : out std_ulogic;
     L0RXDLLPMTYPE : out std_logic_vector(2 downto 0);
     L0RXMACLINKERROR : out std_logic_vector(1 downto 0);
     L0STATSCFGOTHERRECEIVED : out std_ulogic;
     L0STATSCFGOTHERTRANSMITTED : out std_ulogic;
     L0STATSCFGRECEIVED : out std_ulogic;
     L0STATSCFGTRANSMITTED : out std_ulogic;
     L0STATSDLLPRECEIVED : out std_ulogic;
     L0STATSDLLPTRANSMITTED : out std_ulogic;
     L0STATSOSRECEIVED : out std_ulogic;
     L0STATSOSTRANSMITTED : out std_ulogic;
     L0STATSTLPRECEIVED : out std_ulogic;
     L0STATSTLPTRANSMITTED : out std_ulogic;
     L0UNLOCKRECEIVED : out std_ulogic;
     LLKRXCHCOMPLETIONAVAILABLEN : out std_logic_vector(7 downto 0);
     LLKRXCHNONPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
     LLKRXCHPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
     LLKRXDATA : out std_logic_vector(63 downto 0);
     LLKRXEOFN : out std_ulogic;
     LLKRXEOPN : out std_ulogic;
     LLKRXPREFERREDTYPE : out std_logic_vector(15 downto 0);
     LLKRXSOFN : out std_ulogic;
     LLKRXSOPN : out std_ulogic;
     LLKRXSRCLASTREQN : out std_ulogic;
     LLKRXSRCRDYN : out std_ulogic;
     LLKRXVALIDN : out std_logic_vector(1 downto 0);
     LLKTCSTATUS : out std_logic_vector(7 downto 0);
     LLKTXCHANSPACE : out std_logic_vector(9 downto 0);
     LLKTXCHCOMPLETIONREADYN : out std_logic_vector(7 downto 0);
     LLKTXCHNONPOSTEDREADYN : out std_logic_vector(7 downto 0);
     LLKTXCHPOSTEDREADYN : out std_logic_vector(7 downto 0);
     LLKTXCONFIGREADYN : out std_ulogic;
     LLKTXDSTRDYN : out std_ulogic;
     MAXPAYLOADSIZE : out std_logic_vector(2 downto 0);
     MAXREADREQUESTSIZE : out std_logic_vector(2 downto 0);
     MEMSPACEENABLE : out std_ulogic;
     MGMTPSO : out std_logic_vector(16 downto 0);
     MGMTRDATA : out std_logic_vector(31 downto 0);
     MGMTSTATSCREDIT : out std_logic_vector(11 downto 0);
     MIMDLLBRADD : out std_logic_vector(11 downto 0);
     MIMDLLBREN : out std_ulogic;
     MIMDLLBWADD : out std_logic_vector(11 downto 0);
     MIMDLLBWDATA : out std_logic_vector(63 downto 0);
     MIMDLLBWEN : out std_ulogic;
     MIMRXBRADD : out std_logic_vector(12 downto 0);
     MIMRXBREN : out std_ulogic;
     MIMRXBWADD : out std_logic_vector(12 downto 0);
     MIMRXBWDATA : out std_logic_vector(63 downto 0);
     MIMRXBWEN : out std_ulogic;
     MIMTXBRADD : out std_logic_vector(12 downto 0);
     MIMTXBREN : out std_ulogic;
     MIMTXBWADD : out std_logic_vector(12 downto 0);
     MIMTXBWDATA : out std_logic_vector(63 downto 0);
     MIMTXBWEN : out std_ulogic;
     PARITYERRORRESPONSE : out std_ulogic;
     PIPEDESKEWLANESL0 : out std_ulogic;
     PIPEDESKEWLANESL1 : out std_ulogic;
     PIPEDESKEWLANESL2 : out std_ulogic;
     PIPEDESKEWLANESL3 : out std_ulogic;
     PIPEDESKEWLANESL4 : out std_ulogic;
     PIPEDESKEWLANESL5 : out std_ulogic;
     PIPEDESKEWLANESL6 : out std_ulogic;
     PIPEDESKEWLANESL7 : out std_ulogic;
     PIPEPOWERDOWNL0 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL1 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL2 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL3 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL4 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL5 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL6 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL7 : out std_logic_vector(1 downto 0);
     PIPERESETL0 : out std_ulogic;
     PIPERESETL1 : out std_ulogic;
     PIPERESETL2 : out std_ulogic;
     PIPERESETL3 : out std_ulogic;
     PIPERESETL4 : out std_ulogic;
     PIPERESETL5 : out std_ulogic;
     PIPERESETL6 : out std_ulogic;
     PIPERESETL7 : out std_ulogic;
     PIPERXPOLARITYL0 : out std_ulogic;
     PIPERXPOLARITYL1 : out std_ulogic;
     PIPERXPOLARITYL2 : out std_ulogic;
     PIPERXPOLARITYL3 : out std_ulogic;
     PIPERXPOLARITYL4 : out std_ulogic;
     PIPERXPOLARITYL5 : out std_ulogic;
     PIPERXPOLARITYL6 : out std_ulogic;
     PIPERXPOLARITYL7 : out std_ulogic;
     PIPETXCOMPLIANCEL0 : out std_ulogic;
     PIPETXCOMPLIANCEL1 : out std_ulogic;
     PIPETXCOMPLIANCEL2 : out std_ulogic;
     PIPETXCOMPLIANCEL3 : out std_ulogic;
     PIPETXCOMPLIANCEL4 : out std_ulogic;
     PIPETXCOMPLIANCEL5 : out std_ulogic;
     PIPETXCOMPLIANCEL6 : out std_ulogic;
     PIPETXCOMPLIANCEL7 : out std_ulogic;
     PIPETXDATAKL0 : out std_ulogic;
     PIPETXDATAKL1 : out std_ulogic;
     PIPETXDATAKL2 : out std_ulogic;
     PIPETXDATAKL3 : out std_ulogic;
     PIPETXDATAKL4 : out std_ulogic;
     PIPETXDATAKL5 : out std_ulogic;
     PIPETXDATAKL6 : out std_ulogic;
     PIPETXDATAKL7 : out std_ulogic;
     PIPETXDATAL0 : out std_logic_vector(7 downto 0);
     PIPETXDATAL1 : out std_logic_vector(7 downto 0);
     PIPETXDATAL2 : out std_logic_vector(7 downto 0);
     PIPETXDATAL3 : out std_logic_vector(7 downto 0);
     PIPETXDATAL4 : out std_logic_vector(7 downto 0);
     PIPETXDATAL5 : out std_logic_vector(7 downto 0);
     PIPETXDATAL6 : out std_logic_vector(7 downto 0);
     PIPETXDATAL7 : out std_logic_vector(7 downto 0);
     PIPETXDETECTRXLOOPBACKL0 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL1 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL2 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL3 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL4 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL5 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL6 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL7 : out std_ulogic;
     PIPETXELECIDLEL0 : out std_ulogic;
     PIPETXELECIDLEL1 : out std_ulogic;
     PIPETXELECIDLEL2 : out std_ulogic;
     PIPETXELECIDLEL3 : out std_ulogic;
     PIPETXELECIDLEL4 : out std_ulogic;
     PIPETXELECIDLEL5 : out std_ulogic;
     PIPETXELECIDLEL6 : out std_ulogic;
     PIPETXELECIDLEL7 : out std_ulogic;
     SERRENABLE : out std_ulogic;
     URREPORTINGENABLE : out std_ulogic;
     AUXPOWER : in std_ulogic;
     COMPLIANCEAVOID : in std_ulogic;
     CRMCORECLK : in std_ulogic;
     CRMCORECLKDLO : in std_ulogic;
     CRMCORECLKRXO : in std_ulogic;
     CRMCORECLKTXO : in std_ulogic;
     CRMLINKRSTN : in std_ulogic;
     CRMMACRSTN : in std_ulogic;
     CRMMGMTRSTN : in std_ulogic;
     CRMNVRSTN : in std_ulogic;
     CRMURSTN : in std_ulogic;
     CRMUSERCFGRSTN : in std_ulogic;
     CRMUSERCLK : in std_ulogic;
     CRMUSERCLKRXO : in std_ulogic;
     CRMUSERCLKTXO : in std_ulogic;
     L0CFGDISABLESCRAMBLE : in std_ulogic;
     L0CFGLOOPBACKMASTER : in std_ulogic;
     L0LEGACYINTFUNCT0 : in std_ulogic;
     L0MSIREQUEST0 : in std_logic_vector(3 downto 0);
     L0PACKETHEADERFROMUSER : in std_logic_vector(127 downto 0);
     L0PMEREQIN : in std_ulogic;
     L0SETCOMPLETERABORTERROR : in std_ulogic;
     L0SETCOMPLETIONTIMEOUTCORRERROR : in std_ulogic;
     L0SETCOMPLETIONTIMEOUTUNCORRERROR : in std_ulogic;
     L0SETDETECTEDCORRERROR : in std_ulogic;
     L0SETDETECTEDFATALERROR : in std_ulogic;
     L0SETDETECTEDNONFATALERROR : in std_ulogic;
     L0SETUNEXPECTEDCOMPLETIONCORRERROR : in std_ulogic;
     L0SETUNEXPECTEDCOMPLETIONUNCORRERROR : in std_ulogic;
     L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR : in std_ulogic;
     L0SETUNSUPPORTEDREQUESTOTHERERROR : in std_ulogic;
     L0SETUSERDETECTEDPARITYERROR : in std_ulogic;
     L0SETUSERMASTERDATAPARITY : in std_ulogic;
     L0SETUSERRECEIVEDMASTERABORT : in std_ulogic;
     L0SETUSERRECEIVEDTARGETABORT : in std_ulogic;
     L0SETUSERSIGNALLEDTARGETABORT : in std_ulogic;
     L0SETUSERSYSTEMERROR : in std_ulogic;
     L0TRANSACTIONSPENDING : in std_ulogic;
     LLKRXCHFIFO : in std_logic_vector(1 downto 0);
     LLKRXCHTC : in std_logic_vector(2 downto 0);
     LLKRXDSTCONTREQN : in std_ulogic;
     LLKRXDSTREQN : in std_ulogic;
     LLKTXCHFIFO : in std_logic_vector(1 downto 0);
     LLKTXCHTC : in std_logic_vector(2 downto 0);
     LLKTXDATA : in std_logic_vector(63 downto 0);
     LLKTXENABLEN : in std_logic_vector(1 downto 0);
     LLKTXEOFN : in std_ulogic;
     LLKTXEOPN : in std_ulogic;
     LLKTXSOFN : in std_ulogic;
     LLKTXSOPN : in std_ulogic;
     LLKTXSRCDSCN : in std_ulogic;
     LLKTXSRCRDYN : in std_ulogic;
     MGMTADDR : in std_logic_vector(10 downto 0);
     MGMTBWREN : in std_logic_vector(3 downto 0);
     MGMTRDEN : in std_ulogic;
     MGMTSTATSCREDITSEL : in std_logic_vector(6 downto 0);
     MGMTWDATA : in std_logic_vector(31 downto 0);
     MGMTWREN : in std_ulogic;
     MIMDLLBRDATA : in std_logic_vector(63 downto 0);
     MIMRXBRDATA : in std_logic_vector(63 downto 0);
     MIMTXBRDATA : in std_logic_vector(63 downto 0);
     PIPEPHYSTATUSL0 : in std_ulogic;
     PIPEPHYSTATUSL1 : in std_ulogic;
     PIPEPHYSTATUSL2 : in std_ulogic;
     PIPEPHYSTATUSL3 : in std_ulogic;
     PIPEPHYSTATUSL4 : in std_ulogic;
     PIPEPHYSTATUSL5 : in std_ulogic;
     PIPEPHYSTATUSL6 : in std_ulogic;
     PIPEPHYSTATUSL7 : in std_ulogic;
     PIPERXCHANISALIGNEDL0 : in std_ulogic;
     PIPERXCHANISALIGNEDL1 : in std_ulogic;
     PIPERXCHANISALIGNEDL2 : in std_ulogic;
     PIPERXCHANISALIGNEDL3 : in std_ulogic;
     PIPERXCHANISALIGNEDL4 : in std_ulogic;
     PIPERXCHANISALIGNEDL5 : in std_ulogic;
     PIPERXCHANISALIGNEDL6 : in std_ulogic;
     PIPERXCHANISALIGNEDL7 : in std_ulogic;
     PIPERXDATAKL0 : in std_ulogic;
     PIPERXDATAKL1 : in std_ulogic;
     PIPERXDATAKL2 : in std_ulogic;
     PIPERXDATAKL3 : in std_ulogic;
     PIPERXDATAKL4 : in std_ulogic;
     PIPERXDATAKL5 : in std_ulogic;
     PIPERXDATAKL6 : in std_ulogic;
     PIPERXDATAKL7 : in std_ulogic;
     PIPERXDATAL0 : in std_logic_vector(7 downto 0);
     PIPERXDATAL1 : in std_logic_vector(7 downto 0);
     PIPERXDATAL2 : in std_logic_vector(7 downto 0);
     PIPERXDATAL3 : in std_logic_vector(7 downto 0);
     PIPERXDATAL4 : in std_logic_vector(7 downto 0);
     PIPERXDATAL5 : in std_logic_vector(7 downto 0);
     PIPERXDATAL6 : in std_logic_vector(7 downto 0);
     PIPERXDATAL7 : in std_logic_vector(7 downto 0);
     PIPERXELECIDLEL0 : in std_ulogic;
     PIPERXELECIDLEL1 : in std_ulogic;
     PIPERXELECIDLEL2 : in std_ulogic;
     PIPERXELECIDLEL3 : in std_ulogic;
     PIPERXELECIDLEL4 : in std_ulogic;
     PIPERXELECIDLEL5 : in std_ulogic;
     PIPERXELECIDLEL6 : in std_ulogic;
     PIPERXELECIDLEL7 : in std_ulogic;
     PIPERXSTATUSL0 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL1 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL2 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL3 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL4 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL5 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL6 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL7 : in std_logic_vector(2 downto 0);
     PIPERXVALIDL0 : in std_ulogic;
     PIPERXVALIDL1 : in std_ulogic;
     PIPERXVALIDL2 : in std_ulogic;
     PIPERXVALIDL3 : in std_ulogic;
     PIPERXVALIDL4 : in std_ulogic;
     PIPERXVALIDL5 : in std_ulogic;
     PIPERXVALIDL6 : in std_ulogic;
     PIPERXVALIDL7 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PCIE_EP : component is "PRIMITIVE";

----- component PCIE_INTERNAL_1_1 -----
component PCIE_INTERNAL_1_1
  generic (
     ACTIVELANESIN : bit_vector := X"01";
     AERBASEPTR : bit_vector := X"110";
     AERCAPABILITYECRCCHECKCAPABLE : boolean := FALSE;
     AERCAPABILITYECRCGENCAPABLE : boolean := FALSE;
     AERCAPABILITYNEXTPTR : bit_vector := X"138";
     BAR0ADDRWIDTH : integer := 0;
     BAR0EXIST : boolean := TRUE;
     BAR0IOMEMN : integer := 0;
     BAR0MASKWIDTH : bit_vector := X"14";
     BAR0PREFETCHABLE : boolean := TRUE;
     BAR1ADDRWIDTH : integer := 0;
     BAR1EXIST : boolean := FALSE;
     BAR1IOMEMN : integer := 0;
     BAR1MASKWIDTH : bit_vector := X"00";
     BAR1PREFETCHABLE : boolean := FALSE;
     BAR2ADDRWIDTH : integer := 0;
     BAR2EXIST : boolean := FALSE;
     BAR2IOMEMN : integer := 0;
     BAR2MASKWIDTH : bit_vector := X"00";
     BAR2PREFETCHABLE : boolean := FALSE;
     BAR3ADDRWIDTH : integer := 0;
     BAR3EXIST : boolean := FALSE;
     BAR3IOMEMN : integer := 0;
     BAR3MASKWIDTH : bit_vector := X"00";
     BAR3PREFETCHABLE : boolean := FALSE;
     BAR4ADDRWIDTH : integer := 0;
     BAR4EXIST : boolean := FALSE;
     BAR4IOMEMN : integer := 0;
     BAR4MASKWIDTH : bit_vector := X"00";
     BAR4PREFETCHABLE : boolean := FALSE;
     BAR5EXIST : boolean := FALSE;
     BAR5IOMEMN : integer := 0;
     BAR5MASKWIDTH : bit_vector := X"00";
     BAR5PREFETCHABLE : boolean := FALSE;
     CAPABILITIESPOINTER : bit_vector := X"40";
     CARDBUSCISPOINTER : bit_vector := X"00000000";
     CLASSCODE : bit_vector := X"058000";
     CLKDIVIDED : boolean := FALSE;
     CONFIGROUTING : bit_vector := X"1";
     DEVICECAPABILITYENDPOINTL0SLATENCY : bit_vector := X"0";
     DEVICECAPABILITYENDPOINTL1LATENCY : bit_vector := X"0";
     DEVICEID : bit_vector := X"5050";
     DEVICESERIALNUMBER : bit_vector := X"E000000001000A35";
     DSNBASEPTR : bit_vector := X"148";
     DSNCAPABILITYNEXTPTR : bit_vector := X"154";
     DUALCOREENABLE : boolean := FALSE;
     DUALCORESLAVE : boolean := FALSE;
     DUALROLECFGCNTRLROOTEPN : integer := 0;
     EXTCFGCAPPTR : bit_vector := X"00";
     EXTCFGXPCAPPTR : bit_vector := X"000";
     HEADERTYPE : bit_vector := X"00";
     INFINITECOMPLETIONS : boolean := TRUE;
     INTERRUPTPIN : bit_vector := X"00";
     ISSWITCH : boolean := FALSE;
     L0SEXITLATENCY : integer := 7;
     L0SEXITLATENCYCOMCLK : integer := 7;
     L1EXITLATENCY : integer := 7;
     L1EXITLATENCYCOMCLK : integer := 7;
     LINKCAPABILITYASPMSUPPORT : bit_vector := X"1";
     LINKCAPABILITYMAXLINKWIDTH : bit_vector := X"01";
     LINKSTATUSSLOTCLOCKCONFIG : boolean := FALSE;
     LLKBYPASS : boolean := FALSE;
     LOWPRIORITYVCCOUNT : integer := 0;
     MSIBASEPTR : bit_vector := X"048";
     MSICAPABILITYMULTIMSGCAP : bit_vector := X"0";
     MSICAPABILITYNEXTPTR : bit_vector := X"60";
     PBBASEPTR : bit_vector := X"138";
     PBCAPABILITYDW0BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW0DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW0PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW0PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW0POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW0TYPE : bit_vector := X"0";
     PBCAPABILITYDW1BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW1DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW1PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW1PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW1POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW1TYPE : bit_vector := X"0";
     PBCAPABILITYDW2BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW2DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW2PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW2PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW2POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW2TYPE : bit_vector := X"0";
     PBCAPABILITYDW3BASEPOWER : bit_vector := X"00";
     PBCAPABILITYDW3DATASCALE : bit_vector := X"0";
     PBCAPABILITYDW3PMSTATE : bit_vector := X"0";
     PBCAPABILITYDW3PMSUBSTATE : bit_vector := X"0";
     PBCAPABILITYDW3POWERRAIL : bit_vector := X"0";
     PBCAPABILITYDW3TYPE : bit_vector := X"0";
     PBCAPABILITYNEXTPTR : bit_vector := X"148";
     PBCAPABILITYSYSTEMALLOCATED : boolean := FALSE;
     PCIECAPABILITYINTMSGNUM : bit_vector := X"00";
     PCIECAPABILITYNEXTPTR : bit_vector := X"00";
     PCIECAPABILITYSLOTIMPL : boolean := FALSE;
     PCIEREVISION : integer := 1;
     PMBASEPTR : bit_vector := X"040";
     PMCAPABILITYAUXCURRENT : bit_vector := X"0";
     PMCAPABILITYD1SUPPORT : boolean := FALSE;
     PMCAPABILITYD2SUPPORT : boolean := FALSE;
     PMCAPABILITYDSI : boolean := TRUE;
     PMCAPABILITYNEXTPTR : bit_vector := X"60";
     PMCAPABILITYPMESUPPORT : bit_vector := X"00";
     PMDATA0 : bit_vector := X"00";
     PMDATA1 : bit_vector := X"00";
     PMDATA2 : bit_vector := X"00";
     PMDATA3 : bit_vector := X"00";
     PMDATA4 : bit_vector := X"00";
     PMDATA5 : bit_vector := X"00";
     PMDATA6 : bit_vector := X"00";
     PMDATA7 : bit_vector := X"00";
     PMDATA8 : bit_vector := X"00";
     PMDATASCALE0 : integer := 0;
     PMDATASCALE1 : integer := 0;
     PMDATASCALE2 : integer := 0;
     PMDATASCALE3 : integer := 0;
     PMDATASCALE4 : integer := 0;
     PMDATASCALE5 : integer := 0;
     PMDATASCALE6 : integer := 0;
     PMDATASCALE7 : integer := 0;
     PMDATASCALE8 : integer := 0;
     PMSTATUSCONTROLDATASCALE : bit_vector := X"0";
     PORTVCCAPABILITYEXTENDEDVCCOUNT : bit_vector := X"0";
     PORTVCCAPABILITYVCARBCAP : bit_vector := X"00";
     PORTVCCAPABILITYVCARBTABLEOFFSET : bit_vector := X"00";
     RAMSHARETXRX : boolean := FALSE;
     RESETMODE : boolean := FALSE;
     RETRYRAMREADLATENCY : integer := 3;
     RETRYRAMSIZE : bit_vector := X"009";
     RETRYRAMWIDTH : integer := 0;
     RETRYRAMWRITELATENCY : integer := 1;
     RETRYREADADDRPIPE : boolean := FALSE;
     RETRYREADDATAPIPE : boolean := FALSE;
     RETRYWRITEPIPE : boolean := FALSE;
     REVISIONID : bit_vector := X"00";
     RXREADADDRPIPE : boolean := FALSE;
     RXREADDATAPIPE : boolean := FALSE;
     RXWRITEPIPE : boolean := FALSE;
     SELECTASMODE : boolean := FALSE;
     SELECTDLLIF : boolean := FALSE;
     SLOTCAPABILITYATTBUTTONPRESENT : boolean := FALSE;
     SLOTCAPABILITYATTINDICATORPRESENT : boolean := FALSE;
     SLOTCAPABILITYHOTPLUGCAPABLE : boolean := FALSE;
     SLOTCAPABILITYHOTPLUGSURPRISE : boolean := FALSE;
     SLOTCAPABILITYMSLSENSORPRESENT : boolean := FALSE;
     SLOTCAPABILITYPHYSICALSLOTNUM : bit_vector := X"0000";
     SLOTCAPABILITYPOWERCONTROLLERPRESENT : boolean := FALSE;
     SLOTCAPABILITYPOWERINDICATORPRESENT : boolean := FALSE;
     SLOTCAPABILITYSLOTPOWERLIMITSCALE : bit_vector := X"0";
     SLOTCAPABILITYSLOTPOWERLIMITVALUE : bit_vector := X"00";
     SLOTIMPLEMENTED : boolean := FALSE;
     SUBSYSTEMID : bit_vector := X"5050";
     SUBSYSTEMVENDORID : bit_vector := X"10EE";
     TLRAMREADLATENCY : integer := 3;
     TLRAMWIDTH : integer := 0;
     TLRAMWRITELATENCY : integer := 1;
     TXREADADDRPIPE : boolean := FALSE;
     TXREADDATAPIPE : boolean := FALSE;
     TXTSNFTS : integer := 255;
     TXTSNFTSCOMCLK : integer := 255;
     TXWRITEPIPE : boolean := FALSE;
     UPSTREAMFACING : boolean := TRUE;
     VC0RXFIFOBASEC : bit_vector := X"0098";
     VC0RXFIFOBASENP : bit_vector := X"0080";
     VC0RXFIFOBASEP : bit_vector := X"0000";
     VC0RXFIFOLIMITC : bit_vector := X"0117";
     VC0RXFIFOLIMITNP : bit_vector := X"0097";
     VC0RXFIFOLIMITP : bit_vector := X"007f";
     VC0TOTALCREDITSCD : bit_vector := X"000";
     VC0TOTALCREDITSCH : bit_vector := X"00";
     VC0TOTALCREDITSNPH : bit_vector := X"08";
     VC0TOTALCREDITSPD : bit_vector := X"034";
     VC0TOTALCREDITSPH : bit_vector := X"08";
     VC0TXFIFOBASEC : bit_vector := X"0098";
     VC0TXFIFOBASENP : bit_vector := X"0080";
     VC0TXFIFOBASEP : bit_vector := X"0000";
     VC0TXFIFOLIMITC : bit_vector := X"0117";
     VC0TXFIFOLIMITNP : bit_vector := X"0097";
     VC0TXFIFOLIMITP : bit_vector := X"007f";
     VC1RXFIFOBASEC : bit_vector := X"0118";
     VC1RXFIFOBASENP : bit_vector := X"0118";
     VC1RXFIFOBASEP : bit_vector := X"0118";
     VC1RXFIFOLIMITC : bit_vector := X"0118";
     VC1RXFIFOLIMITNP : bit_vector := X"0118";
     VC1RXFIFOLIMITP : bit_vector := X"0118";
     VC1TOTALCREDITSCD : bit_vector := X"000";
     VC1TOTALCREDITSCH : bit_vector := X"00";
     VC1TOTALCREDITSNPH : bit_vector := X"00";
     VC1TOTALCREDITSPD : bit_vector := X"000";
     VC1TOTALCREDITSPH : bit_vector := X"00";
     VC1TXFIFOBASEC : bit_vector := X"0118";
     VC1TXFIFOBASENP : bit_vector := X"0118";
     VC1TXFIFOBASEP : bit_vector := X"0118";
     VC1TXFIFOLIMITC : bit_vector := X"0118";
     VC1TXFIFOLIMITNP : bit_vector := X"0118";
     VC1TXFIFOLIMITP : bit_vector := X"0118";
     VCBASEPTR : bit_vector := X"154";
     VCCAPABILITYNEXTPTR : bit_vector := X"000";
     VENDORID : bit_vector := X"10EE";
     XLINKSUPPORTED : boolean := FALSE;
     XPBASEPTR : bit_vector := X"60";
     XPDEVICEPORTTYPE : bit_vector := X"0";
     XPMAXPAYLOAD : integer := 0;
     XPRCBCONTROL : integer := 0
  );
  port (
     BUSMASTERENABLE : out std_ulogic;
     CRMDOHOTRESETN : out std_ulogic;
     CRMPWRSOFTRESETN : out std_ulogic;
     CRMRXHOTRESETN : out std_ulogic;
     DLLTXPMDLLPOUTSTANDING : out std_ulogic;
     INTERRUPTDISABLE : out std_ulogic;
     IOSPACEENABLE : out std_ulogic;
     L0ASAUTONOMOUSINITCOMPLETED : out std_ulogic;
     L0ATTENTIONINDICATORCONTROL : out std_logic_vector(1 downto 0);
     L0CFGLOOPBACKACK : out std_ulogic;
     L0COMPLETERID : out std_logic_vector(12 downto 0);
     L0CORRERRMSGRCVD : out std_ulogic;
     L0DLLASRXSTATE : out std_logic_vector(1 downto 0);
     L0DLLASTXSTATE : out std_ulogic;
     L0DLLERRORVECTOR : out std_logic_vector(6 downto 0);
     L0DLLRXACKOUTSTANDING : out std_ulogic;
     L0DLLTXNONFCOUTSTANDING : out std_ulogic;
     L0DLLTXOUTSTANDING : out std_ulogic;
     L0DLLVCSTATUS : out std_logic_vector(7 downto 0);
     L0DLUPDOWN : out std_logic_vector(7 downto 0);
     L0ERRMSGREQID : out std_logic_vector(15 downto 0);
     L0FATALERRMSGRCVD : out std_ulogic;
     L0FIRSTCFGWRITEOCCURRED : out std_ulogic;
     L0FWDCORRERROUT : out std_ulogic;
     L0FWDFATALERROUT : out std_ulogic;
     L0FWDNONFATALERROUT : out std_ulogic;
     L0LTSSMSTATE : out std_logic_vector(3 downto 0);
     L0MACENTEREDL0 : out std_ulogic;
     L0MACLINKTRAINING : out std_ulogic;
     L0MACLINKUP : out std_ulogic;
     L0MACNEGOTIATEDLINKWIDTH : out std_logic_vector(3 downto 0);
     L0MACNEWSTATEACK : out std_ulogic;
     L0MACRXL0SSTATE : out std_ulogic;
     L0MACUPSTREAMDOWNSTREAM : out std_ulogic;
     L0MCFOUND : out std_logic_vector(2 downto 0);
     L0MSIENABLE0 : out std_ulogic;
     L0MULTIMSGEN0 : out std_logic_vector(2 downto 0);
     L0NONFATALERRMSGRCVD : out std_ulogic;
     L0PMEACK : out std_ulogic;
     L0PMEEN : out std_ulogic;
     L0PMEREQOUT : out std_ulogic;
     L0POWERCONTROLLERCONTROL : out std_ulogic;
     L0POWERINDICATORCONTROL : out std_logic_vector(1 downto 0);
     L0PWRINHIBITTRANSFERS : out std_ulogic;
     L0PWRL1STATE : out std_ulogic;
     L0PWRL23READYDEVICE : out std_ulogic;
     L0PWRL23READYSTATE : out std_ulogic;
     L0PWRSTATE0 : out std_logic_vector(1 downto 0);
     L0PWRTURNOFFREQ : out std_ulogic;
     L0PWRTXL0SSTATE : out std_ulogic;
     L0RECEIVEDASSERTINTALEGACYINT : out std_ulogic;
     L0RECEIVEDASSERTINTBLEGACYINT : out std_ulogic;
     L0RECEIVEDASSERTINTCLEGACYINT : out std_ulogic;
     L0RECEIVEDASSERTINTDLEGACYINT : out std_ulogic;
     L0RECEIVEDDEASSERTINTALEGACYINT : out std_ulogic;
     L0RECEIVEDDEASSERTINTBLEGACYINT : out std_ulogic;
     L0RECEIVEDDEASSERTINTCLEGACYINT : out std_ulogic;
     L0RECEIVEDDEASSERTINTDLEGACYINT : out std_ulogic;
     L0RXBEACON : out std_ulogic;
     L0RXDLLFCCMPLMCCRED : out std_logic_vector(23 downto 0);
     L0RXDLLFCCMPLMCUPDATE : out std_logic_vector(7 downto 0);
     L0RXDLLFCNPOSTBYPCRED : out std_logic_vector(19 downto 0);
     L0RXDLLFCNPOSTBYPUPDATE : out std_logic_vector(7 downto 0);
     L0RXDLLFCPOSTORDCRED : out std_logic_vector(23 downto 0);
     L0RXDLLFCPOSTORDUPDATE : out std_logic_vector(7 downto 0);
     L0RXDLLPM : out std_ulogic;
     L0RXDLLPMTYPE : out std_logic_vector(2 downto 0);
     L0RXDLLSBFCDATA : out std_logic_vector(18 downto 0);
     L0RXDLLSBFCUPDATE : out std_ulogic;
     L0RXDLLTLPECRCOK : out std_ulogic;
     L0RXDLLTLPEND : out std_logic_vector(1 downto 0);
     L0RXMACLINKERROR : out std_logic_vector(1 downto 0);
     L0STATSCFGOTHERRECEIVED : out std_ulogic;
     L0STATSCFGOTHERTRANSMITTED : out std_ulogic;
     L0STATSCFGRECEIVED : out std_ulogic;
     L0STATSCFGTRANSMITTED : out std_ulogic;
     L0STATSDLLPRECEIVED : out std_ulogic;
     L0STATSDLLPTRANSMITTED : out std_ulogic;
     L0STATSOSRECEIVED : out std_ulogic;
     L0STATSOSTRANSMITTED : out std_ulogic;
     L0STATSTLPRECEIVED : out std_ulogic;
     L0STATSTLPTRANSMITTED : out std_ulogic;
     L0TOGGLEELECTROMECHANICALINTERLOCK : out std_ulogic;
     L0TRANSFORMEDVC : out std_logic_vector(2 downto 0);
     L0TXDLLFCCMPLMCUPDATED : out std_logic_vector(7 downto 0);
     L0TXDLLFCNPOSTBYPUPDATED : out std_logic_vector(7 downto 0);
     L0TXDLLFCPOSTORDUPDATED : out std_logic_vector(7 downto 0);
     L0TXDLLPMUPDATED : out std_ulogic;
     L0TXDLLSBFCUPDATED : out std_ulogic;
     L0UCBYPFOUND : out std_logic_vector(3 downto 0);
     L0UCORDFOUND : out std_logic_vector(3 downto 0);
     L0UNLOCKRECEIVED : out std_ulogic;
     LLKRX4DWHEADERN : out std_ulogic;
     LLKRXCHCOMPLETIONAVAILABLEN : out std_logic_vector(7 downto 0);
     LLKRXCHCOMPLETIONPARTIALN : out std_logic_vector(7 downto 0);
     LLKRXCHCONFIGAVAILABLEN : out std_ulogic;
     LLKRXCHCONFIGPARTIALN : out std_ulogic;
     LLKRXCHNONPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
     LLKRXCHNONPOSTEDPARTIALN : out std_logic_vector(7 downto 0);
     LLKRXCHPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
     LLKRXCHPOSTEDPARTIALN : out std_logic_vector(7 downto 0);
     LLKRXDATA : out std_logic_vector(63 downto 0);
     LLKRXECRCBADN : out std_ulogic;
     LLKRXEOFN : out std_ulogic;
     LLKRXEOPN : out std_ulogic;
     LLKRXPREFERREDTYPE : out std_logic_vector(15 downto 0);
     LLKRXSOFN : out std_ulogic;
     LLKRXSOPN : out std_ulogic;
     LLKRXSRCDSCN : out std_ulogic;
     LLKRXSRCLASTREQN : out std_ulogic;
     LLKRXSRCRDYN : out std_ulogic;
     LLKRXVALIDN : out std_logic_vector(1 downto 0);
     LLKTCSTATUS : out std_logic_vector(7 downto 0);
     LLKTXCHANSPACE : out std_logic_vector(9 downto 0);
     LLKTXCHCOMPLETIONREADYN : out std_logic_vector(7 downto 0);
     LLKTXCHNONPOSTEDREADYN : out std_logic_vector(7 downto 0);
     LLKTXCHPOSTEDREADYN : out std_logic_vector(7 downto 0);
     LLKTXCONFIGREADYN : out std_ulogic;
     LLKTXDSTRDYN : out std_ulogic;
     MAXPAYLOADSIZE : out std_logic_vector(2 downto 0);
     MAXREADREQUESTSIZE : out std_logic_vector(2 downto 0);
     MEMSPACEENABLE : out std_ulogic;
     MGMTPSO : out std_logic_vector(16 downto 0);
     MGMTRDATA : out std_logic_vector(31 downto 0);
     MGMTSTATSCREDIT : out std_logic_vector(11 downto 0);
     MIMDLLBRADD : out std_logic_vector(11 downto 0);
     MIMDLLBREN : out std_ulogic;
     MIMDLLBWADD : out std_logic_vector(11 downto 0);
     MIMDLLBWDATA : out std_logic_vector(63 downto 0);
     MIMDLLBWEN : out std_ulogic;
     MIMRXBRADD : out std_logic_vector(12 downto 0);
     MIMRXBREN : out std_ulogic;
     MIMRXBWADD : out std_logic_vector(12 downto 0);
     MIMRXBWDATA : out std_logic_vector(63 downto 0);
     MIMRXBWEN : out std_ulogic;
     MIMTXBRADD : out std_logic_vector(12 downto 0);
     MIMTXBREN : out std_ulogic;
     MIMTXBWADD : out std_logic_vector(12 downto 0);
     MIMTXBWDATA : out std_logic_vector(63 downto 0);
     MIMTXBWEN : out std_ulogic;
     PARITYERRORRESPONSE : out std_ulogic;
     PIPEDESKEWLANESL0 : out std_ulogic;
     PIPEDESKEWLANESL1 : out std_ulogic;
     PIPEDESKEWLANESL2 : out std_ulogic;
     PIPEDESKEWLANESL3 : out std_ulogic;
     PIPEDESKEWLANESL4 : out std_ulogic;
     PIPEDESKEWLANESL5 : out std_ulogic;
     PIPEDESKEWLANESL6 : out std_ulogic;
     PIPEDESKEWLANESL7 : out std_ulogic;
     PIPEPOWERDOWNL0 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL1 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL2 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL3 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL4 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL5 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL6 : out std_logic_vector(1 downto 0);
     PIPEPOWERDOWNL7 : out std_logic_vector(1 downto 0);
     PIPERESETL0 : out std_ulogic;
     PIPERESETL1 : out std_ulogic;
     PIPERESETL2 : out std_ulogic;
     PIPERESETL3 : out std_ulogic;
     PIPERESETL4 : out std_ulogic;
     PIPERESETL5 : out std_ulogic;
     PIPERESETL6 : out std_ulogic;
     PIPERESETL7 : out std_ulogic;
     PIPERXPOLARITYL0 : out std_ulogic;
     PIPERXPOLARITYL1 : out std_ulogic;
     PIPERXPOLARITYL2 : out std_ulogic;
     PIPERXPOLARITYL3 : out std_ulogic;
     PIPERXPOLARITYL4 : out std_ulogic;
     PIPERXPOLARITYL5 : out std_ulogic;
     PIPERXPOLARITYL6 : out std_ulogic;
     PIPERXPOLARITYL7 : out std_ulogic;
     PIPETXCOMPLIANCEL0 : out std_ulogic;
     PIPETXCOMPLIANCEL1 : out std_ulogic;
     PIPETXCOMPLIANCEL2 : out std_ulogic;
     PIPETXCOMPLIANCEL3 : out std_ulogic;
     PIPETXCOMPLIANCEL4 : out std_ulogic;
     PIPETXCOMPLIANCEL5 : out std_ulogic;
     PIPETXCOMPLIANCEL6 : out std_ulogic;
     PIPETXCOMPLIANCEL7 : out std_ulogic;
     PIPETXDATAKL0 : out std_ulogic;
     PIPETXDATAKL1 : out std_ulogic;
     PIPETXDATAKL2 : out std_ulogic;
     PIPETXDATAKL3 : out std_ulogic;
     PIPETXDATAKL4 : out std_ulogic;
     PIPETXDATAKL5 : out std_ulogic;
     PIPETXDATAKL6 : out std_ulogic;
     PIPETXDATAKL7 : out std_ulogic;
     PIPETXDATAL0 : out std_logic_vector(7 downto 0);
     PIPETXDATAL1 : out std_logic_vector(7 downto 0);
     PIPETXDATAL2 : out std_logic_vector(7 downto 0);
     PIPETXDATAL3 : out std_logic_vector(7 downto 0);
     PIPETXDATAL4 : out std_logic_vector(7 downto 0);
     PIPETXDATAL5 : out std_logic_vector(7 downto 0);
     PIPETXDATAL6 : out std_logic_vector(7 downto 0);
     PIPETXDATAL7 : out std_logic_vector(7 downto 0);
     PIPETXDETECTRXLOOPBACKL0 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL1 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL2 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL3 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL4 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL5 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL6 : out std_ulogic;
     PIPETXDETECTRXLOOPBACKL7 : out std_ulogic;
     PIPETXELECIDLEL0 : out std_ulogic;
     PIPETXELECIDLEL1 : out std_ulogic;
     PIPETXELECIDLEL2 : out std_ulogic;
     PIPETXELECIDLEL3 : out std_ulogic;
     PIPETXELECIDLEL4 : out std_ulogic;
     PIPETXELECIDLEL5 : out std_ulogic;
     PIPETXELECIDLEL6 : out std_ulogic;
     PIPETXELECIDLEL7 : out std_ulogic;
     SERRENABLE : out std_ulogic;
     URREPORTINGENABLE : out std_ulogic;
     AUXPOWER : in std_ulogic;
     CFGNEGOTIATEDLINKWIDTH : in std_logic_vector(5 downto 0);
     COMPLIANCEAVOID : in std_ulogic;
     CRMCFGBRIDGEHOTRESET : in std_ulogic;
     CRMCORECLK : in std_ulogic;
     CRMCORECLKDLO : in std_ulogic;
     CRMCORECLKRXO : in std_ulogic;
     CRMCORECLKTXO : in std_ulogic;
     CRMLINKRSTN : in std_ulogic;
     CRMMACRSTN : in std_ulogic;
     CRMMGMTRSTN : in std_ulogic;
     CRMNVRSTN : in std_ulogic;
     CRMTXHOTRESETN : in std_ulogic;
     CRMURSTN : in std_ulogic;
     CRMUSERCFGRSTN : in std_ulogic;
     CRMUSERCLK : in std_ulogic;
     CRMUSERCLKRXO : in std_ulogic;
     CRMUSERCLKTXO : in std_ulogic;
     CROSSLINKSEED : in std_ulogic;
     L0ACKNAKTIMERADJUSTMENT : in std_logic_vector(11 downto 0);
     L0ALLDOWNPORTSINL1 : in std_ulogic;
     L0ALLDOWNRXPORTSINL0S : in std_ulogic;
     L0ASE : in std_ulogic;
     L0ASPORTCOUNT : in std_logic_vector(7 downto 0);
     L0ASTURNPOOLBITSCONSUMED : in std_logic_vector(2 downto 0);
     L0ATTENTIONBUTTONPRESSED : in std_ulogic;
     L0CFGASSPANTREEOWNEDSTATE : in std_ulogic;
     L0CFGASSTATECHANGECMD : in std_logic_vector(3 downto 0);
     L0CFGDISABLESCRAMBLE : in std_ulogic;
     L0CFGEXTENDEDSYNC : in std_ulogic;
     L0CFGL0SENTRYENABLE : in std_ulogic;
     L0CFGL0SENTRYSUP : in std_ulogic;
     L0CFGL0SEXITLAT : in std_logic_vector(2 downto 0);
     L0CFGLINKDISABLE : in std_ulogic;
     L0CFGLOOPBACKMASTER : in std_ulogic;
     L0CFGNEGOTIATEDMAXP : in std_logic_vector(2 downto 0);
     L0CFGVCENABLE : in std_logic_vector(7 downto 0);
     L0CFGVCID : in std_logic_vector(23 downto 0);
     L0DLLHOLDLINKUP : in std_ulogic;
     L0ELECTROMECHANICALINTERLOCKENGAGED : in std_ulogic;
     L0FWDASSERTINTALEGACYINT : in std_ulogic;
     L0FWDASSERTINTBLEGACYINT : in std_ulogic;
     L0FWDASSERTINTCLEGACYINT : in std_ulogic;
     L0FWDASSERTINTDLEGACYINT : in std_ulogic;
     L0FWDCORRERRIN : in std_ulogic;
     L0FWDDEASSERTINTALEGACYINT : in std_ulogic;
     L0FWDDEASSERTINTBLEGACYINT : in std_ulogic;
     L0FWDDEASSERTINTCLEGACYINT : in std_ulogic;
     L0FWDDEASSERTINTDLEGACYINT : in std_ulogic;
     L0FWDFATALERRIN : in std_ulogic;
     L0FWDNONFATALERRIN : in std_ulogic;
     L0LEGACYINTFUNCT0 : in std_ulogic;
     L0MRLSENSORCLOSEDN : in std_ulogic;
     L0MSIREQUEST0 : in std_logic_vector(3 downto 0);
     L0PACKETHEADERFROMUSER : in std_logic_vector(127 downto 0);
     L0PMEREQIN : in std_ulogic;
     L0PORTNUMBER : in std_logic_vector(7 downto 0);
     L0POWERFAULTDETECTED : in std_ulogic;
     L0PRESENCEDETECTSLOTEMPTYN : in std_ulogic;
     L0PWRNEWSTATEREQ : in std_ulogic;
     L0PWRNEXTLINKSTATE : in std_logic_vector(1 downto 0);
     L0REPLAYTIMERADJUSTMENT : in std_logic_vector(11 downto 0);
     L0ROOTTURNOFFREQ : in std_ulogic;
     L0RXTLTLPNONINITIALIZEDVC : in std_logic_vector(7 downto 0);
     L0SENDUNLOCKMESSAGE : in std_ulogic;
     L0SETCOMPLETERABORTERROR : in std_ulogic;
     L0SETCOMPLETIONTIMEOUTCORRERROR : in std_ulogic;
     L0SETCOMPLETIONTIMEOUTUNCORRERROR : in std_ulogic;
     L0SETDETECTEDCORRERROR : in std_ulogic;
     L0SETDETECTEDFATALERROR : in std_ulogic;
     L0SETDETECTEDNONFATALERROR : in std_ulogic;
     L0SETLINKDETECTEDPARITYERROR : in std_ulogic;
     L0SETLINKMASTERDATAPARITY : in std_ulogic;
     L0SETLINKRECEIVEDMASTERABORT : in std_ulogic;
     L0SETLINKRECEIVEDTARGETABORT : in std_ulogic;
     L0SETLINKSIGNALLEDTARGETABORT : in std_ulogic;
     L0SETLINKSYSTEMERROR : in std_ulogic;
     L0SETUNEXPECTEDCOMPLETIONCORRERROR : in std_ulogic;
     L0SETUNEXPECTEDCOMPLETIONUNCORRERROR : in std_ulogic;
     L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR : in std_ulogic;
     L0SETUNSUPPORTEDREQUESTOTHERERROR : in std_ulogic;
     L0SETUSERDETECTEDPARITYERROR : in std_ulogic;
     L0SETUSERMASTERDATAPARITY : in std_ulogic;
     L0SETUSERRECEIVEDMASTERABORT : in std_ulogic;
     L0SETUSERRECEIVEDTARGETABORT : in std_ulogic;
     L0SETUSERSIGNALLEDTARGETABORT : in std_ulogic;
     L0SETUSERSYSTEMERROR : in std_ulogic;
     L0TLASFCCREDSTARVATION : in std_ulogic;
     L0TLLINKRETRAIN : in std_ulogic;
     L0TRANSACTIONSPENDING : in std_ulogic;
     L0TXBEACON : in std_ulogic;
     L0TXCFGPM : in std_ulogic;
     L0TXCFGPMTYPE : in std_logic_vector(2 downto 0);
     L0TXTLFCCMPLMCCRED : in std_logic_vector(159 downto 0);
     L0TXTLFCCMPLMCUPDATE : in std_logic_vector(15 downto 0);
     L0TXTLFCNPOSTBYPCRED : in std_logic_vector(191 downto 0);
     L0TXTLFCNPOSTBYPUPDATE : in std_logic_vector(15 downto 0);
     L0TXTLFCPOSTORDCRED : in std_logic_vector(159 downto 0);
     L0TXTLFCPOSTORDUPDATE : in std_logic_vector(15 downto 0);
     L0TXTLSBFCDATA : in std_logic_vector(18 downto 0);
     L0TXTLSBFCUPDATE : in std_ulogic;
     L0TXTLTLPDATA : in std_logic_vector(63 downto 0);
     L0TXTLTLPEDB : in std_ulogic;
     L0TXTLTLPENABLE : in std_logic_vector(1 downto 0);
     L0TXTLTLPEND : in std_logic_vector(1 downto 0);
     L0TXTLTLPLATENCY : in std_logic_vector(3 downto 0);
     L0TXTLTLPREQ : in std_ulogic;
     L0TXTLTLPREQEND : in std_ulogic;
     L0TXTLTLPWIDTH : in std_ulogic;
     L0UPSTREAMRXPORTINL0S : in std_ulogic;
     L0VC0PREVIEWEXPAND : in std_ulogic;
     L0WAKEN : in std_ulogic;
     LLKRXCHFIFO : in std_logic_vector(1 downto 0);
     LLKRXCHTC : in std_logic_vector(2 downto 0);
     LLKRXDSTCONTREQN : in std_ulogic;
     LLKRXDSTREQN : in std_ulogic;
     LLKTX4DWHEADERN : in std_ulogic;
     LLKTXCHFIFO : in std_logic_vector(1 downto 0);
     LLKTXCHTC : in std_logic_vector(2 downto 0);
     LLKTXCOMPLETEN : in std_ulogic;
     LLKTXCREATEECRCN : in std_ulogic;
     LLKTXDATA : in std_logic_vector(63 downto 0);
     LLKTXENABLEN : in std_logic_vector(1 downto 0);
     LLKTXEOFN : in std_ulogic;
     LLKTXEOPN : in std_ulogic;
     LLKTXSOFN : in std_ulogic;
     LLKTXSOPN : in std_ulogic;
     LLKTXSRCDSCN : in std_ulogic;
     LLKTXSRCRDYN : in std_ulogic;
     MAINPOWER : in std_ulogic;
     MGMTADDR : in std_logic_vector(10 downto 0);
     MGMTBWREN : in std_logic_vector(3 downto 0);
     MGMTRDEN : in std_ulogic;
     MGMTSTATSCREDITSEL : in std_logic_vector(6 downto 0);
     MGMTWDATA : in std_logic_vector(31 downto 0);
     MGMTWREN : in std_ulogic;
     MIMDLLBRDATA : in std_logic_vector(63 downto 0);
     MIMRXBRDATA : in std_logic_vector(63 downto 0);
     MIMTXBRDATA : in std_logic_vector(63 downto 0);
     PIPEPHYSTATUSL0 : in std_ulogic;
     PIPEPHYSTATUSL1 : in std_ulogic;
     PIPEPHYSTATUSL2 : in std_ulogic;
     PIPEPHYSTATUSL3 : in std_ulogic;
     PIPEPHYSTATUSL4 : in std_ulogic;
     PIPEPHYSTATUSL5 : in std_ulogic;
     PIPEPHYSTATUSL6 : in std_ulogic;
     PIPEPHYSTATUSL7 : in std_ulogic;
     PIPERXCHANISALIGNEDL0 : in std_ulogic;
     PIPERXCHANISALIGNEDL1 : in std_ulogic;
     PIPERXCHANISALIGNEDL2 : in std_ulogic;
     PIPERXCHANISALIGNEDL3 : in std_ulogic;
     PIPERXCHANISALIGNEDL4 : in std_ulogic;
     PIPERXCHANISALIGNEDL5 : in std_ulogic;
     PIPERXCHANISALIGNEDL6 : in std_ulogic;
     PIPERXCHANISALIGNEDL7 : in std_ulogic;
     PIPERXDATAKL0 : in std_ulogic;
     PIPERXDATAKL1 : in std_ulogic;
     PIPERXDATAKL2 : in std_ulogic;
     PIPERXDATAKL3 : in std_ulogic;
     PIPERXDATAKL4 : in std_ulogic;
     PIPERXDATAKL5 : in std_ulogic;
     PIPERXDATAKL6 : in std_ulogic;
     PIPERXDATAKL7 : in std_ulogic;
     PIPERXDATAL0 : in std_logic_vector(7 downto 0);
     PIPERXDATAL1 : in std_logic_vector(7 downto 0);
     PIPERXDATAL2 : in std_logic_vector(7 downto 0);
     PIPERXDATAL3 : in std_logic_vector(7 downto 0);
     PIPERXDATAL4 : in std_logic_vector(7 downto 0);
     PIPERXDATAL5 : in std_logic_vector(7 downto 0);
     PIPERXDATAL6 : in std_logic_vector(7 downto 0);
     PIPERXDATAL7 : in std_logic_vector(7 downto 0);
     PIPERXELECIDLEL0 : in std_ulogic;
     PIPERXELECIDLEL1 : in std_ulogic;
     PIPERXELECIDLEL2 : in std_ulogic;
     PIPERXELECIDLEL3 : in std_ulogic;
     PIPERXELECIDLEL4 : in std_ulogic;
     PIPERXELECIDLEL5 : in std_ulogic;
     PIPERXELECIDLEL6 : in std_ulogic;
     PIPERXELECIDLEL7 : in std_ulogic;
     PIPERXSTATUSL0 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL1 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL2 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL3 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL4 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL5 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL6 : in std_logic_vector(2 downto 0);
     PIPERXSTATUSL7 : in std_logic_vector(2 downto 0);
     PIPERXVALIDL0 : in std_ulogic;
     PIPERXVALIDL1 : in std_ulogic;
     PIPERXVALIDL2 : in std_ulogic;
     PIPERXVALIDL3 : in std_ulogic;
     PIPERXVALIDL4 : in std_ulogic;
     PIPERXVALIDL5 : in std_ulogic;
     PIPERXVALIDL6 : in std_ulogic;
     PIPERXVALIDL7 : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PCIE_INTERNAL_1_1 : component is "PRIMITIVE";

----- component PLL_ADV -----
component PLL_ADV
  generic (
     BANDWIDTH : string := "OPTIMIZED";
     CLKFBOUT_DESKEW_ADJUST : string := "NONE";
     CLKFBOUT_MULT : integer := 1;
     CLKFBOUT_PHASE : real := 0.0;
     CLKIN1_PERIOD : real := 0.000;
     CLKIN2_PERIOD : real := 0.000;
     CLKOUT0_DESKEW_ADJUST : string := "NONE";
     CLKOUT0_DIVIDE : integer := 1;
     CLKOUT0_DUTY_CYCLE : real := 0.5;
     CLKOUT0_PHASE : real := 0.0;
     CLKOUT1_DESKEW_ADJUST : string := "NONE";
     CLKOUT1_DIVIDE : integer := 1;
     CLKOUT1_DUTY_CYCLE : real := 0.5;
     CLKOUT1_PHASE : real := 0.0;
     CLKOUT2_DESKEW_ADJUST : string := "NONE";
     CLKOUT2_DIVIDE : integer := 1;
     CLKOUT2_DUTY_CYCLE : real := 0.5;
     CLKOUT2_PHASE : real := 0.0;
     CLKOUT3_DESKEW_ADJUST : string := "NONE";
     CLKOUT3_DIVIDE : integer := 1;
     CLKOUT3_DUTY_CYCLE : real := 0.5;
     CLKOUT3_PHASE : real := 0.0;
     CLKOUT4_DESKEW_ADJUST : string := "NONE";
     CLKOUT4_DIVIDE : integer := 1;
     CLKOUT4_DUTY_CYCLE : real := 0.5;
     CLKOUT4_PHASE : real := 0.0;
     CLKOUT5_DESKEW_ADJUST : string := "NONE";
     CLKOUT5_DIVIDE : integer := 1;
     CLKOUT5_DUTY_CYCLE : real := 0.5;
     CLKOUT5_PHASE : real := 0.0;
     CLK_FEEDBACK : string := "CLKFBOUT";
     COMPENSATION : string := "SYSTEM_SYNCHRONOUS";
     DIVCLK_DIVIDE : integer := 1;
     EN_REL : boolean := FALSE;
     PLL_PMCD_MODE : boolean := FALSE;
     REF_JITTER : real := 0.100;
     RESET_ON_LOSS_OF_LOCK : boolean := FALSE;
     RST_DEASSERT_CLK : string := "CLKIN1";
     SIM_DEVICE : string := "VIRTEX5"
  );
  port (
     CLKFBDCM : out std_ulogic := '0';
     CLKFBOUT : out std_ulogic := '0';
     CLKOUT0 : out std_ulogic := '0';
     CLKOUT1 : out std_ulogic := '0';
     CLKOUT2 : out std_ulogic := '0';
     CLKOUT3 : out std_ulogic := '0';
     CLKOUT4 : out std_ulogic := '0';
     CLKOUT5 : out std_ulogic := '0';
     CLKOUTDCM0 : out std_ulogic := '0';
     CLKOUTDCM1 : out std_ulogic := '0';
     CLKOUTDCM2 : out std_ulogic := '0';
     CLKOUTDCM3 : out std_ulogic := '0';
     CLKOUTDCM4 : out std_ulogic := '0';
     CLKOUTDCM5 : out std_ulogic := '0';
     DO : out std_logic_vector(15 downto 0);
     DRDY : out std_ulogic := '0';
     LOCKED : out std_ulogic := '0';
     CLKFBIN : in std_ulogic;
     CLKIN1 : in std_ulogic;
     CLKIN2 : in std_ulogic;
     CLKINSEL : in std_ulogic;
     DADDR : in std_logic_vector(4 downto 0);
     DCLK : in std_ulogic;
     DEN : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DWE : in std_ulogic;
     REL : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PLL_ADV : component is "PRIMITIVE";

----- component PLL_BASE -----
component PLL_BASE
  generic (
     BANDWIDTH : string := "OPTIMIZED";
     CLKFBOUT_MULT : integer := 1;
     CLKFBOUT_PHASE : real := 0.0;
     CLKIN_PERIOD : real := 0.000;
     CLKOUT0_DIVIDE : integer := 1;
     CLKOUT0_DUTY_CYCLE : real := 0.5;
     CLKOUT0_PHASE : real := 0.0;
     CLKOUT1_DIVIDE : integer := 1;
     CLKOUT1_DUTY_CYCLE : real := 0.5;
     CLKOUT1_PHASE : real := 0.0;
     CLKOUT2_DIVIDE : integer := 1;
     CLKOUT2_DUTY_CYCLE : real := 0.5;
     CLKOUT2_PHASE : real := 0.0;
     CLKOUT3_DIVIDE : integer := 1;
     CLKOUT3_DUTY_CYCLE : real := 0.5;
     CLKOUT3_PHASE : real := 0.0;
     CLKOUT4_DIVIDE : integer := 1;
     CLKOUT4_DUTY_CYCLE : real := 0.5;
     CLKOUT4_PHASE : real := 0.0;
     CLKOUT5_DIVIDE : integer := 1;
     CLKOUT5_DUTY_CYCLE : real := 0.5;
     CLKOUT5_PHASE : real := 0.0;
     CLK_FEEDBACK : string := "CLKFBOUT";
     COMPENSATION : string := "SYSTEM_SYNCHRONOUS";
     DIVCLK_DIVIDE : integer := 1;
     REF_JITTER : real := 0.100;
     RESET_ON_LOSS_OF_LOCK : boolean := FALSE
  );
  port (
     CLKFBOUT : out std_ulogic;
     CLKOUT0 : out std_ulogic;
     CLKOUT1 : out std_ulogic;
     CLKOUT2 : out std_ulogic;
     CLKOUT3 : out std_ulogic;
     CLKOUT4 : out std_ulogic;
     CLKOUT5 : out std_ulogic;
     LOCKED : out std_ulogic;
     CLKFBIN : in std_ulogic;
     CLKIN : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PLL_BASE : component is "PRIMITIVE";

----- component PMCD -----
component PMCD
  generic (
     EN_REL : boolean := FALSE;
     RST_DEASSERT_CLK : string := "CLKA"
  );
  port (
     CLKA1 : out std_ulogic;
     CLKA1D2 : out std_ulogic;
     CLKA1D4 : out std_ulogic;
     CLKA1D8 : out std_ulogic;
     CLKB1 : out std_ulogic;
     CLKC1 : out std_ulogic;
     CLKD1 : out std_ulogic;
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     CLKC : in std_ulogic;
     CLKD : in std_ulogic;
     REL : in std_ulogic;
     RST : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PMCD : component is "PRIMITIVE";

----- component POST_CRC_INTERNAL -----
component POST_CRC_INTERNAL
  port (
     CRCERROR : out std_ulogic := '0'
  );
end component;
attribute BOX_TYPE of
  POST_CRC_INTERNAL : component is "PRIMITIVE";

----- component PPC405_ADV -----
component PPC405_ADV
  port (
     APUFCMDECODED : out std_ulogic;
     APUFCMDECUDI : out std_logic_vector(0 to 2);
     APUFCMDECUDIVALID : out std_ulogic;
     APUFCMENDIAN : out std_ulogic;
     APUFCMFLUSH : out std_ulogic;
     APUFCMINSTRUCTION : out std_logic_vector(0 to 31);
     APUFCMINSTRVALID : out std_ulogic;
     APUFCMLOADBYTEEN : out std_logic_vector(0 to 3);
     APUFCMLOADDATA : out std_logic_vector(0 to 31);
     APUFCMLOADDVALID : out std_ulogic;
     APUFCMOPERANDVALID : out std_ulogic;
     APUFCMRADATA : out std_logic_vector(0 to 31);
     APUFCMRBDATA : out std_logic_vector(0 to 31);
     APUFCMWRITEBACKOK : out std_ulogic;
     APUFCMXERCA : out std_ulogic;
     C405CPMCORESLEEPREQ : out std_ulogic;
     C405CPMMSRCE : out std_ulogic;
     C405CPMMSREE : out std_ulogic;
     C405CPMTIMERIRQ : out std_ulogic;
     C405CPMTIMERRESETREQ : out std_ulogic;
     C405DBGLOADDATAONAPUDBUS : out std_ulogic;
     C405DBGMSRWE : out std_ulogic;
     C405DBGSTOPACK : out std_ulogic;
     C405DBGWBCOMPLETE : out std_ulogic;
     C405DBGWBFULL : out std_ulogic;
     C405DBGWBIAR : out std_logic_vector(0 to 29);
     C405JTGCAPTUREDR : out std_ulogic;
     C405JTGEXTEST : out std_ulogic;
     C405JTGPGMOUT : out std_ulogic;
     C405JTGSHIFTDR : out std_ulogic;
     C405JTGTDO : out std_ulogic;
     C405JTGTDOEN : out std_ulogic;
     C405JTGUPDATEDR : out std_ulogic;
     C405PLBDCUABORT : out std_ulogic;
     C405PLBDCUABUS : out std_logic_vector(0 to 31);
     C405PLBDCUBE : out std_logic_vector(0 to 7);
     C405PLBDCUCACHEABLE : out std_ulogic;
     C405PLBDCUGUARDED : out std_ulogic;
     C405PLBDCUPRIORITY : out std_logic_vector(0 to 1);
     C405PLBDCUREQUEST : out std_ulogic;
     C405PLBDCURNW : out std_ulogic;
     C405PLBDCUSIZE2 : out std_ulogic;
     C405PLBDCUU0ATTR : out std_ulogic;
     C405PLBDCUWRDBUS : out std_logic_vector(0 to 63);
     C405PLBDCUWRITETHRU : out std_ulogic;
     C405PLBICUABORT : out std_ulogic;
     C405PLBICUABUS : out std_logic_vector(0 to 29);
     C405PLBICUCACHEABLE : out std_ulogic;
     C405PLBICUPRIORITY : out std_logic_vector(0 to 1);
     C405PLBICUREQUEST : out std_ulogic;
     C405PLBICUSIZE : out std_logic_vector(2 to 3);
     C405PLBICUU0ATTR : out std_ulogic;
     C405RSTCHIPRESETREQ : out std_ulogic;
     C405RSTCORERESETREQ : out std_ulogic;
     C405RSTSYSRESETREQ : out std_ulogic;
     C405TRCCYCLE : out std_ulogic;
     C405TRCEVENEXECUTIONSTATUS : out std_logic_vector(0 to 1);
     C405TRCODDEXECUTIONSTATUS : out std_logic_vector(0 to 1);
     C405TRCTRACESTATUS : out std_logic_vector(0 to 3);
     C405TRCTRIGGEREVENTOUT : out std_ulogic;
     C405TRCTRIGGEREVENTTYPE : out std_logic_vector(0 to 10);
     C405XXXMACHINECHECK : out std_ulogic;
     DCREMACABUS : out std_logic_vector(8 to 9);
     DCREMACCLK : out std_ulogic;
     DCREMACDBUS : out std_logic_vector(0 to 31);
     DCREMACENABLER : out std_ulogic;
     DCREMACREAD : out std_ulogic;
     DCREMACWRITE : out std_ulogic;
     DSOCMBRAMABUS : out std_logic_vector(8 to 29);
     DSOCMBRAMBYTEWRITE : out std_logic_vector(0 to 3);
     DSOCMBRAMEN : out std_ulogic;
     DSOCMBRAMWRDBUS : out std_logic_vector(0 to 31);
     DSOCMBUSY : out std_ulogic;
     DSOCMRDADDRVALID : out std_ulogic;
     DSOCMWRADDRVALID : out std_ulogic;
     EXTDCRABUS : out std_logic_vector(0 to 9);
     EXTDCRDBUSOUT : out std_logic_vector(0 to 31);
     EXTDCRREAD : out std_ulogic;
     EXTDCRWRITE : out std_ulogic;
     ISOCMBRAMEN : out std_ulogic;
     ISOCMBRAMEVENWRITEEN : out std_ulogic;
     ISOCMBRAMODDWRITEEN : out std_ulogic;
     ISOCMBRAMRDABUS : out std_logic_vector(8 to 28);
     ISOCMBRAMWRABUS : out std_logic_vector(8 to 28);
     ISOCMBRAMWRDBUS : out std_logic_vector(0 to 31);
     ISOCMDCRBRAMEVENEN : out std_ulogic;
     ISOCMDCRBRAMODDEN : out std_ulogic;
     ISOCMDCRBRAMRDSELECT : out std_ulogic;
     BRAMDSOCMCLK : in std_ulogic;
     BRAMDSOCMRDDBUS : in std_logic_vector(0 to 31);
     BRAMISOCMCLK : in std_ulogic;
     BRAMISOCMDCRRDDBUS : in std_logic_vector(0 to 31);
     BRAMISOCMRDDBUS : in std_logic_vector(0 to 63);
     CPMC405CLOCK : in std_ulogic;
     CPMC405CORECLKINACTIVE : in std_ulogic;
     CPMC405CPUCLKEN : in std_ulogic;
     CPMC405JTAGCLKEN : in std_ulogic;
     CPMC405SYNCBYPASS : in std_ulogic;
     CPMC405TIMERCLKEN : in std_ulogic;
     CPMC405TIMERTICK : in std_ulogic;
     CPMDCRCLK : in std_ulogic;
     CPMFCMCLK : in std_ulogic;
     DBGC405DEBUGHALT : in std_ulogic;
     DBGC405EXTBUSHOLDACK : in std_ulogic;
     DBGC405UNCONDDEBUGEVENT : in std_ulogic;
     DSARCVALUE : in std_logic_vector(0 to 7);
     DSCNTLVALUE : in std_logic_vector(0 to 7);
     DSOCMRWCOMPLETE : in std_ulogic;
     EICC405CRITINPUTIRQ : in std_ulogic;
     EICC405EXTINPUTIRQ : in std_ulogic;
     EMACDCRACK : in std_ulogic;
     EMACDCRDBUS : in std_logic_vector(0 to 31);
     EXTDCRACK : in std_ulogic;
     EXTDCRDBUSIN : in std_logic_vector(0 to 31);
     FCMAPUCR : in std_logic_vector(0 to 3);
     FCMAPUDCDCREN : in std_ulogic;
     FCMAPUDCDFORCEALIGN : in std_ulogic;
     FCMAPUDCDFORCEBESTEERING : in std_ulogic;
     FCMAPUDCDFPUOP : in std_ulogic;
     FCMAPUDCDGPRWRITE : in std_ulogic;
     FCMAPUDCDLDSTBYTE : in std_ulogic;
     FCMAPUDCDLDSTDW : in std_ulogic;
     FCMAPUDCDLDSTHW : in std_ulogic;
     FCMAPUDCDLDSTQW : in std_ulogic;
     FCMAPUDCDLDSTWD : in std_ulogic;
     FCMAPUDCDLOAD : in std_ulogic;
     FCMAPUDCDPRIVOP : in std_ulogic;
     FCMAPUDCDRAEN : in std_ulogic;
     FCMAPUDCDRBEN : in std_ulogic;
     FCMAPUDCDSTORE : in std_ulogic;
     FCMAPUDCDTRAPBE : in std_ulogic;
     FCMAPUDCDTRAPLE : in std_ulogic;
     FCMAPUDCDUPDATE : in std_ulogic;
     FCMAPUDCDXERCAEN : in std_ulogic;
     FCMAPUDCDXEROVEN : in std_ulogic;
     FCMAPUDECODEBUSY : in std_ulogic;
     FCMAPUDONE : in std_ulogic;
     FCMAPUEXCEPTION : in std_ulogic;
     FCMAPUEXEBLOCKINGMCO : in std_ulogic;
     FCMAPUEXECRFIELD : in std_logic_vector(0 to 2);
     FCMAPUEXENONBLOCKINGMCO : in std_ulogic;
     FCMAPUINSTRACK : in std_ulogic;
     FCMAPULOADWAIT : in std_ulogic;
     FCMAPURESULT : in std_logic_vector(0 to 31);
     FCMAPURESULTVALID : in std_ulogic;
     FCMAPUSLEEPNOTREADY : in std_ulogic;
     FCMAPUXERCA : in std_ulogic;
     FCMAPUXEROV : in std_ulogic;
     ISARCVALUE : in std_logic_vector(0 to 7);
     ISCNTLVALUE : in std_logic_vector(0 to 7);
     JTGC405BNDSCANTDO : in std_ulogic;
     JTGC405TCK : in std_ulogic;
     JTGC405TDI : in std_ulogic;
     JTGC405TMS : in std_ulogic;
     JTGC405TRSTNEG : in std_ulogic;
     MCBCPUCLKEN : in std_ulogic;
     MCBJTAGEN : in std_ulogic;
     MCBTIMEREN : in std_ulogic;
     MCPPCRST : in std_ulogic;
     PLBC405DCUADDRACK : in std_ulogic;
     PLBC405DCUBUSY : in std_ulogic;
     PLBC405DCUERR : in std_ulogic;
     PLBC405DCURDDACK : in std_ulogic;
     PLBC405DCURDDBUS : in std_logic_vector(0 to 63);
     PLBC405DCURDWDADDR : in std_logic_vector(1 to 3);
     PLBC405DCUSSIZE1 : in std_ulogic;
     PLBC405DCUWRDACK : in std_ulogic;
     PLBC405ICUADDRACK : in std_ulogic;
     PLBC405ICUBUSY : in std_ulogic;
     PLBC405ICUERR : in std_ulogic;
     PLBC405ICURDDACK : in std_ulogic;
     PLBC405ICURDDBUS : in std_logic_vector(0 to 63);
     PLBC405ICURDWDADDR : in std_logic_vector(1 to 3);
     PLBC405ICUSSIZE1 : in std_ulogic;
     PLBCLK : in std_ulogic;
     RSTC405RESETCHIP : in std_ulogic;
     RSTC405RESETCORE : in std_ulogic;
     RSTC405RESETSYS : in std_ulogic;
     TIEAPUCONTROL : in std_logic_vector(0 to 15);
     TIEAPUUDI1 : in std_logic_vector(0 to 23);
     TIEAPUUDI2 : in std_logic_vector(0 to 23);
     TIEAPUUDI3 : in std_logic_vector(0 to 23);
     TIEAPUUDI4 : in std_logic_vector(0 to 23);
     TIEAPUUDI5 : in std_logic_vector(0 to 23);
     TIEAPUUDI6 : in std_logic_vector(0 to 23);
     TIEAPUUDI7 : in std_logic_vector(0 to 23);
     TIEAPUUDI8 : in std_logic_vector(0 to 23);
     TIEC405DETERMINISTICMULT : in std_ulogic;
     TIEC405DISOPERANDFWD : in std_ulogic;
     TIEC405MMUEN : in std_ulogic;
     TIEDCRADDR : in std_logic_vector(0 to 5);
     TIEPVRBIT10 : in std_ulogic;
     TIEPVRBIT11 : in std_ulogic;
     TIEPVRBIT28 : in std_ulogic;
     TIEPVRBIT29 : in std_ulogic;
     TIEPVRBIT30 : in std_ulogic;
     TIEPVRBIT31 : in std_ulogic;
     TIEPVRBIT8 : in std_ulogic;
     TIEPVRBIT9 : in std_ulogic;
     TRCC405TRACEDISABLE : in std_ulogic;
     TRCC405TRIGGEREVENTIN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PPC405_ADV : component is "PRIMITIVE";

----- component PPC440 -----
component PPC440
  generic (
     APU_CONTROL : bit_vector := X"02000";
     APU_UDI0 : bit_vector := X"000000";
     APU_UDI1 : bit_vector := X"000000";
     APU_UDI10 : bit_vector := X"000000";
     APU_UDI11 : bit_vector := X"000000";
     APU_UDI12 : bit_vector := X"000000";
     APU_UDI13 : bit_vector := X"000000";
     APU_UDI14 : bit_vector := X"000000";
     APU_UDI15 : bit_vector := X"000000";
     APU_UDI2 : bit_vector := X"000000";
     APU_UDI3 : bit_vector := X"000000";
     APU_UDI4 : bit_vector := X"000000";
     APU_UDI5 : bit_vector := X"000000";
     APU_UDI6 : bit_vector := X"000000";
     APU_UDI7 : bit_vector := X"000000";
     APU_UDI8 : bit_vector := X"000000";
     APU_UDI9 : bit_vector := X"000000";
     CLOCK_DELAY : boolean := FALSE;
     DCR_AUTOLOCK_ENABLE : boolean := TRUE;
     DMA0_CONTROL : bit_vector := X"00";
     DMA0_RXCHANNELCTRL : bit_vector := X"01010000";
     DMA0_RXIRQTIMER : bit_vector := X"3FF";
     DMA0_TXCHANNELCTRL : bit_vector := X"01010000";
     DMA0_TXIRQTIMER : bit_vector := X"3FF";
     DMA1_CONTROL : bit_vector := X"00";
     DMA1_RXCHANNELCTRL : bit_vector := X"01010000";
     DMA1_RXIRQTIMER : bit_vector := X"3FF";
     DMA1_TXCHANNELCTRL : bit_vector := X"01010000";
     DMA1_TXIRQTIMER : bit_vector := X"3FF";
     DMA2_CONTROL : bit_vector := X"00";
     DMA2_RXCHANNELCTRL : bit_vector := X"01010000";
     DMA2_RXIRQTIMER : bit_vector := X"3FF";
     DMA2_TXCHANNELCTRL : bit_vector := X"01010000";
     DMA2_TXIRQTIMER : bit_vector := X"3FF";
     DMA3_CONTROL : bit_vector := X"00";
     DMA3_RXCHANNELCTRL : bit_vector := X"01010000";
     DMA3_RXIRQTIMER : bit_vector := X"3FF";
     DMA3_TXCHANNELCTRL : bit_vector := X"01010000";
     DMA3_TXIRQTIMER : bit_vector := X"3FF";
     INTERCONNECT_IMASK : bit_vector := X"FFFFFFFF";
     INTERCONNECT_TMPL_SEL : bit_vector := X"3FFFFFFF";
     MI_ARBCONFIG : bit_vector := X"00432010";
     MI_BANKCONFLICT_MASK : bit_vector := X"00000000";
     MI_CONTROL : bit_vector := X"0000008F";
     MI_ROWCONFLICT_MASK : bit_vector := X"00000000";
     PPCDM_ASYNCMODE : boolean := FALSE;
     PPCDS_ASYNCMODE : boolean := FALSE;
     PPCM_ARBCONFIG : bit_vector := X"00432010";
     PPCM_CONTROL : bit_vector := X"8000009F";
     PPCM_COUNTER : bit_vector := X"00000500";
     PPCS0_ADDRMAP_TMPL0 : bit_vector := X"FFFFFFFF";
     PPCS0_ADDRMAP_TMPL1 : bit_vector := X"FFFFFFFF";
     PPCS0_ADDRMAP_TMPL2 : bit_vector := X"FFFFFFFF";
     PPCS0_ADDRMAP_TMPL3 : bit_vector := X"FFFFFFFF";
     PPCS0_CONTROL : bit_vector := X"8033336C";
     PPCS0_WIDTH_128N64 : boolean := TRUE;
     PPCS1_ADDRMAP_TMPL0 : bit_vector := X"FFFFFFFF";
     PPCS1_ADDRMAP_TMPL1 : bit_vector := X"FFFFFFFF";
     PPCS1_ADDRMAP_TMPL2 : bit_vector := X"FFFFFFFF";
     PPCS1_ADDRMAP_TMPL3 : bit_vector := X"FFFFFFFF";
     PPCS1_CONTROL : bit_vector := X"8033336C";
     PPCS1_WIDTH_128N64 : boolean := TRUE;
     XBAR_ADDRMAP_TMPL0 : bit_vector := X"FFFF0000";
     XBAR_ADDRMAP_TMPL1 : bit_vector := X"00000000";
     XBAR_ADDRMAP_TMPL2 : bit_vector := X"00000000";
     XBAR_ADDRMAP_TMPL3 : bit_vector := X"00000000"
  );
  port (
     APUFCMDECFPUOP : out std_ulogic;
     APUFCMDECLDSTXFERSIZE : out std_logic_vector(0 to 2);
     APUFCMDECLOAD : out std_ulogic;
     APUFCMDECNONAUTON : out std_ulogic;
     APUFCMDECSTORE : out std_ulogic;
     APUFCMDECUDI : out std_logic_vector(0 to 3);
     APUFCMDECUDIVALID : out std_ulogic;
     APUFCMENDIAN : out std_ulogic;
     APUFCMFLUSH : out std_ulogic;
     APUFCMINSTRUCTION : out std_logic_vector(0 to 31);
     APUFCMINSTRVALID : out std_ulogic;
     APUFCMLOADBYTEADDR : out std_logic_vector(0 to 3);
     APUFCMLOADDATA : out std_logic_vector(0 to 127);
     APUFCMLOADDVALID : out std_ulogic;
     APUFCMMSRFE0 : out std_ulogic;
     APUFCMMSRFE1 : out std_ulogic;
     APUFCMNEXTINSTRREADY : out std_ulogic;
     APUFCMOPERANDVALID : out std_ulogic;
     APUFCMRADATA : out std_logic_vector(0 to 31);
     APUFCMRBDATA : out std_logic_vector(0 to 31);
     APUFCMWRITEBACKOK : out std_ulogic;
     C440CPMCORESLEEPREQ : out std_ulogic;
     C440CPMDECIRPTREQ : out std_ulogic;
     C440CPMFITIRPTREQ : out std_ulogic;
     C440CPMMSRCE : out std_ulogic;
     C440CPMMSREE : out std_ulogic;
     C440CPMTIMERRESETREQ : out std_ulogic;
     C440CPMWDIRPTREQ : out std_ulogic;
     C440DBGSYSTEMCONTROL : out std_logic_vector(0 to 7);
     C440JTGTDO : out std_ulogic;
     C440JTGTDOEN : out std_ulogic;
     C440MACHINECHECK : out std_ulogic;
     C440RSTCHIPRESETREQ : out std_ulogic;
     C440RSTCORERESETREQ : out std_ulogic;
     C440RSTSYSTEMRESETREQ : out std_ulogic;
     C440TRCBRANCHSTATUS : out std_logic_vector(0 to 2);
     C440TRCCYCLE : out std_ulogic;
     C440TRCEXECUTIONSTATUS : out std_logic_vector(0 to 4);
     C440TRCTRACESTATUS : out std_logic_vector(0 to 6);
     C440TRCTRIGGEREVENTOUT : out std_ulogic;
     C440TRCTRIGGEREVENTTYPE : out std_logic_vector(0 to 13);
     DMA0LLRSTENGINEACK : out std_ulogic;
     DMA0LLRXDSTRDYN : out std_ulogic;
     DMA0LLTXD : out std_logic_vector(0 to 31);
     DMA0LLTXEOFN : out std_ulogic;
     DMA0LLTXEOPN : out std_ulogic;
     DMA0LLTXREM : out std_logic_vector(0 to 3);
     DMA0LLTXSOFN : out std_ulogic;
     DMA0LLTXSOPN : out std_ulogic;
     DMA0LLTXSRCRDYN : out std_ulogic;
     DMA0RXIRQ : out std_ulogic;
     DMA0TXIRQ : out std_ulogic;
     DMA1LLRSTENGINEACK : out std_ulogic;
     DMA1LLRXDSTRDYN : out std_ulogic;
     DMA1LLTXD : out std_logic_vector(0 to 31);
     DMA1LLTXEOFN : out std_ulogic;
     DMA1LLTXEOPN : out std_ulogic;
     DMA1LLTXREM : out std_logic_vector(0 to 3);
     DMA1LLTXSOFN : out std_ulogic;
     DMA1LLTXSOPN : out std_ulogic;
     DMA1LLTXSRCRDYN : out std_ulogic;
     DMA1RXIRQ : out std_ulogic;
     DMA1TXIRQ : out std_ulogic;
     DMA2LLRSTENGINEACK : out std_ulogic;
     DMA2LLRXDSTRDYN : out std_ulogic;
     DMA2LLTXD : out std_logic_vector(0 to 31);
     DMA2LLTXEOFN : out std_ulogic;
     DMA2LLTXEOPN : out std_ulogic;
     DMA2LLTXREM : out std_logic_vector(0 to 3);
     DMA2LLTXSOFN : out std_ulogic;
     DMA2LLTXSOPN : out std_ulogic;
     DMA2LLTXSRCRDYN : out std_ulogic;
     DMA2RXIRQ : out std_ulogic;
     DMA2TXIRQ : out std_ulogic;
     DMA3LLRSTENGINEACK : out std_ulogic;
     DMA3LLRXDSTRDYN : out std_ulogic;
     DMA3LLTXD : out std_logic_vector(0 to 31);
     DMA3LLTXEOFN : out std_ulogic;
     DMA3LLTXEOPN : out std_ulogic;
     DMA3LLTXREM : out std_logic_vector(0 to 3);
     DMA3LLTXSOFN : out std_ulogic;
     DMA3LLTXSOPN : out std_ulogic;
     DMA3LLTXSRCRDYN : out std_ulogic;
     DMA3RXIRQ : out std_ulogic;
     DMA3TXIRQ : out std_ulogic;
     MIMCADDRESS : out std_logic_vector(0 to 35);
     MIMCADDRESSVALID : out std_ulogic;
     MIMCBANKCONFLICT : out std_ulogic;
     MIMCBYTEENABLE : out std_logic_vector(0 to 15);
     MIMCREADNOTWRITE : out std_ulogic;
     MIMCROWCONFLICT : out std_ulogic;
     MIMCWRITEDATA : out std_logic_vector(0 to 127);
     MIMCWRITEDATAVALID : out std_ulogic;
     PPCCPMINTERCONNECTBUSY : out std_ulogic;
     PPCDMDCRABUS : out std_logic_vector(0 to 9);
     PPCDMDCRDBUSOUT : out std_logic_vector(0 to 31);
     PPCDMDCRREAD : out std_ulogic;
     PPCDMDCRUABUS : out std_logic_vector(20 to 21);
     PPCDMDCRWRITE : out std_ulogic;
     PPCDSDCRACK : out std_ulogic;
     PPCDSDCRDBUSIN : out std_logic_vector(0 to 31);
     PPCDSDCRTIMEOUTWAIT : out std_ulogic;
     PPCEICINTERCONNECTIRQ : out std_ulogic;
     PPCMPLBABORT : out std_ulogic;
     PPCMPLBABUS : out std_logic_vector(0 to 31);
     PPCMPLBBE : out std_logic_vector(0 to 15);
     PPCMPLBBUSLOCK : out std_ulogic;
     PPCMPLBLOCKERR : out std_ulogic;
     PPCMPLBPRIORITY : out std_logic_vector(0 to 1);
     PPCMPLBRDBURST : out std_ulogic;
     PPCMPLBREQUEST : out std_ulogic;
     PPCMPLBRNW : out std_ulogic;
     PPCMPLBSIZE : out std_logic_vector(0 to 3);
     PPCMPLBTATTRIBUTE : out std_logic_vector(0 to 15);
     PPCMPLBTYPE : out std_logic_vector(0 to 2);
     PPCMPLBUABUS : out std_logic_vector(28 to 31);
     PPCMPLBWRBURST : out std_ulogic;
     PPCMPLBWRDBUS : out std_logic_vector(0 to 127);
     PPCS0PLBADDRACK : out std_ulogic;
     PPCS0PLBMBUSY : out std_logic_vector(0 to 3);
     PPCS0PLBMIRQ : out std_logic_vector(0 to 3);
     PPCS0PLBMRDERR : out std_logic_vector(0 to 3);
     PPCS0PLBMWRERR : out std_logic_vector(0 to 3);
     PPCS0PLBRDBTERM : out std_ulogic;
     PPCS0PLBRDCOMP : out std_ulogic;
     PPCS0PLBRDDACK : out std_ulogic;
     PPCS0PLBRDDBUS : out std_logic_vector(0 to 127);
     PPCS0PLBRDWDADDR : out std_logic_vector(0 to 3);
     PPCS0PLBREARBITRATE : out std_ulogic;
     PPCS0PLBSSIZE : out std_logic_vector(0 to 1);
     PPCS0PLBWAIT : out std_ulogic;
     PPCS0PLBWRBTERM : out std_ulogic;
     PPCS0PLBWRCOMP : out std_ulogic;
     PPCS0PLBWRDACK : out std_ulogic;
     PPCS1PLBADDRACK : out std_ulogic;
     PPCS1PLBMBUSY : out std_logic_vector(0 to 3);
     PPCS1PLBMIRQ : out std_logic_vector(0 to 3);
     PPCS1PLBMRDERR : out std_logic_vector(0 to 3);
     PPCS1PLBMWRERR : out std_logic_vector(0 to 3);
     PPCS1PLBRDBTERM : out std_ulogic;
     PPCS1PLBRDCOMP : out std_ulogic;
     PPCS1PLBRDDACK : out std_ulogic;
     PPCS1PLBRDDBUS : out std_logic_vector(0 to 127);
     PPCS1PLBRDWDADDR : out std_logic_vector(0 to 3);
     PPCS1PLBREARBITRATE : out std_ulogic;
     PPCS1PLBSSIZE : out std_logic_vector(0 to 1);
     PPCS1PLBWAIT : out std_ulogic;
     PPCS1PLBWRBTERM : out std_ulogic;
     PPCS1PLBWRCOMP : out std_ulogic;
     PPCS1PLBWRDACK : out std_ulogic;
     CPMC440CLK : in std_ulogic;
     CPMC440CLKEN : in std_ulogic;
     CPMC440CORECLOCKINACTIVE : in std_ulogic;
     CPMC440TIMERCLOCK : in std_ulogic;
     CPMDCRCLK : in std_ulogic;
     CPMDMA0LLCLK : in std_ulogic;
     CPMDMA1LLCLK : in std_ulogic;
     CPMDMA2LLCLK : in std_ulogic;
     CPMDMA3LLCLK : in std_ulogic;
     CPMFCMCLK : in std_ulogic;
     CPMINTERCONNECTCLK : in std_ulogic;
     CPMINTERCONNECTCLKEN : in std_ulogic;
     CPMINTERCONNECTCLKNTO1 : in std_ulogic;
     CPMMCCLK : in std_ulogic;
     CPMPPCMPLBCLK : in std_ulogic;
     CPMPPCS0PLBCLK : in std_ulogic;
     CPMPPCS1PLBCLK : in std_ulogic;
     DBGC440DEBUGHALT : in std_ulogic;
     DBGC440SYSTEMSTATUS : in std_logic_vector(0 to 4);
     DBGC440UNCONDDEBUGEVENT : in std_ulogic;
     DCRPPCDMACK : in std_ulogic;
     DCRPPCDMDBUSIN : in std_logic_vector(0 to 31);
     DCRPPCDMTIMEOUTWAIT : in std_ulogic;
     DCRPPCDSABUS : in std_logic_vector(0 to 9);
     DCRPPCDSDBUSOUT : in std_logic_vector(0 to 31);
     DCRPPCDSREAD : in std_ulogic;
     DCRPPCDSWRITE : in std_ulogic;
     EICC440CRITIRQ : in std_ulogic;
     EICC440EXTIRQ : in std_ulogic;
     FCMAPUCONFIRMINSTR : in std_ulogic;
     FCMAPUCR : in std_logic_vector(0 to 3);
     FCMAPUDONE : in std_ulogic;
     FCMAPUEXCEPTION : in std_ulogic;
     FCMAPUFPSCRFEX : in std_ulogic;
     FCMAPURESULT : in std_logic_vector(0 to 31);
     FCMAPURESULTVALID : in std_ulogic;
     FCMAPUSLEEPNOTREADY : in std_ulogic;
     FCMAPUSTOREDATA : in std_logic_vector(0 to 127);
     JTGC440TCK : in std_ulogic;
     JTGC440TDI : in std_ulogic;
     JTGC440TMS : in std_ulogic;
     JTGC440TRSTNEG : in std_ulogic;
     LLDMA0RSTENGINEREQ : in std_ulogic;
     LLDMA0RXD : in std_logic_vector(0 to 31);
     LLDMA0RXEOFN : in std_ulogic;
     LLDMA0RXEOPN : in std_ulogic;
     LLDMA0RXREM : in std_logic_vector(0 to 3);
     LLDMA0RXSOFN : in std_ulogic;
     LLDMA0RXSOPN : in std_ulogic;
     LLDMA0RXSRCRDYN : in std_ulogic;
     LLDMA0TXDSTRDYN : in std_ulogic;
     LLDMA1RSTENGINEREQ : in std_ulogic;
     LLDMA1RXD : in std_logic_vector(0 to 31);
     LLDMA1RXEOFN : in std_ulogic;
     LLDMA1RXEOPN : in std_ulogic;
     LLDMA1RXREM : in std_logic_vector(0 to 3);
     LLDMA1RXSOFN : in std_ulogic;
     LLDMA1RXSOPN : in std_ulogic;
     LLDMA1RXSRCRDYN : in std_ulogic;
     LLDMA1TXDSTRDYN : in std_ulogic;
     LLDMA2RSTENGINEREQ : in std_ulogic;
     LLDMA2RXD : in std_logic_vector(0 to 31);
     LLDMA2RXEOFN : in std_ulogic;
     LLDMA2RXEOPN : in std_ulogic;
     LLDMA2RXREM : in std_logic_vector(0 to 3);
     LLDMA2RXSOFN : in std_ulogic;
     LLDMA2RXSOPN : in std_ulogic;
     LLDMA2RXSRCRDYN : in std_ulogic;
     LLDMA2TXDSTRDYN : in std_ulogic;
     LLDMA3RSTENGINEREQ : in std_ulogic;
     LLDMA3RXD : in std_logic_vector(0 to 31);
     LLDMA3RXEOFN : in std_ulogic;
     LLDMA3RXEOPN : in std_ulogic;
     LLDMA3RXREM : in std_logic_vector(0 to 3);
     LLDMA3RXSOFN : in std_ulogic;
     LLDMA3RXSOPN : in std_ulogic;
     LLDMA3RXSRCRDYN : in std_ulogic;
     LLDMA3TXDSTRDYN : in std_ulogic;
     MCMIADDRREADYTOACCEPT : in std_ulogic;
     MCMIREADDATA : in std_logic_vector(0 to 127);
     MCMIREADDATAERR : in std_ulogic;
     MCMIREADDATAVALID : in std_ulogic;
     PLBPPCMADDRACK : in std_ulogic;
     PLBPPCMMBUSY : in std_ulogic;
     PLBPPCMMIRQ : in std_ulogic;
     PLBPPCMMRDERR : in std_ulogic;
     PLBPPCMMWRERR : in std_ulogic;
     PLBPPCMRDBTERM : in std_ulogic;
     PLBPPCMRDDACK : in std_ulogic;
     PLBPPCMRDDBUS : in std_logic_vector(0 to 127);
     PLBPPCMRDPENDPRI : in std_logic_vector(0 to 1);
     PLBPPCMRDPENDREQ : in std_ulogic;
     PLBPPCMRDWDADDR : in std_logic_vector(0 to 3);
     PLBPPCMREARBITRATE : in std_ulogic;
     PLBPPCMREQPRI : in std_logic_vector(0 to 1);
     PLBPPCMSSIZE : in std_logic_vector(0 to 1);
     PLBPPCMTIMEOUT : in std_ulogic;
     PLBPPCMWRBTERM : in std_ulogic;
     PLBPPCMWRDACK : in std_ulogic;
     PLBPPCMWRPENDPRI : in std_logic_vector(0 to 1);
     PLBPPCMWRPENDREQ : in std_ulogic;
     PLBPPCS0ABORT : in std_ulogic;
     PLBPPCS0ABUS : in std_logic_vector(0 to 31);
     PLBPPCS0BE : in std_logic_vector(0 to 15);
     PLBPPCS0BUSLOCK : in std_ulogic;
     PLBPPCS0LOCKERR : in std_ulogic;
     PLBPPCS0MASTERID : in std_logic_vector(0 to 1);
     PLBPPCS0MSIZE : in std_logic_vector(0 to 1);
     PLBPPCS0PAVALID : in std_ulogic;
     PLBPPCS0RDBURST : in std_ulogic;
     PLBPPCS0RDPENDPRI : in std_logic_vector(0 to 1);
     PLBPPCS0RDPENDREQ : in std_ulogic;
     PLBPPCS0RDPRIM : in std_ulogic;
     PLBPPCS0REQPRI : in std_logic_vector(0 to 1);
     PLBPPCS0RNW : in std_ulogic;
     PLBPPCS0SAVALID : in std_ulogic;
     PLBPPCS0SIZE : in std_logic_vector(0 to 3);
     PLBPPCS0TATTRIBUTE : in std_logic_vector(0 to 15);
     PLBPPCS0TYPE : in std_logic_vector(0 to 2);
     PLBPPCS0UABUS : in std_logic_vector(28 to 31);
     PLBPPCS0WRBURST : in std_ulogic;
     PLBPPCS0WRDBUS : in std_logic_vector(0 to 127);
     PLBPPCS0WRPENDPRI : in std_logic_vector(0 to 1);
     PLBPPCS0WRPENDREQ : in std_ulogic;
     PLBPPCS0WRPRIM : in std_ulogic;
     PLBPPCS1ABORT : in std_ulogic;
     PLBPPCS1ABUS : in std_logic_vector(0 to 31);
     PLBPPCS1BE : in std_logic_vector(0 to 15);
     PLBPPCS1BUSLOCK : in std_ulogic;
     PLBPPCS1LOCKERR : in std_ulogic;
     PLBPPCS1MASTERID : in std_logic_vector(0 to 1);
     PLBPPCS1MSIZE : in std_logic_vector(0 to 1);
     PLBPPCS1PAVALID : in std_ulogic;
     PLBPPCS1RDBURST : in std_ulogic;
     PLBPPCS1RDPENDPRI : in std_logic_vector(0 to 1);
     PLBPPCS1RDPENDREQ : in std_ulogic;
     PLBPPCS1RDPRIM : in std_ulogic;
     PLBPPCS1REQPRI : in std_logic_vector(0 to 1);
     PLBPPCS1RNW : in std_ulogic;
     PLBPPCS1SAVALID : in std_ulogic;
     PLBPPCS1SIZE : in std_logic_vector(0 to 3);
     PLBPPCS1TATTRIBUTE : in std_logic_vector(0 to 15);
     PLBPPCS1TYPE : in std_logic_vector(0 to 2);
     PLBPPCS1UABUS : in std_logic_vector(28 to 31);
     PLBPPCS1WRBURST : in std_ulogic;
     PLBPPCS1WRDBUS : in std_logic_vector(0 to 127);
     PLBPPCS1WRPENDPRI : in std_logic_vector(0 to 1);
     PLBPPCS1WRPENDREQ : in std_ulogic;
     PLBPPCS1WRPRIM : in std_ulogic;
     RSTC440RESETCHIP : in std_ulogic;
     RSTC440RESETCORE : in std_ulogic;
     RSTC440RESETSYSTEM : in std_ulogic;
     TIEC440DCURDLDCACHEPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440DCURDNONCACHEPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440DCURDTOUCHPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440DCURDURGENTPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440DCUWRFLUSHPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440DCUWRSTOREPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440DCUWRURGENTPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440ENDIANRESET : in std_ulogic;
     TIEC440ERPNRESET : in std_logic_vector(0 to 3);
     TIEC440ICURDFETCHPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440ICURDSPECPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440ICURDTOUCHPLBPRIO : in std_logic_vector(0 to 1);
     TIEC440PIR : in std_logic_vector(28 to 31);
     TIEC440PVR : in std_logic_vector(28 to 31);
     TIEC440USERRESET : in std_logic_vector(0 to 3);
     TIEDCRBASEADDR : in std_logic_vector(0 to 1);
     TRCC440TRACEDISABLE : in std_ulogic;
     TRCC440TRIGGEREVENTIN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  PPC440 : component is "PRIMITIVE";

----- component PULLDOWN -----
component PULLDOWN
  port (
     O : out std_ulogic := 'L'
  );
end component;
attribute BOX_TYPE of
  PULLDOWN : component is "PRIMITIVE";

----- component PULLUP -----
component PULLUP
  port (
     O : out std_ulogic := 'H'
  );
end component;
attribute BOX_TYPE of
  PULLUP : component is "PRIMITIVE";

----- component RAM128X1D -----
component RAM128X1D
  generic (
     INIT : bit_vector(127 downto 0) := X"00000000000000000000000000000000"
  );
  port (
     DPO : out std_ulogic;
     SPO : out std_ulogic;
     A : in std_logic_vector(6 downto 0);
     D : in std_ulogic;
     DPRA : in std_logic_vector(6 downto 0);
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM128X1D : component is "PRIMITIVE";

----- component RAM128X1S -----
component RAM128X1S
  generic (
     INIT : bit_vector(127 downto 0) := X"00000000000000000000000000000000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     A5 : in std_ulogic;
     A6 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM128X1S : component is "PRIMITIVE";

----- component RAM128X1S_1 -----
component RAM128X1S_1
  generic (
     INIT : bit_vector(127 downto 0) := X"00000000000000000000000000000000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     A5 : in std_ulogic;
     A6 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM128X1S_1 : component is "PRIMITIVE";

----- component RAM16X1D -----
component RAM16X1D
  generic (
     INIT : bit_vector(15 downto 0) := X"0000"
  );
  port (
     DPO : out std_ulogic;
     SPO : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     D : in std_ulogic;
     DPRA0 : in std_ulogic;
     DPRA1 : in std_ulogic;
     DPRA2 : in std_ulogic;
     DPRA3 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM16X1D : component is "PRIMITIVE";

----- component RAM16X1D_1 -----
component RAM16X1D_1
  generic (
     INIT : bit_vector(15 downto 0) := X"0000"
  );
  port (
     DPO : out std_ulogic;
     SPO : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     D : in std_ulogic;
     DPRA0 : in std_ulogic;
     DPRA1 : in std_ulogic;
     DPRA2 : in std_ulogic;
     DPRA3 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM16X1D_1 : component is "PRIMITIVE";

----- component RAM16X1S -----
component RAM16X1S
  generic (
     INIT : bit_vector(15 downto 0) := X"0000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM16X1S : component is "PRIMITIVE";

----- component RAM16X1S_1 -----
component RAM16X1S_1
  generic (
     INIT : bit_vector(15 downto 0) := X"0000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM16X1S_1 : component is "PRIMITIVE";

----- component RAM16X2S -----
component RAM16X2S
  generic (
     INIT_00 : bit_vector(15 downto 0) := X"0000";
     INIT_01 : bit_vector(15 downto 0) := X"0000"
  );
  port (
     O0 : out std_ulogic;
     O1 : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM16X2S : component is "PRIMITIVE";

----- component RAM16X4S -----
component RAM16X4S
  generic (
     INIT_00 : bit_vector(15 downto 0) := X"0000";
     INIT_01 : bit_vector(15 downto 0) := X"0000";
     INIT_02 : bit_vector(15 downto 0) := X"0000";
     INIT_03 : bit_vector(15 downto 0) := X"0000"
  );
  port (
     O0 : out std_ulogic;
     O1 : out std_ulogic;
     O2 : out std_ulogic;
     O3 : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM16X4S : component is "PRIMITIVE";

----- component RAM16X8S -----
component RAM16X8S
  generic (
     INIT_00 : bit_vector(15 downto 0) := X"0000";
     INIT_01 : bit_vector(15 downto 0) := X"0000";
     INIT_02 : bit_vector(15 downto 0) := X"0000";
     INIT_03 : bit_vector(15 downto 0) := X"0000";
     INIT_04 : bit_vector(15 downto 0) := X"0000";
     INIT_05 : bit_vector(15 downto 0) := X"0000";
     INIT_06 : bit_vector(15 downto 0) := X"0000";
     INIT_07 : bit_vector(15 downto 0) := X"0000"
  );
  port (
     O : out std_logic_vector ( 7 downto 0);
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     D : in std_logic_vector ( 7 downto 0);
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM16X8S : component is "PRIMITIVE";

----- component RAM256X1S -----
component RAM256X1S
  generic (
     INIT : bit_vector(255 downto 0) := X"0000000000000000000000000000000000000000000000000000000000000000"
  );
  port (
     O : out std_ulogic;
     A : in std_logic_vector(7 downto 0);
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM256X1S : component is "PRIMITIVE";

----- component RAM32M -----
component RAM32M
  generic (
     INIT_A : bit_vector(63 downto 0) := X"0000000000000000";
     INIT_B : bit_vector(63 downto 0) := X"0000000000000000";
     INIT_C : bit_vector(63 downto 0) := X"0000000000000000";
     INIT_D : bit_vector(63 downto 0) := X"0000000000000000"
  );
  port (
     DOA : out std_logic_vector (1 downto 0);
     DOB : out std_logic_vector (1 downto 0);
     DOC : out std_logic_vector (1 downto 0);
     DOD : out std_logic_vector (1 downto 0);
     ADDRA : in std_logic_vector(4 downto 0);
     ADDRB : in std_logic_vector(4 downto 0);
     ADDRC : in std_logic_vector(4 downto 0);
     ADDRD : in std_logic_vector(4 downto 0);
     DIA : in std_logic_vector (1 downto 0);
     DIB : in std_logic_vector (1 downto 0);
     DIC : in std_logic_vector (1 downto 0);
     DID : in std_logic_vector (1 downto 0);
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32M : component is "PRIMITIVE";

----- component RAM32X1D -----
component RAM32X1D
  generic (
     INIT : bit_vector(31 downto 0) := X"00000000"
  );
  port (
     DPO : out std_ulogic;
     SPO : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     D : in std_ulogic;
     DPRA0 : in std_ulogic;
     DPRA1 : in std_ulogic;
     DPRA2 : in std_ulogic;
     DPRA3 : in std_ulogic;
     DPRA4 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32X1D : component is "PRIMITIVE";

----- component RAM32X1D_1 -----
component RAM32X1D_1
  generic (
     INIT : bit_vector(31 downto 0) := X"00000000"
  );
  port (
     DPO : out std_ulogic;
     SPO : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     D : in std_ulogic;
     DPRA0 : in std_ulogic;
     DPRA1 : in std_ulogic;
     DPRA2 : in std_ulogic;
     DPRA3 : in std_ulogic;
     DPRA4 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32X1D_1 : component is "PRIMITIVE";

----- component RAM32X1S -----
component RAM32X1S
  generic (
     INIT : bit_vector(31 downto 0) := X"00000000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32X1S : component is "PRIMITIVE";

----- component RAM32X1S_1 -----
component RAM32X1S_1
  generic (
     INIT : bit_vector(31 downto 0) := X"00000000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32X1S_1 : component is "PRIMITIVE";

----- component RAM32X2S -----
component RAM32X2S
  generic (
     INIT_00 : bit_vector(31 downto 0) := X"00000000";
     INIT_01 : bit_vector(31 downto 0) := X"00000000"
  );
  port (
     O0 : out std_ulogic;
     O1 : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32X2S : component is "PRIMITIVE";

----- component RAM32X4S -----
component RAM32X4S
  generic (
     INIT_00 : bit_vector(31 downto 0) := X"00000000";
     INIT_01 : bit_vector(31 downto 0) := X"00000000";
     INIT_02 : bit_vector(31 downto 0) := X"00000000";
     INIT_03 : bit_vector(31 downto 0) := X"00000000"
  );
  port (
     O0 : out std_ulogic;
     O1 : out std_ulogic;
     O2 : out std_ulogic;
     O3 : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     D2 : in std_ulogic;
     D3 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32X4S : component is "PRIMITIVE";

----- component RAM32X8S -----
component RAM32X8S
  generic (
     INIT_00 : bit_vector(31 downto 0) := X"00000000";
     INIT_01 : bit_vector(31 downto 0) := X"00000000";
     INIT_02 : bit_vector(31 downto 0) := X"00000000";
     INIT_03 : bit_vector(31 downto 0) := X"00000000";
     INIT_04 : bit_vector(31 downto 0) := X"00000000";
     INIT_05 : bit_vector(31 downto 0) := X"00000000";
     INIT_06 : bit_vector(31 downto 0) := X"00000000";
     INIT_07 : bit_vector(31 downto 0) := X"00000000"
  );
  port (
     O : out std_logic_vector ( 7 downto 0);
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     D : in std_logic_vector ( 7 downto 0);
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM32X8S : component is "PRIMITIVE";

----- component RAM64M -----
component RAM64M
  generic (
     INIT_A : bit_vector(63 downto 0) := X"0000000000000000";
     INIT_B : bit_vector(63 downto 0) := X"0000000000000000";
     INIT_C : bit_vector(63 downto 0) := X"0000000000000000";
     INIT_D : bit_vector(63 downto 0) := X"0000000000000000"
  );
  port (
     DOA : out std_ulogic;
     DOB : out std_ulogic;
     DOC : out std_ulogic;
     DOD : out std_ulogic;
     ADDRA : in std_logic_vector(5 downto 0);
     ADDRB : in std_logic_vector(5 downto 0);
     ADDRC : in std_logic_vector(5 downto 0);
     ADDRD : in std_logic_vector(5 downto 0);
     DIA : in std_ulogic;
     DIB : in std_ulogic;
     DIC : in std_ulogic;
     DID : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM64M : component is "PRIMITIVE";

----- component RAM64X1D -----
component RAM64X1D
  generic (
     INIT : bit_vector(63 downto 0) := X"0000000000000000"
  );
  port (
     DPO : out std_ulogic;
     SPO : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     A5 : in std_ulogic;
     D : in std_ulogic;
     DPRA0 : in std_ulogic;
     DPRA1 : in std_ulogic;
     DPRA2 : in std_ulogic;
     DPRA3 : in std_ulogic;
     DPRA4 : in std_ulogic;
     DPRA5 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM64X1D : component is "PRIMITIVE";

----- component RAM64X1D_1 -----
component RAM64X1D_1
  generic (
     INIT : bit_vector(63 downto 0) := X"0000000000000000"
  );
  port (
     DPO : out std_ulogic;
     SPO : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     A5 : in std_ulogic;
     D : in std_ulogic;
     DPRA0 : in std_ulogic;
     DPRA1 : in std_ulogic;
     DPRA2 : in std_ulogic;
     DPRA3 : in std_ulogic;
     DPRA4 : in std_ulogic;
     DPRA5 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM64X1D_1 : component is "PRIMITIVE";

----- component RAM64X1S -----
component RAM64X1S
  generic (
     INIT : bit_vector(63 downto 0) := X"0000000000000000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     A5 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM64X1S : component is "PRIMITIVE";

----- component RAM64X1S_1 -----
component RAM64X1S_1
  generic (
     INIT : bit_vector(63 downto 0) := X"0000000000000000"
  );
  port (
     O : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     A5 : in std_ulogic;
     D : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM64X1S_1 : component is "PRIMITIVE";

----- component RAM64X2S -----
component RAM64X2S
  generic (
     INIT_00 : bit_vector(63 downto 0) := X"0000000000000000";
     INIT_01 : bit_vector(63 downto 0) := X"0000000000000000"
  );
  port (
     O0 : out std_ulogic;
     O1 : out std_ulogic;
     A0 : in std_ulogic;
     A1 : in std_ulogic;
     A2 : in std_ulogic;
     A3 : in std_ulogic;
     A4 : in std_ulogic;
     A5 : in std_ulogic;
     D0 : in std_ulogic;
     D1 : in std_ulogic;
     WCLK : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAM64X2S : component is "PRIMITIVE";

----- component RAMB16 -----
component RAMB16
  generic (
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     INIT_FILE : string := "NONE";
     INVERT_CLK_DOA_REG : boolean := false;
     INVERT_CLK_DOB_REG : boolean := false;
     RAM_EXTENSION_A : string := "NONE";
     RAM_EXTENSION_B : string := "NONE";
     READ_WIDTH_A : integer := 0;
     READ_WIDTH_B : integer := 0;
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST";
     WRITE_WIDTH_A : integer := 0;
     WRITE_WIDTH_B : integer := 0
  );
  port (
     CASCADEOUTA : out std_ulogic;
     CASCADEOUTB : out std_ulogic;
     DOA : out std_logic_vector (31 downto 0);
     DOB : out std_logic_vector (31 downto 0);
     DOPA : out std_logic_vector (3 downto 0);
     DOPB : out std_logic_vector (3 downto 0);
     ADDRA : in std_logic_vector (14 downto 0);
     ADDRB : in std_logic_vector (14 downto 0);
     CASCADEINA : in std_ulogic;
     CASCADEINB : in std_ulogic;
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector (31 downto 0);
     DIB : in std_logic_vector (31 downto 0);
     DIPA : in std_logic_vector (3 downto 0);
     DIPB : in std_logic_vector (3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     REGCEA : in std_ulogic;
     REGCEB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector (3 downto 0);
     WEB : in std_logic_vector (3 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16 : component is "PRIMITIVE";

----- component RAMB16BWE -----
component RAMB16BWE
  generic (
     DATA_WIDTH_A : integer := 0;
     DATA_WIDTH_B : integer := 0;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     INIT_FILE : string := "NONE";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector (31 downto 0);
     DOB : out std_logic_vector (31 downto 0);
     DOPA : out std_logic_vector (3 downto 0);
     DOPB : out std_logic_vector (3 downto 0);
     ADDRA : in std_logic_vector (13 downto 0);
     ADDRB : in std_logic_vector (13 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector (31 downto 0);
     DIB : in std_logic_vector (31 downto 0);
     DIPA : in std_logic_vector (3 downto 0);
     DIPB : in std_logic_vector (3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector (3 downto 0);
     WEB : in std_logic_vector (3 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE : component is "PRIMITIVE";

----- component RAMB16BWER -----
component RAMB16BWER
  generic (
     DATA_WIDTH_A : integer := 0;
     DATA_WIDTH_B : integer := 0;
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     EN_RSTRAM_A : boolean := TRUE;
     EN_RSTRAM_B : boolean := TRUE;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     INIT_FILE : string := "NONE";
     RSTTYPE : string := "SYNC";
     RST_PRIORITY_A : string := "CE";
     RST_PRIORITY_B : string := "CE";
     SETUP_ALL : time := 1000 ps;
     SETUP_READ_FIRST : time := 3000 ps;
     SIM_COLLISION_CHECK : string := "ALL";
     SIM_DEVICE : string := "SPARTAN3ADSP";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector (31 downto 0);
     DOB : out std_logic_vector (31 downto 0);
     DOPA : out std_logic_vector (3 downto 0);
     DOPB : out std_logic_vector (3 downto 0);
     ADDRA : in std_logic_vector (13 downto 0);
     ADDRB : in std_logic_vector (13 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector (31 downto 0);
     DIB : in std_logic_vector (31 downto 0);
     DIPA : in std_logic_vector (3 downto 0);
     DIPB : in std_logic_vector (3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     REGCEA : in std_ulogic;
     REGCEB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_logic_vector (3 downto 0);
     WEB : in std_logic_vector (3 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16BWER : component is "PRIMITIVE";

----- component RAMB16BWE_S18 -----
component RAMB16BWE_S18
  generic (
     INIT : bit_vector := X"00000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"00000";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out std_logic_vector(15 downto 0);
     DOP : out std_logic_vector(1 downto 0);
     ADDR : in std_logic_vector(9 downto 0);
     CLK : in std_ulogic;
     DI : in std_logic_vector(15 downto 0);
     DIP : in std_logic_vector(1 downto 0);
     EN : in std_ulogic;
     SSR : in std_ulogic;
     WE : in std_logic_vector(1 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE_S18 : component is "PRIMITIVE";

----- component RAMB16BWE_S18_S18 -----
component RAMB16BWE_S18_S18
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"00000";
     INIT_B : bit_vector := X"00000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"00000";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(15 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPA : out std_logic_vector(1 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(9 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(15 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPA : in std_logic_vector(1 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector(1 downto 0);
     WEB : in std_logic_vector(1 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE_S18_S18 : component is "PRIMITIVE";

----- component RAMB16BWE_S18_S9 -----
component RAMB16BWE_S18_S9
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"00000";
     INIT_B : bit_vector := X"000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"00000";
     SRVAL_B : bit_vector := X"000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(15 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     DOPA : out std_logic_vector(1 downto 0);
     DOPB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(9 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(15 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     DIPA : in std_logic_vector(1 downto 0);
     DIPB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector(1 downto 0);
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE_S18_S9 : component is "PRIMITIVE";

----- component RAMB16BWE_S36 -----
component RAMB16BWE_S36
  generic (
     INIT : bit_vector := X"000000000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"000000000";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out std_logic_vector(31 downto 0);
     DOP : out std_logic_vector(3 downto 0);
     ADDR : in std_logic_vector(8 downto 0);
     CLK : in std_ulogic;
     DI : in std_logic_vector(31 downto 0);
     DIP : in std_logic_vector(3 downto 0);
     EN : in std_ulogic;
     SSR : in std_ulogic;
     WE : in std_logic_vector(3 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE_S36 : component is "PRIMITIVE";

----- component RAMB16BWE_S36_S18 -----
component RAMB16BWE_S36_S18
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"00000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(31 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPA : out std_logic_vector(3 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(8 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(31 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPA : in std_logic_vector(3 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector(3 downto 0);
     WEB : in std_logic_vector(1 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE_S36_S18 : component is "PRIMITIVE";

----- component RAMB16BWE_S36_S36 -----
component RAMB16BWE_S36_S36
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(31 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPA : out std_logic_vector(3 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(8 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(31 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPA : in std_logic_vector(3 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector(3 downto 0);
     WEB : in std_logic_vector(3 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE_S36_S36 : component is "PRIMITIVE";

----- component RAMB16BWE_S36_S9 -----
component RAMB16BWE_S36_S9
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(31 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     DOPA : out std_logic_vector(3 downto 0);
     DOPB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(8 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(31 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     DIPA : in std_logic_vector(3 downto 0);
     DIPB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector(3 downto 0);
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16BWE_S36_S9 : component is "PRIMITIVE";

----- component RAMB16_S1 -----
component RAMB16_S1
  generic (
     INIT : bit_vector := X"0";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"0";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out STD_LOGIC_VECTOR (0 downto 0);
     ADDR : in STD_LOGIC_VECTOR (13 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (0 downto 0);
     EN : in STD_ULOGIC;
     SSR : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB16_S1 : component is "PRIMITIVE";

----- component RAMB16_S18 -----
component RAMB16_S18
  generic (
     INIT : bit_vector := X"00000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"00000";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out std_logic_vector (15 downto 0);
     DOP : out std_logic_vector (1 downto 0);
     ADDR : in std_logic_vector (9 downto 0);
     CLK : in std_ulogic;
     DI : in std_logic_vector (15 downto 0);
     DIP : in std_logic_vector (1 downto 0);
     EN : in std_ulogic;
     SSR : in std_ulogic;
     WE : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S18 : component is "PRIMITIVE";

----- component RAMB16_S18_S18 -----
component RAMB16_S18_S18
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"00000";
     INIT_B : bit_vector := X"00000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"00000";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(15 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPA : out std_logic_vector(1 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(9 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(15 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPA : in std_logic_vector(1 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S18_S18 : component is "PRIMITIVE";

----- component RAMB16_S18_S36 -----
component RAMB16_S18_S36
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"00000";
     INIT_B : bit_vector := X"000000000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"00000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(15 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPA : out std_logic_vector(1 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(9 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(15 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPA : in std_logic_vector(1 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S18_S36 : component is "PRIMITIVE";

----- component RAMB16_S1_S1 -----
component RAMB16_S1_S1
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"0";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"0";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(13 downto 0);
     ADDRB : in std_logic_vector(13 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S1_S1 : component is "PRIMITIVE";

----- component RAMB16_S1_S18 -----
component RAMB16_S1_S18
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"00000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(13 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S1_S18 : component is "PRIMITIVE";

----- component RAMB16_S1_S2 -----
component RAMB16_S1_S2
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"0";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"0";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(13 downto 0);
     ADDRB : in std_logic_vector(12 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S1_S2 : component is "PRIMITIVE";

----- component RAMB16_S1_S36 -----
component RAMB16_S1_S36
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"000000000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(13 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S1_S36 : component is "PRIMITIVE";

----- component RAMB16_S1_S4 -----
component RAMB16_S1_S4
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"0";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"0";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(13 downto 0);
     ADDRB : in std_logic_vector(11 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S1_S4 : component is "PRIMITIVE";

----- component RAMB16_S1_S9 -----
component RAMB16_S1_S9
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     DOPB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(13 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     DIPB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S1_S9 : component is "PRIMITIVE";

----- component RAMB16_S2 -----
component RAMB16_S2
  generic (
     INIT : bit_vector := X"0";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"0";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out STD_LOGIC_VECTOR (1 downto 0);
     ADDR : in STD_LOGIC_VECTOR (12 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (1 downto 0);
     EN : in STD_ULOGIC;
     SSR : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB16_S2 : component is "PRIMITIVE";

----- component RAMB16_S2_S18 -----
component RAMB16_S2_S18
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"00000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(12 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S2_S18 : component is "PRIMITIVE";

----- component RAMB16_S2_S2 -----
component RAMB16_S2_S2
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"0";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"0";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(12 downto 0);
     ADDRB : in std_logic_vector(12 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S2_S2 : component is "PRIMITIVE";

----- component RAMB16_S2_S36 -----
component RAMB16_S2_S36
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"000000000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(12 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S2_S36 : component is "PRIMITIVE";

----- component RAMB16_S2_S4 -----
component RAMB16_S2_S4
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"0";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"0";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(12 downto 0);
     ADDRB : in std_logic_vector(11 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S2_S4 : component is "PRIMITIVE";

----- component RAMB16_S2_S9 -----
component RAMB16_S2_S9
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     DOPB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(12 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     DIPB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S2_S9 : component is "PRIMITIVE";

----- component RAMB16_S36 -----
component RAMB16_S36
  generic (
     INIT : bit_vector := X"000000000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"000000000";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out STD_LOGIC_VECTOR (31 downto 0);
     DOP : out STD_LOGIC_VECTOR (3 downto 0);
     ADDR : in STD_LOGIC_VECTOR (8 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (31 downto 0);
     DIP : in STD_LOGIC_VECTOR (3 downto 0);
     EN : in STD_ULOGIC;
     SSR : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB16_S36 : component is "PRIMITIVE";

----- component RAMB16_S36_S36 -----
component RAMB16_S36_S36
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(31 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPA : out std_logic_vector(3 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(8 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(31 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPA : in std_logic_vector(3 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S36_S36 : component is "PRIMITIVE";

----- component RAMB16_S4 -----
component RAMB16_S4
  generic (
     INIT : bit_vector := X"0";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"0";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out STD_LOGIC_VECTOR (3 downto 0);
     ADDR : in STD_LOGIC_VECTOR (11 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (3 downto 0);
     EN : in STD_ULOGIC;
     SSR : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB16_S4 : component is "PRIMITIVE";

----- component RAMB16_S4_S18 -----
component RAMB16_S4_S18
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"00000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(3 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(3 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S4_S18 : component is "PRIMITIVE";

----- component RAMB16_S4_S36 -----
component RAMB16_S4_S36
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"000000000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(3 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(3 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S4_S36 : component is "PRIMITIVE";

----- component RAMB16_S4_S4 -----
component RAMB16_S4_S4
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"0";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"0";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(3 downto 0);
     DOB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(11 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(3 downto 0);
     DIB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S4_S4 : component is "PRIMITIVE";

----- component RAMB16_S4_S9 -----
component RAMB16_S4_S9
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"0";
     INIT_B : bit_vector := X"000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"0";
     SRVAL_B : bit_vector := X"000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(3 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     DOPB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(3 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     DIPB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S4_S9 : component is "PRIMITIVE";

----- component RAMB16_S9 -----
component RAMB16_S9
  generic (
     INIT : bit_vector := X"000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SRVAL : bit_vector := X"000";
     WRITE_MODE : string := "WRITE_FIRST"
  );
  port (
     DO : out STD_LOGIC_VECTOR (7 downto 0);
     DOP : out STD_LOGIC_VECTOR (0 downto 0);
     ADDR : in STD_LOGIC_VECTOR (10 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (7 downto 0);
     DIP : in STD_LOGIC_VECTOR (0 downto 0);
     EN : in STD_ULOGIC;
     SSR : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB16_S9 : component is "PRIMITIVE";

----- component RAMB16_S9_S18 -----
component RAMB16_S9_S18
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000";
     INIT_B : bit_vector := X"00000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(7 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPA : out std_logic_vector(0 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(10 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(7 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPA : in std_logic_vector(0 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S9_S18 : component is "PRIMITIVE";

----- component RAMB16_S9_S36 -----
component RAMB16_S9_S36
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000";
     INIT_B : bit_vector := X"000000000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(7 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPA : out std_logic_vector(0 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(10 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(7 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPA : in std_logic_vector(0 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S9_S36 : component is "PRIMITIVE";

----- component RAMB16_S9_S9 -----
component RAMB16_S9_S9
  generic (
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000";
     INIT_B : bit_vector := X"000";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000";
     SRVAL_B : bit_vector := X"000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST"
  );
  port (
     DOA : out std_logic_vector(7 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     DOPA : out std_logic_vector(0 downto 0);
     DOPB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(10 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(7 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     DIPA : in std_logic_vector(0 downto 0);
     DIPB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB16_S9_S9 : component is "PRIMITIVE";

----- component RAMB18 -----
component RAMB18
  generic (
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"00000";
     INIT_B : bit_vector := X"00000";
     INIT_FILE : string := "NONE";
     READ_WIDTH_A : integer := 0;
     READ_WIDTH_B : integer := 0;
     SIM_COLLISION_CHECK : string := "ALL";
     SIM_MODE : string := "SAFE";
     SRVAL_A : bit_vector := X"00000";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST";
     WRITE_WIDTH_A : integer := 0;
     WRITE_WIDTH_B : integer := 0
  );
  port (
     DOA : out std_logic_vector(15 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     DOPA : out std_logic_vector(1 downto 0);
     DOPB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(13 downto 0);
     ADDRB : in std_logic_vector(13 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(15 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     DIPA : in std_logic_vector(1 downto 0);
     DIPB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     REGCEA : in std_ulogic;
     REGCEB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector(1 downto 0);
     WEB : in std_logic_vector(1 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB18 : component is "PRIMITIVE";

----- component RAMB18E1 -----
component RAMB18E1
  generic (
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"00000";
     INIT_B : bit_vector := X"00000";
     INIT_FILE : string := "NONE";
     RAM_MODE : string := "TDP";
     READ_WIDTH_A : integer := 0;
     READ_WIDTH_B : integer := 0;
     RSTREG_PRIORITY_A : string := "RSTREG";
     RSTREG_PRIORITY_B : string := "RSTREG";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"00000";
     SRVAL_B : bit_vector := X"00000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST";
     WRITE_WIDTH_A : integer := 0;
     WRITE_WIDTH_B : integer := 0
  );
  port (
     DOADO : out std_logic_vector(15 downto 0);
     DOBDO : out std_logic_vector(15 downto 0);
     DOPADOP : out std_logic_vector(1 downto 0);
     DOPBDOP : out std_logic_vector(1 downto 0);
     ADDRARDADDR : in std_logic_vector(13 downto 0);
     ADDRBWRADDR : in std_logic_vector(13 downto 0);
     CLKARDCLK : in std_ulogic;
     CLKBWRCLK : in std_ulogic;
     DIADI : in std_logic_vector(15 downto 0);
     DIBDI : in std_logic_vector(15 downto 0);
     DIPADIP : in std_logic_vector(1 downto 0);
     DIPBDIP : in std_logic_vector(1 downto 0);
     ENARDEN : in std_ulogic;
     ENBWREN : in std_ulogic;
     REGCEAREGCE : in std_ulogic;
     REGCEB : in std_ulogic;
     RSTRAMARSTRAM : in std_ulogic;
     RSTRAMB : in std_ulogic;
     RSTREGARSTREG : in std_ulogic;
     RSTREGB : in std_ulogic;
     WEA : in std_logic_vector(1 downto 0);
     WEBWE : in std_logic_vector(3 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB18E1 : component is "PRIMITIVE";

----- component RAMB18SDP -----
component RAMB18SDP
  generic (
     DO_REG : integer := 0;
     INIT : bit_vector := X"000000000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_FILE : string := "NONE";
     SIM_COLLISION_CHECK : string := "ALL";
     SIM_MODE : string := "SAFE";
     SRVAL : bit_vector := X"000000000"
  );
  port (
     DO : out std_logic_vector(31 downto 0);
     DOP : out std_logic_vector(3 downto 0);
     DI : in std_logic_vector(31 downto 0);
     DIP : in std_logic_vector(3 downto 0);
     RDADDR : in std_logic_vector(8 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     SSR : in std_ulogic;
     WE : in std_logic_vector(3 downto 0);
     WRADDR : in std_logic_vector(8 downto 0);
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB18SDP : component is "PRIMITIVE";

----- component RAMB32_S64_ECC -----
component RAMB32_S64_ECC
  generic (
     DO_REG : integer := 0;
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DO : out std_logic_vector(63 downto 0);
     STATUS : out std_logic_vector(1 downto 0);
     DI : in std_logic_vector(63 downto 0);
     RDADDR : in std_logic_vector(8 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     SSR : in std_ulogic;
     WRADDR : in std_logic_vector(8 downto 0);
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB32_S64_ECC : component is "PRIMITIVE";

----- component RAMB36 -----
component RAMB36
  generic (
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_40 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_41 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_42 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_43 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_44 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_45 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_46 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_47 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_48 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_49 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_50 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_51 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_52 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_53 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_54 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_55 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_56 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_57 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_58 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_59 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_60 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_61 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_62 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_63 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_64 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_65 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_66 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_67 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_68 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_69 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_70 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_71 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_72 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_73 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_74 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_75 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_76 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_77 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_78 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_79 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     INIT_FILE : string := "NONE";
     RAM_EXTENSION_A : string := "NONE";
     RAM_EXTENSION_B : string := "NONE";
     READ_WIDTH_A : integer := 0;
     READ_WIDTH_B : integer := 0;
     SIM_COLLISION_CHECK : string := "ALL";
     SIM_MODE : string := "SAFE";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST";
     WRITE_WIDTH_A : integer := 0;
     WRITE_WIDTH_B : integer := 0
  );
  port (
     CASCADEOUTLATA : out std_ulogic;
     CASCADEOUTLATB : out std_ulogic;
     CASCADEOUTREGA : out std_ulogic;
     CASCADEOUTREGB : out std_ulogic;
     DOA : out std_logic_vector(31 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPA : out std_logic_vector(3 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(15 downto 0);
     ADDRB : in std_logic_vector(15 downto 0);
     CASCADEINLATA : in std_ulogic;
     CASCADEINLATB : in std_ulogic;
     CASCADEINREGA : in std_ulogic;
     CASCADEINREGB : in std_ulogic;
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(31 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPA : in std_logic_vector(3 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     REGCEA : in std_ulogic;
     REGCEB : in std_ulogic;
     SSRA : in std_ulogic;
     SSRB : in std_ulogic;
     WEA : in std_logic_vector(3 downto 0);
     WEB : in std_logic_vector(3 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB36 : component is "PRIMITIVE";

----- component RAMB36E1 -----
component RAMB36E1
  generic (
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_40 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_41 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_42 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_43 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_44 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_45 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_46 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_47 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_48 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_49 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_50 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_51 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_52 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_53 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_54 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_55 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_56 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_57 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_58 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_59 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_60 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_61 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_62 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_63 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_64 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_65 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_66 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_67 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_68 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_69 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_70 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_71 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_72 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_73 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_74 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_75 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_76 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_77 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_78 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_79 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     INIT_FILE : string := "NONE";
     RAM_EXTENSION_A : string := "NONE";
     RAM_EXTENSION_B : string := "NONE";
     RAM_MODE : string := "TDP";
     READ_WIDTH_A : integer := 0;
     READ_WIDTH_B : integer := 0;
     RSTREG_PRIORITY_A : string := "RSTREG";
     RSTREG_PRIORITY_B : string := "RSTREG";
     SIM_COLLISION_CHECK : string := "ALL";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST";
     WRITE_WIDTH_A : integer := 0;
     WRITE_WIDTH_B : integer := 0
  );
  port (
     CASCADEOUTA : out std_ulogic;
     CASCADEOUTB : out std_ulogic;
     DBITERR : out std_ulogic;
     DOADO : out std_logic_vector(31 downto 0);
     DOBDO : out std_logic_vector(31 downto 0);
     DOPADOP : out std_logic_vector(3 downto 0);
     DOPBDOP : out std_logic_vector(3 downto 0);
     ECCPARITY : out std_logic_vector(7 downto 0);
     RDADDRECC : out std_logic_vector(8 downto 0);
     SBITERR : out std_ulogic;
     ADDRARDADDR : in std_logic_vector(15 downto 0);
     ADDRBWRADDR : in std_logic_vector(15 downto 0);
     CASCADEINA : in std_ulogic;
     CASCADEINB : in std_ulogic;
     CLKARDCLK : in std_ulogic;
     CLKBWRCLK : in std_ulogic;
     DIADI : in std_logic_vector(31 downto 0);
     DIBDI : in std_logic_vector(31 downto 0);
     DIPADIP : in std_logic_vector(3 downto 0);
     DIPBDIP : in std_logic_vector(3 downto 0);
     ENARDEN : in std_ulogic;
     ENBWREN : in std_ulogic;
     INJECTDBITERR : in std_ulogic;
     INJECTSBITERR : in std_ulogic;
     REGCEAREGCE : in std_ulogic;
     REGCEB : in std_ulogic;
     RSTRAMARSTRAM : in std_ulogic;
     RSTRAMB : in std_ulogic;
     RSTREGARSTREG : in std_ulogic;
     RSTREGB : in std_ulogic;
     WEA : in std_logic_vector(3 downto 0);
     WEBWE : in std_logic_vector(7 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB36E1 : component is "PRIMITIVE";

----- component RAMB36SDP -----
component RAMB36SDP
  generic (
     DO_REG : integer := 0;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_SCRUB : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     INIT : bit_vector := X"000000000000000000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_40 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_41 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_42 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_43 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_44 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_45 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_46 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_47 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_48 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_49 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_50 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_51 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_52 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_53 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_54 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_55 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_56 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_57 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_58 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_59 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_60 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_61 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_62 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_63 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_64 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_65 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_66 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_67 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_68 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_69 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_70 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_71 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_72 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_73 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_74 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_75 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_76 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_77 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_78 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_79 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_FILE : string := "NONE";
     SIM_COLLISION_CHECK : string := "ALL";
     SIM_MODE : string := "SAFE";
     SRVAL : bit_vector := X"000000000000000000"
  );
  port (
     DBITERR : out std_ulogic;
     DO : out std_logic_vector(63 downto 0);
     DOP : out std_logic_vector(7 downto 0);
     ECCPARITY : out std_logic_vector(7 downto 0);
     SBITERR : out std_ulogic;
     DI : in std_logic_vector(63 downto 0);
     DIP : in std_logic_vector(7 downto 0);
     RDADDR : in std_logic_vector(8 downto 0);
     RDCLK : in std_ulogic;
     RDEN : in std_ulogic;
     REGCE : in std_ulogic;
     SSR : in std_ulogic;
     WE : in std_logic_vector(7 downto 0);
     WRADDR : in std_logic_vector(8 downto 0);
     WRCLK : in std_ulogic;
     WREN : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB36SDP : component is "PRIMITIVE";

----- component RAMB36SDP_EXP -----
component RAMB36SDP_EXP
  generic (
     DO_REG : integer := 0;
     EN_ECC_READ : boolean := FALSE;
     EN_ECC_SCRUB : boolean := FALSE;
     EN_ECC_WRITE : boolean := FALSE;
     INIT : bit_vector := X"000000000000000000";
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_40 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_41 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_42 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_43 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_44 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_45 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_46 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_47 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_48 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_49 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_50 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_51 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_52 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_53 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_54 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_55 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_56 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_57 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_58 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_59 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_60 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_61 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_62 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_63 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_64 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_65 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_66 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_67 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_68 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_69 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_70 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_71 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_72 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_73 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_74 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_75 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_76 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_77 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_78 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_79 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_FILE : string := "NONE";
     SIM_COLLISION_CHECK : string := "ALL";
     SIM_MODE : string := "SAFE";
     SRVAL : bit_vector := X"000000000000000000"
  );
  port (
     DBITERR : out std_ulogic;
     DO : out std_logic_vector(63 downto 0);
     DOP : out std_logic_vector(7 downto 0);
     ECCPARITY : out std_logic_vector(7 downto 0);
     SBITERR : out std_ulogic;
     DI : in std_logic_vector(63 downto 0);
     DIP : in std_logic_vector(7 downto 0);
     RDADDRL : in std_logic_vector(15 downto 0);
     RDADDRU : in std_logic_vector(14 downto 0);
     RDCLKL : in std_ulogic;
     RDCLKU : in std_ulogic;
     RDENL : in std_ulogic;
     RDENU : in std_ulogic;
     RDRCLKL : in std_ulogic;
     RDRCLKU : in std_ulogic;
     REGCEL : in std_ulogic;
     REGCEU : in std_ulogic;
     SSRL : in std_ulogic;
     SSRU : in std_ulogic;
     WEL : in std_logic_vector(7 downto 0);
     WEU : in std_logic_vector(7 downto 0);
     WRADDRL : in std_logic_vector(15 downto 0);
     WRADDRU : in std_logic_vector(14 downto 0);
     WRCLKL : in std_ulogic;
     WRCLKU : in std_ulogic;
     WRENL : in std_ulogic;
     WRENU : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB36SDP_EXP : component is "PRIMITIVE";

----- component RAMB36_EXP -----
component RAMB36_EXP
  generic (
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_40 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_41 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_42 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_43 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_44 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_45 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_46 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_47 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_48 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_49 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_4F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_50 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_51 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_52 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_53 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_54 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_55 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_56 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_57 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_58 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_59 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_5F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_60 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_61 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_62 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_63 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_64 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_65 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_66 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_67 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_68 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_69 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_6F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_70 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_71 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_72 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_73 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_74 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_75 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_76 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_77 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_78 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_79 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_7F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_A : bit_vector := X"000000000";
     INIT_B : bit_vector := X"000000000";
     INIT_FILE : string := "NONE";
     RAM_EXTENSION_A : string := "NONE";
     RAM_EXTENSION_B : string := "NONE";
     READ_WIDTH_A : integer := 0;
     READ_WIDTH_B : integer := 0;
     SIM_COLLISION_CHECK : string := "ALL";
     SIM_MODE : string := "SAFE";
     SRVAL_A : bit_vector := X"000000000";
     SRVAL_B : bit_vector := X"000000000";
     WRITE_MODE_A : string := "WRITE_FIRST";
     WRITE_MODE_B : string := "WRITE_FIRST";
     WRITE_WIDTH_A : integer := 0;
     WRITE_WIDTH_B : integer := 0
  );
  port (
     CASCADEOUTLATA : out std_ulogic;
     CASCADEOUTLATB : out std_ulogic;
     CASCADEOUTREGA : out std_ulogic;
     CASCADEOUTREGB : out std_ulogic;
     DOA : out std_logic_vector(31 downto 0);
     DOB : out std_logic_vector(31 downto 0);
     DOPA : out std_logic_vector(3 downto 0);
     DOPB : out std_logic_vector(3 downto 0);
     ADDRAL : in std_logic_vector(15 downto 0);
     ADDRAU : in std_logic_vector(14 downto 0);
     ADDRBL : in std_logic_vector(15 downto 0);
     ADDRBU : in std_logic_vector(14 downto 0);
     CASCADEINLATA : in std_ulogic;
     CASCADEINLATB : in std_ulogic;
     CASCADEINREGA : in std_ulogic;
     CASCADEINREGB : in std_ulogic;
     CLKAL : in std_ulogic;
     CLKAU : in std_ulogic;
     CLKBL : in std_ulogic;
     CLKBU : in std_ulogic;
     DIA : in std_logic_vector(31 downto 0);
     DIB : in std_logic_vector(31 downto 0);
     DIPA : in std_logic_vector(3 downto 0);
     DIPB : in std_logic_vector(3 downto 0);
     ENAL : in std_ulogic;
     ENAU : in std_ulogic;
     ENBL : in std_ulogic;
     ENBU : in std_ulogic;
     REGCEAL : in std_ulogic;
     REGCEAU : in std_ulogic;
     REGCEBL : in std_ulogic;
     REGCEBU : in std_ulogic;
     REGCLKAL : in std_ulogic;
     REGCLKAU : in std_ulogic;
     REGCLKBL : in std_ulogic;
     REGCLKBU : in std_ulogic;
     SSRAL : in std_ulogic;
     SSRAU : in std_ulogic;
     SSRBL : in std_ulogic;
     SSRBU : in std_ulogic;
     WEAL : in std_logic_vector(3 downto 0);
     WEAU : in std_logic_vector(3 downto 0);
     WEBL : in std_logic_vector(7 downto 0);
     WEBU : in std_logic_vector(7 downto 0)
  );
end component;
attribute BOX_TYPE of
  RAMB36_EXP : component is "PRIMITIVE";

----- component RAMB4_S1 -----
component RAMB4_S1
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000"
  );
  port (
     DO : out STD_LOGIC_VECTOR (0 downto 0);
     ADDR : in STD_LOGIC_VECTOR (11 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (0 downto 0);
     EN : in STD_ULOGIC;
     RST : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB4_S1 : component is "PRIMITIVE";

----- component RAMB4_S16 -----
component RAMB4_S16
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000"
  );
  port (
     DO : out STD_LOGIC_VECTOR (15 downto 0);
     ADDR : in STD_LOGIC_VECTOR (7 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (15 downto 0);
     EN : in STD_ULOGIC;
     RST : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB4_S16 : component is "PRIMITIVE";

----- component RAMB4_S16_S16 -----
component RAMB4_S16_S16
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(15 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     ADDRA : in std_logic_vector(7 downto 0);
     ADDRB : in std_logic_vector(7 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(15 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S16_S16 : component is "PRIMITIVE";

----- component RAMB4_S1_S1 -----
component RAMB4_S1_S1
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(0 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(11 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(0 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S1_S1 : component is "PRIMITIVE";

----- component RAMB4_S1_S16 -----
component RAMB4_S1_S16
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(7 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S1_S16 : component is "PRIMITIVE";

----- component RAMB4_S1_S2 -----
component RAMB4_S1_S2
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S1_S2 : component is "PRIMITIVE";

----- component RAMB4_S1_S4 -----
component RAMB4_S1_S4
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S1_S4 : component is "PRIMITIVE";

----- component RAMB4_S1_S8 -----
component RAMB4_S1_S8
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(0 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     ADDRA : in std_logic_vector(11 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(0 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S1_S8 : component is "PRIMITIVE";

----- component RAMB4_S2 -----
component RAMB4_S2
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000"
  );
  port (
     DO : out STD_LOGIC_VECTOR (1 downto 0);
     ADDR : in STD_LOGIC_VECTOR (10 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (1 downto 0);
     EN : in STD_ULOGIC;
     RST : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB4_S2 : component is "PRIMITIVE";

----- component RAMB4_S2_S16 -----
component RAMB4_S2_S16
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     ADDRA : in std_logic_vector(10 downto 0);
     ADDRB : in std_logic_vector(7 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S2_S16 : component is "PRIMITIVE";

----- component RAMB4_S2_S2 -----
component RAMB4_S2_S2
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(1 downto 0);
     ADDRA : in std_logic_vector(10 downto 0);
     ADDRB : in std_logic_vector(10 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(1 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S2_S2 : component is "PRIMITIVE";

----- component RAMB4_S2_S4 -----
component RAMB4_S2_S4
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(10 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S2_S4 : component is "PRIMITIVE";

----- component RAMB4_S2_S8 -----
component RAMB4_S2_S8
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(1 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     ADDRA : in std_logic_vector(10 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(1 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S2_S8 : component is "PRIMITIVE";

----- component RAMB4_S4 -----
component RAMB4_S4
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000"
  );
  port (
     DO : out STD_LOGIC_VECTOR (3 downto 0);
     ADDR : in STD_LOGIC_VECTOR (9 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (3 downto 0);
     EN : in STD_ULOGIC;
     RST : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB4_S4 : component is "PRIMITIVE";

----- component RAMB4_S4_S16 -----
component RAMB4_S4_S16
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(3 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     ADDRA : in std_logic_vector(9 downto 0);
     ADDRB : in std_logic_vector(7 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(3 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S4_S16 : component is "PRIMITIVE";

----- component RAMB4_S4_S4 -----
component RAMB4_S4_S4
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(3 downto 0);
     DOB : out std_logic_vector(3 downto 0);
     ADDRA : in std_logic_vector(9 downto 0);
     ADDRB : in std_logic_vector(9 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(3 downto 0);
     DIB : in std_logic_vector(3 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S4_S4 : component is "PRIMITIVE";

----- component RAMB4_S4_S8 -----
component RAMB4_S4_S8
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(3 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     ADDRA : in std_logic_vector(9 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(3 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S4_S8 : component is "PRIMITIVE";

----- component RAMB4_S8 -----
component RAMB4_S8
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000"
  );
  port (
     DO : out STD_LOGIC_VECTOR (7 downto 0);
     ADDR : in STD_LOGIC_VECTOR (8 downto 0);
     CLK : in STD_ULOGIC;
     DI : in STD_LOGIC_VECTOR (7 downto 0);
     EN : in STD_ULOGIC;
     RST : in STD_ULOGIC;
     WE : in STD_ULOGIC
  );
end component;
attribute BOX_TYPE of
  RAMB4_S8 : component is "PRIMITIVE";

----- component RAMB4_S8_S16 -----
component RAMB4_S8_S16
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(7 downto 0);
     DOB : out std_logic_vector(15 downto 0);
     ADDRA : in std_logic_vector(8 downto 0);
     ADDRB : in std_logic_vector(7 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(7 downto 0);
     DIB : in std_logic_vector(15 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S8_S16 : component is "PRIMITIVE";

----- component RAMB4_S8_S8 -----
component RAMB4_S8_S8
  generic (
     INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     SIM_COLLISION_CHECK : string := "ALL"
  );
  port (
     DOA : out std_logic_vector(7 downto 0);
     DOB : out std_logic_vector(7 downto 0);
     ADDRA : in std_logic_vector(8 downto 0);
     ADDRB : in std_logic_vector(8 downto 0);
     CLKA : in std_ulogic;
     CLKB : in std_ulogic;
     DIA : in std_logic_vector(7 downto 0);
     DIB : in std_logic_vector(7 downto 0);
     ENA : in std_ulogic;
     ENB : in std_ulogic;
     RSTA : in std_ulogic;
     RSTB : in std_ulogic;
     WEA : in std_ulogic;
     WEB : in std_ulogic
  );
end component;
attribute BOX_TYPE of
  RAMB4_S8_S8 : component is "PRIMITIVE";

----- component RAMB8BWER -----
component RAMB8BWER
  generic (
     DATA_WIDTH_A : integer := 0;
     DATA_WIDTH_B : integer := 0;
     DOA_REG : integer := 0;
     DOB_REG : integer := 0;
     EN_RSTRAM_A : boolean := TRUE;
     EN_RSTRAM_B : boolean := TRUE;
     INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
     INITP_02 : bit_vector := X"00000000000000